/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.DSUtil;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;

public class DSFileDialog {
    public static String getFileName(String path, boolean save) {
        String title = DSUtil._resource.getString("general", save ? "Save-title" : "Open-title");
        FileDialog dlg = new FileDialog(new Frame(), title, save ? 1 : 0);
        File file = null;
        String dir = null;
        if (path != null && path.length() > 0) {
            file = new File(path);
            if (!file.isDirectory()) {
                String parent = file.getParent();
                if (parent != null) {
                    file = new File(parent);
                    if (file != null) {
                        dir = file.getPath();
                    }
                } else if (File.separator.equals("\\") && path.length() == 2 && path.charAt(1) == ':') {
                    dir = String.valueOf(path) + File.separator;
                    path = null;
                }
            } else {
                dir = path;
                path = null;
            }
        }
        if (dir == null) {
            dir = File.separator;
        }
        if (path == null) {
            path = "";
        }
        if (dir != null) {
            dlg.setDirectory(dir);
        }
        if (path != null) {
            dlg.setFile(path);
        }
        dlg.setModal(true);
        dlg.show();
        path = dlg.getFile();
        if (path != null) {
            return String.valueOf(dlg.getDirectory()) + dlg.getFile();
        }
        return null;
    }

    public static String getFileName(String path) {
        return DSFileDialog.getFileName(path, true);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Please input filename");
            System.exit(1);
        }
        String s = DSFileDialog.getFileName(args[0], true);
        System.out.println("Selected file: " + s);
        System.exit(0);
    }
}

