/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.BaseConfigPanel;
import com.netscape.management.admserv.config.ConfigPanelException;
import com.netscape.management.admserv.config.EditMonitor;
import com.netscape.management.admserv.config.GBC;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.PluginConfigPanel;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.CGILoggingSetup;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.SingleByteTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LoggingConfigPanel
extends PluginConfigPanel {
    IConfigDataModel _configData;
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    static String _i18nLogFile = _resource.getString("logging", "LogFile");
    static String _i18nErrorLogGroupbox;
    static String _i18nAccessLogGroupbox;
    Help _help;
    public static final int topInset = 12;
    public static final int rghtColInset = 6;
    JLabel _lblAccessFile;
    JLabel _lblErrorFile;
    JTextField _txtAccessFile;
    JTextField _txtErrorFile;

    public LoggingConfigPanel(String title, ConsoleInfo consoleInfo) {
        super(title);
        this._configData = new CGILoggingSetup(consoleInfo);
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeConfigPanel(), "North");
        this._help = new Help(_resource);
    }

    public void showHelp() {
        this._help.contextHelp("loggingHelp");
    }

    public IConfigDataModel getDataModel() {
        return this._configData;
    }

    public void setDataModel(IConfigDataModel data) {
        this._configData = data;
        if (this._configData.isLoaded()) {
            this.setPanelContent(this._configData);
        }
    }

    public void initialize() throws ConfigPanelException {
        if (!this._configData.isLoaded()) {
            this._configData.load();
        }
        this.setPanelContent(this._configData);
    }

    public void resetContent() {
        this.setPanelContent(this._configData);
    }

    public void applyChanges() throws ValidationException {
        this.getPanelContent(this._configData);
    }

    public void registerEditComponents(EditMonitor editMonitor) {
        editMonitor.monitor(this._txtAccessFile);
        editMonitor.monitor(this._txtErrorFile);
    }

    public void setPanelContent(IConfigDataModel data) {
        String value = data.getAttribute("configuration.nsaccesslog");
        this._txtAccessFile.setText(value == null ? "" : value);
        value = data.getAttribute("configuration.nserrorlog");
        this._txtErrorFile.setText(value == null ? "" : value);
    }

    public void getPanelContent(IConfigDataModel data) throws ValidationException {
        data.setAttribute("configuration.nsaccesslog", this._txtAccessFile.getText());
        data.setAttribute("configuration.nserrorlog", this._txtErrorFile.getText());
    }

    private JPanel makeConfigPanel() {
        JPanel p = new JPanel();
        GBC gbc = new GBC();
        GridBagLayout gbl = new GridBagLayout();
        p.setLayout(gbl);
        this._lblAccessFile = new JLabel(_i18nLogFile);
        this._txtAccessFile = new SingleByteTextField(16);
        gbc.setGrid(0, 0, 1, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        p.add((Component)this.createLogGroup(_i18nAccessLogGroupbox, this._lblAccessFile, this._txtAccessFile), gbc);
        this._lblErrorFile = new JLabel(_i18nLogFile);
        this._txtErrorFile = new SingleByteTextField(16);
        gbc.setGrid(0, 1, 1, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        p.add((Component)this.createLogGroup(_i18nErrorLogGroupbox, this._lblErrorFile, this._txtErrorFile), gbc);
        return p;
    }

    private JPanel createLogGroup(String groupTitle, JLabel lbl, JTextField txt) {
        GBC gbc = new GBC();
        GridBagLayout gbl = new GridBagLayout();
        JPanel group = new JPanel(gbl);
        group.setBorder(BaseConfigPanel.createGroupBorder(groupTitle));
        lbl.setFont(BaseConfigPanel.getLabelFont());
        gbc.setInsets(0, 0, 0, 0);
        gbc.setGrid(0, 0, 1, 1);
        gbc.setSpace(0.0, 0.0, 17, 0);
        group.add((Component)lbl, gbc);
        gbc.setInsets(0, 6, 0, 0);
        gbc.setGrid(1, 0, 1, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        group.add((Component)txt, gbc);
        return group;
    }

    static {
        _i18nAccessLogGroupbox = _resource.getString("logging", "AccessLogGroupbox");
        _i18nErrorLogGroupbox = _resource.getString("logging", "ErrorLogGroupbox");
    }
}

