/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.BaseConfigPanel;
import com.netscape.management.admserv.config.ButtonBar;
import com.netscape.management.admserv.config.ConfigErrorDialog;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.ItemEditDialog;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class EditableList
extends JPanel
implements SuiConstants {
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    static String _i18nAddButton = _resource.getString("editlist", "AddButton");
    static String _i18nEditButton = _resource.getString("editlist", "EditButton");
    static String _i18nRemoveButton = _resource.getString("editlist", "RemoveButton");
    static String _i18nOKButton = _resource.getString("editlist", "OKButton");
    static String _i18nCancelButton = _resource.getString("editlist", "CancelButton");
    static String _i18nAddDefaultToolTip = _resource.getString("editlist", "AddDefaultToolTip");
    static String _i18nEditDefaultToolTip = _resource.getString("editlist", "EditDefaultToolTip");
    static String _i18nRemoveDefaultToolTip = _resource.getString("editlist", "RemoveDefaultToolTip");
    static String _i18nOKDefaultToolTip = _resource.getString("editlist", "OKDefaultToolTip");
    static String _i18nCancelDefaultToolTip = _resource.getString("editlist", "CancelDefaultToolTip");
    static String _i18nHelpDefaultToolTip = _resource.getString("editlist", "HelpDefaultToolTip");
    protected JList _list;
    protected DefaultListModel _listModel;
    protected JScrollPane _listScroller;
    protected ButtonBar _buttons;
    protected ItemEditDialog _editDialog;
    protected JPanel _detailsPanel;
    protected JPanel _editPanel;
    protected static String _cmdAdd = "add";
    protected static String _cmdEdit = "edit";
    protected static String _cmdRemove = "remove";
    protected JPanel _north;
    protected JPanel _south;
    public JComponent _initialFocusComponent;
    public JTextField[] _commitOnEnterComponents;
    ListSelectionListener _selectListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                EditableList.this.adjustSelection();
            }
        }
    };
    MouseListener _dblclkListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            JList list;
            int idx;
            if (e.getClickCount() == 2 && (idx = (list = (JList)e.getSource()).locationToIndex(e.getPoint())) >= 0) {
                EditableList.this.createEditDialog(false);
                String item = (String)EditableList.this._listModel.getElementAt(idx);
                EditableList.this.setEditPanelParameters(item);
                while (true) {
                    EditableList.this._editDialog.setVisible(true);
                    if (!EditableList.this._editDialog.getCommand().equals("ok")) break;
                    try {
                        EditableList.this.validateEdit();
                        String newName = EditableList.this.getEditPanelItem().trim();
                        EditableList.this.processEditOperation(newName);
                    }
                    catch (ValidationException ex) {
                        ConfigErrorDialog.showDialog(EditableList.this._north, ex);
                        continue;
                    }
                    break;
                }
            }
        }
    };
    ActionListener _btnListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            block11: {
                int idx = EditableList.this.getSelectedIndex();
                String cmd = e.getActionCommand();
                if (cmd.equals(_cmdAdd)) {
                    EditableList.this.createEditDialog(true);
                    EditableList.this.setEditPanelParameters(null);
                    while (true) {
                        EditableList.this._editDialog.setVisible(true);
                        if (!EditableList.this._editDialog.getCommand().equals("ok")) break block11;
                        try {
                            EditableList.this.validateEdit();
                            String item = EditableList.this.getEditPanelItem().trim();
                            EditableList.this.addItem(item);
                            break block11;
                        }
                        catch (ValidationException ex) {
                            ConfigErrorDialog.showDialog(EditableList.this._north, ex);
                            continue;
                        }
                        break;
                    }
                }
                if (cmd.equals(_cmdEdit)) {
                    EditableList.this.createEditDialog(false);
                    if (idx >= 0) {
                        String item = (String)EditableList.this._listModel.getElementAt(idx);
                        EditableList.this.setEditPanelParameters(item);
                        while (true) {
                            EditableList.this._editDialog.setVisible(true);
                            if (!EditableList.this._editDialog.getCommand().equals("ok")) break;
                            try {
                                EditableList.this.validateEdit();
                                String newName = EditableList.this.getEditPanelItem().trim();
                                EditableList.this.processEditOperation(newName);
                            }
                            catch (ValidationException ex) {
                                ConfigErrorDialog.showDialog(EditableList.this._north, ex);
                                continue;
                            }
                            break;
                        }
                    }
                } else if (cmd.equals(_cmdRemove) && idx >= 0) {
                    EditableList.this.removeItem((String)EditableList.this._listModel.getElementAt(idx));
                    EditableList.this._listModel.removeElementAt(idx);
                }
            }
            EditableList.this.adjustSelection();
        }
    };

    public EditableList() {
        this.setLayout(new BorderLayout(0, 12));
        this.createLayout();
    }

    protected void finalize() {
        if (this._editDialog != null) {
            this._editDialog.dispose();
            ModalDialogUtil.sleep();
        }
    }

    public void addListDataListener(ListDataListener listener) {
        this._listModel.addListDataListener(listener);
    }

    public void removeListDataListener(ListDataListener listener) {
        this._listModel.removeListDataListener(listener);
    }

    private void createLayout() {
        this.setBorder(BorderFactory.createEmptyBorder(9, 0, 0, 0));
        this._north = new JPanel(new BorderLayout(9, 0));
        this._list = new JList();
        this._listModel = new DefaultListModel();
        this._list.setModel(this._listModel);
        this._list.addListSelectionListener(this._selectListener);
        this._list.addMouseListener(this._dblclkListener);
        this._list.setVisibleRowCount(5);
        this._list.setBackground(Color.white);
        this._listScroller = new JScrollPane();
        this._listScroller.getViewport().setView(this._list);
        this._listScroller.setBorder(BorderFactory.createLoweredBevelBorder());
        this._buttons = new ButtonBar(new String[]{_cmdAdd, _cmdEdit, _cmdRemove}, new String[]{_i18nAddButton, _i18nEditButton, _i18nRemoveButton}, new String[]{this.getAddToolTip(), this.getEditToolTip(), this.getRemoveToolTip()}, false);
        this._buttons.addActionListener(this._btnListener);
        this._buttons.getButton(_cmdEdit).setEnabled(false);
        this._buttons.getButton(_cmdRemove).setEnabled(false);
        this._north.add((Component)this._listScroller, "Center");
        this._north.add((Component)this._buttons, "East");
        this._detailsPanel = this.getDetailsPanel();
        this.add((Component)this._north, "Center");
        if (this._detailsPanel != null) {
            this._south = new JPanel(new BorderLayout());
            this._south.setBorder(BaseConfigPanel.createGroupBorder(this.getDetailsTitle()));
            this._south.add(this._detailsPanel);
            this.add((Component)this._south, "South");
        }
        this._editPanel = this.getEditPanel();
    }

    int findItemIndex(String item) {
        int i = 0;
        while (i < this._listModel.getSize()) {
            String curItem = (String)this._listModel.getElementAt(i);
            if (curItem.equals(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void addItem(String item) {
        if (item.length() == 0) {
            return;
        }
        if (this.findItemIndex(item) == -1) {
            this.createItem(item);
            this._listModel.addElement(item);
        } else {
            this.updateItem(item, false);
        }
        this.selectItem(item);
        this._list.setSelectedIndex(this.findItemIndex(item));
    }

    void processEditOperation(String item) {
        int idx = this._list.getSelectedIndex();
        if (idx < 0) {
            return;
        }
        if (item.length() == 0) {
            this._listModel.removeElementAt(idx);
            this.removeItem(item);
        } else {
            String itemOldName = (String)this._listModel.getElementAt(idx);
            boolean isRenamed = !itemOldName.equals(item);
            this._listModel.setElementAt(item, idx);
            this.updateItem(itemOldName, isRenamed);
            this._list.setSelectedIndex(this.findItemIndex(item));
            if (isRenamed) {
                this._list.repaint();
            }
        }
    }

    int getSelectedIndex() {
        int idx = this._list.getSelectedIndex();
        return idx < this._listModel.size() ? idx : -1;
    }

    void adjustSelection() {
        int idx = this.getSelectedIndex();
        this._buttons.getButton(_cmdEdit).setEnabled(idx >= 0);
        this._buttons.getButton(_cmdRemove).setEnabled(idx >= 0);
        this.selectItem(idx >= 0 ? (String)this._listModel.getElementAt(idx) : null);
    }

    protected void createEditDialog(boolean setAddTitle) {
        this._editDialog = setAddTitle ? new ItemEditDialog(this._north, this.getAddTitle(), this._editPanel, this) : new ItemEditDialog(this._north, this.getEditTitle(), this._editPanel, this);
        this._editDialog.setHelpResourceSet(this.getHelpResourceSet());
        this._editDialog.setHelpToken(this.getHelpToken());
    }

    public void setList(Vector v) {
        this._listModel.removeAllElements();
        int i = 0;
        while (i < v.size()) {
            this._listModel.addElement(v.elementAt(i));
            ++i;
        }
        this._buttons.getButton(_cmdEdit).setEnabled(false);
        this._buttons.getButton(_cmdRemove).setEnabled(false);
        if (v.size() > 0) {
            this._list.setSelectedIndex(0);
            this._buttons.getButton(_cmdEdit).setEnabled(true);
            this._buttons.getButton(_cmdRemove).setEnabled(true);
        }
    }

    public Vector getList() {
        Vector v = new Vector();
        int i = 0;
        while (i < this._listModel.getSize()) {
            v.addElement(this._listModel.getElementAt(i));
            ++i;
        }
        return v;
    }

    public abstract JPanel getDetailsPanel();

    public abstract String getDetailsTitle();

    public abstract JPanel getEditPanel();

    public abstract String getEditTitle();

    public abstract String getAddTitle();

    public abstract ResourceSet getHelpResourceSet();

    public abstract String getHelpToken();

    public abstract void validateEdit() throws ValidationException;

    protected String getEditToolTip() {
        return _i18nEditDefaultToolTip;
    }

    protected String getAddToolTip() {
        return _i18nAddDefaultToolTip;
    }

    protected String getRemoveToolTip() {
        return _i18nRemoveDefaultToolTip;
    }

    public abstract void setEditPanelParameters(String var1);

    public abstract void createItem(String var1);

    public abstract void updateItem(String var1, boolean var2);

    public abstract void removeItem(String var1);

    public abstract void selectItem(String var1);

    public abstract String getEditPanelItem();

    public void setEditPanelInitalFocusComponent(JComponent c) {
        this._initialFocusComponent = c;
    }

    public void setEditPanelCommitOnEnterComponents(JTextField[] components) {
        this._commitOnEnterComponents = components;
    }
}

