/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.BaseConfigPanel;
import com.netscape.management.admserv.config.ConfigPanelException;
import com.netscape.management.admserv.config.EditMonitor;
import com.netscape.management.admserv.config.FilteredInputDocument;
import com.netscape.management.admserv.config.GBC;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.PluginConfigPanel;
import com.netscape.management.admserv.config.RemoteRequestException;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.AdminConfigData;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.SingleByteTextField;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class DirectoryConfigPanel
extends PluginConfigPanel
implements SuiConstants {
    IConfigDataModel _configData;
    String _defaultPort = "389";
    String _defaultSSLPort = "636";
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    static String _i18nHost;
    static String _i18nPort;
    static String _i18nDSGroupbox;
    static String _i18nUseSSL;
    static String _i18nEnterLdapHost;
    static String _i18nEnterLdapPort;
    static String _i18nPortRange;
    static String _i18nWarnMigrate;
    static String _i18nWarnCert;
    Help _help;
    public static final int topInset = 6;
    public static final int rghtColInset = 9;
    JLabel _lblHost;
    JLabel _lblPort;
    JCheckBox _cbSSL;
    JTextField _txtPort;
    SingleByteTextField _txtHost;
    ActionListener _cbSSLListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (DirectoryConfigPanel.this._cbSSL.isSelected() && DirectoryConfigPanel.this._txtPort.getText().equals(DirectoryConfigPanel.this._defaultPort)) {
                DirectoryConfigPanel.this._txtPort.setText(DirectoryConfigPanel.this._defaultSSLPort);
            } else if (!DirectoryConfigPanel.this._cbSSL.isSelected() && DirectoryConfigPanel.this._txtPort.getText().equals(DirectoryConfigPanel.this._defaultSSLPort)) {
                DirectoryConfigPanel.this._txtPort.setText(DirectoryConfigPanel.this._defaultPort);
            }
        }
    };

    public DirectoryConfigPanel(String title, IConfigDataModel data) {
        super(title);
        this._configData = data;
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeConfigPanel(), "North");
        this._help = new Help(_resource);
    }

    public void showHelp() {
        this._help.contextHelp("ldapHelp");
    }

    public IConfigDataModel getDataModel() {
        return this._configData;
    }

    public void setDataModel(IConfigDataModel data) {
        this._configData = data;
        if (this._configData.isLoaded()) {
            this.setPanelContent(this._configData);
        }
    }

    public void initialize() throws RemoteRequestException {
        if (!this._configData.isLoaded()) {
            this._configData.load();
        }
        this.setPanelContent(this._configData);
        this._cbSSL.addActionListener(this._cbSSLListener);
    }

    public void resetContent() {
        this.setPanelContent(this._configData);
    }

    public void applyChanges() throws ConfigPanelException {
        this.getPanelContent(this._configData);
    }

    public void registerEditComponents(EditMonitor editMonitor) {
        editMonitor.monitor(this._txtPort);
        editMonitor.monitor((JTextComponent)this._txtHost);
        editMonitor.monitor(this._cbSSL);
    }

    public void setPanelContent(IConfigDataModel data) {
        this.setLDAPHost(data.getAttribute("dsconfig.host"));
        this.setLDAPPort(data.getAttribute("dsconfig.port"));
        this.setSSL(data.getAttribute("dsconfig.ssl"));
    }

    String getSSL() {
        return this._cbSSL.isSelected() ? "true" : "false";
    }

    void setSSL(String booleanFlag) {
        this._cbSSL.setSelected(booleanFlag != null && booleanFlag.equals("true"));
    }

    void setLDAPHost(String host) {
        this._txtHost.setText(host == null ? "" : host);
    }

    void setLDAPPort(String port) {
        this._txtPort.setText(port == null ? "" : port);
    }

    public void getPanelContent(IConfigDataModel data) throws ConfigPanelException {
        String host = this._txtHost.getText().trim();
        String port = this._txtPort.getText().trim();
        if (host.length() == 0) {
            throw new ValidationException("", _i18nEnterLdapHost);
        }
        if (port.length() == 0) {
            throw new ValidationException("", _i18nEnterLdapPort);
        }
        int portNum = -1;
        try {
            portNum = Integer.parseInt(port);
            if (portNum < 1 || portNum > 65535) {
                throw new ValidationException("", _i18nPortRange);
            }
        }
        catch (Exception e) {
            throw new ValidationException("", _i18nPortRange);
        }
        try {
            LDAPUtil.validateLDAPParams((String)host, (int)portNum, (boolean)this._cbSSL.isSelected(), null, null, null);
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("", e.getMessage());
        }
        data.setAttribute("dsconfig.host", host);
        data.setAttribute("dsconfig.port", port);
        data.setAttribute("dsconfig.ssl", this.getSSL());
        if (data instanceof AdminConfigData) {
            ((AdminConfigData)data).setDialogParent(this);
        }
    }

    protected JComponent makeConfigPanel() {
        JPanel p = new JPanel();
        GBC gbc = new GBC();
        GridBagLayout gbl = new GridBagLayout();
        p.setLayout(gbl);
        gbc.setGrid(0, 0, 1, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        p.add((Component)this.createServerGroup(), gbc);
        return p;
    }

    private JPanel createServerGroup() {
        GBC gbc = new GBC();
        GridBagLayout gbl = new GridBagLayout();
        JPanel group = new JPanel(gbl);
        group.setBorder(BaseConfigPanel.createGroupBorder(_i18nDSGroupbox));
        int row = 0;
        gbc.setInsets(0, 0, 0, 0);
        gbc.setGrid(0, row, 3, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        group.add((Component)this.createInfoMessage(), gbc);
        this._lblHost = new JLabel(_i18nHost);
        gbc.setInsets(0, 0, 0, 0);
        gbc.setGrid(0, ++row, 1, 1);
        gbc.setSpace(0.0, 0.0, 13, 0);
        group.add((Component)this._lblHost, gbc);
        this._txtHost = new SingleByteTextField(16);
        gbc.setInsets(0, 9, 0, 0);
        gbc.setGrid(1, row, 2, 1);
        gbc.setSpace(0.0, 0.0, 17, 2);
        group.add((Component)this._txtHost, gbc);
        this._lblHost.setLabelFor((Component)this._txtHost);
        this._lblPort = new JLabel(_i18nPort);
        gbc.setInsets(6, 0, 0, 0);
        gbc.setGrid(0, ++row, 1, 1);
        gbc.setSpace(0.0, 0.0, 13, 0);
        group.add((Component)this._lblPort, gbc);
        this._txtPort = new JTextField("389", 6);
        ((JTextComponent)this._txtPort).setDocument(FilteredInputDocument.allowDigitsOnly());
        gbc.setInsets(6, 9, 0, 0);
        gbc.setGrid(1, row, 1, 1);
        gbc.setSpace(0.0, 0.0, 17, 2);
        group.add((Component)this._txtPort, gbc);
        this._lblPort.setLabelFor(this._txtPort);
        this._cbSSL = new JCheckBox(_i18nUseSSL, false);
        gbc.setInsets(6, 18, 0, 0);
        gbc.setGrid(2, row, 1, 1);
        gbc.setSpace(1.0, 0.0, 17, 0);
        group.add((Component)this._cbSSL, gbc);
        return group;
    }

    private JPanel createInfoMessage() {
        GBC gbc = new GBC();
        GridBagLayout gbl = new GridBagLayout();
        JPanel group = new JPanel(gbl);
        int row = 0;
        JLabel refLabel = new JLabel();
        gbc.setInsets(0, 6, 0, 0);
        gbc.setGrid(1, row, 1, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        MultilineLabel mll = new MultilineLabel(_i18nWarnMigrate, 1, 36);
        group.add((Component)mll, gbc);
        mll.setFont(refLabel.getFont());
        gbc.setInsets(6, 6, 9, 0);
        gbc.setGrid(1, ++row, 1, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        mll = new MultilineLabel(_i18nWarnCert, 1, 36);
        group.add((Component)mll, gbc);
        mll.setFont(refLabel.getFont());
        ++row;
        return group;
    }

    public void setPort(String port) {
        this._txtPort.setText(port != null ? port : "");
    }

    public String getPort() {
        String port = this._txtPort.getText();
        return port;
    }

    public void setHost(String host) {
        this._txtHost.setText(host != null ? host : "");
    }

    public String getHost() {
        String host = this._txtHost.getText();
        return host;
    }

    static {
        _i18nDSGroupbox = _resource.getString("ldapds", "DSGroupbox");
        _i18nHost = _resource.getString("ldapds", "DSHost");
        _i18nPort = _resource.getString("ldapds", "Port");
        _i18nUseSSL = _resource.getString("ldapds", "UseSSL");
        _i18nEnterLdapHost = _resource.getString("ldapds", "EnterLdapHost");
        _i18nEnterLdapPort = _resource.getString("ldapds", "EnterLdapPort");
        _i18nPortRange = _resource.getString("common", "PortRange");
        _i18nWarnMigrate = _resource.getString("ldapds", "WarnMigrate");
        _i18nWarnCert = _resource.getString("ldapds", "WarnCert");
    }
}

