/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.CGIDataModel;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.util.Hashtable;
import java.util.Vector;

public class CGISNMPSetup
extends CGIDataModel {
    private static String _taskURL = "admin-serv/tasks/Configuration/SNMPSetup";
    public static final String COMMUNITY_NAME = "community";
    public static final String COMMUNITY_OPERATION = "operation";
    public static final String MANAGER_NAME = "mananger";
    public static final String MANAGER_PORT = "port";
    public static final String MANAGER_COMMUNITY = "community";

    public CGISNMPSetup(ConsoleInfo consoleInfo) {
        super(consoleInfo, _taskURL);
    }

    public static int findEntry(Vector list, String propName, String propValue) {
        int i = 0;
        while (i < list.size()) {
            Hashtable entry = (Hashtable)list.elementAt(i);
            String prop = (String)entry.get(propName);
            if (prop.equals(propValue)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Hashtable createCommunityEntry(String community, String operation) {
        Hashtable<String, String> entry = new Hashtable<String, String>();
        entry.put("community", community);
        entry.put(COMMUNITY_OPERATION, operation);
        return entry;
    }

    public static Vector stringToCommunityVector(String value) throws ValidationException {
        if (value == null) {
            throw new ValidationException("", "Community list is undefined");
        }
        if (value.equals("-")) {
            return new Vector();
        }
        Vector v = CGIDataModel.commaStringToVector(value);
        int i = 0;
        while (i < v.size()) {
            String rawValue = (String)v.elementAt(i);
            v.setElementAt(CGISNMPSetup.stringToCommunityEntry(rawValue), i);
            ++i;
        }
        return v;
    }

    public static Hashtable stringToCommunityEntry(String value) throws ValidationException {
        String community = null;
        String operation = null;
        int idx = value.indexOf("\t");
        if (idx < 1) {
            throw new ValidationException("<" + value + ">", "Field separator <TAB> not found");
        }
        community = value.substring(0, idx);
        operation = value.substring(idx + 1);
        if (operation.equals("ALL") || operation.equals("SET") || operation.equals("GET")) {
            return CGISNMPSetup.createCommunityEntry(community, operation);
        }
        throw new ValidationException("<" + operation + ">", "Bad value for operation");
    }

    public static String communityVectorToString(Vector v) throws ValidationException {
        String value = null;
        int i = 0;
        while (i < v.size()) {
            Hashtable entry = (Hashtable)v.elementAt(i);
            value = value == null ? CGISNMPSetup.communityEntryToString(entry) : value + "," + CGISNMPSetup.communityEntryToString(entry);
            ++i;
        }
        return value == null ? "-" : value;
    }

    public static String communityEntryToString(Hashtable entry) throws ValidationException {
        String value = null;
        if (entry.get("community") == null) {
            Thread.currentThread();
            Thread.dumpStack();
            Debug.println((String)"Community property community not found");
        }
        if (entry.get(COMMUNITY_OPERATION) == null) {
            Thread.currentThread();
            Thread.dumpStack();
            Debug.println((String)"Community property operation not found");
        }
        value = (String)entry.get("community") + "\t" + (String)entry.get(COMMUNITY_OPERATION);
        return value;
    }

    public static Hashtable createManagerEntry(String manager, String port, String community) {
        Hashtable<String, String> entry = new Hashtable<String, String>();
        entry.put(MANAGER_NAME, manager);
        entry.put(MANAGER_PORT, port);
        entry.put("community", community);
        return entry;
    }

    public static Vector stringToManagerVector(String value) throws ValidationException {
        if (value == null) {
            throw new ValidationException("", "Manager list is undefined");
        }
        if (value.equals("-")) {
            return new Vector();
        }
        Vector v = CGIDataModel.commaStringToVector(value);
        int i = 0;
        while (i < v.size()) {
            String rawValue = (String)v.elementAt(i);
            v.setElementAt(CGISNMPSetup.stringToManagerEntry(rawValue), i);
            ++i;
        }
        return v;
    }

    public static Hashtable stringToManagerEntry(String value) throws ValidationException {
        String manager = null;
        String port = null;
        String community = null;
        int tab1 = value.indexOf("\t");
        if (tab1 < 1) {
            throw new ValidationException("<" + value + ">", "Field separator <TAB> not found");
        }
        int tab2 = value.indexOf("\t", tab1 + 1);
        if (tab2 < 1) {
            throw new ValidationException("<" + value + ">", "Second field separator <TAB> not found");
        }
        manager = value.substring(0, tab1);
        port = value.substring(tab1 + 1, tab2);
        community = value.substring(tab2 + 1);
        Debug.println((String)("manager={" + manager + "} port={" + port + "} community={" + community + "}"));
        try {
            int portValue = Integer.parseInt(port);
            if (portValue < 1 || portValue > 65535) {
                ResourceSet rs = new ResourceSet("com.netscape.management.admserv.panel.panel");
                String msg = rs.getString("common", "PortRange");
                throw new ValidationException("", msg);
            }
        }
        catch (Exception ex) {
            ResourceSet rs = new ResourceSet("com.netscape.management.admserv.panel.panel");
            String msg = rs.getString("common", "PortRange");
            throw new ValidationException("", msg);
        }
        return CGISNMPSetup.createManagerEntry(manager, port, community);
    }

    public static String managerVectorToString(Vector v) throws ValidationException {
        String value = null;
        int i = 0;
        while (i < v.size()) {
            Hashtable entry = (Hashtable)v.elementAt(i);
            value = value == null ? CGISNMPSetup.managerEntryToString(entry) : value + "," + CGISNMPSetup.managerEntryToString(entry);
            ++i;
        }
        return value == null ? "-" : value;
    }

    public static String managerEntryToString(Hashtable entry) throws ValidationException {
        String value = null;
        if (entry.get(MANAGER_NAME) == null) {
            Thread.currentThread();
            Thread.dumpStack();
            Debug.println((String)"Manager property mananger not found");
        }
        if (entry.get(MANAGER_PORT) == null) {
            Thread.currentThread();
            Thread.dumpStack();
            Debug.println((String)"Manager property port not found");
        }
        if (entry.get("community") == null) {
            Thread.currentThread();
            Thread.dumpStack();
            Debug.println((String)"Manager community community not found");
        }
        value = (String)entry.get(MANAGER_NAME) + "\t" + (String)entry.get(MANAGER_PORT) + "\t" + (String)entry.get("community");
        return value;
    }

    public String getCGIParamsForGetOp() {
        return "op=getconfig";
    }

    public String getCGIParamsForSetOp() {
        String result = "op=setconfig&" + this.toURLformat(this._data);
        Debug.println((String)("SNMPConfigData.getCGIParamsForSetOp=<" + result + ">"));
        return result;
    }
}

