/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.config;

import com.netscape.management.admserv.config.ActionMonitorPanel;
import com.netscape.management.admserv.config.ButtonBar;
import com.netscape.management.admserv.config.ConfigErrorDialog;
import com.netscape.management.admserv.config.ConfigPanelException;
import com.netscape.management.admserv.config.EditMonitor;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.IPluginConfigPanel;
import com.netscape.management.admserv.panel.DialogFrame;
import com.netscape.management.client.Framework;
import com.netscape.management.client.StatusItemProgress;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Permissions;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class BaseConfigPanel
extends JPanel
implements SuiConstants {
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.config.config");
    static String _i18nStatusLoading = _resource.getString("baseconfig", "StatusLoading");
    static String _i18nStatusSaving = _resource.getString("baseconfig", "StatusSaving");
    static String _i18nLoadFailed = _resource.getString("baseconfig", "LoadFailed");
    static String _i18nSaveToolTip = _resource.getString("baseconfig", "SaveToolTip");
    static String _i18nResetToolTip = _resource.getString("baseconfig", "ResetToolTip");
    static String _i18nHelpToolTip = _resource.getString("baseconfig", "HelpToolTip");
    private static String[] _toolTips = new String[]{_i18nSaveToolTip, _i18nResetToolTip, null, _i18nHelpToolTip};
    protected JLabel _heading;
    protected ButtonBar _cmdButtons;
    protected JComboBox _targetChoice;
    protected EditMonitor _editMonitor;
    protected JPanel _editPanel;
    protected ActionMonitorPanel _actionPanel = new ActionMonitorPanel();
    protected CardLayout _card;
    protected boolean _initialized;
    protected boolean _dataValid;
    protected boolean _dataSaved;
    protected static Font _fontHeadingLabel = UIManager.getFont("Title.font");
    protected static Font _fontLabel = UIManager.getFont("Panel.font");
    protected IPluginConfigPanel _pluginPanel;
    protected boolean _hasTitle;
    protected boolean _inDialog;
    ActionListener _btnListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            BaseConfigPanel.this.commandButtonAction(e.getActionCommand());
        }
    };
    private JPanel _currentPanel;
    static /* synthetic */ Class class$com$netscape$management$client$Framework;
    static /* synthetic */ Class class$com$netscape$management$admserv$panel$DialogFrame;

    public BaseConfigPanel(IPluginConfigPanel pluginPanel) {
        this(pluginPanel, false);
    }

    public BaseConfigPanel(IPluginConfigPanel pluginPanel, boolean inDialog) {
        int vi = 3;
        int hi = 3;
        this._card = new CardLayout();
        this.setLayout(this._card);
        if (!inDialog) {
            this.setBorder(BorderFactory.createEmptyBorder(vi, hi, vi, hi));
        }
        this._inDialog = inDialog;
        this._editPanel = new JPanel();
        this._editPanel.setLayout(new BorderLayout(0, 12));
        this.add((Component)this._editPanel, "edit");
        this.setPluginPanel(pluginPanel);
    }

    public void setPluginPanel(IPluginConfigPanel pluginPanel) {
        this._pluginPanel = pluginPanel;
        this._cmdButtons = this.createCommandButtonBar();
        this._editMonitor = this.createEditMonitor();
        this._hasTitle = this._pluginPanel.getTitleText() != null && this._pluginPanel.getTitleText().length() != 0;
        this._heading = this.createHeadingLabel(this._pluginPanel.getTitleText());
        this.createEditLayout();
        if (this.isPluginModelLoaded()) {
            this.showPanel(this._editPanel);
            this.initPluginPanel();
        } else {
            this.monitorPluginPanelInit();
        }
    }

    public boolean isInitialized() {
        if (this._initialized) {
            this.showPanel(this._editPanel);
        }
        return this._initialized;
    }

    public IPluginConfigPanel getPluginPanel() {
        return this._pluginPanel;
    }

    public static BaseConfigPanel getInstance(Component c) {
        while (c != null && !(c instanceof BaseConfigPanel)) {
            c = c.getParent();
        }
        return (BaseConfigPanel)c;
    }

    protected boolean isPluginModelLoaded() {
        IConfigDataModel data = this._pluginPanel.getDataModel();
        return data != null && data.isLoaded();
    }

    protected void initPluginPanel() {
        this._initialized = false;
        try {
            IConfigDataModel data = this._pluginPanel.getDataModel();
            if (data != null && !data.isLoaded()) {
                data.load();
            }
            this._pluginPanel.initialize();
        }
        catch (ConfigPanelException e) {
            ConfigErrorDialog.showDialog(this._pluginPanel.getPanel(), e);
            return;
        }
        this._pluginPanel.registerEditComponents(this._editMonitor);
        this._editMonitor.start();
        this._initialized = true;
    }

    protected void monitorPluginPanelInit() {
        Method m = Permissions.getEnablePrivilegeMethod();
        if (m != null) {
            Object[] args = new Object[]{"UniversalThreadGroupAccess"};
            try {
                m.invoke(null, args);
            }
            catch (Exception e) {
                Debug.println((String)("ThreadGroup:monitorPluginPanelInit():unable to grant ThreadGroup privileges:" + e));
            }
        }
        this.showPanel(this._actionPanel);
        final ThreadGroup tg = new ThreadGroup("LongActionTG");
        Thread t = new Thread(tg, "LongAction"){
            ActionListener _stopAction = new ActionListener(this){
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    1.access$000(this.this$1).closeDialog();
                }
            };

            public void run() {
                try {
                    Thread.currentThread();
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                BaseConfigPanel.this._actionPanel.monitorProgressStart(_i18nStatusLoading, tg, this._stopAction);
                BaseConfigPanel.this.initPluginPanel();
                BaseConfigPanel.this._actionPanel.monitorProgressStop(BaseConfigPanel.this._initialized ? "" : _i18nLoadFailed);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            if (1.access$000(this.this$1)._initialized) {
                                1.access$000(this.this$1).showPanel(1.access$000(this.this$1)._editPanel);
                            } else if (1.access$000(this.this$1)._inDialog) {
                                1.access$000(this.this$1).closeDialog();
                            }
                        }
                    });
                }
                catch (Exception e1) {
                    Debug.println((String)("monitorPluginPanelInit invokeAndWait " + e1));
                }
            }

            static /* synthetic */ BaseConfigPanel access$000(1 x0) {
                return x0.BaseConfigPanel.this;
            }
        };
        t.start();
    }

    protected void createEditLayout() {
        if (this._heading != null) {
            this._editPanel.add((Component)this.createNorthPanel(), "North");
        }
        if (this._pluginPanel != null) {
            this._editPanel.add((Component)this.createCenterPanel(), "Center");
        }
        if (this._cmdButtons != null) {
            this._editPanel.add((Component)this.createSouthPanel(), "South");
        }
    }

    protected JPanel createNorthPanel() {
        JPanel p = new JPanel(new BorderLayout(0, 12));
        if (this._heading != null) {
            p.add((Component)this._heading, "North");
        }
        return p;
    }

    protected JPanel createCenterPanel() {
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this._pluginPanel.getPanel(), "Center");
        return p;
    }

    protected JLabel createHeadingLabel(String label) {
        if (label == null || label.length() == 0) {
            return null;
        }
        JLabel heading = new JLabel(label, 2);
        heading.setFont(_fontHeadingLabel);
        return heading;
    }

    protected JPanel createSouthPanel() {
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this._cmdButtons, "East");
        return p;
    }

    public ButtonBar createCommandButtonBar() {
        ButtonBar bb = new ButtonBar(this._inDialog, _toolTips);
        bb.addActionListener(this._btnListener);
        return bb;
    }

    public ButtonBar getCommandButtonBar() {
        return this._cmdButtons;
    }

    protected EditMonitor createEditMonitor() {
        if (this._cmdButtons == null) {
            return null;
        }
        EditMonitor monitor = new EditMonitor();
        monitor.addEnableComponent(this._cmdButtons.getButton("ok"));
        if (!this._inDialog) {
            monitor.addEnableComponent(this._cmdButtons.getButton("cancel"));
        }
        return monitor;
    }

    public EditMonitor getEditMonitor() {
        return this._editMonitor;
    }

    protected void commandButtonAction(String command) {
        block12: {
            if (command.equals("ok")) {
                this._dataSaved = false;
                this._dataValid = false;
                try {
                    this._pluginPanel.applyChanges();
                    this._dataValid = true;
                    if (this.isPluginModelModified()) {
                        this.monitorLongAction(_i18nStatusSaving, new Runnable(){

                            public void run() {
                                BaseConfigPanel.this.savePluginPanel();
                            }
                        });
                        break block12;
                    }
                    this._editMonitor.setDirtyFlag(false);
                }
                catch (ConfigPanelException e) {
                    ConfigErrorDialog.showDialog(this._pluginPanel.getPanel(), e);
                }
            } else if (command.equals("cancel")) {
                if (this._inDialog) {
                    this.closeDialog();
                    return;
                }
                try {
                    this._pluginPanel.resetContent();
                }
                catch (ConfigPanelException e) {
                    ConfigErrorDialog.showDialog(this._pluginPanel.getPanel(), e);
                    return;
                }
                this._editMonitor.setDirtyFlag(false);
            } else if (command.equals("help")) {
                this._pluginPanel.showHelp();
            } else {
                Debug.println((String)(command + " not implemented"));
            }
        }
    }

    protected boolean isPluginModelModified() {
        IConfigDataModel data = this._pluginPanel.getDataModel();
        return data != null && data.isModified();
    }

    void savePluginPanel() {
        try {
            this._pluginPanel.getDataModel().save();
            this._dataSaved = true;
            this._pluginPanel.resetContent();
            this._editMonitor.setDirtyFlag(false);
            this.closeDialog();
        }
        catch (ConfigPanelException e) {
            ConfigErrorDialog.showDialog(this._pluginPanel.getPanel(), e);
        }
    }

    public void monitorLongAction(Runnable action) {
        this.monitorLongAction(_i18nStatusLoading, action);
    }

    public void monitorLongAction(String msg, Runnable action) {
        Method m = Permissions.getEnablePrivilegeMethod();
        if (m != null) {
            Object[] args = new Object[]{"UniversalThreadGroupAccess"};
            try {
                m.invoke(null, args);
            }
            catch (Exception e) {
                Debug.println((String)("BaseConfigPanel:monitorLongAction():unable to grant ThreadGroup privileges:" + e));
            }
        }
        this.showPanel(this._actionPanel);
        final ThreadGroup tg = new ThreadGroup("LongActionTG");
        final Runnable actionTask = action;
        final String actionMsg = msg;
        Thread t = new Thread(tg, "LongAction"){
            ActionListener _stopAction = new ActionListener(this){
                private final /* synthetic */ 6 this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    6.access$100(this.this$1).showPanel(6.access$100(this.this$1)._editPanel);
                }
            };

            public void run() {
                BaseConfigPanel.this._actionPanel.monitorProgressStart(actionMsg, tg, this._stopAction);
                actionTask.run();
                BaseConfigPanel.this._actionPanel.monitorProgressStop("");
                BaseConfigPanel.this.showPanel(BaseConfigPanel.this._editPanel);
            }

            static /* synthetic */ BaseConfigPanel access$100(6 x0) {
                return x0.BaseConfigPanel.this;
            }
        };
        t.start();
    }

    protected Window getDialog() {
        Container c = this;
        while ((c = c.getParent()) != null) {
            if (!(c instanceof Dialog) && !(c instanceof JDialog)) continue;
            return (Window)c;
        }
        return null;
    }

    protected void closeDialog() {
        Window dialog = this.getDialog();
        if (dialog != null) {
            ((Component)dialog).setVisible(false);
        }
    }

    public static Border createGroupBorder(String label) {
        TitledBorder titleBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), label);
        Border interiorBorder = BorderFactory.createEmptyBorder(6, 6, 6, 6);
        return BorderFactory.createCompoundBorder(titleBorder, interiorBorder);
    }

    public static Font getLabelFont() {
        return _fontLabel;
    }

    public static Font getHeadingLabelFont() {
        return _fontHeadingLabel;
    }

    protected void showPanel(JPanel panel) {
        if (panel == this._actionPanel) {
            this.add((Component)this._actionPanel, "action");
            this._card.show(this, "action");
            this._currentPanel = panel;
        } else {
            if (this._currentPanel == this._actionPanel) {
                this._actionPanel.setVisible(false);
                this.remove(this._actionPanel);
            }
            this._card.show(this, "edit");
            this._currentPanel = panel;
        }
    }

    private static Framework getActiveFrame(Component c) {
        Framework activeFrame = null;
        if (c != null) {
            activeFrame = (Framework)SwingUtilities.getAncestorOfClass(class$com$netscape$management$client$Framework == null ? (class$com$netscape$management$client$Framework = BaseConfigPanel.class$("com.netscape.management.client.Framework")) : class$com$netscape$management$client$Framework, c);
        }
        if (activeFrame == null) {
            activeFrame = (Framework)UtilConsoleGlobals.getActivatedFrame();
        }
        return activeFrame;
    }

    public static void setProgressIndicator(Component c, String text, int total, int done) {
        Framework activeFrame;
        DialogFrame dialog = (DialogFrame)((Object)SwingUtilities.getAncestorOfClass(class$com$netscape$management$admserv$panel$DialogFrame == null ? (class$com$netscape$management$admserv$panel$DialogFrame = BaseConfigPanel.class$("com.netscape.management.admserv.panel.DialogFrame")) : class$com$netscape$management$admserv$panel$DialogFrame, c));
        if (dialog != null) {
            dialog.setBusyCursor(true);
        }
        if ((activeFrame = BaseConfigPanel.getActiveFrame(c)) == null) {
            return;
        }
        Integer proc = StatusItemProgress.STATE_BUSY;
        if (total > 0) {
            proc = new Integer(total == done ? 100 : (int)((double)done * 100.0 / (double)total));
        }
        activeFrame.setBusyCursor(true);
        activeFrame.changeStatusItemState("StatusItemText", (Object)text);
        activeFrame.changeStatusItemState("StatusItemProgress", (Object)proc);
    }

    public static void clearProgressIndicator(Component c) {
        Framework activeFrame;
        DialogFrame dialog = (DialogFrame)((Object)SwingUtilities.getAncestorOfClass(class$com$netscape$management$admserv$panel$DialogFrame == null ? (class$com$netscape$management$admserv$panel$DialogFrame = BaseConfigPanel.class$("com.netscape.management.admserv.panel.DialogFrame")) : class$com$netscape$management$admserv$panel$DialogFrame, c));
        if (dialog != null) {
            dialog.setBusyCursor(false);
        }
        if ((activeFrame = BaseConfigPanel.getActiveFrame(c)) == null) {
            return;
        }
        activeFrame.setBusyCursor(false);
        activeFrame.changeStatusItemState("StatusItemText", (Object)"");
        activeFrame.changeStatusItemState("StatusItemProgress", (Object)new Integer(0));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

