/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv;

import com.netscape.management.admserv.AdminServer;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.IProductObject;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.URLByteEncoder;
import com.netscape.management.nmclf.SuiOptionPane;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class AdminServerProduct
implements IProductObject {
    protected ConsoleInfo _consoleInfo;

    public void initialize(ConsoleInfo info) {
        this._consoleInfo = info;
    }

    public boolean migrate(String serverRoot, String server, String targetDN, boolean overwrite) {
        ResourceSet resource = AdminServer._resource;
        String adminURL = this._consoleInfo.getAdminURL();
        if (adminURL == null || adminURL.equals("")) {
            Debug.println((String)"ERROR AdminServerProduct.migrate: admin URL is not available.");
            return false;
        }
        if (!this.migrateConfig(adminURL, serverRoot)) {
            Debug.println((String)"ERROR AdminServerProduct.migrate: migrateConfig failed.");
            String msg = resource.getString("status", "migrateConfigFailed");
            String title = resource.getString("status", "migrateTitle");
            SuiOptionPane.showMessageDialog(null, (Object)msg, (String)title, (int)0);
            return false;
        }
        String msg = resource.getString("status", "migrateSucceeded");
        String title = resource.getString("status", "migrateTitle");
        SuiOptionPane.showMessageDialog(null, (Object)msg, (String)title, (int)1);
        return true;
    }

    public boolean createNewInstance(String targetDN) {
        Debug.println((String)"trace AdminServerProduct.createNewInstance: not implemented.");
        return false;
    }

    protected boolean migrateConfig(String adminURL, String serverRoot) {
        String commandString = new String(adminURL + "admin-serv/tasks/operation/MigrateConfig" + "?oldServerRoot=" + URLByteEncoder.encodeUTF8((String)serverRoot));
        Debug.println((String)("TRACE AdminServerProduct.migrateConfig: MigrateConfig commandString = " + commandString));
        try {
            URL command = new URL(commandString);
            AdmTask task = new AdmTask(command, this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
            int execStatus = task.exec();
            if (execStatus != 0) {
                System.out.println("ERROR AdminServerProduct.migrateConfig: exec failed");
                return false;
            }
            int status = task.getStatus();
            if (status != 0) {
                System.out.println("ERROR AdminServerProduct.migrateConfig: exec status: " + status + ": " + task.getResult("NMC_ErrInfo"));
                return false;
            }
        }
        catch (MalformedURLException e) {
            Debug.println((String)("TRACE AdminServerProduct.migrateConfig: Bad URL: " + e));
            return false;
        }
        catch (Exception e) {
            Debug.println((String)("TRACE AdminServerProduct.migrateConfig: unhandled exception: " + e));
            return false;
        }
        return true;
    }

    protected String getTargetAdminServerID(String targetDN) {
        LDAPConnection ldc = this._consoleInfo.getLDAPConnection();
        if (ldc == null) {
            Debug.println((String)"ERROR AdminServerProduct.getTargetAdminServerID: no LDAPConnection");
            return null;
        }
        String productDN = null;
        String serverDN = null;
        String serverName = null;
        try {
            LDAPEntry entry = ldc.read(targetDN);
            if (entry == null) {
                Debug.println((String)("ERROR AdminServerProduct.getTargetAdminServerID: could not get entry = " + targetDN));
                return null;
            }
            LDAPAttribute attribute = entry.getAttribute("uniquemember", LDAPUtil.getLDAPAttributeLocale());
            if (attribute == null) {
                Debug.println((String)"ERROR AdminServerProduct.getTargetAdminServerID: no 'uniquemember' attribute");
                return null;
            }
            Enumeration e = attribute.getStringValues();
            while (e.hasMoreElements()) {
                productDN = (String)e.nextElement();
                if (productDN.startsWith("cn=Netscape Administration Server")) break;
                productDN = null;
            }
            if (productDN == null) {
                Debug.println((String)"ERROR AdminServerProduct.getTargetAdminServerID: could not get product DN.");
                return null;
            }
            entry = ldc.read(productDN);
            if (entry == null) {
                Debug.println((String)("ERROR AdminServerProduct.getTargetAdminServerID: could not get entry = " + productDN));
                return null;
            }
            serverDN = LDAPUtil.flatting((LDAPAttribute)entry.getAttribute("uniquemember", LDAPUtil.getLDAPAttributeLocale()));
            if (serverDN != null && serverDN.length() > 3) {
                serverName = serverDN.substring(3, serverDN.indexOf(44));
            }
        }
        catch (LDAPException e) {
            Debug.println((String)("ERROR AdminServerProduct.getTargetAdminServerID: " + (Object)((Object)e)));
            return null;
        }
        return serverName;
    }
}

