/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.task;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class LDAPTaskProgressDialog
extends JDialog
implements SuiConstants {
    protected final int ROWS = 10;
    protected final int COLUMNS = 30;
    private static final int PAD = 10;
    protected JButton _bCancel;
    protected JPanel _panel;
    protected JLabel _statusField;
    protected JTextArea _logField;
    protected JProgressBar _progressBar;
    protected JLabel _progressLabel;
    protected ActionListener _listener;

    public LDAPTaskProgressDialog(JFrame jFrame, String string) {
        this(jFrame, string, true);
    }

    public LDAPTaskProgressDialog(JFrame jFrame, String string, boolean bl) {
        this(jFrame, string, bl, null);
    }

    public LDAPTaskProgressDialog(JFrame jFrame, String string, boolean bl, Component component) {
        this(jFrame, string, bl, component, null);
    }

    public LDAPTaskProgressDialog(JFrame jFrame, String string, boolean bl, Component component, ActionListener actionListener) {
        super((Frame)jFrame, true);
        ModalDialogUtil.setDialogLocation((Component)this, (Component)jFrame);
        this.setTitle(string);
        this._panel = new GroupPanel("");
        this._panel.setLayout(new GridBagLayout());
        this._listener = actionListener;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this._panel.add(Box.createVerticalStrut(10), gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        this._panel.add((Component)this.createFieldsPanel(), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 0.0;
        this._panel.add(Box.createVerticalStrut(10), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this._panel.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 15;
        this._panel.add((Component)this.createButtonPanel(bl), gridBagConstraints);
        this.setContentPane(this._panel);
    }

    protected JScrollPane createFieldsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this._statusField = new JLabel();
        JLabel jLabel = new JLabel("Status");
        this.addEntryField(jPanel, jLabel, this._statusField);
        this._logField = new JTextArea();
        this._logField.setColumns(30);
        this._logField.setRows(10);
        this._logField.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this._logField);
        jLabel = new JLabel("Log");
        this.addEntryField(jPanel, jLabel, jScrollPane);
        this._progressBar = new JProgressBar();
        this._progressBar.setMinimum(0);
        this._progressBar.setMaximum(1);
        this._progressLabel = new JLabel("0 %");
        this.addEntryField(jPanel, this._progressLabel, this._progressBar);
        JScrollPane jScrollPane2 = new JScrollPane(jPanel);
        jScrollPane2.setBorder(new EmptyBorder(6, 9, 6, 9));
        return jScrollPane2;
    }

    protected void addEntryField(JPanel jPanel, JLabel jLabel, JComponent jComponent) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        jPanel.add(Box.createHorizontalStrut(10), gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)jComponent, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add(Box.createVerticalStrut(10), gridBagConstraints);
    }

    public void update(Hashtable hashtable) {
        String string = (String)hashtable.get("nsTaskStatus");
        StatusFieldUpdater statusFieldUpdater = new StatusFieldUpdater(string);
        try {
            SwingUtilities.invokeLater(statusFieldUpdater);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = (String)hashtable.get("nsTaskLog");
        LogFieldUpdater logFieldUpdater = new LogFieldUpdater(string2);
        try {
            SwingUtilities.invokeLater(logFieldUpdater);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Integer n = new Integer((String)hashtable.get("nsTaskCurrentItem"));
        Integer n2 = new Integer((String)hashtable.get("nsTaskTotalItems"));
        int n3 = n;
        int n4 = n2;
        ProgressBarUpdater progressBarUpdater = new ProgressBarUpdater(n3, n4);
        try {
            SwingUtilities.invokeLater(progressBarUpdater);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JPanel createButtonPanel(boolean bl) {
        this._bCancel = UIFactory.makeJButton((Object)this, "general", "Cancel");
        this._bCancel.setActionCommand("Cancel");
        this._bCancel.setOpaque(true);
        this._bCancel.setVisible(bl);
        if (this._listener != null) {
            this._bCancel.addActionListener(this._listener);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        JButton[] jButtonArray = new JButton[]{this._bCancel};
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)UIFactory.makeJButtonPanel(jButtonArray), gridBagConstraints);
        return jPanel;
    }

    public void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            Debug.println((String)("LDAPTaskProgressDialog.finalize(): Exception: " + throwable));
        }
    }

    public void packAndShow() {
        Debug.println((String)"LDAPTaskProgressDialog.packAndShow");
        this.pack();
        super.show();
    }

    public void waitForClose() {
        this._bCancel.setEnabled(true);
        this._bCancel.setVisible(true);
        this._bCancel.setText(DSUtil._resource.getString("general", "Close-label"));
        this._bCancel.setActionCommand("Close");
    }

    public String getLogFieldText() {
        return this._logField.getText();
    }

    public static void main(String[] stringArray) {
        LDAPTaskProgressDialog lDAPTaskProgressDialog = new LDAPTaskProgressDialog(null, "TEST", true);
        lDAPTaskProgressDialog.pack();
        lDAPTaskProgressDialog.show();
    }

    class ProgressBarUpdater
    implements Runnable {
        int _minValue;
        int _maxValue;

        ProgressBarUpdater(int n, int n2) {
            this._minValue = n;
            this._maxValue = n2;
        }

        public void run() {
            if (this._minValue <= this._maxValue && this._maxValue != 0) {
                if (LDAPTaskProgressDialog.this._progressBar.getMinimum() != this._minValue) {
                    LDAPTaskProgressDialog.this._progressBar.setMinimum(this._minValue);
                }
                if (LDAPTaskProgressDialog.this._progressBar.getMaximum() != this._maxValue) {
                    LDAPTaskProgressDialog.this._progressBar.setMaximum(this._maxValue);
                }
                int n = 100 * this._minValue / this._maxValue;
                if (!LDAPTaskProgressDialog.this._progressLabel.getText().equals(n + " %")) {
                    LDAPTaskProgressDialog.this._progressLabel.setText(n + " %");
                }
                if (this._minValue != this._maxValue) {
                    Debug.println((String)"ProgressBarUpdater.run(): a problem with the values");
                }
            }
        }
    }

    class LogFieldUpdater
    implements Runnable {
        String _text;

        LogFieldUpdater(String string) {
            this._text = string;
        }

        public void run() {
            if (!LDAPTaskProgressDialog.this._logField.getText().equals(this._text)) {
                LDAPTaskProgressDialog.this._logField.setText(this._text);
            }
        }
    }

    class StatusFieldUpdater
    implements Runnable {
        String _text;

        StatusFieldUpdater(String string) {
            this._text = string;
        }

        public void run() {
            if (!LDAPTaskProgressDialog.this._statusField.getText().equals(this._text)) {
                LDAPTaskProgressDialog.this._statusField.setText(this._text);
            }
        }
    }

    class winAdapter
    extends WindowAdapter {
        winAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Debug.println((String)"winAdapter.windowClosing: ");
        }
    }
}

