/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.task;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.task.LDAPBasicProgressDialog;
import com.netscape.admin.dirserv.task.LDAPTask;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class LDAPImport
extends LDAPTask {
    private final String IMPORT = "import";
    protected int _currentInstanceNumber;
    protected int _numberOfInstances;
    protected String _currentInstance;
    protected String _previousInstanceLogs = "";
    public String[] MANDATORY_ARGUMENTS = new String[]{"nsFilename", "nsInstance"};
    public String[] OPTIONAL_ARGUMENTS = new String[]{"nsIncludeSuffix", "nsExcludeSuffix", "nsImportIndexAttrs"};
    public static final String FILENAME = "nsFilename";
    public static final String INSTANCE = "nsInstance";
    public static final String INCLUDE_SUFFIX = "nsIncludeSuffix";
    public static final String EXCLUDE_SUFFIX = "nsExcludeSuffix";
    public static final String INDEX_ATTRIBUTES = "nsImportIndexAttrs";
    public static final String CHUNK_SIZE = "nsImportChunkSize";
    public static final String UNIQUE_ID_GENERATOR = "nsUniqueIdGenerator";
    public static final String UNIQUE_ID_GENERATOR_NAMESPACE = "nsUniqueIdGeneratorNamespace";

    public LDAPImport(IDSModel iDSModel, Hashtable hashtable) {
        super(iDSModel, hashtable);
        this._taskType = "import";
        this._taskSection = "import";
        LDAPAttribute lDAPAttribute = (LDAPAttribute)this._attributes.get(INSTANCE);
        String[] stringArray = lDAPAttribute.getStringValueArray();
        this._numberOfInstances = stringArray.length;
        try {
            this.createProgressDialog();
            Thread thread = new Thread(this);
            thread.start();
            ((GenericProgressDialog)this._progressDialog).packAndShow();
        }
        catch (Exception exception) {
            Debug.println((String)("LDAPTask.start(): " + exception));
            exception.printStackTrace();
        }
    }

    public LDAPImport(IDSModel iDSModel) {
        this(iDSModel, null);
    }

    public void run() {
        LDAPAttribute lDAPAttribute = (LDAPAttribute)this._attributes.get(INSTANCE);
        LDAPAttribute lDAPAttribute2 = (LDAPAttribute)this._attributes.get(FILENAME);
        String string = lDAPAttribute2.getStringValueArray()[0];
        String[] stringArray = lDAPAttribute.getStringValueArray();
        int n = 0;
        while (n < stringArray.length) {
            String string2;
            String[] stringArray2;
            this._currentInstance = stringArray[n];
            this._currentInstanceNumber = n + 1;
            ((GenericProgressDialog)this._progressDialog).reset();
            if (this._numberOfInstances > 1) {
                stringArray2 = new String[]{DSUtil.inverseAbreviateString(string, 40), DSUtil.abreviateString(this._currentInstance, 30), String.valueOf(this._currentInstanceNumber), String.valueOf(this._numberOfInstances)};
                string2 = DSUtil._resource.getString(this._taskSection, "LDAPMode-progresslabel-title", stringArray2);
            } else {
                stringArray2 = new String[]{DSUtil.inverseAbreviateString(string, 40), DSUtil.abreviateString(this._currentInstance, 30)};
                string2 = DSUtil._resource.getString(this._taskSection, "LDAPMode-progresslabel-one-partition-title", stringArray2);
            }
            ((GenericProgressDialog)this._progressDialog).setTextInLabel(string2);
            lDAPAttribute = new LDAPAttribute(INSTANCE, stringArray[n]);
            this._attributes.put(INSTANCE, lDAPAttribute);
            if (!this.initTask()) {
                ((GenericProgressDialog)this._progressDialog).waitForClose();
                break;
            }
            ((GenericProgressDialog)this._progressDialog).enableButtons(true);
            this.updateProgressDialog();
            this._previousInstanceLogs = this._statusProgressDialog.getLogFieldText();
            if (this._taskCancelled) break;
            ++n;
        }
    }

    protected boolean initTask() {
        String[] stringArray;
        Object object;
        String string;
        this._taskCancelled = false;
        this.createTaskDn();
        LDAPAttributeSet lDAPAttributeSet = this.createTaskEntryAttributes();
        if (lDAPAttributeSet == null) {
            Debug.println((String)("LDAPImport.initTask():  Error, insufficient arguments to perform the task " + this._taskType));
            ((GenericProgressDialog)this._progressDialog).setTextInLabel(DSUtil._resource.getString("general", "LDAPTaskError-notenoughargs-label"));
            return false;
        }
        this._entry = new LDAPEntry(this._taskDn, lDAPAttributeSet);
        LDAPConnection lDAPConnection = this.getLDAPConnection();
        Debug.println((String)("DN = " + this._entry.getDN()));
        Enumeration enumeration = lDAPAttributeSet.getAttributes();
        while (enumeration.hasMoreElements()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            string = lDAPAttribute.getName();
            Debug.println((String)string);
            object = lDAPAttribute.getStringValues();
            while (object.hasMoreElements()) {
                stringArray = (String[])object.nextElement();
            }
        }
        try {
            Debug.println((String)("LDAPImport.initTask(): adding entry " + this._entry));
            lDAPConnection.add(this._entry);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("LDAPImport.initTask(): LDAP error code = " + lDAPException.getLDAPResultCode() + " error=" + (Object)((Object)lDAPException)));
            string = lDAPException.errorCodeToString();
            object = lDAPException.getLDAPErrorMessage();
            if (object != null && ((String)object).length() > 0) {
                string = string + ". " + (String)object;
            }
            stringArray = new String[]{string};
            ((GenericProgressDialog)this._progressDialog).setTextInLabel(DSUtil._resource.getString("general", "LDAPTaskError-starting-label", stringArray));
            return false;
        }
        return true;
    }

    protected LDAPAttributeSet createTaskEntryAttributes() {
        LDAPAttribute lDAPAttribute;
        LDAPAttributeSet lDAPAttributeSet = super.createTaskEntryAttributes();
        int n = 0;
        while (n < this.MANDATORY_ARGUMENTS.length) {
            lDAPAttribute = (LDAPAttribute)this._attributes.get(this.MANDATORY_ARGUMENTS[n]);
            if (lDAPAttribute == null) {
                return null;
            }
            lDAPAttributeSet.add(lDAPAttribute);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.OPTIONAL_ARGUMENTS.length) {
            lDAPAttribute = (LDAPAttribute)this._attributes.get(this.OPTIONAL_ARGUMENTS[n2]);
            if (lDAPAttribute != null) {
                lDAPAttributeSet.add(lDAPAttribute);
            }
            ++n2;
        }
        return lDAPAttributeSet;
    }

    protected void createProgressDialog() {
        String string = this.getTitle();
        this._progressDialog = new GenericProgressDialog(this.getModel().getFrame(), true, 3, string, null, this);
        ((GenericProgressDialog)this._progressDialog).enableButtons(false);
        ((GenericProgressDialog)this._progressDialog).addStep(DSUtil._resource.getString(this._taskSection, "LDAPMode-firstStep-title"));
        ((GenericProgressDialog)this._progressDialog).addStep(DSUtil._resource.getString(this._taskSection, "LDAPMode-secondStep-title"));
        ((GenericProgressDialog)this._progressDialog).addStep(DSUtil._resource.getString(this._taskSection, "LDAPMode-thirdStep-title"));
        this._statusProgressDialog = new LDAPBasicProgressDialog(this.getModel().getFrame(), DSUtil._resource.getString(this._taskSection, "LDAPMode-Status-title"), true, null, this);
        this._statusProgressDialog.waitForClose();
    }

    public String getTitle() {
        String string;
        if (this._numberOfInstances == 1) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)this._attributes.get(INSTANCE);
            String[] stringArray = lDAPAttribute.getStringValueArray();
            string = DSUtil._resource.getString(this._taskSection, "initializebackend-title", stringArray);
        } else {
            string = DSUtil._resource.getString(this._taskSection, "title");
        }
        return string;
    }

    protected void updateProgressDialog(Hashtable hashtable) {
        String string = (String)hashtable.get("nsTaskLog");
        if (string.lastIndexOf("Processing file") >= 0) {
            ((GenericProgressDialog)this._progressDialog).stepCompleted(0);
        }
        if (string.lastIndexOf("Finished scanning file") >= 0) {
            ((GenericProgressDialog)this._progressDialog).stepCompleted(1);
        }
        if (string.lastIndexOf("Import complete") >= 0) {
            ((GenericProgressDialog)this._progressDialog).stepCompleted(2);
        }
        string = this._previousInstanceLogs + "\n\n\n" + string;
        hashtable.put("nsTaskLog", string);
        this._statusProgressDialog.update(hashtable);
    }

    protected void finalizeTask(int n) {
        Debug.println((String)("LDAPImport.finalizeTask result " + n));
        switch (n) {
            case 0: {
                this._taskCancelled = true;
                break;
            }
            case 1: {
                this._taskCancelled = true;
                break;
            }
            case 2: {
                this._taskCancelled = true;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                ((GenericProgressDialog)this._progressDialog).stepCompleted(0);
                ((GenericProgressDialog)this._progressDialog).stepCompleted(1);
                ((GenericProgressDialog)this._progressDialog).stepCompleted(2);
                break;
            }
            case 5: {
                if (this._currentInstanceNumber == this._numberOfInstances) {
                    String string = DSUtil._resource.getString("general", "LDAPTaskCompleted-unsuccessful-label");
                    ((GenericProgressDialog)this._progressDialog).setTextInLabel(string);
                    break;
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            int n = DSUtil.showConfirmationDialog((Component)LDAPImport.this._progressDialog, "LDAPMode-unsuccessful-wantToCancel", LDAPImport.this._currentInstance, LDAPImport.this._taskSection);
                            if (n != 0) {
                                LDAPImport.this._taskCancelled = true;
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this._taskCancelled) break;
                this.waitForClose();
            }
        }
        this._result = n;
        this.waitForClose();
    }
}

