/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.task;

import com.netscape.admin.dirserv.DSContentPage;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.GlobalConstants;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.browser.BrowserController;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.admin.dirserv.task.ErrorDialogDisplayer;
import com.netscape.admin.dirserv.task.LDAPBasicProgressDialog;
import com.netscape.admin.dirserv.task.LDAPCreateIndex;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.util.DN;

public class CreateVLVIndex
implements ActionListener {
    String[] _attributeTags = null;
    public static int NO_INDEX = 0;
    public static int HAS_INDEX = 1;
    public static int CAN_NOT_HAVE_INDEX = 2;
    static final String LDBM_PLUGIN_ROOT = "cn=ldbm database, cn=plugins, cn=config";
    static final String COULD_NOT_FIND_BACKEND = "Could not find entry";
    static final String MORE_THAN_ONE_BACKEND = "More than one backend";
    static final String SEPARATOR = ";";
    static final String FILTER_VLV = "(|(objectclass=*)(objectclass=ldapsubentry))";
    static final String TAG = "by";
    static final String REVERSE_TAG = "d";
    public static final String[] DEFAULT_ATTRIBUTES = BrowserController.SORT_ATTRIBUTES;
    final int INDEX_CREATED = 0;
    final int ERROR_CREATING_INDEX = -1;
    final int SUB = 2;
    boolean _taskCancelled = false;
    LDAPBasicProgressDialog _statusProgressDialog;
    GenericProgressDialog _progressDialog;
    ConsoleInfo _consoleInfo;
    String _dn;
    private boolean _result = false;
    static final String _section = "CreateVLVIndex";
    static ResourceSet _resource = DSUtil._resource;

    public CreateVLVIndex(ConsoleInfo consoleInfo) {
        this._consoleInfo = consoleInfo;
    }

    public boolean execute(String string) {
        this._dn = string;
        this.createProgressDialog();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                CreateVLVIndex.this.createVLVIndex();
            }
        });
        thread.start();
        this._progressDialog.packAndShow();
        return this.getResult();
    }

    public void createVLVIndex() {
        boolean bl;
        LDAPConnection lDAPConnection = this._consoleInfo.getLDAPConnection();
        String string = CreateVLVIndex.getInstanceName(this._dn, this._consoleInfo);
        IDSModel iDSModel = (IDSModel)this._consoleInfo.get("dsresmodel");
        if (string == null || string.equals(COULD_NOT_FIND_BACKEND)) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        DSUtil.showErrorDialog(CreateVLVIndex.this._progressDialog, "CouldNotFindBackendForVLV-title", "CouldNotFindBackendForVLV-msg", null, "dirtask-CreateVLVIndex", _resource);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._progressDialog.closeCallBack();
            this._result = false;
            return;
        }
        if (string.equals(MORE_THAN_ONE_BACKEND)) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        DSUtil.showErrorDialog(CreateVLVIndex.this._progressDialog, "multipleBackendForVLV-title", "multipleBackendForVLV-msg", null, "dirtask-CreateVLVIndex", _resource);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._progressDialog.closeCallBack();
            this._result = false;
            return;
        }
        int n = this.createIndex(lDAPConnection, this._dn);
        boolean bl2 = bl = n == 0;
        if (this._taskCancelled) {
            this._progressDialog.setTextInLabel(_resource.getString(_section, "LDAPMode-cancelled-title"));
            this.cleanupCreatedIndex();
            this._statusProgressDialog.hide();
            this._progressDialog.closeCallBack();
            this._result = false;
            return;
        }
        if (bl) {
            this._progressDialog.stepCompleted(0);
            if (this._attributeTags == null) {
                this._progressDialog.setTextInLabel(_resource.getString(_section, "LDAPMode-couldNotCreateTags-title"));
                this._progressDialog.waitForClose();
                this._result = false;
            }
            Hashtable<String, LDAPAttribute> hashtable = new Hashtable<String, LDAPAttribute>();
            hashtable.put("nsInstance", new LDAPAttribute("nsInstance", string));
            hashtable.put("nsIndexVLVAttribute", new LDAPAttribute("nsIndexVLVAttribute", this._attributeTags));
            LDAPCreateIndex lDAPCreateIndex = new LDAPCreateIndex(iDSModel, hashtable, this._progressDialog, this._statusProgressDialog, true);
            if (this._taskCancelled) {
                this._progressDialog.setTextInLabel(_resource.getString(_section, "LDAPMode-cancelled-title"));
                this.cleanupCreatedIndex();
                this._statusProgressDialog.hide();
                this._progressDialog.closeCallBack();
                this._result = false;
                return;
            }
            if (lDAPCreateIndex.getResult() != 4 && lDAPCreateIndex.getResult() != 3) {
                this._progressDialog.disableCancelButton();
                this._progressDialog.setTextInLabel(_resource.getString(_section, "LDAPMode-cancelled-title"));
                this.cleanupCreatedIndex();
                this._progressDialog.setTextInLabel(_resource.getString(_section, "LDAPMode-endError-title"));
                this._progressDialog.waitForClose();
                bl = false;
            } else {
                this._progressDialog.stepCompleted(1);
                this._progressDialog.waitForClose();
            }
        } else {
            this._progressDialog.setTextInLabel(_resource.getString(_section, "LDAPMode-endError-title"));
            this._progressDialog.waitForClose();
        }
        this._result = bl;
    }

    public boolean getResult() {
        return this._result;
    }

    public static String getBackendConfigRoot(String string, ConsoleInfo consoleInfo) {
        String string2 = CreateVLVIndex.getInstanceName(string, consoleInfo);
        if (string2 == null) {
            return null;
        }
        if (string2.equals(MORE_THAN_ONE_BACKEND) || string2.equals(COULD_NOT_FIND_BACKEND)) {
            return string2;
        }
        String string3 = "cn=" + CreateVLVIndex.createVlvSearchTag(string) + ", cn=" + string2 + ", " + LDBM_PLUGIN_ROOT;
        Debug.println((String)("CreateVLVIndex.getBackendConfigRoot(): backend config root for " + string + " is " + string3));
        return string3;
    }

    public static String getInstanceName(String string, ConsoleInfo consoleInfo) {
        LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
        String[] stringArray = MappingUtils.getOrderedSuffixList(lDAPConnection, 2);
        if (stringArray == null) {
            return COULD_NOT_FIND_BACKEND;
        }
        String string2 = null;
        String[] stringArray2 = new String[1];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[0] = stringArray[n];
            if (MappingUtils.isEntryInSuffixes(string, stringArray2, stringArray)) {
                if (string2 != null) {
                    return MORE_THAN_ONE_BACKEND;
                }
                string2 = stringArray[n];
            }
            ++n;
        }
        String string3 = MappingUtils.getBackendForSuffix(lDAPConnection, string2);
        if (string3 == null) {
            return COULD_NOT_FIND_BACKEND;
        }
        return string3;
    }

    public static String getSuffix(String string, ConsoleInfo consoleInfo) {
        String string2 = CreateVLVIndex.getInstanceName(string, consoleInfo);
        if (string2 == null) {
            return null;
        }
        if (string2.equals(MORE_THAN_ONE_BACKEND) || string2.equals(COULD_NOT_FIND_BACKEND)) {
            return string2;
        }
        String string3 = MappingUtils.getSuffixForBackend(consoleInfo.getLDAPConnection(), string2);
        return string3;
    }

    private int createIndex(LDAPConnection lDAPConnection, String string) {
        String[] stringArray;
        String string2;
        int n = -1;
        String string3 = CreateVLVIndex.getBackendConfigRoot(string, this._consoleInfo);
        if (string3 == null || string3.equals(COULD_NOT_FIND_BACKEND)) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        DSUtil.showErrorDialog(CreateVLVIndex.this._progressDialog, "CouldNotFindBackendForVLV-title", "CouldNotFindBackendForVLV-msg", null, "dirtask-CreateVLVIndex", _resource);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            return -1;
        }
        if (string3.equals(MORE_THAN_ONE_BACKEND)) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        DSUtil.showErrorDialog(CreateVLVIndex.this._progressDialog, "multipleBackendForVLV-title", "multipleBackendForVLV-msg", null, "dirtask-CreateVLVIndex", _resource);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            return -1;
        }
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        LDAPAttribute lDAPAttribute = new LDAPAttribute("objectclass");
        lDAPAttribute.addValue("top");
        lDAPAttribute.addValue("vlvSearch");
        lDAPAttributeSet.add(lDAPAttribute);
        lDAPAttribute = new LDAPAttribute("cn", CreateVLVIndex.createVlvSearchTag(string));
        lDAPAttributeSet.add(lDAPAttribute);
        String string4 = string;
        lDAPAttribute = new LDAPAttribute("vlvbase", string4);
        lDAPAttributeSet.add(lDAPAttribute);
        lDAPAttribute = new LDAPAttribute("vlvscope", "1");
        lDAPAttributeSet.add(lDAPAttribute);
        lDAPAttribute = new LDAPAttribute("vlvfilter", FILTER_VLV);
        lDAPAttributeSet.add(lDAPAttribute);
        LDAPEntry lDAPEntry = new LDAPEntry(string3, lDAPAttributeSet);
        if (this._taskCancelled) {
            this._result = false;
            return -1;
        }
        try {
            Debug.println((String)("CreateVLVIndex.createIndex: adding vlvSearchEntry:" + lDAPEntry));
            string2 = DSUtil.abreviateString(lDAPEntry.getDN(), 30);
            this._progressDialog.setTextInLabel(_resource.getString(_section, "LDAPMode-addingEntry-title", string2));
            stringArray = (String[])lDAPConnection.getSearchConstraints().clone();
            stringArray.setServerControls(DSContentPage._manageDSAITControl);
            lDAPConnection.add(lDAPEntry, (LDAPConstraints)stringArray);
            n = 0;
            Debug.println((String)"CreateVLVIndex.createIndex: index entry added");
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 68) {
                n = 0;
                Debug.println((String)("CreateVLVIndex.createIndex: index entry <" + string + "> already exists"));
            }
            Debug.println((String)("CreateVLVIndex.createIndex: " + lDAPException.toString() + ", <" + string + ">"));
            stringArray = "\nException adding index: " + lDAPEntry.getDN() + "\n" + lDAPException.toString();
            try {
                SwingUtilities.invokeAndWait(new ErrorDialogDisplayer((String)stringArray, this._progressDialog));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n == 0) {
            string2 = CreateVLVIndex.getSuffix(string, this._consoleInfo);
            stringArray = DEFAULT_ATTRIBUTES;
            if (stringArray == null || stringArray.length < 1) {
                return -1;
            }
            n = this.addVlvIndexEntries(string, stringArray);
        }
        return n;
    }

    private void cleanupCreatedIndex() {
        if (!CreateVLVIndex.hasIndex(this._dn, this._consoleInfo)) {
            return;
        }
        String string = CreateVLVIndex.getBackendConfigRoot(this._dn, this._consoleInfo);
        if (string == null || string.equals(COULD_NOT_FIND_BACKEND) || string.equals(MORE_THAN_ONE_BACKEND)) {
            return;
        }
        try {
            Thread.sleep(600L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LDAPConnection lDAPConnection = this._consoleInfo.getLDAPConnection();
        DSUtil.deleteTree(string, lDAPConnection, true);
    }

    public static void deleteIndex(String string, ConsoleInfo consoleInfo) {
        int n;
        if (!CreateVLVIndex.hasIndex(string, consoleInfo)) {
            return;
        }
        final String string2 = CreateVLVIndex.getBackendConfigRoot(string, consoleInfo);
        if (string2 == null || string2.equals(COULD_NOT_FIND_BACKEND) || string2.equals(MORE_THAN_ONE_BACKEND)) {
            return;
        }
        final LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
        IDSModel iDSModel = (IDSModel)consoleInfo.get("dsresmodel");
        if (DSUtil.requiresConfirmation(GlobalConstants.PREFERENCES_CONFIRM_DELETE_INDEX) && (n = DSUtil.showConfirmationDialog((Component)iDSModel.getFrame(), "confirm-delete-index", "", "browser")) != 0) {
            return;
        }
        String string3 = _resource.getString(_section, "deleteIndex-title");
        final GenericProgressDialog genericProgressDialog = new GenericProgressDialog(iDSModel.getFrame(), true, 1, string3, null, null);
        try {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    DSUtil.deleteTree(string2, lDAPConnection, true, genericProgressDialog);
                    genericProgressDialog.closeCallBack();
                }
            });
            thread.start();
            genericProgressDialog.packAndShow();
        }
        catch (Exception exception) {
            Debug.println((String)("CreateVLVIndex.deleteIndex(): " + exception));
            exception.printStackTrace();
        }
    }

    public static boolean hasIndex(String string, ConsoleInfo consoleInfo) {
        String string2 = CreateVLVIndex.getBackendConfigRoot(string, consoleInfo);
        if (string2 == null || string2.equals(COULD_NOT_FIND_BACKEND) || string2.equals(MORE_THAN_ONE_BACKEND)) {
            return false;
        }
        LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
        try {
            LDAPEntry lDAPEntry = lDAPConnection.read(string2);
            return lDAPEntry != null;
        }
        catch (LDAPException lDAPException) {
            return false;
        }
    }

    public static int indexStatus(String string, ConsoleInfo consoleInfo) throws LDAPException {
        Debug.println((String)("CreateVLVIndex.indexStatus(): " + string));
        int n = CAN_NOT_HAVE_INDEX;
        String string2 = CreateVLVIndex.getBackendConfigRoot(string, consoleInfo);
        if (string2 == null || string2.equals(COULD_NOT_FIND_BACKEND) || string2.equals(MORE_THAN_ONE_BACKEND)) {
            n = CAN_NOT_HAVE_INDEX;
        } else {
            LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
            try {
                String[] stringArray = new String[]{"dn"};
                LDAPEntry lDAPEntry = lDAPConnection.read(string2, stringArray);
                n = lDAPEntry == null ? NO_INDEX : HAS_INDEX;
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() != 32) {
                    throw lDAPException;
                }
                n = NO_INDEX;
            }
        }
        return n;
    }

    private int addVlvIndexEntries(String string, String[] stringArray) {
        LDAPConnection lDAPConnection = this._consoleInfo.getLDAPConnection();
        String string2 = CreateVLVIndex.getBackendConfigRoot(string, this._consoleInfo);
        if (string2 == null || string2.equals(COULD_NOT_FIND_BACKEND) || string2.equals(MORE_THAN_ONE_BACKEND)) {
            return -1;
        }
        if (this._taskCancelled) {
            this._result = false;
            return -1;
        }
        String string3 = "by " + CreateVLVIndex.createVlvSearchTag(string);
        this._attributeTags = new String[1];
        this._attributeTags[0] = string3;
        String string4 = "cn=" + string3 + "," + string2;
        try {
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            LDAPAttribute lDAPAttribute = new LDAPAttribute("objectclass");
            lDAPAttribute.addValue("top");
            lDAPAttribute.addValue("vlvIndex");
            lDAPAttributeSet.add(lDAPAttribute);
            lDAPAttribute = new LDAPAttribute("cn", string3);
            lDAPAttributeSet.add(lDAPAttribute);
            String string5 = new String("");
            int n = 0;
            while (n < stringArray.length) {
                string5 = string5 + stringArray[n] + " ";
                ++n;
            }
            string5 = string5.trim();
            lDAPAttribute = new LDAPAttribute("vlvsort", string5);
            lDAPAttributeSet.add(lDAPAttribute);
            LDAPEntry lDAPEntry = new LDAPEntry(string4, lDAPAttributeSet);
            Debug.println((String)("CreateVLVIndex.addVlvIndexEntries: adding vlvIndexEntry:" + lDAPEntry));
            String string6 = DSUtil.abreviateString(lDAPEntry.getDN(), 30);
            this._progressDialog.setTextInLabel(_resource.getString(_section, "LDAPMode-addingEntry-title", string6));
            lDAPConnection.add(lDAPEntry);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 68) {
                Debug.println((String)("CreateVLVIndex.addVlvIndexEntries: index entry <" + string4 + "> already exists"));
            }
            Debug.println((String)("CreateVLVIndex.addVlvIndexEntries: " + lDAPException.toString() + ", <" + string4 + ">"));
            String string7 = "\nException adding index: " + string4 + "\n" + lDAPException.toString();
            try {
                SwingUtilities.invokeAndWait(new ErrorDialogDisplayer(string7, this._progressDialog));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return -1;
        }
        return 0;
    }

    private String[] getAttributesToIndex(String string, String string2) {
        int n;
        Object object;
        String[] stringArray;
        String string3 = "(&";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n2 = 0;
        while (n2 < DEFAULT_ATTRIBUTES.length) {
            string3 = string3 + "(!(" + DEFAULT_ATTRIBUTES[n2] + "=*))";
            hashtable.put(DEFAULT_ATTRIBUTES[n2], DEFAULT_ATTRIBUTES[n2]);
            ++n2;
        }
        string3 = string3 + ")";
        LDAPConnection lDAPConnection = this._consoleInfo.getLDAPConnection();
        String[] stringArray2 = new String[]{"*"};
        try {
            stringArray = lDAPConnection.getSearchConstraints();
            stringArray.setMaxResults(0);
            object = lDAPConnection.search(string, 1, string3, stringArray2, false, (LDAPSearchConstraints)stringArray);
            n = 0;
            while (object.hasMoreElements()) {
                LDAPEntry lDAPEntry = object.next();
                if (lDAPEntry == null || lDAPEntry.getDN() == null) continue;
                String string4 = lDAPEntry.getDN();
                String string5 = string4.substring(0, string4.indexOf(61)).trim().toLowerCase();
                hashtable.put(string5, string5);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("CreateVLVIndex.getNamingAttributes(); " + (Object)((Object)lDAPException)));
        }
        if (hashtable.size() > 0) {
            stringArray = new String[hashtable.size()];
            object = hashtable.elements();
            n = 0;
            while (object.hasMoreElements()) {
                stringArray[n] = (String)object.nextElement();
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    private boolean inBackend(String string, String string2, String[] stringArray) {
        DN dN = new DN(string);
        DN dN2 = new DN(string2);
        if (dN.isDescendantOf(dN2)) {
            int n = 0;
            while (n < stringArray.length) {
                DN dN3 = new DN(stringArray[n]);
                if (dN.isDescendantOf(dN3) ? dN3.isDescendantOf(dN2) : dN.equals(dN3)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return dN.equals(dN2);
    }

    private static String createVlvSearchTag(String string) {
        String string2 = "MCC " + string.replace(',', ' ').replace('\"', '-');
        return string2;
    }

    protected void createProgressDialog() {
        String string = _resource.getString(_section, "title");
        IDSModel iDSModel = (IDSModel)this._consoleInfo.get("dsresmodel");
        this._progressDialog = new GenericProgressDialog(iDSModel.getFrame(), true, 6, string, null, this);
        this._progressDialog.addStep(DSUtil._resource.getString(_section, "LDAPMode-firstStep-title"));
        this._progressDialog.addStep(DSUtil._resource.getString(_section, "LDAPMode-secondStep-title"));
        this._statusProgressDialog = new LDAPBasicProgressDialog(iDSModel.getFrame(), DSUtil._resource.getString(_section, "LDAPMode-Status-title"), true, null, this);
        this._statusProgressDialog.waitForClose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Cancel-GenericProgressDialog")) {
            Debug.println((String)"CreateVLVIndex.actionPerformed: CANCEL");
            this._progressDialog.disableCancelButton();
            this._taskCancelled = true;
        } else if (actionEvent.getActionCommand().equals("Close-GenericProgressDialog")) {
            Debug.println((String)"CreateVLVIndex.actionPerformed: CLOSE");
            this._statusProgressDialog.hide();
            this._progressDialog.closeCallBack();
        } else if (actionEvent.getActionCommand().equals("Show_Logs-GenericProgressDialog")) {
            Debug.println((String)"CreateVLVIndex.actionPerformed: SHOW_LOGS");
            this._statusProgressDialog.pack();
            this._statusProgressDialog.setLocationRelativeTo(this._progressDialog);
            ((Component)this._statusProgressDialog).setLocation(this._progressDialog.getWidth(), this._progressDialog.getHeight());
            this._statusProgressDialog.show();
        } else if (actionEvent.getActionCommand().equals("Close")) {
            this._statusProgressDialog.hide();
            this._statusProgressDialog.dispose();
        }
    }
}

