/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.roledit;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSResourceEditorPage;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.roledit.RolePickerDialog;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.DefaultResEditorPage;
import com.netscape.management.client.ug.IRPCallBack;
import com.netscape.management.client.ug.ResourceEditor;
import com.netscape.management.client.ug.ResourcePageObservable;
import com.netscape.management.client.ug.ResourcePickerDlg;
import com.netscape.management.client.ug.SearchResultPanel;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;

public class ResEditorManagedRole
extends DefaultResEditorPage
implements Observer,
ActionListener,
IDSResourceEditorPage,
ListSelectionListener,
AncestorListener,
IRPCallBack {
    ResourceEditor _parent;
    ResourcePageObservable _observable;
    String _id;
    String _lastRoleName;
    Vector _addJournal = new Vector();
    Vector _removeJournal = new Vector();
    SearchResultPanel _searchResultPanel;
    JButton _refreshButton;
    JButton _addButton;
    JButton _removeButton;
    static ResourceSet _resource = DSUtil._resource;
    private static final String _section = "managedRolePage";
    private static final String NSROLEDN_ATTR = "nsRoleDN";
    private static final String NSROLE_ATTR = "nsRole";
    private static final String[] ROLE_ATTRS = new String[]{"nsRoleDN"};
    static /* synthetic */ Class class$javax$swing$JTable;

    public ResEditorManagedRole() {
        this._id = _resource.getString(_section, "id");
    }

    public void update(Observable observable, Object object) {
        this.updateLastRoleName();
    }

    public void initialize(ResourcePageObservable resourcePageObservable, ResourceEditor resourceEditor) {
        this._parent = resourceEditor;
        this._observable = resourcePageObservable;
        this._addJournal.removeAllElements();
        this._removeJournal.removeAllElements();
        if (this._searchResultPanel == null) {
            JLabel jLabel = new JLabel(_resource.getString(_section, "label"));
            this._searchResultPanel = new SearchResultPanel(this._parent.getConsoleInfo(), (ActionListener)this);
            this._searchResultPanel.addAncestorListener(this);
            this._searchResultPanel.addListSelectionListener((ListSelectionListener)this);
            JTable jTable = (JTable)DSUtil.searchChildComponent((Component)this._searchResultPanel, class$javax$swing$JTable == null ? (class$javax$swing$JTable = ResEditorManagedRole.class$("javax.swing.JTable")) : class$javax$swing$JTable);
            jLabel.setLabelFor(jTable);
            jTable.setPreferredScrollableViewportSize(new Dimension(10, 10));
            this._refreshButton = UIFactory.makeJButton(this, _section, "refreshButton", _resource);
            this._addButton = UIFactory.makeJButton(this, _section, "addButton", _resource);
            this._removeButton = UIFactory.makeJButton(this, _section, "removeButton", _resource);
            JButtonFactory.resizeGroup((JButton)this._addButton, (JButton)this._removeButton);
            Box box = new Box(0);
            box.add(this._refreshButton);
            box.add(Box.createHorizontalGlue());
            box.add(this._addButton);
            box.add(Box.createHorizontalStrut(12));
            box.add(this._removeButton);
            ((Container)((Object)this)).setLayout(new GridBagLayout());
            GridBagUtil.constrain((Container)((Object)this), (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (double)1.0, (double)0.0, (int)17, (int)2, (int)9, (int)9, (int)0, (int)9);
            GridBagUtil.constrain((Container)((Object)this), (Component)this._searchResultPanel, (int)0, (int)1, (int)1, (int)1, (double)1.0, (double)1.0, (int)17, (int)1, (int)0, (int)9, (int)0, (int)9);
            GridBagUtil.constrain((Container)((Object)this), (Component)box, (int)0, (int)2, (int)1, (int)1, (double)0.0, (double)0.0, (int)13, (int)2, (int)12, (int)9, (int)9, (int)9);
        }
        this.updateLastRoleName();
        this.valueChanged(null);
    }

    public String getID() {
        return this._id;
    }

    public boolean save(ResourcePageObservable resourcePageObservable) throws Exception {
        block6: {
            String string = this._observable.get("cn", 0);
            if (!string.equals(this._lastRoleName)) {
                ConsoleInfo consoleInfo = this._parent.getConsoleInfo();
                LDAPConnection lDAPConnection = consoleInfo.getUserLDAPConnection();
                String string2 = this.makeLastRoleDn();
                String string3 = RolePickerDialog.makeParentDn(string2);
                String string4 = "cn=" + string + "," + string3;
                try {
                    String string5 = "(nsroledn = " + string2 + ")";
                    LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string3, 2, string5, null, true);
                    int n = 0;
                    int n2 = 0;
                    while (lDAPSearchResults.hasMoreElements()) {
                        try {
                            LDAPEntry lDAPEntry = lDAPSearchResults.next();
                            LDAPAttribute lDAPAttribute = new LDAPAttribute("nsroledn", string2);
                            LDAPAttribute lDAPAttribute2 = new LDAPAttribute("nsroledn", string4);
                            LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
                            lDAPModificationSet.add(1, lDAPAttribute);
                            lDAPModificationSet.add(0, lDAPAttribute2);
                            lDAPConnection.modify(lDAPEntry.getDN(), lDAPModificationSet);
                            ++n;
                        }
                        catch (LDAPException lDAPException) {
                            ++n2;
                            Debug.println((int)0, (String)("ResEditorManagedRole.save: exception " + (Object)((Object)lDAPException) + "while renaming " + string4));
                            if (!Debug.getTrace()) continue;
                            lDAPException.printStackTrace();
                        }
                    }
                    Debug.println((String)("ResEditorManagedRole.save: updated " + n + " members"));
                }
                catch (LDAPException lDAPException) {
                    Debug.println((int)0, (String)("ResEditorManagedRole.save: exception " + (Object)((Object)lDAPException) + "while searching for members of " + string4));
                    if (!Debug.getTrace()) break block6;
                    lDAPException.printStackTrace();
                }
            }
        }
        return true;
    }

    public void cancel(ResourcePageObservable resourcePageObservable) throws Exception {
        ConsoleInfo consoleInfo = this._parent.getConsoleInfo();
        LDAPConnection lDAPConnection = consoleInfo.getUserLDAPConnection();
        if (this._lastRoleName != null) {
            String string;
            String string2 = this.makeLastRoleDn();
            Enumeration enumeration = this._addJournal.elements();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                try {
                    Debug.println((String)("ResEditorManagedRole.cancel: cancelling membership of " + string));
                    this.removeManagedRoleFromEntry(lDAPConnection, string, string2);
                }
                catch (LDAPException lDAPException) {
                    Debug.println((int)0, (String)("ResEditorManagedRole.cancel: caught exception " + (Object)((Object)lDAPException)));
                    if (!Debug.getTrace()) continue;
                    lDAPException.printStackTrace();
                }
            }
            enumeration = this._removeJournal.elements();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                try {
                    Debug.println((String)("ResEditorManagedRole.cancel: restoring membership of " + string));
                    this.addManagedRoleToEntry(lDAPConnection, string, string2);
                }
                catch (LDAPException lDAPException) {
                    Debug.println((int)0, (String)("ResEditorManagedRole.cancel: caught exception " + (Object)((Object)lDAPException)));
                    if (!Debug.getTrace()) continue;
                    lDAPException.printStackTrace();
                }
            }
        }
    }

    public void help() {
        DSUtil.help("configuration-role-member-managed-help");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this._parent.setBusyCursor(true);
        Object object = actionEvent.getSource();
        if (object == this._addButton) {
            this.actionAdd();
        } else if (object == this._removeButton) {
            this.actionRemove();
        } else if (object == this._refreshButton) {
            this.actionRefresh();
        } else {
            Debug.println((int)0, (String)("ResEditorManagedRole.actionPerformed: ignored event" + actionEvent));
        }
        this._parent.setBusyCursor(false);
    }

    void actionAdd() {
        ConsoleInfo consoleInfo = this._parent.getConsoleInfo();
        LDAPConnection lDAPConnection = consoleInfo.getUserLDAPConnection();
        JFrame jFrame = UtilConsoleGlobals.getActivatedFrame();
        if (this._lastRoleName == null) {
            JOptionPane.showMessageDialog(jFrame, _resource.getString(_section, "namedRequired"), _resource.getString(_section, "errortitle"), 0);
            ModalDialogUtil.sleep();
            return;
        }
        String string = this.makeLastRoleDn();
        String string2 = RolePickerDialog.makeParentDn(string);
        Debug.println((String)("ResEditorManagedRole.actionAdd: baseDn " + string2));
        ConsoleInfo consoleInfo2 = (ConsoleInfo)consoleInfo.clone();
        consoleInfo2.setUserBaseDN(string2);
        ResourcePickerDlg resourcePickerDlg = new ResourcePickerDlg(consoleInfo2, (IRPCallBack)this, this._parent.getFrame());
        resourcePickerDlg.show();
    }

    public void getResults(Vector vector) {
        String string = this.makeLastRoleDn();
        ConsoleInfo consoleInfo = this._parent.getConsoleInfo();
        LDAPConnection lDAPConnection = consoleInfo.getUserLDAPConnection();
        JFrame jFrame = UtilConsoleGlobals.getActivatedFrame();
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LDAPEntry lDAPEntry = (LDAPEntry)enumeration.nextElement();
            String string2 = lDAPEntry.getDN();
            try {
                if (this.addManagedRoleToEntry(lDAPConnection, string2, string)) {
                    this.updateJournalAfterAdd(string2);
                    ++n;
                    continue;
                }
                DSUtil.showInformationDialog((Component)jFrame, "alreadyMember", string2, _section);
            }
            catch (LDAPException lDAPException) {
                if (Debug.getTrace()) {
                    Debug.println((int)0, (String)("ResEditorManagedRole.actionAdd: exception " + (Object)((Object)lDAPException)));
                    lDAPException.printStackTrace();
                }
                DSUtil.showLDAPErrorDialog(jFrame, lDAPException, "111-title");
            }
        }
        if (n >= 1) {
            this.actionRefresh();
        }
    }

    void actionRemove() {
        JFrame jFrame = UtilConsoleGlobals.getActivatedFrame();
        Vector vector = this._searchResultPanel.getSelectedEntries();
        if (vector != null && vector.size() >= 1) {
            Object object;
            ConsoleInfo consoleInfo = this._parent.getConsoleInfo();
            LDAPConnection lDAPConnection = consoleInfo.getUserLDAPConnection();
            String string = this.makeLastRoleDn();
            Vector<LDAPEntry> vector2 = new Vector<LDAPEntry>(vector.size());
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (LDAPEntry)enumeration.nextElement();
                String string2 = object.getDN();
                try {
                    this.removeManagedRoleFromEntry(lDAPConnection, string2, string);
                    this.updateJournalAfterRemove(string2);
                    vector2.addElement((LDAPEntry)object);
                }
                catch (LDAPException lDAPException) {
                    Debug.println((int)0, (String)("ResEditorManagedRole.actionRemove: error for " + string2));
                }
            }
            this._searchResultPanel.deleteRows(vector2);
            this.valueChanged(null);
            if (vector2.size() < vector.size()) {
                object = null;
                object = vector.size() == 1 ? "The operation has failed. Check the ACI of this entry" : "The operation has been failed for the selected entries. Check the ACI of those entries.";
                JOptionPane.showMessageDialog(jFrame, "Error", (String)object, 0);
                ModalDialogUtil.sleep();
            }
        }
    }

    void actionRefresh() {
        JFrame jFrame = UtilConsoleGlobals.getActivatedFrame();
        ConsoleInfo consoleInfo = this._parent.getConsoleInfo();
        if (this._lastRoleName == null) {
            this._searchResultPanel.removeAllElements();
            return;
        }
        String string = this.makeLastRoleDn();
        String string2 = RolePickerDialog.makeParentDn(string);
        String string3 = "ldap:///" + string2 + "??sub?(nsroledn=" + string + ")";
        Debug.println((String)("ResEditorManagedRole.actionRefresh: url = " + string3));
        try {
            LDAPUrl lDAPUrl = new LDAPUrl(string3);
            LDAPConnection lDAPConnection = consoleInfo.getUserLDAPConnection();
            this._searchResultPanel.removeAllElements();
            this._searchResultPanel.doSearch(lDAPConnection, lDAPUrl);
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(jFrame, _resource.getString(_section, "errortext"), _resource.getString(_section, "errortitle"), 0);
            ModalDialogUtil.sleep();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Debug.println((int)9, (String)("ResEditorManagedRole.valueChanged: e = " + listSelectionEvent));
        JTable jTable = (JTable)DSUtil.searchChildComponent((Component)this._searchResultPanel, class$javax$swing$JTable == null ? (class$javax$swing$JTable = ResEditorManagedRole.class$("javax.swing.JTable")) : class$javax$swing$JTable);
        this._removeButton.setEnabled(jTable.getSelectedRowCount() > 0 && jTable.getRowCount() > 0);
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        if (ancestorEvent.getSource() == this._searchResultPanel) {
            Runnable runnable = new Runnable(){

                public void run() {
                    ResEditorManagedRole.this.actionRefresh();
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else {
            Debug.println((int)0, (String)("ResEditorManagedRole.componentShown: ignored event " + ancestorEvent));
        }
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    private void updateJournalAfterAdd(String string) {
        int n = this._removeJournal.indexOf(string);
        if (n != -1) {
            this._removeJournal.removeElementAt(n);
        } else {
            this._addJournal.addElement(string);
        }
    }

    private void updateJournalAfterRemove(String string) {
        int n = this._addJournal.indexOf(string);
        if (n != -1) {
            this._addJournal.removeElementAt(n);
        } else {
            this._removeJournal.addElement(string);
        }
    }

    private boolean addManagedRoleToEntry(LDAPConnection lDAPConnection, String string, String string2) throws LDAPException {
        boolean bl = true;
        try {
            LDAPAttribute lDAPAttribute = new LDAPAttribute("nsroledn", string2);
            LDAPModification lDAPModification = new LDAPModification(0, lDAPAttribute);
            lDAPConnection.modify(string, lDAPModification);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 20) {
                bl = false;
            }
            throw lDAPException;
        }
        return bl;
    }

    private void removeManagedRoleFromEntry(LDAPConnection lDAPConnection, String string, String string2) throws LDAPException {
        LDAPAttribute lDAPAttribute = new LDAPAttribute("nsroledn", string2);
        LDAPModification lDAPModification = new LDAPModification(1, lDAPAttribute);
        lDAPConnection.modify(string, lDAPModification);
    }

    private void updateLastRoleName() {
        if (this._lastRoleName == null) {
            this._lastRoleName = this._observable.get("cn", 0);
            if (this._lastRoleName != null && this._lastRoleName.length() == 0) {
                this._lastRoleName = null;
            }
        }
    }

    private String makeLastRoleDn() {
        String string = null;
        if (this._lastRoleName != null) {
            String string2 = this._observable.isNewUser() ? this._observable.getCreateBaseDN() : RolePickerDialog.makeParentDn(this._observable.getDN());
            string = "cn=" + this._lastRoleName + "," + string2;
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

