/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.panel.replication.AgreementWizard;
import com.netscape.admin.dirserv.panel.replication.AgreementWizardInfo;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.admin.dirserv.panel.replication.WAgreementPanel;
import com.netscape.admin.dirserv.wizard.IWizardPanel;
import com.netscape.admin.dirserv.wizard.WizardInfo;
import com.netscape.management.client.util.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class WAgreementSchedulePanel
extends WAgreementPanel
implements IWizardPanel,
ActionListener,
DocumentListener {
    private AgreementWizardInfo _wizardInfo;
    private boolean _initialized = false;
    private String _error = "WAgreementSchedulePanel: error message";
    private Color _activeColor;
    private JRadioButton _inSync;
    private JRadioButton _syncOn;
    private JButton _allButton;
    private JCheckBox[] _dayButton = new JCheckBox[7];
    private JTextField _startHr;
    private JTextField _startMin;
    private JTextField _endHr;
    private JTextField _endMin;
    private JPanel dayPanel;
    private JLabel check;
    private JTextField _intervalText;
    private AgreementWizard _wizard;

    public WAgreementSchedulePanel(AgreementWizard agreementWizard) {
        this._helpToken = "replication-wizard-schedule-help";
        this._section = "replication-schedule";
        this._wizard = agreementWizard;
    }

    public void init() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ReplicationTool.resetGBC(gridBagConstraints);
        this.setLayout(gridBagLayout);
        this.setPreferredSize(ReplicationTool.DEFAULT_PANEL_SIZE);
        this.setMaximumSize(ReplicationTool.DEFAULT_PANEL_SIZE);
        int n = UIFactory.getComponentSpace();
        int n2 = UIFactory.getDifferentSpace();
        int n3 = 20;
        int n4 = 2;
        JLabel jLabel = UIFactory.makeJLabel(this._section, "ask", WAgreementPanel._resource);
        jLabel.setLabelFor(this);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(n2, n, n2, n2);
        this.add((Component)jLabel, gridBagConstraints);
        this.check = UIFactory.makeJLabel(this._section, "checkSync", WAgreementPanel._resource);
        gridBagConstraints.gridwidth = 0;
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        this.add((Component)this.check, gridBagConstraints);
        this._intervalText = UIFactory.makeJTextField(null, "5", 3);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        this.add((Component)this._intervalText, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        this._inSync = UIFactory.makeJRadioButton(this, this._section, "inSyncButton", false, WAgreementPanel._resource);
        buttonGroup.add(this._inSync);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, n2, 0, n2);
        this.add((Component)this._inSync, gridBagConstraints);
        this._syncOn = UIFactory.makeJRadioButton(this, this._section, "syncOnButton", false, WAgreementPanel._resource);
        buttonGroup.add(this._syncOn);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, n2, 0, n2);
        this.add((Component)this._syncOn, gridBagConstraints);
        this.dayPanel = new JPanel();
        this.dayPanel.setLayout(new GridBagLayout());
        this.dayPanel.setBackground(this.getBackground());
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.dayPanel, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(this.getBackground());
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        this.makeDayButton(1, "dateMon");
        this.makeDayButton(2, "dateTue");
        this.makeDayButton(3, "dateWed");
        this.makeDayButton(4, "dateThu");
        this.makeDayButton(5, "dateFri");
        this.makeDayButton(6, "dateSat");
        this.makeDayButton(0, "dateSun");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = gridBagConstraints.insets.left;
        gridBagConstraints.anchor = 13;
        this._allButton = UIFactory.makeJButton(this, this._section, "allButton", WAgreementPanel._resource);
        this.dayPanel.add((Component)this._allButton, gridBagConstraints);
        this.check.setLabelFor(this.dayPanel);
        JLabel jLabel2 = UIFactory.makeJLabel(this._section, "between", WAgreementPanel._resource);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this._startHr = UIFactory.makeJTextField(null, "00", 3);
        jLabel2.setLabelFor(this._startHr);
        this._startHr.getDocument().addDocumentListener(this);
        this._activeColor = this._startHr.getBackground();
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this._startHr, gridBagConstraints);
        this._startMin = UIFactory.makeJTextField(null, "00", 3);
        jLabel2.setLabelFor(this._startMin);
        this._startMin.getDocument().addDocumentListener(this);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this._startMin, gridBagConstraints);
        JLabel jLabel3 = UIFactory.makeJLabel(this._section, "and", WAgreementPanel._resource);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this._endHr = UIFactory.makeJTextField(null, "00", 3);
        jLabel3.setLabelFor(this._endHr);
        this._endHr.getDocument().addDocumentListener(this);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this._endHr, gridBagConstraints);
        this._endMin = UIFactory.makeJTextField(null, "00", 3);
        jLabel3.setLabelFor(this._endMin);
        this._endMin.getDocument().addDocumentListener(this);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this._endMin, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        this.populateData();
        this._initialized = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Debug.println((String)("AgreementSchedulePanel: actionPerformed()" + actionEvent.toString()));
        if (actionEvent.getSource().equals(this._allButton)) {
            this.checkDate(true);
        }
        if (actionEvent.getSource().equals(this._inSync)) {
            this.disableTimeSelection();
        }
        if (actionEvent.getSource().equals(this._syncOn)) {
            this.enableTimeSelection();
        }
        this.checkNextButton();
    }

    public boolean initializePanel(WizardInfo wizardInfo) {
        Debug.println((String)"WAgreementSchedulePanel: initialize()");
        this._wizardInfo = (AgreementWizardInfo)wizardInfo;
        if (!this._initialized) {
            this.init();
        }
        if (this._wizardInfo.getAgreementType().equals("LEGACYR")) {
            this.setTimeIntervalVisible(true);
            this._intervalText.setText(Integer.toString(this._wizardInfo.getSyncInterval()));
        } else {
            this.setTimeIntervalVisible(false);
        }
        this.checkNextButton();
        return true;
    }

    public boolean validatePanel() {
        int n;
        Debug.println((String)"WAgreementSchedulePanel: validate()");
        if (this._syncOn.isSelected()) {
            int n2;
            int n3;
            int n4;
            int n5;
            n = 0;
            int n6 = 0;
            while (n6 < 7) {
                if (this._dayButton[n6].isSelected()) {
                    n = 1;
                }
                ++n6;
            }
            if (n == 0) {
                this._error = WAgreementPanel._resource.getString(this._section, "noneSelected");
                return false;
            }
            try {
                n5 = Integer.parseInt(this._startHr.getText());
                n4 = Integer.parseInt(this._endHr.getText());
                n3 = Integer.parseInt(this._startMin.getText());
                n2 = Integer.parseInt(this._endMin.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this._error = WAgreementPanel._resource.getString(this._section, "timeFormat");
                return false;
            }
            if (n5 < 0 || n5 > 23 || n4 < 0 || n4 > 23) {
                this._error = WAgreementPanel._resource.getString(this._section, "hrFormat");
                return false;
            }
            if (n3 < 0 || n3 > 59 || n2 < 0 || n2 > 59) {
                this._error = WAgreementPanel._resource.getString(this._section, "minFormat");
                return false;
            }
        }
        if (this._wizardInfo.getAgreementType().equals("LEGACYR")) {
            try {
                n = Integer.parseInt(this._intervalText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this._error = WAgreementPanel._resource.getString(this._section, "timeFormat");
                return false;
            }
        }
        return true;
    }

    public boolean concludePanel(WizardInfo wizardInfo) {
        return true;
    }

    public void getUpdateInfo(WizardInfo wizardInfo) {
        Debug.println((String)"WAgreementSchedulePanel: getUpdateInfo()");
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.createDateString());
        this._wizardInfo.setDate(vector);
    }

    public String getErrorMessage() {
        return this._error;
    }

    private void setTimeIntervalVisible(boolean bl) {
        this.check.setVisible(bl);
        this._intervalText.setVisible(bl);
    }

    private void makeDayButton(int n, String string) {
        this._dayButton[n] = UIFactory.makeJCheckBox(this, this._section, string, false, WAgreementPanel._resource);
        this._dayButton[n].setVerticalTextPosition(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ReplicationTool.resetGBC(gridBagConstraints);
        if (n == 0) {
            gridBagConstraints.gridwidth = 0;
        }
        this.dayPanel.add((Component)this._dayButton[n], gridBagConstraints);
    }

    private void disableTimeSelection() {
        int n = 0;
        while (n < 7) {
            this._dayButton[n].setEnabled(false);
            ++n;
        }
        this._allButton.setEnabled(false);
        this._startHr.setEnabled(false);
        this._startHr.setEditable(false);
        this._startHr.setBackground(this.getBackground());
        this._startMin.setEnabled(false);
        this._startMin.setEditable(false);
        this._startMin.setBackground(this.getBackground());
        this._endHr.setEnabled(false);
        this._endHr.setEditable(false);
        this._endHr.setBackground(this.getBackground());
        this._endMin.setEnabled(false);
        this._endMin.setEditable(false);
        this._endMin.setBackground(this.getBackground());
    }

    private void enableTimeSelection() {
        int n = 0;
        while (n < 7) {
            this._dayButton[n].setEnabled(true);
            ++n;
        }
        this._allButton.setEnabled(true);
        this._startHr.setEnabled(true);
        this._startHr.setEditable(true);
        this._startHr.setBackground(this._activeColor);
        this._startMin.setEnabled(true);
        this._startMin.setEditable(true);
        this._startMin.setBackground(this._activeColor);
        this._endHr.setEnabled(true);
        this._endHr.setEditable(true);
        this._endHr.setBackground(this._activeColor);
        this._endMin.setEnabled(true);
        this._endMin.setEditable(true);
        this._endMin.setBackground(this._activeColor);
    }

    private void checkDate(boolean bl) {
        int n = 0;
        while (n < 7) {
            this._dayButton[n].setSelected(bl);
            ++n;
        }
    }

    private void populateData() {
        String string = "";
        if (this._wizardInfo.getDate() != null && this._wizardInfo.getDate().size() > 0) {
            string = (String)this._wizardInfo.getDate().firstElement();
        }
        this.setSchedule(string);
    }

    private void setSchedule(String string) {
        Debug.println((String)("Schedule: " + string));
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        StringBuffer stringBuffer5 = new StringBuffer();
        if (!ReplicationTool.parseReplicaSchedule(string, stringBuffer, stringBuffer2, stringBuffer3, stringBuffer4, stringBuffer5)) {
            this._inSync.setSelected(true);
            this._startHr.setText("00");
            this._startMin.setText("00");
            this._endHr.setText("00");
            this._endMin.setText("00");
            this.checkDate(false);
            this.disableTimeSelection();
        } else {
            this._syncOn.setSelected(true);
            this._startHr.setText(stringBuffer.toString());
            this._startMin.setText(stringBuffer2.toString());
            this._endHr.setText(stringBuffer3.toString());
            this._endMin.setText(stringBuffer4.toString());
            String string2 = stringBuffer5.toString();
            int n = 0;
            while (n < string2.length()) {
                int n2 = Integer.parseInt(string2.substring(n, n + 1));
                this._dayButton[n2].setSelected(true);
                ++n;
            }
        }
    }

    private String createDateString() {
        if (this._inSync.isSelected()) {
            return "";
        }
        return ReplicationTool.createDateString(this._startHr, this._startMin, this._endHr, this._endMin, this._dayButton);
    }

    private String pad4(String string) {
        if (string.length() == 3) {
            return "0" + string;
        }
        if (string.length() == 2) {
            return "00" + string;
        }
        if (string.length() == 1) {
            return "000" + string;
        }
        if (string.length() == 0) {
            return "0000";
        }
        return string;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkNextButton();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    protected void checkNextButton() {
        if (this._syncOn.isSelected()) {
            boolean bl = false;
            int n = 0;
            while (n < this._dayButton.length) {
                if (this._dayButton[n].isSelected()) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                this._wizard.getbNext_Done().setEnabled(false);
                return;
            }
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            try {
                n2 = Integer.parseInt(this._startHr.getText());
                n3 = Integer.parseInt(this._startMin.getText());
                n4 = Integer.parseInt(this._endHr.getText());
                n5 = Integer.parseInt(this._endMin.getText());
            }
            catch (Exception exception) {
                this._wizard.getbNext_Done().setEnabled(false);
                return;
            }
            if (n3 < 0 || n3 >= 60 || n5 < 0 || n5 >= 60 || n2 < 0 || n2 >= 24 || n4 < 0 || n4 >= 24 || n2 > n4 || n2 == n4 && n3 >= n5) {
                this._wizard.getbNext_Done().setEnabled(false);
                return;
            }
        }
        this._wizard.getbNext_Done().setEnabled(true);
    }
}

