/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.SchemaUtility;
import com.netscape.admin.dirserv.panel.replication.AgreementWizardInfo;
import com.netscape.admin.dirserv.panel.replication.AttrCellRenderer;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.admin.dirserv.panel.replication.WAgreementPanel;
import com.netscape.admin.dirserv.wizard.IWizardPanel;
import com.netscape.admin.dirserv.wizard.WizardInfo;
import com.netscape.management.client.util.Debug;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPSchema;

public class WAgreementAttributePanel
extends WAgreementPanel
implements IWizardPanel,
ActionListener {
    private AgreementWizardInfo _wizardInfo;
    private boolean _initialized = false;
    private String _error = "WAgreementAttributePanel: error message";
    private Color _activeColor;
    private JScrollPane _rightScroll;
    private JScrollPane _leftScroll;
    private DefaultListModel _attrBoxModel = new DefaultListModel();
    private DefaultListModel _repBoxModel = new DefaultListModel();
    private JList _attrBox;
    private JList _repBox;
    private JPanel _entriesPanel;
    private JPanel _attrPanel;
    private JCheckBox _allAttr;
    private JRadioButton _allEntries;
    private JRadioButton _filterEntries;
    private JButton _addButton;
    private JButton _removeButton;
    private JButton _addAllButton;
    private JButton _removeAllButton;
    private JTextField _filterText;
    private JPanel _leftPanel;
    private JPanel _rightPanel;
    private static final Dimension BUTTON_MIN_SIZE = new Dimension(100, 25);

    public WAgreementAttributePanel() {
        this._helpToken = "replication-wizard-attribute-help";
        this._section = "replication-attribute";
    }

    public void init() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ReplicationTool.resetGBC(gridBagConstraints);
        this.setLayout(gridBagLayout);
        this.setPreferredSize(ReplicationTool.DEFAULT_PANEL_SIZE);
        this.setMaximumSize(ReplicationTool.DEFAULT_PANEL_SIZE);
        JLabel jLabel = new JLabel(WAgreementPanel._resource.getString(this._section, "ask-label"));
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 5, 10, 10);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        String string = WAgreementPanel._resource.getString(this._section, "entries-label");
        this._entriesPanel = new GroupPanel(string);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this._entriesPanel.setLayout(gridBagLayout2);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this._entriesPanel, gridBagConstraints);
        this.add(this._entriesPanel);
        ButtonGroup buttonGroup = new ButtonGroup();
        this._allEntries = new JRadioButton(WAgreementPanel._resource.getString(this._section, "entriesAll-label"));
        buttonGroup.add(this._allEntries);
        this._allEntries.addActionListener(this);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        gridBagLayout2.setConstraints(this._allEntries, gridBagConstraints);
        this._entriesPanel.add(this._allEntries);
        this._filterEntries = new JRadioButton(WAgreementPanel._resource.getString(this._section, "matchFilter-label"));
        buttonGroup.add(this._filterEntries);
        this._filterEntries.addActionListener(this);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        gridBagLayout2.setConstraints(this._filterEntries, gridBagConstraints);
        this._entriesPanel.add(this._filterEntries);
        this._filterText = new JTextField("");
        this._activeColor = this._filterText.getBackground();
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 30, 0, 5);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout2.setConstraints(this._filterText, gridBagConstraints);
        this._entriesPanel.add(this._filterText);
        string = WAgreementPanel._resource.getString(this._section, "attribute-label");
        this._attrPanel = new GroupPanel(string);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        this._attrPanel.setLayout(gridBagLayout3);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this._attrPanel, gridBagConstraints);
        this.add(this._attrPanel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        gridBagLayout3.setConstraints(jPanel, gridBagConstraints);
        this._attrPanel.add(jPanel);
        this._allAttr = new JCheckBox(WAgreementPanel._resource.getString(this._section, "attributeAll-label"));
        this._allAttr.setToolTipText(WAgreementPanel._resource.getString(this._section, "attributeAll-ttip"));
        this._allAttr.addActionListener(this);
        jPanel.add("West", this._allAttr);
        string = WAgreementPanel._resource.getString(this._section, "attributeAttr-label");
        this._leftPanel = new GroupPanel(string);
        this._leftPanel.setLayout(new BorderLayout());
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.5;
        gridBagLayout3.setConstraints(this._leftPanel, gridBagConstraints);
        this._attrPanel.add(this._leftPanel);
        this._attrBox = this.createListBox(this._attrBoxModel, 10);
        this._leftScroll = this.createScrollPane(this._attrBox);
        this._leftPanel.add("Center", this._leftScroll);
        string = WAgreementPanel._resource.getString(this._section, "attributeReplica-label");
        this._rightPanel = new GroupPanel(string);
        this._rightPanel.setLayout(new BorderLayout());
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout3.setConstraints(this._rightPanel, gridBagConstraints);
        this._attrPanel.add(this._rightPanel);
        this._repBox = this.createListBox(this._repBoxModel, 10);
        this._rightScroll = this.createScrollPane(this._repBox);
        this._rightPanel.add("Center", this._rightScroll);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout4);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout3.setConstraints(jPanel2, gridBagConstraints);
        this._attrPanel.add(jPanel2);
        this._addAllButton = new JButton(WAgreementPanel._resource.getString(this._section, "attributeAddAllButton-label"));
        this._addAllButton.addActionListener(this);
        this._addAllButton.setSize(BUTTON_MIN_SIZE);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagLayout4.setConstraints(this._addAllButton, gridBagConstraints);
        jPanel2.add(this._addAllButton);
        this._addButton = new JButton(WAgreementPanel._resource.getString(this._section, "attributeAddButton-label"));
        this._addButton.addActionListener(this);
        this._addButton.setSize(BUTTON_MIN_SIZE);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagLayout4.setConstraints(this._addButton, gridBagConstraints);
        jPanel2.add(this._addButton);
        this._removeButton = new JButton(WAgreementPanel._resource.getString(this._section, "attributeRemoveButton-label"));
        this._removeButton.addActionListener(this);
        this._removeButton.setSize(BUTTON_MIN_SIZE);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagLayout4.setConstraints(this._removeButton, gridBagConstraints);
        jPanel2.add(this._removeButton);
        this._removeAllButton = new JButton(WAgreementPanel._resource.getString(this._section, "attributeRemoveAllButton-label"));
        this._removeAllButton.addActionListener(this);
        this._removeAllButton.setSize(BUTTON_MIN_SIZE);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout4.setConstraints(this._removeAllButton, gridBagConstraints);
        jPanel2.add(this._removeAllButton);
        this.populateData();
        this._initialized = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this._initialized) {
            int n;
            Object[] objectArray;
            Debug.println((String)("AgreementAttributePanel: actionPerformed()" + actionEvent.toString()));
            if (actionEvent.getSource().equals(this._allEntries)) {
                this._filterText.setEditable(false);
                this._filterText.setBackground(this.getBackground());
                this._filterText.repaint(1L);
            }
            if (actionEvent.getSource().equals(this._filterEntries)) {
                this._filterText.setEditable(true);
                this._filterText.setBackground(this._activeColor);
                this._filterText.repaint(1L);
            }
            if (actionEvent.getSource().equals(this._allAttr)) {
                if (this._allAttr.isSelected()) {
                    this.populateAttrList(false);
                    this.disableAttrSelection();
                } else {
                    this.enableAttrSelection();
                }
            }
            if (actionEvent.getSource().equals(this._addAllButton)) {
                this.populateAttrList(false);
            }
            if (actionEvent.getSource().equals(this._addButton)) {
                objectArray = this._attrBox.getSelectedValues();
                if (objectArray.length > 0) {
                    n = 0;
                    while (n < objectArray.length) {
                        SchemaUtility.InsertElement(this._repBoxModel, objectArray[n]);
                        this._attrBoxModel.removeElement(objectArray[n]);
                        ++n;
                    }
                }
                this._attrBox.invalidate();
                this._attrBox.validate();
                this._attrBox.repaint(1L);
            }
            if (actionEvent.getSource().equals(this._removeButton)) {
                objectArray = this._repBox.getSelectedValues();
                if (objectArray.length > 0) {
                    n = 0;
                    while (n < objectArray.length) {
                        SchemaUtility.InsertElement(this._attrBoxModel, objectArray[n]);
                        this._repBoxModel.removeElement(objectArray[n]);
                        ++n;
                    }
                }
                this._repBox.invalidate();
                this._repBox.validate();
                this._repBox.repaint(1L);
            }
            if (actionEvent.getSource().equals(this._removeAllButton)) {
                this.populateAttrList(true);
            }
        }
    }

    public boolean initializePanel(WizardInfo wizardInfo) {
        Debug.println((String)"WAgreementAttributePanel: initialize()");
        this._wizardInfo = (AgreementWizardInfo)wizardInfo;
        if (this._wizardInfo.getAgreementType().equals("LEGACYR")) {
            return false;
        }
        if (!this._initialized) {
            this.init();
        }
        return true;
    }

    public boolean validatePanel() {
        Debug.println((String)"WAgreementAttributePanel: validate()");
        if (this._filterEntries.isSelected() && this._filterText.getText().equals("")) {
            this._error = WAgreementPanel._resource.getString(this._section, "dialog-filterEmpty");
            return false;
        }
        if (this._repBoxModel.size() == 0) {
            this._error = WAgreementPanel._resource.getString(this._section, "dialog-noAttr");
            return false;
        }
        return true;
    }

    public boolean concludePanel(WizardInfo wizardInfo) {
        Debug.println((String)"WAgreementAttributePanel: conclude()");
        return true;
    }

    public void getUpdateInfo(WizardInfo wizardInfo) {
        Debug.println((String)"WAgreementAttributePanel: getUpdateInfo()");
        if (this._filterEntries.isSelected()) {
            this._wizardInfo.setFilter(this._filterText.getText());
        } else {
            this._wizardInfo.setFilter("");
        }
        Vector vector = new Vector();
        if (!this._allAttr.isSelected()) {
            if (this._attrBoxModel.size() == 0) {
                this._allAttr.setSelected(true);
                this._wizardInfo.setAttrType(0);
                this.disableAttrSelection();
            } else if (this._repBoxModel.size() <= this._attrBoxModel.size()) {
                int n = 0;
                while (n < this._repBoxModel.size()) {
                    vector.addElement(this._repBoxModel.getElementAt(n));
                    ++n;
                }
                this._wizardInfo.setAttrType(1);
            } else {
                int n = 0;
                while (n < this._attrBoxModel.size()) {
                    vector.addElement(this._attrBoxModel.getElementAt(n));
                    ++n;
                }
                this._wizardInfo.setAttrType(2);
            }
        } else {
            this._wizardInfo.setAttrType(0);
        }
        this._wizardInfo.setSelectedAttr(vector);
    }

    public String getErrorMessage() {
        return this._error;
    }

    private void populateData() {
        if (this._wizardInfo.getFilter() == null || this._wizardInfo.getFilter().equals("")) {
            this._allEntries.setSelected(true);
            this._filterText.setEditable(false);
            this._filterText.setBackground(this.getBackground());
        } else {
            this._filterEntries.setSelected(true);
            this._filterText.setEditable(true);
            this._filterText.setBackground(this._activeColor);
            this._filterText.setText(this._wizardInfo.getFilter());
        }
        if (this._wizardInfo.getSelectedAttr() == null) {
            this.populateAttrList(true);
            this._allAttr.setSelected(false);
            this.enableAttrSelection();
        } else {
            this.populateAttrList(true);
            Enumeration enumeration = this._wizardInfo.getSelectedAttr().elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this._attrBoxModel.removeElement(string);
                SchemaUtility.InsertElement(this._repBoxModel, string);
            }
            this.enableAttrSelection();
        }
    }

    private void populateAttrList(boolean bl) {
        this._attrBoxModel.removeAllElements();
        this._repBoxModel.removeAllElements();
        LDAPSchema lDAPSchema = this._wizardInfo.getLDAPSchema();
        if (lDAPSchema == null) {
            return;
        }
        LDAPSchema lDAPSchema2 = lDAPSchema;
        synchronized (lDAPSchema2) {
            Enumeration enumeration = lDAPSchema.getAttributes();
            while (enumeration.hasMoreElements()) {
                LDAPAttributeSchema lDAPAttributeSchema = (LDAPAttributeSchema)enumeration.nextElement();
                if (bl) {
                    SchemaUtility.InsertElement(this._attrBoxModel, lDAPAttributeSchema.getName());
                    continue;
                }
                SchemaUtility.InsertElement(this._repBoxModel, lDAPAttributeSchema.getName());
            }
        }
    }

    private void disableAttrSelection() {
        this._leftPanel.setEnabled(false);
        this._leftScroll.setEnabled(false);
        this._rightPanel.setEnabled(false);
        this._rightScroll.setEnabled(false);
        this._attrBox.setEnabled(false);
        this._repBox.setEnabled(false);
        this._addAllButton.setEnabled(false);
        this._addButton.setEnabled(false);
        this._removeButton.setEnabled(false);
        this._removeAllButton.setEnabled(false);
    }

    private void enableAttrSelection() {
        this._leftPanel.setEnabled(true);
        this._leftScroll.setEnabled(true);
        this._rightPanel.setEnabled(true);
        this._rightScroll.setEnabled(true);
        this._attrBox.setEnabled(true);
        this._repBox.setEnabled(true);
        this._addAllButton.setEnabled(true);
        this._addButton.setEnabled(true);
        this._removeButton.setEnabled(true);
        this._removeAllButton.setEnabled(true);
    }

    JList createListBox(DefaultListModel defaultListModel, int n) {
        JList<String> jList = new JList<String>(defaultListModel);
        jList.setCellRenderer(new AttrCellRenderer());
        jList.setSelectionModel(new DefaultListSelectionModel());
        jList.setPrototypeCellValue("1234567890 1234567890");
        jList.setVisibleRowCount(n);
        return jList;
    }

    JScrollPane createScrollPane(JList jList) {
        JScrollPane jScrollPane = new JScrollPane(jList, 22, 31);
        jScrollPane.setAlignmentX(0.0f);
        jScrollPane.setAlignmentY(0.0f);
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        return jScrollPane;
    }
}

