/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.panel.replication.ReplicationAgreement;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class SIRAgreement
extends ReplicationAgreement {
    private static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.panel.replication.replication");
    private static final String SIRAgreementClass = "LDAPReplica";

    public SIRAgreement(ConsoleInfo consoleInfo, LDAPEntry lDAPEntry, LDAPEntry lDAPEntry2) {
        super(1);
        this.supplierHost = consoleInfo.getHost();
        this.supplierPort = consoleInfo.getPort();
        this.setServerInfo(consoleInfo);
        String string = null;
        if (lDAPEntry != null) {
            string = lDAPEntry.getDN();
            this.setOrigEntryDN(string);
            this.setEntryDN(string);
            this.readValuesFromEntry(lDAPEntry);
            this.agreementIsNew = false;
        } else if (lDAPEntry2 != null) {
            string = "cn=xxx," + lDAPEntry2.getDN();
            this.agreementIsNew = true;
            this.setOrigEntryDN(string);
        }
    }

    public void readValuesFromEntry(LDAPEntry lDAPEntry) {
        Debug.println((int)7, (String)("SIRAgreement.readValuesFromEntry: " + lDAPEntry));
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        Enumeration enumeration = lDAPAttributeSet.getAttributes();
        String string = null;
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2;
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            if (lDAPAttribute.getName().equalsIgnoreCase("replicatedAttributeList")) {
                this.parseReplAttrList(lDAPAttribute);
                this.origSelattrType = this.getSelattrType();
                this.origSelectedAttrs = (Vector)this.getSelectedAttributes().clone();
                continue;
            }
            if (lDAPAttribute.getName().equalsIgnoreCase("replicaUpdateSchedule")) {
                enumeration2 = lDAPAttribute.getStringValues();
                while (enumeration2.hasMoreElements()) {
                    this.addUpdateSchedule((String)enumeration2.nextElement());
                }
                continue;
            }
            enumeration2 = lDAPAttribute.getStringValues();
            if (!enumeration2.hasMoreElements()) continue;
            String string2 = (String)enumeration2.nextElement();
            if (lDAPAttribute.getName().equalsIgnoreCase("replicaRoot")) {
                this.setReplicatedSubtree(string2);
                this.origReplicatedSubtree = string2;
                continue;
            }
            if (lDAPAttribute.getName().equalsIgnoreCase("replicaHost")) {
                this.setConsumerHost(string2);
                this.origConsumerHost = this.getConsumerHost();
                continue;
            }
            if (lDAPAttribute.getName().equalsIgnoreCase("replicaPort")) {
                try {
                    this.setConsumerPort(Integer.parseInt(string2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.origConsumerPort = this.getConsumerPort();
                continue;
            }
            if (lDAPAttribute.getName().equalsIgnoreCase("replicaBindDN")) {
                this.setBindDN(string2);
                continue;
            }
            if (lDAPAttribute.getName().equalsIgnoreCase("replicaCredentials")) {
                this.setBindCredentials(string2);
                continue;
            }
            if (lDAPAttribute.getName().equalsIgnoreCase("replicaNickname")) {
                this.setNickname(string2);
                continue;
            }
            if (lDAPAttribute.getName().equalsIgnoreCase("replicaUseSSL")) {
                this.setUseSSL(string2);
                continue;
            }
            if (lDAPAttribute.getName().equalsIgnoreCase("replicaEntryFilter")) {
                this.setEntryFilter(string2);
                this.origEntryFilter = this.getEntryFilter();
                continue;
            }
            if (lDAPAttribute.getName().equalsIgnoreCase("cn")) {
                string = string2;
                continue;
            }
            if (!lDAPAttribute.getName().equalsIgnoreCase("replicaBeginORC")) continue;
            this.setORCValue(string2);
        }
        if (string != null) {
            this.setEntryCN(string);
        }
    }

    public int writeToServer() throws IOException {
        if (this.agreementDNHasChanged() || this.agreementIsNew) {
            String[] stringArray;
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            String[] stringArray2 = new String[]{"top", SIRAgreementClass};
            LDAPAttribute lDAPAttribute = new LDAPAttribute("objectclass", stringArray2);
            lDAPAttributeSet.add(lDAPAttribute);
            lDAPAttribute = new LDAPAttribute("replicaNickname", this.nickname);
            lDAPAttributeSet.add(lDAPAttribute);
            lDAPAttribute = new LDAPAttribute("cn", this.entryCN);
            lDAPAttributeSet.add(lDAPAttribute);
            lDAPAttribute = this.replicatedSubtree == null ? new LDAPAttribute("replicaRoot", "") : new LDAPAttribute("replicaRoot", this.replicatedSubtree);
            lDAPAttributeSet.add(lDAPAttribute);
            lDAPAttribute = new LDAPAttribute("replicaHost", this.consumerHost);
            lDAPAttributeSet.add(lDAPAttribute);
            lDAPAttribute = new LDAPAttribute("replicaPort", Integer.toString(this.consumerPort));
            lDAPAttributeSet.add(lDAPAttribute);
            if (this.bindDN != null) {
                lDAPAttribute = new LDAPAttribute("replicaBindDN", this.bindDN);
                lDAPAttributeSet.add(lDAPAttribute);
            }
            if (this.bindCredentials != null) {
                lDAPAttribute = new LDAPAttribute("replicaCredentials", this.bindCredentials);
                lDAPAttributeSet.add(lDAPAttribute);
            }
            lDAPAttribute = new LDAPAttribute("replicaUseSSL", this.useSSL ? "1" : "0");
            lDAPAttributeSet.add(lDAPAttribute);
            String string = this.createReplicatedAttributesList();
            if (string != null) {
                lDAPAttribute = new LDAPAttribute("replicatedAttributeList", string);
                lDAPAttributeSet.add(lDAPAttribute);
            }
            if (this.entryFilter != null && !this.entryFilter.equals("")) {
                lDAPAttribute = new LDAPAttribute("replicaEntryFilter", this.entryFilter);
                lDAPAttributeSet.add(lDAPAttribute);
            }
            if ((stringArray = this.getUpdateScheduleStrings()) != null) {
                boolean bl = false;
                int n = 0;
                while (!bl && n < stringArray.length) {
                    bl = stringArray[n] != null && stringArray[n].length() > 0;
                    ++n;
                }
                if (bl) {
                    lDAPAttribute = new LDAPAttribute("replicaUpdateSchedule", stringArray);
                    lDAPAttributeSet.add(lDAPAttribute);
                }
            }
            LDAPEntry lDAPEntry = new LDAPEntry(this.entryDN, lDAPAttributeSet);
            try {
                this.createNewEntry(lDAPEntry);
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("SIRAgreement.writeToServer: <" + this.entryDN + "> " + lDAPException.toString()));
                return lDAPException.getLDAPResultCode();
            }
            if (!this.agreementIsNew) {
                try {
                    this.deleteOldEntry();
                    this.setOrigEntryDN(this.getEntryDN());
                }
                catch (LDAPException lDAPException) {
                    Debug.println((String)("SIRAgreement.writeToServer: <" + this.entryDN + "> " + lDAPException.toString()));
                    return lDAPException.getLDAPResultCode();
                }
            }
        } else {
            LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
            LDAPAttribute lDAPAttribute = new LDAPAttribute("replicaNickname", this.getNickname());
            lDAPModificationSet.add(2, lDAPAttribute);
            lDAPAttribute = new LDAPAttribute("cn", this.entryCN);
            lDAPModificationSet.add(2, lDAPAttribute);
            lDAPAttribute = new LDAPAttribute("replicaRoot", this.replicatedSubtree);
            lDAPModificationSet.add(2, lDAPAttribute);
            lDAPAttribute = this.bindDN != null ? new LDAPAttribute("replicaBindDN", this.bindDN) : new LDAPAttribute("replicaBindDN");
            lDAPModificationSet.add(2, lDAPAttribute);
            lDAPAttribute = this.bindCredentials != null ? new LDAPAttribute("replicaCredentials", this.bindCredentials) : new LDAPAttribute("replicaCredentials");
            lDAPModificationSet.add(2, lDAPAttribute);
            lDAPAttribute = new LDAPAttribute("replicaUseSSL", this.useSSL ? "1" : "0");
            lDAPModificationSet.add(2, lDAPAttribute);
            if (this.getSelattrType() == 0 || this.selectedAttrs == null || this.selectedAttrs.size() == 0) {
                lDAPAttribute = new LDAPAttribute("replicatedAttributeList");
                lDAPModificationSet.add(2, lDAPAttribute);
            } else {
                String string = this.createReplicatedAttributesList();
                lDAPAttribute = new LDAPAttribute("replicatedAttributeList", string);
                lDAPModificationSet.add(2, lDAPAttribute);
            }
            if (this.entryFilter != null && !this.entryFilter.equals("")) {
                lDAPAttribute = new LDAPAttribute("replicaEntryFilter", this.entryFilter);
                lDAPModificationSet.add(2, lDAPAttribute);
            } else {
                lDAPAttribute = new LDAPAttribute("replicaEntryFilter");
                lDAPModificationSet.add(2, lDAPAttribute);
            }
            String[] stringArray = this.getUpdateScheduleStrings();
            lDAPAttribute = new LDAPAttribute("replicaUpdateSchedule");
            if (stringArray != null) {
                boolean bl = false;
                int n = 0;
                while (!bl && n < stringArray.length) {
                    bl = stringArray[n] != null && stringArray[n].length() > 0;
                    ++n;
                }
                if (bl) {
                    lDAPAttribute = new LDAPAttribute("replicaUpdateSchedule", stringArray);
                }
            }
            lDAPModificationSet.add(2, lDAPAttribute);
            try {
                this.updateEntry(lDAPModificationSet);
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("SIRAgreement.writeToServer: <" + this.entryDN + "> " + lDAPException.toString()));
                return lDAPException.getLDAPResultCode();
            }
        }
        return 0;
    }
}

