/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class ReplicationTool {
    static final int borderWidth = UIFactory.getBorderInsets().left;
    static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(borderWidth, borderWidth, borderWidth, borderWidth);
    static final Border LOWERED_BORDER = BorderFactory.createLoweredBevelBorder();
    static final Border RAISED_BORDER = BorderFactory.createRaisedBevelBorder();
    static final Border ETCHED_BORDER = BorderFactory.createEtchedBorder();
    static final Dimension DEFAULT_PANEL_SIZE = new Dimension(300, 300);
    static final Dimension TALL_PANEL_SIZE = new Dimension(300, 440);
    static final int DEFAULT_PADDING = 6;
    static final Insets DEFAULT_EMPTY_INSETS = new Insets(0, 0, 0, 0);
    static final Insets BOTTOM_INSETS = new Insets(6, 6, 6, 6);
    static final Insets DEFAULT_INSETS = new Insets(6, 6, 6, 0);
    static final String MD_ENTRY_DN = "cn=replication, cn=config";
    static final String MD_ATTRIBUTE_KEY = "netscapeMDSuffix.key";
    static final String REPLICA_CN = "replica";
    static final String REPLICA_RDN = "cn=replica";
    static final String[] REPLICA_OBJECTCLASSES = new String[]{"top", "nsDS5Replica"};
    static final String REPLICA_ROOT_ATTR = "nsDS5ReplicaRoot";
    static final String REPLICA_TYPE_ATTR = "nsDS5ReplicaType";
    static final String REPLICA_BINDDN_ATTR = "nsDS5ReplicaBindDN";
    static final String PUBLIC_SUFFIX_ATTR = "nsslapd-suffix";
    static final String MMR_AGREEMENT_OBJECTCLASS = "nsDS5ReplicationAgreement";
    static final String[] MMR_AGREEMENT_OBJECTCLASSES = new String[]{"top", "nsDS5ReplicationAgreement"};
    static final String REPLICA_HOST_ATTR = "nsDS5ReplicaHost";
    static final String REPLICA_PORT_ATTR = "nsDS5ReplicaPort";
    static final String REPLICA_TRANSPORT_ATTR = "nsDS5ReplicaTransportInfo";
    static final String REPLICA_TRANSPORT_SSL = "SSL";
    static final String REPLICA_TRANSPORT_STARTTLS = "startTLS";
    static final String REPLICA_TRANSPORT_LDAP = "LDAP";
    static final String REPLICA_CRED_ATTR = "nsDS5ReplicaCredentials";
    static final String REPLICA_BINDMETHOD_ATTR = "nsDS5ReplicaBindMethod";
    static final String REPLICA_BINDMETHOD_SIMPLE = "SIMPLE";
    static final String REPLICA_BINDMETHOD_SSLCLIENTAUTH = "SSLCLIENTAUTH";
    static final String REPLICA_SCHEDULE_ATTR = "nsDS5ReplicaUpdateSchedule";
    static final String REPLICA_REFRESH_ATTR = "nsds5BeginReplicaRefresh";
    static final String MMR_NAME_ATTR = "cn";
    static final String MMR_NICKNAME_ATTR = "description";
    static final String LEGACYR_AGREEMENT_OBJECTCLASS = "LDAPReplica";
    static final String[] LEGACYR_AGREEMENT_OBJECTCLASSES = new String[]{"top", "LDAPReplica"};
    static final String REPLICA_CONSUMER_INIT_BEGIN_ATTR = "nsds5replicaLastInitStart";
    static final String REPLICA_CONSUMER_INIT_END_ATTR = "nsds5replicaLastInitEnd";
    static final String REPLICA_CONSUMER_INIT_STATUS_ATTR = "nsds5replicalastinitstatus";
    static final String REPLICA_LAST_UPDATE_START_ATTR = "nsds5replicaLastUpdateStart";
    static final String REPLICA_LAST_UPDATE_END_ATTR = "nsds5replicaLastUpdateEnd";
    static final String REPLICA_N_CHANGES_SENT_ATTR = "nsds5replicaChangesSentSinceStartup";
    static final String REPLICA_LAST_UPDATE_STATUS_ATTR = "nsds5replicaLastUpdateStatus";
    static final String REPLICA_UPDATE_IN_PROGRESS_ATTR = "nsds5replicaUpdateInProgress";
    static final String REPLICA_LEGACY_CONSUMER_ATTR = "nsds5ReplicaLegacyConsumer";
    static final String REPLICA_PURGE_DELAY_ATTR = "nsds5ReplicaPurgeDelay";
    static final String DEFAULT_PURGE_DELAY = "604800";
    static final String REPLICA_ID_ATTR = "nsDS5ReplicaID";
    static final String REPLICA_LOG_CHANGES_ATTR = "nsDS5Flags";
    static final String REPLICA_REFERRAL_ATTR = "nsDS5ReplicaReferral";
    static final String REPLICA_CONSUMER_INIT_IN_PROGRESS = "start";
    static final String[] REPLICA_STATUS_ATTRS = new String[]{"nsds5replicaLastUpdateStart", "nsds5replicaLastUpdateEnd", "nsds5replicaChangesSentSinceStartup", "nsds5replicaLastUpdateStatus", "nsds5replicaUpdateInProgress", "nsds5replicaLastInitStart", "nsds5replicaLastInitEnd", "nsds5replicalastinitstatus", "nsds5BeginReplicaRefresh"};
    private static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.panel.replication.replication");
    private static Hashtable _cPackageImages = new Hashtable();
    private static String _sImageDir = "com/netscape/admin/dirserv/images";

    static RemoteImage getImage(String string) {
        RemoteImage remoteImage = (RemoteImage)_cPackageImages.get(string);
        if (remoteImage != null) {
            return remoteImage;
        }
        remoteImage = new RemoteImage(_sImageDir + "/" + string);
        if (remoteImage != null) {
            _cPackageImages.put(string, remoteImage);
        }
        return remoteImage;
    }

    public static void resetGBC(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = (Insets)DEFAULT_INSETS.clone();
    }

    static String getMachineDataDN(ConsoleInfo consoleInfo) {
        LDAPConnection lDAPConnection;
        String string = null;
        string = (String)consoleInfo.get(MD_ATTRIBUTE_KEY);
        if (string == null && (lDAPConnection = consoleInfo.getLDAPConnection()) != null) {
            LDAPEntry lDAPEntry = null;
            try {
                lDAPEntry = lDAPConnection.read(MD_ENTRY_DN);
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("fail read : cn=replication, cn=config error:" + lDAPException.toString()));
            }
            if (lDAPEntry != null) {
                string = lDAPEntry.getDN();
                consoleInfo.put(MD_ATTRIBUTE_KEY, string);
            }
        }
        Debug.println((String)("getMachineDataDN: returning " + string));
        return string;
    }

    private static String lookupRealDSHost(ConsoleInfo consoleInfo) {
        LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
        String string = "";
        String[] stringArray = new String[]{"dataversion"};
        try {
            LDAPEntry lDAPEntry = lDAPConnection.read("", stringArray);
            LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
            Enumeration enumeration = lDAPAttributeSet.getAttributes();
            while (enumeration.hasMoreElements()) {
                LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                if (!lDAPAttribute.getName().equalsIgnoreCase("dataversion")) continue;
                string = (String)lDAPAttribute.getStringValues().nextElement();
            }
        }
        catch (LDAPException lDAPException) {
            return "";
        }
        int n = string.indexOf(":");
        if (n == -1) {
            return "";
        }
        return string.substring(0, n).trim();
    }

    static String fullyQualifyHostName(String string) {
        String string2 = string;
        if (string != null) {
            int n = string.indexOf(46);
            if (n == -1) {
                n = string.length();
            }
            try {
                String string3 = DSUtil.canonicalHost(string);
                if (string3 != null) {
                    int n2 = string3.length();
                    if (n > n2) {
                        n = n2;
                    }
                    if (string3.substring(0, n).equalsIgnoreCase(string)) {
                        string2 = string3;
                    }
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        Debug.println((String)("fullyQualifyHostName: return " + string2));
        return string2;
    }

    public static boolean authenticate(IDSModel iDSModel) {
        boolean bl = true;
        while (!ReplicationTool.verifyDM(iDSModel.getServerInfo())) {
            String string = _resource.getString("replication-dialog", "authenticationAsDM");
            DSUtil.showErrorDialog((Component)iDSModel.getFrame(), "error", string, "replication-dialog");
            if (iDSModel.getNewAuthentication(false)) continue;
            bl = false;
            break;
        }
        iDSModel.notifyAuthChangeListeners();
        return bl;
    }

    static boolean verifyDM(ConsoleInfo consoleInfo) {
        LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
        if (lDAPConnection.getAuthenticationDN().trim().equals("")) {
            return false;
        }
        Debug.println((String)("ReplicationTool.verifyDM: authDN = <" + lDAPConnection.getAuthenticationDN() + ">, authPassword = <" + lDAPConnection.getAuthenticationPassword() + ">"));
        LDAPSearchResults lDAPSearchResults = null;
        String string = "(objectclass=*)";
        try {
            lDAPSearchResults = lDAPConnection.search(ReplicationTool.getMachineDataDN(consoleInfo), 2, string, null, false);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("ReplicationTool.verifyDM: " + (Object)((Object)lDAPException)));
            ReplicationTool.displayError(lDAPException.errorCodeToString());
            return false;
        }
        if (lDAPSearchResults.hasMoreElements()) {
            return true;
        }
        Debug.println((String)"ReplicationTool.verifyDM: no results on search");
        return false;
    }

    static void displayError(String string) {
        if (string == null || string.equals("")) {
            string = _resource.getString("replication", "err0080");
        }
        DSUtil.showErrorDialog(null, "error", string, "replication-dialog");
    }

    static void displayError(int n) {
        ReplicationTool.displayError(LDAPException.errorCodeToString((int)n));
    }

    static void displayError(Component component, String string, String string2, String string3, String[] stringArray) {
        DSUtil.showErrorDialog(component, string2, string3, stringArray, string, _resource);
    }

    static boolean parseReplicaSchedule(String string, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3, StringBuffer stringBuffer4, StringBuffer stringBuffer5) {
        if (stringBuffer == null || stringBuffer2 == null || stringBuffer3 == null || stringBuffer4 == null || stringBuffer5 == null) {
            return false;
        }
        stringBuffer.setLength(0);
        stringBuffer2.setLength(0);
        stringBuffer3.setLength(0);
        stringBuffer4.setLength(0);
        stringBuffer5.setLength(0);
        boolean bl = false;
        if (string != null && !string.equals("") && string.charAt(0) == '*') {
            Debug.println((String)("ReplicationTool.parseReplicaSchedule(): invalid replica schedule [" + string + "]"));
            string = "0000-2359" + string.substring(1);
        }
        if (string != null && !string.equals("") && string.length() >= 4) {
            stringBuffer.append(string.substring(0, 2));
            stringBuffer2.append(string.substring(2, 4));
            int n = string.indexOf(45);
            if (n > 0) {
                stringBuffer3.append(string.substring(n + 1, n + 3));
                stringBuffer4.append(string.substring(n + 3, n + 5));
            } else {
                stringBuffer3.append("00");
                stringBuffer4.append("00");
            }
            int n2 = string.indexOf(32);
            if (n2 > 0) {
                stringBuffer5.append(string.substring(n2 + 1).trim());
            } else {
                stringBuffer5.append("0123456");
            }
            bl = true;
        } else {
            stringBuffer.append("00");
            stringBuffer2.append("00");
            stringBuffer3.append("23");
            stringBuffer4.append("59");
            stringBuffer5.append("0123456");
        }
        return bl;
    }

    static String createDateString(JTextComponent jTextComponent, JTextComponent jTextComponent2, JTextComponent jTextComponent3, JTextComponent jTextComponent4, AbstractButton[] abstractButtonArray) {
        String string = "";
        String string2 = ReplicationTool.pad4(jTextComponent.getText(), jTextComponent2.getText());
        String string3 = ReplicationTool.pad4(jTextComponent3.getText(), jTextComponent4.getText());
        int n = 0;
        while (n < 7) {
            if (abstractButtonArray[n].isSelected()) {
                string = string + Integer.toString(n);
            }
            ++n;
        }
        return string2 + "-" + string3 + " " + string;
    }

    static String pad4(String string, String string2) {
        String string3 = string.length() == 0 ? "00" : (string.length() == 1 ? "0" + string : string);
        if (string2.length() == 0) {
            return string3 + "00";
        }
        if (string2.length() == 1) {
            return string3 + "0" + string2;
        }
        return string3 + string2;
    }

    public static String convertStatusMessage(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = stringTokenizer.nextToken();
        if (string2 != null && string2.length() > 0) {
            try {
                int n = Integer.parseInt(string2);
                String string3 = string.substring(string2.length() + 1);
                if (string3 != null && string3.length() > 0) {
                    if (n != 0) {
                        String[] stringArray = new String[]{string3, string2};
                        return _resource.getString("replication", "convertupdatemessage-error-label", stringArray);
                    }
                    return string3;
                }
            }
            catch (Exception exception) {
                Debug.println((String)("ReplicationTool.convertStatusMessage() exception parsing " + string2 + ": " + exception));
            }
        }
        return string;
    }
}

