/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.DSResourceModel;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.node.DSResourceObject;
import com.netscape.admin.dirserv.panel.replication.ReplicaResourceObject;
import com.netscape.admin.dirserv.panel.replication.ReplicationSettingPanel;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class ReplicationResourceObject
extends DSResourceObject
implements ActionListener,
TreeExpansionListener,
IMenuInfo {
    protected String[] _categoryID;
    protected IMenuItem[] _contextMenuItems;
    protected IMenuItem[] _objectMenuItems;
    private boolean _isLoaded;
    private boolean _isInitiallyExpanded = false;
    private boolean _isLeaf = false;
    Component _panel;
    private static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.panel.replication.replication");
    static final String NEW = "new";
    static final String REFRESH = "refreshagreements";

    private ReplicationResourceObject(IDSModel iDSModel) {
        this("", null, null, iDSModel);
    }

    private ReplicationResourceObject(String string, IDSModel iDSModel) {
        this(string, null, null, iDSModel);
    }

    public ReplicationResourceObject(String string, RemoteImage remoteImage, RemoteImage remoteImage2, IDSModel iDSModel) {
        super(string, remoteImage, remoteImage2, iDSModel);
    }

    public Component getCustomPanel() {
        if (this._panel == null) {
            this._panel = new ReplicationSettingPanel(this._model);
        }
        return this._panel;
    }

    public boolean run(IPage iPage) {
        Debug.println((String)"ReplicationResourceObject: run()");
        this.reload();
        if (super.getChildCount() != 0) {
            this.expandPath((ResourcePage)iPage);
        }
        this.refreshTree();
        return true;
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        return this.run(iPage);
    }

    public void reload() {
        this.cleanTree();
        this._isLeaf = true;
        if (!ReplicationTool.authenticate(this._model)) {
            return;
        }
        this.addReplicaNodes();
    }

    public boolean isLoaded() {
        return this._isLoaded;
    }

    public boolean isLeaf() {
        return this._isLeaf;
    }

    public void select(IPage iPage) {
        if (!this.isLoaded()) {
            this.reload();
        }
        super.select(iPage);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("refresh")) {
            if (!ReplicationTool.authenticate(this._model)) {
                return;
            }
            this.refreshReplicationNode();
        }
    }

    public String[] getMenuCategoryIDs() {
        if (this._categoryID == null) {
            this._categoryID = new String[]{"OBJECT", "CONTEXT"};
        }
        return this._categoryID;
    }

    public IMenuItem[] getMenuItems(String string) {
        if (string.equals("CONTEXT")) {
            if (this._contextMenuItems == null) {
                this._contextMenuItems = this.createMenuItems();
            }
            return this._contextMenuItems;
        }
        if (string.equals("OBJECT")) {
            if (this._objectMenuItems == null) {
                this._objectMenuItems = this.createMenuItems();
            }
            return this._objectMenuItems;
        }
        return null;
    }

    private IMenuItem[] createMenuItems() {
        return new IMenuItem[]{new MenuItemText("refresh", DSUtil._resource.getString("menu", "refresh"), DSUtil._resource.getString("menu", "refresh-description"))};
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        if (iMenuItem.getID().equals("refresh")) {
            ((DSResourceModel)this._model).actionMenuSelected(iPage, iMenuItem);
        }
    }

    public void refreshReplicationNode() {
        this.reload();
        this.refreshTree();
    }

    private void addReplicaNodes() {
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        String string = "LDAP server " + DSUtil.format(lDAPConnection);
        try {
            Vector vector = DSUtil.getLDBMInstanceList(lDAPConnection, true, null);
            int n = 0;
            while (vector != null && n < vector.size()) {
                Vector vector2 = (Vector)vector.elementAt(n);
                LDAPEntry lDAPEntry = (LDAPEntry)vector2.elementAt(0);
                LDAPEntry lDAPEntry2 = (LDAPEntry)vector2.elementAt(1);
                ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)((Object)new ReplicaResourceObject(this._model, this, lDAPEntry, lDAPEntry2)));
                this._isLeaf = false;
                ++n;
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("Error: ReplicationResourceObject.addReplicaNodes: could not get the list of backend instances: detail: " + string + ": " + (Object)((Object)lDAPException)));
        }
        this.refreshTree();
        this._isLoaded = true;
    }

    void refreshTree() {
        this._model.fireTreeStructureChanged(this);
    }

    private void expandPath(ResourcePage resourcePage) {
        TreePath treePath = new TreePath(((DefaultMutableTreeNode)((Object)this)).getPath());
        resourcePage.expandTreePath(treePath);
    }

    private void cleanTree() {
        ((DefaultMutableTreeNode)((Object)this)).removeAllChildren();
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        IResourceObject iResourceObject = (IResourceObject)treeExpansionEvent.getPath().getLastPathComponent();
        if (this.equals(iResourceObject) && !this._isInitiallyExpanded) {
            this._isInitiallyExpanded = true;
            Debug.println((String)"ReplicationResourceObject.treeExpanded: this");
            if (!this.isLoaded()) {
                this.reload();
            }
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }
}

