/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.SimpleProgressDialog;
import com.netscape.admin.dirserv.panel.DatabaseExportPanel;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.admin.dirserv.panel.replication.AgreementTable;
import com.netscape.admin.dirserv.panel.replication.IReplicationAgreement;
import com.netscape.admin.dirserv.panel.replication.MMRAgreement;
import com.netscape.admin.dirserv.panel.replication.ORCTask;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.admin.dirserv.panel.replication.SIRAgreement;
import com.netscape.admin.dirserv.task.LDAPExport;
import com.netscape.admin.dirserv.task.ReadOnly;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.controls.LDAPPersistSearchControl;
import netscape.ldap.util.DN;

public class ReplicationAgreement
implements IReplicationAgreement {
    public static final int AGREEMENT_TYPE_LEGACYR = 1;
    public static final int AGREEMENT_TYPE_MMR = 2;
    protected static final int CLOSE_AGREEMENT = 1;
    protected static final int KEEP_AGREEMENT = 2;
    protected String nickname;
    protected String entryDN;
    protected String origEntryDN;
    protected String entryCN;
    protected String replicatedSubtree;
    protected String supplierHost;
    protected int supplierPort;
    protected String consumerHost;
    protected int consumerPort;
    protected String bindDN;
    protected String bindCredentials;
    protected Vector updateSchedule;
    protected boolean useSSL;
    protected boolean useSSLAuth;
    protected int agreementType;
    protected String orcValue;
    protected Vector selectedAttrs;
    protected int selattrType;
    protected boolean selattrNotRepresentable;
    protected String entryFilter;
    protected boolean filterNotRepresentable;
    protected boolean agreementIsNew;
    protected AgreementTable repList;
    protected String origSupplierHost;
    protected int origSupplierPort;
    protected int origConsumerPort;
    protected String origConsumerHost;
    protected int origSelattrType;
    protected Vector origSelectedAttrs;
    protected String origEntryFilter;
    protected String origReplicatedSubtree;
    protected String machineDataDN;
    protected String _description;
    private boolean needsReORC;
    private ConsoleInfo _serverInfo;
    private Hashtable _status = new Hashtable();
    private static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.panel.replication.replication");

    public ReplicationAgreement(int n) {
        this.agreementType = n;
        this.selattrType = 0;
        this.agreementIsNew = true;
        this.updateSchedule = new Vector();
        this.needsReORC = false;
    }

    public void setServerInfo(ConsoleInfo consoleInfo) {
        this._serverInfo = consoleInfo;
    }

    public ConsoleInfo getServerInfo() {
        return this._serverInfo;
    }

    public void setNickname(String string) {
        this.nickname = string;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setOrigEntryDN(String string) {
        Debug.println((String)("ReplicationAgreement.setOrigEntryDN: " + string));
        this.origEntryDN = string;
    }

    public String getOrigEntryDN() {
        return this.origEntryDN;
    }

    protected void setEntryDN(String string) {
        Debug.println((String)("ReplicationAgreement.setEntryDN: " + string));
        this.entryDN = string;
    }

    public String getEntryDN() {
        return this.entryDN;
    }

    public void setReplicatedSubtree(String string) {
        if (string == null || string.equals(_resource.getString("replication", "misc-rootName"))) {
            this.replicatedSubtree = "";
        } else if (string == null || string.length() == 0) {
            this.replicatedSubtree = null;
        } else {
            DN dN = new DN(string);
            this.replicatedSubtree = dN.toString();
        }
    }

    public String getReplicatedSubtree() {
        return this.replicatedSubtree;
    }

    public void setConsumerHost(String string) {
        this.consumerHost = string;
    }

    public String getConsumerHost() {
        return this.consumerHost;
    }

    public void setConsumerPort(int n) {
        this.consumerPort = n;
    }

    public int getConsumerPort() {
        return this.consumerPort;
    }

    public void setSupplierHost(String string) {
        this.supplierHost = string;
    }

    public String getSupplierHost() {
        return this.supplierHost;
    }

    public void setSupplierPort(int n) {
        this.supplierPort = n;
    }

    public int getSupplierPort() {
        return this.supplierPort;
    }

    public void setRemoteHost(String string) {
        this.consumerHost = string;
    }

    public String getRemoteHost() {
        return this.consumerHost;
    }

    public void setRemotePort(int n) {
        this.consumerPort = n;
    }

    public int getRemotePort() {
        return this.consumerPort;
    }

    public void setBindDN(String string) {
        this.bindDN = string;
    }

    public String getBindDN() {
        return this.bindDN;
    }

    public void setBindCredentials(String string) {
        this.bindCredentials = string;
    }

    public String getBindCredentials() {
        return this.bindCredentials;
    }

    public void setUpdateSchedule(Vector vector) {
        this.updateSchedule = vector;
    }

    public void setUpdateSchedule(String string) {
        this.updateSchedule.removeAllElements();
        this.updateSchedule.addElement(string);
    }

    public void addUpdateSchedule(String string) {
        if (string != null) {
            this.updateSchedule.addElement(string);
        }
    }

    public Vector getUpdateSchedule() {
        return this.updateSchedule;
    }

    public String[] getUpdateScheduleStrings() {
        if (this.updateSchedule == null || this.updateSchedule.isEmpty()) {
            return null;
        }
        String[] stringArray = new String[this.updateSchedule.size()];
        Enumeration enumeration = this.updateSchedule.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public void setUseSSL(String string) {
        Debug.println((int)8, (String)("ReplicationAgreement.useSSL() val = " + string));
        this.useSSL = string.equalsIgnoreCase("true") ? true : (string.equals("1") ? true : string.equals("SSL"));
        Debug.println((int)8, (String)("ReplicationAgreement.useSSL() = " + this.useSSL));
    }

    public void setUseSSL(boolean bl) {
        this.useSSL = bl;
    }

    public boolean getUseSSL() {
        return this.useSSL;
    }

    public void setUseSSLAuth(String string) {
        this.useSSLAuth = string.equalsIgnoreCase("true") ? true : string.equals("SSLCLIENTAUTH");
    }

    public void setUseSSLAuth(boolean bl) {
        this.useSSLAuth = bl;
    }

    public boolean getUseSSLAuth() {
        return this.useSSLAuth;
    }

    public void setAgreementType(int n) {
        this.agreementType = n;
    }

    public int getAgreementType() {
        return this.agreementType;
    }

    public String getEntryCN() {
        return this.entryCN;
    }

    public void setEntryCN(String string) {
        this.entryCN = string;
    }

    public void setEntryFilter(String string) {
        this.entryFilter = string;
    }

    public String getEntryFilter() {
        return this.entryFilter;
    }

    public int getSelattrType() {
        return this.selattrType;
    }

    public void setSelattrType(int n) {
        this.selattrType = n;
    }

    public Vector getSelectedAttributes() {
        return this.selectedAttrs;
    }

    public String getSelectedAttributesString() {
        String string = "";
        if (this.selectedAttrs == null) {
            return string;
        }
        Enumeration enumeration = this.selectedAttrs.elements();
        while (enumeration.hasMoreElements()) {
            string = string + (String)enumeration.nextElement() + "\n";
        }
        return string;
    }

    public void setSelectedAttributes(Vector vector) {
        this.selectedAttrs = vector;
    }

    public void setSelectedAttributes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\t:,", false);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        int n = objectArray.length;
        while (--n >= 0) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                if (((String)objectArray[n2]).toLowerCase().compareTo(((String)objectArray[n2 + 1]).toLowerCase()) > 0) {
                    Object object = objectArray[n2];
                    objectArray[n2] = objectArray[n2 + 1];
                    objectArray[n2 + 1] = object;
                    bl = true;
                }
                ++n2;
            }
        }
        this.selectedAttrs = new Vector(objectArray.length);
        n = 0;
        while (n < objectArray.length) {
            if (n >= objectArray.length - 1 || !((String)objectArray[n]).equalsIgnoreCase((String)objectArray[n + 1])) {
                this.selectedAttrs.addElement(objectArray[n]);
            }
            ++n;
        }
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public String getDescription() {
        return this._description;
    }

    public void setAgreementTable(AgreementTable agreementTable) {
        this.repList = agreementTable;
    }

    public void setORCValue(String string) {
        this.orcValue = string;
    }

    public String getORCValue() {
        return this.orcValue;
    }

    public boolean agreementDNHasChanged() {
        this.computeNewEntryCNandDN();
        boolean bl = !DSUtil.equalDNs(this.origEntryDN, this.entryDN);
        Debug.println((String)("ReplicationAgreement.agreementDNHasChanged: " + this.origEntryDN + (bl ? " <> " : " = ") + this.entryDN));
        return bl;
    }

    protected void computeNewEntryCNandDN() {
        this.entryCN = this.nickname;
        String[] stringArray = LDAPDN.explodeDN((String)this.origEntryDN, (boolean)false);
        this.entryDN = "cn=" + this.entryCN;
        if (stringArray == null || stringArray.length == 0) {
            this.entryDN = null;
        } else {
            int n = 1;
            while (n < stringArray.length) {
                this.entryDN = this.entryDN + ", " + stringArray[n];
                ++n;
            }
        }
    }

    public boolean getAgreementIsNew() {
        return this.agreementIsNew;
    }

    public int writeAgreementToServer() {
        int n = 0;
        if (this.checkForReORC()) {
            Debug.println((String)"ReplicationAgreement.writeAgreementToServer: Consumer needs to be reinitialized");
        }
        switch (this.agreementType) {
            case 2: {
                this.setConsumerHost(ReplicationTool.fullyQualifyHostName(this.getConsumerHost()));
                try {
                    n = ((MMRAgreement)this).writeToServer();
                }
                catch (IOException iOException) {
                    Debug.println((String)("ReplicationAgreement.writeAgreementToServer: Cannot save entry <" + this.entryDN + "> to server: " + iOException));
                }
                break;
            }
            case 1: {
                this.setConsumerHost(ReplicationTool.fullyQualifyHostName(this.getConsumerHost()));
                try {
                    n = ((SIRAgreement)this).writeToServer();
                    break;
                }
                catch (IOException iOException) {
                    Debug.println((String)("ReplicationAgreement.writeAgreementToServer: Cannot save entry <" + this.entryDN + "> to server: " + iOException));
                }
            }
        }
        return n;
    }

    public void deleteAgreementFromServer() throws LDAPException {
        LDAPConnection lDAPConnection = this._serverInfo.getLDAPConnection();
        lDAPConnection.delete(this.origEntryDN);
    }

    public Vector checkForErrors() {
        Vector<Integer> vector = new Vector<Integer>();
        Enumeration enumeration = this.repList.elements();
        String string = ReplicationTool.fullyQualifyHostName(this.getRemoteHost());
        if (string != null) {
            this.setRemoteHost(string);
        }
        while (enumeration.hasMoreElements()) {
            ReplicationAgreement replicationAgreement = (ReplicationAgreement)enumeration.nextElement();
            if (!replicationAgreement.getRemoteHost().equalsIgnoreCase(this.getRemoteHost()) || replicationAgreement.getRemotePort() != this.getRemotePort() || !DSUtil.equalDNs(replicationAgreement.getReplicatedSubtree(), this.getReplicatedSubtree()) || replicationAgreement == this) continue;
            vector.addElement(new Integer(1));
        }
        return vector;
    }

    public void updateNow() {
        LDAPAttribute lDAPAttribute;
        LDAPModificationSet lDAPModificationSet;
        String string;
        Debug.println((String)"ReplicationAgreement.updateNow: begin");
        if (this.agreementType == 1) {
            string = "replicaUpdateSchedule";
        } else if (this.agreementType == 2) {
            string = "nsDS5ReplicaUpdateSchedule";
        } else {
            return;
        }
        try {
            lDAPModificationSet = new LDAPModificationSet();
            lDAPAttribute = new LDAPAttribute(string, "*");
            lDAPModificationSet.add(0, lDAPAttribute);
            this.updateEntry(lDAPModificationSet);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("Unable to add value \"*\" to attribute " + string + ": " + lDAPException.toString()));
        }
        if (this.agreementType == 1) {
            try {
                lDAPModificationSet = new LDAPModificationSet();
                lDAPAttribute = new LDAPAttribute("replicaUpdateReplayed", (String)null);
                lDAPModificationSet.add(2, lDAPAttribute);
                lDAPAttribute = new LDAPAttribute("replicaUpdateFailedAt", (String)null);
                lDAPModificationSet.add(2, lDAPAttribute);
                this.updateEntry(lDAPModificationSet);
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("Unable to remove \"replicaUpdateReplayed\" and \"replicaUpdateFailedAt\" attributes: " + lDAPException.toString()));
            }
        }
        try {
            lDAPModificationSet = new LDAPModificationSet();
            lDAPAttribute = new LDAPAttribute(string, "*");
            lDAPModificationSet.add(1, lDAPAttribute);
            this.updateEntry(lDAPModificationSet);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("Unable to remove value \"*\" from attribute " + string + ": " + lDAPException.toString()));
        }
    }

    public int initializeConsumer() {
        String string = _resource.getString("replication-node-orc", "title");
        String string2 = _resource.getString("replication-node-orc", "description");
        ORCTask oRCTask = new ORCTask(this);
        IDSModel iDSModel = (IDSModel)this._serverInfo.get("dsresmodel");
        SimpleProgressDialog simpleProgressDialog = new SimpleProgressDialog(iDSModel.getFrame(), oRCTask, string, string2);
        oRCTask.setProgressDialog(simpleProgressDialog);
        simpleProgressDialog.setModal(true);
        simpleProgressDialog.setLocationRelativeTo(iDSModel.getFrame());
        simpleProgressDialog.setVisible(true);
        if (oRCTask.getStatus() == 0) {
            if (!simpleProgressDialog.isCancelled()) {
                if (oRCTask.getFirstUpdateStatus() == 0) {
                    if (this.getStatusByKeyword("nsds5BeginReplicaRefresh").equals("start")) {
                        DSUtil.showInformationDialog(iDSModel.getFrame(), "initconsumer-not-finished", null, "replication-agreement", _resource);
                    } else {
                        DSUtil.showInformationDialog(iDSModel.getFrame(), "initconsumer-finished", null, "replication-agreement", _resource);
                    }
                } else {
                    String[] stringArray = new String[]{oRCTask.getFirstUpdateMessage()};
                    if (this.getStatusByKeyword("nsds5BeginReplicaRefresh").equals("start")) {
                        DSUtil.showErrorDialog((Component)iDSModel.getFrame(), "initconsumer-error-not-finished", stringArray, "replication-agreement", _resource);
                    } else {
                        DSUtil.showErrorDialog((Component)iDSModel.getFrame(), "initconsumer-error-finished", stringArray, "replication-agreement", _resource);
                    }
                }
            }
        } else if (!simpleProgressDialog.isCancelled()) {
            String string3 = LDAPException.errorCodeToString((int)oRCTask.getStatus());
            String string4 = oRCTask.getFirstUpdateMessage();
            if (string4 != null && string4.length() > 0) {
                string3 = string3 + ". " + string4;
            }
            String[] stringArray = new String[]{string3};
            DSUtil.showErrorDialog((Component)iDSModel.getFrame(), "initconsumer-local-error", stringArray, "replication-agreement", _resource);
        } else {
            String string5 = LDAPException.errorCodeToString((int)oRCTask.getStatus());
            String string6 = oRCTask.getFirstUpdateMessage();
            if (string6 != null && string6.length() > 0) {
                string5 = string5 + ". " + string6;
            }
            String[] stringArray = new String[]{string5};
            DSUtil.showErrorDialog((Component)iDSModel.getFrame(), "initconsumer-stop-local-error", stringArray, "replication-agreement", _resource);
        }
        return oRCTask.getStatus();
    }

    public boolean populateLDIFFile(String string) {
        Object object;
        int n;
        File file = new File(string);
        if (DSUtil.fileExists(file) && (n = DSUtil.showConfirmationDialog((Component)(object = UtilConsoleGlobals.getActivatedFrame()), "confirm-delete-export-file", DSUtil.inverseAbreviateString(string, 30), "export")) != 0) {
            return false;
        }
        object = this.getDataVersion();
        LDAPConnection lDAPConnection = this._serverInfo.getLDAPConnection();
        boolean bl = false;
        boolean bl2 = false;
        String string2 = MappingUtils.getBackendForSuffix(this._serverInfo.getLDAPConnection(), this.replicatedSubtree);
        if (string2 == null) {
            return false;
        }
        String string3 = "cn=" + string2 + "," + "cn=ldbm database,cn=plugins,cn=config";
        try {
            bl2 = ReadOnly.isReadOnly(this._serverInfo, string3);
            bl = true;
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("ReplicationAgreement.populateLDIFFile() (1) " + (Object)((Object)lDAPException)));
        }
        if (bl && !bl2) {
            bl = ReadOnly.setReadOnly(this._serverInfo, true, string3);
        }
        if (bl) {
            Hashtable<String, LDAPAttribute> hashtable = new Hashtable<String, LDAPAttribute>();
            hashtable.put("nsFilename", new LDAPAttribute("nsFilename", string));
            hashtable.put("nsUseOneFile", new LDAPAttribute("nsUseOneFile", "TRUE"));
            hashtable.put("nsInstance", new LDAPAttribute("nsInstance", string2));
            hashtable.put("nsExportReplica", new LDAPAttribute("nsExportReplica", "TRUE"));
            IDSModel iDSModel = (IDSModel)this._serverInfo.get("dsresmodel");
            LDAPExport lDAPExport = new LDAPExport(iDSModel, hashtable);
        }
        if (!bl2) {
            ReadOnly.setReadOnly(this._serverInfo, false, string3);
        }
        return bl;
    }

    public boolean populateLDIFFile(IDSModel iDSModel) {
        String string = this.getDataVersion();
        LDAPConnection lDAPConnection = iDSModel.getServerInfo().getLDAPConnection();
        boolean bl = false;
        boolean bl2 = false;
        String string2 = MappingUtils.getBackendForSuffix(lDAPConnection, this.replicatedSubtree);
        if (string2 == null) {
            return false;
        }
        String string3 = "cn=" + string2 + "," + "cn=ldbm database,cn=plugins,cn=config";
        try {
            bl2 = ReadOnly.isReadOnly(iDSModel.getServerInfo(), string3);
            bl = true;
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("ReplicationAgreement.populateLDIFFile() (1) " + (Object)((Object)lDAPException)));
        }
        if (bl && !bl2) {
            bl = ReadOnly.setReadOnly(iDSModel.getServerInfo(), true, string3);
        }
        if (bl) {
            DatabaseExportPanel databaseExportPanel = new DatabaseExportPanel(iDSModel, string2, true);
            String[] stringArray = new String[]{string2};
            String string4 = _resource.getString("replication-export", "title", stringArray);
            SimpleDialog simpleDialog = new SimpleDialog(iDSModel.getFrame(), string4, 11, databaseExportPanel);
            simpleDialog.setComponent(databaseExportPanel);
            simpleDialog.setOKButtonEnabled(false);
            simpleDialog.setDefaultButton(1);
            simpleDialog.packAndShow();
        }
        if (!bl2) {
            ReadOnly.setReadOnly(iDSModel.getServerInfo(), false, string3);
        }
        return bl;
    }

    void waitForORCCompletion(String string) throws LDAPException {
        boolean bl = false;
        Object var3_3 = null;
        String string2 = "objectclass=*";
        LDAPConnection lDAPConnection = this._serverInfo.getLDAPConnection();
        LDAPConnection lDAPConnection2 = (LDAPConnection)lDAPConnection.clone();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection2.getSearchConstraints();
        String[] stringArray = new String[]{string};
        lDAPSearchConstraints.setBatchSize(1);
        LDAPPersistSearchControl lDAPPersistSearchControl = new LDAPPersistSearchControl(4, false, false, false);
        lDAPSearchConstraints.setServerControls((LDAPControl)lDAPPersistSearchControl);
        LDAPSearchResults lDAPSearchResults = lDAPConnection2.search(this.entryDN, 0, string2, stringArray, false, lDAPSearchConstraints);
        while (!bl && lDAPSearchResults.hasMoreElements()) {
            LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
            String string3 = DSUtil.getAttrValue(lDAPEntry, string);
            if (string3.equalsIgnoreCase("start")) continue;
            bl = true;
        }
        lDAPConnection2.abandon(lDAPSearchResults);
        lDAPConnection2.disconnect();
    }

    public static String getCopiedFrom(LDAPConnection lDAPConnection, String string) {
        String[] stringArray = new String[]{"copiedFrom"};
        String string2 = null;
        try {
            LDAPAttribute lDAPAttribute;
            LDAPEntry lDAPEntry = lDAPConnection.read(string, stringArray);
            if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute("copiedFrom")) != null) {
                Enumeration enumeration = lDAPAttribute.getStringValues();
                string2 = (String)enumeration.nextElement();
            }
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        return string2;
    }

    public boolean checkForReORC() {
        Debug.print((String)"ReplicationAgreement.checkforReOrc: ");
        if (this.agreementIsNew) {
            this.needsReORC = false;
            Debug.println((String)"agreement is new");
            return this.needsReORC;
        }
        Debug.println((String)(this.replicatedSubtree + " " + this.origReplicatedSubtree));
        if (!this.stringsEqualIgnoreCase(this.replicatedSubtree, this.origReplicatedSubtree)) {
            Debug.println((String)"replicatedSubtree changed");
            this.needsReORC = true;
        }
        if (this.consumerPort != this.origConsumerPort) {
            Debug.println((String)"consumerPort changed");
            this.needsReORC = true;
        }
        if (!this.stringsEqualIgnoreCase(this.consumerHost, this.origConsumerHost)) {
            Debug.println((String)"consumerHost changed");
            this.needsReORC = true;
        }
        if (!this.stringsEqualIgnoreCase(this.entryFilter, this.origEntryFilter)) {
            Debug.println((String)"entryFilter changed");
            this.needsReORC = true;
        }
        if (this.selattrType != this.origSelattrType) {
            Debug.println((String)("selattrType: (" + this.selattrType + ") != (" + this.origSelattrType + ")"));
            this.needsReORC = true;
        }
        if (this.selectedAttrs == null) {
            if (this.origSelectedAttrs != null) {
                Debug.println((String)"selectedAttrs changed");
                this.needsReORC = true;
            }
        } else if (this.origSelectedAttrs == null) {
            Debug.println((String)"selectedAttrs changed");
            this.needsReORC = true;
        } else if (this.selectedAttrs.size() != this.origSelectedAttrs.size()) {
            Debug.println((String)"selectedAttrs changed");
            this.needsReORC = true;
        } else {
            int n = this.selectedAttrs.size();
            int n2 = 0;
            while (n2 < n && !this.needsReORC) {
                String string;
                String string2 = (String)this.selectedAttrs.elementAt(n2);
                if (!string2.equalsIgnoreCase(string = (String)this.origSelectedAttrs.elementAt(n2))) {
                    Debug.println((String)"selectedAttrs changed");
                    this.needsReORC = true;
                }
                ++n2;
            }
        }
        if (!this.needsReORC) {
            Debug.println((String)"no changes");
        }
        return this.needsReORC;
    }

    public void updateAgreementFromServer() {
        LDAPConnection lDAPConnection = this._serverInfo.getLDAPConnection();
        if (lDAPConnection == null) {
            return;
        }
        LDAPEntry lDAPEntry = null;
        try {
            lDAPEntry = lDAPConnection.read(this.getEntryDN());
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("ReplicationAgreement.updateAgreementFromServer() " + (Object)((Object)lDAPException)));
        }
        if (lDAPEntry == null) {
            return;
        }
        this._status.clear();
        String string = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaLastUpdateStatus");
        if (string != null && string.length() > 0) {
            this._status.put("nsds5replicaLastUpdateStatus", string);
        } else {
            Debug.println((String)("ReplicationAgreement.updateAgreementFromServer: unable to read the replica status from " + DSUtil.format(lDAPConnection)));
        }
        string = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaChangesSentSinceStartup");
        if (string != null && string.length() > 0) {
            this._status.put("nsds5replicaChangesSentSinceStartup", string);
        } else {
            Debug.println((String)("ReplicationAgreement.updateAgreementFromServer: unable to read the replica number of changes from " + DSUtil.format(lDAPConnection)));
        }
        string = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaLastUpdateStart");
        if (string != null && string.length() > 0) {
            this._status.put("nsds5replicaLastUpdateStart", string);
        } else {
            Debug.println((String)("ReplicationAgreement.updateAgreementFromServer: unable to read the replica last update start from " + DSUtil.format(lDAPConnection)));
        }
        string = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaLastUpdateEnd");
        if (string != null && string.length() > 0) {
            this._status.put("nsds5replicaLastUpdateEnd", string);
        } else {
            Debug.println((String)("ReplicationAgreement.updateAgreementFromServer: unable to read the replica last update end from " + DSUtil.format(lDAPConnection)));
        }
        string = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaUpdateInProgress");
        if (string != null && string.length() > 0) {
            this._status.put("nsds5replicaUpdateInProgress", string);
        } else {
            Debug.println((String)("ReplicationAgreement.updateAgreementFromServer: unable to read the replica in progress from " + DSUtil.format(lDAPConnection)));
        }
        string = DSUtil.getAttrValue(lDAPEntry, "nsds5BeginReplicaRefresh");
        if (string != null && string.length() > 0) {
            this._status.put("nsds5BeginReplicaRefresh", string);
        } else {
            Debug.println((String)("ReplicationAgreement.updateAgreementFromServer: unable to read the replica refresh attribute " + DSUtil.format(lDAPConnection)));
        }
        string = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaLastInitStart");
        if (string != null && string.length() > 0) {
            this._status.put("nsds5replicaLastInitStart", string);
        } else {
            Debug.println((String)("ReplicationAgreement.updateAgreementFromServer: unable to read the consumer initialization begin attribute (nsds5replicaLastInitStart) " + DSUtil.format(lDAPConnection)));
        }
        string = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaLastInitEnd");
        if (string != null && string.length() > 0) {
            this._status.put("nsds5replicaLastInitEnd", string);
        } else {
            Debug.println((String)("ReplicationAgreement.updateAgreementFromServer: unable to read the consumer initialization end attribute (nsds5replicaLastInitEnd) " + DSUtil.format(lDAPConnection)));
        }
        string = DSUtil.getAttrValue(lDAPEntry, "nsds5replicalastinitstatus");
        if (string != null && string.length() > 0) {
            this._status.put("nsds5replicalastinitstatus", string);
        } else {
            Debug.println((String)("ReplicationAgreement.updateAgreementFromServer: unable to read the consumer initialization status attribute (nsds5replicalastinitstatus) " + DSUtil.format(lDAPConnection)));
        }
        this._description = this.nickname = DSUtil.getAttrValue(lDAPEntry, "description");
        this.entryCN = DSUtil.getAttrValue(lDAPEntry, "cn");
        this.origReplicatedSubtree = this.replicatedSubtree = DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaRoot");
        String string2 = DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaPort");
        try {
            int n;
            this.origConsumerPort = this.consumerPort = (n = Integer.parseInt(string2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.consumerHost = DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaHost");
        this.supplierHost = lDAPConnection.getHost();
        this.origSupplierHost = this.origSupplierHost;
        this.origSupplierPort = this.supplierPort = lDAPConnection.getPort();
        this.bindDN = DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaBindDN");
        this.bindCredentials = DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaCredentials");
        this.setUseSSL(DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaTransportInfo"));
        this.setUseSSLAuth(DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaBindMethod"));
        String[] stringArray = DSUtil.getAttrValues(lDAPEntry, "nsDS5ReplicaUpdateSchedule");
        Vector<String> vector = new Vector<String>();
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
        } else {
            vector.addElement(new String(""));
        }
        this.setUpdateSchedule(vector);
    }

    public void updateReplicaStatus() {
        LDAPConnection lDAPConnection = this._serverInfo.getLDAPConnection();
        if (lDAPConnection == null) {
            return;
        }
        LDAPEntry lDAPEntry = null;
        this._status.clear();
        try {
            lDAPEntry = lDAPConnection.read(this.getEntryDN(), ReplicationTool.REPLICA_STATUS_ATTRS);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("ReplicationAgreement.updateReplicaStatus: " + lDAPException.toString()));
            Debug.println((String)("ReplicationAgreement.updateReplicaStatus: unable to read the replication status from DN " + this.getEntryDN() + ": " + DSUtil.format(lDAPConnection)));
            return;
        }
        String string = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaLastUpdateStatus");
        if (string != null && string.length() > 0) {
            this._status.put("nsds5replicaLastUpdateStatus", string);
        } else {
            Debug.println((String)("ReplicationAgreement.updateReplicaStatus: unable to read the replica status from " + DSUtil.format(lDAPConnection)));
        }
        string = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaChangesSentSinceStartup");
        if (string != null && string.length() > 0) {
            this._status.put("nsds5replicaChangesSentSinceStartup", string);
        } else {
            Debug.println((String)("ReplicationAgreement.updateReplicaStatus: unable to read the replica number of changes from " + DSUtil.format(lDAPConnection)));
        }
        string = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaLastUpdateStart");
        if (string != null && string.length() > 0) {
            this._status.put("nsds5replicaLastUpdateStart", string);
        } else {
            Debug.println((String)("ReplicationAgreement.updateReplicaStatus: unable to read the replica last update start from " + DSUtil.format(lDAPConnection)));
        }
        string = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaLastUpdateEnd");
        if (string != null && string.length() > 0) {
            this._status.put("nsds5replicaLastUpdateEnd", string);
        } else {
            Debug.println((String)("ReplicationAgreement.updateReplicaStatus: unable to read the replica last update end from " + DSUtil.format(lDAPConnection)));
        }
        string = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaUpdateInProgress");
        if (string != null && string.length() > 0) {
            this._status.put("nsds5replicaUpdateInProgress", string);
        } else {
            Debug.println((String)("ReplicationAgreement.updateReplicaStatus: unable to read the replica in progress from " + DSUtil.format(lDAPConnection)));
        }
        string = DSUtil.getAttrValue(lDAPEntry, "nsds5BeginReplicaRefresh");
        if (string != null && string.length() > 0) {
            this._status.put("nsds5BeginReplicaRefresh", string);
        } else {
            Debug.println((String)("ReplicationAgreement.updateReplicaStatus: unable to read the replica refresh attribute " + DSUtil.format(lDAPConnection)));
        }
        string = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaLastInitStart");
        if (string != null && string.length() > 0) {
            this._status.put("nsds5replicaLastInitStart", string);
        } else {
            Debug.println((String)("ReplicationAgreement.updateReplicaStatus: unable to read the consumer initialization begin attribute (nsds5replicaLastInitStart) " + DSUtil.format(lDAPConnection)));
        }
        string = DSUtil.getAttrValue(lDAPEntry, "nsds5replicaLastInitEnd");
        if (string != null && string.length() > 0) {
            this._status.put("nsds5replicaLastInitEnd", string);
        } else {
            Debug.println((String)("ReplicationAgreement.updateReplicaStatus: unable to read the consumer initialization end attribute (nsds5replicaLastInitEnd) " + DSUtil.format(lDAPConnection)));
        }
        string = DSUtil.getAttrValue(lDAPEntry, "nsds5replicalastinitstatus");
        if (string != null && string.length() > 0) {
            this._status.put("nsds5replicalastinitstatus", string);
        } else {
            Debug.println((String)("ReplicationAgreement.updateReplicaStatus: unable to read the consumer initialization status attribute (nsds5replicalastinitstatus) " + DSUtil.format(lDAPConnection)));
        }
    }

    private String getStatusByKeyword(String string) {
        if (this._status != null && this._status.containsKey(string)) {
            return this._status.get(string).toString();
        }
        return _resource.getString("replication-info-status-code", "unknown");
    }

    public String getLastUpdateStatus() {
        return this.getStatusByKeyword("nsds5replicaLastUpdateStatus");
    }

    public String getInProgress() {
        return this.getStatusByKeyword("nsds5replicaUpdateInProgress");
    }

    public String getNChangesLast() {
        return this.getStatusByKeyword("nsds5replicaChangesSentSinceStartup");
    }

    public String getLastUpdateBegin() {
        String string = this.getStatusByKeyword("nsds5replicaLastUpdateStart");
        if (string.equals("0")) {
            return _resource.getString("replication-agreement", "lastupdatebegin-unknown-value");
        }
        Date date = DSUtil.getDateTime(string);
        return date.toString();
    }

    public String getLastUpdateEnd() {
        String string = this.getStatusByKeyword("nsds5replicaLastUpdateEnd");
        if (string.equals("0")) {
            return _resource.getString("replication-agreement", "lastupdateend-unknown-value");
        }
        Date date = DSUtil.getDateTime(string);
        return date.toString();
    }

    public String getConsumerInitializationBegin() {
        String string = this.getStatusByKeyword("nsds5replicaLastInitStart");
        if (string.equals(_resource.getString("replication-info-status-code", "unknown")) || string.equals("0")) {
            return _resource.getString("replication-agreement", "initconsumer-begin-unknown-value");
        }
        Date date = DSUtil.getDateTime(string);
        return date.toString();
    }

    public String getConsumerInitializationEnd() {
        String string = this.getStatusByKeyword("nsds5replicaLastInitEnd");
        if (string.equals(_resource.getString("replication-info-status-code", "unknown")) || string.equals("0")) {
            return _resource.getString("replication-agreement", "initconsumer-end-unknown-value");
        }
        Date date = DSUtil.getDateTime(string);
        return date.toString();
    }

    public String getConsumerInitializationStatus() {
        String string = this.getStatusByKeyword("nsds5replicalastinitstatus");
        return string;
    }

    public String getConsumerInitializationInProgress() {
        String string = this.getStatusByKeyword("nsds5BeginReplicaRefresh");
        if (string == null || !string.equals("start")) {
            return _resource.getString("replication-agreement", "initconsumer-inprogress-false-value");
        }
        return _resource.getString("replication-agreement", "initconsumer-inprogress-true-value");
    }

    protected void parseReplAttrList(LDAPAttribute lDAPAttribute) {
        boolean bl = false;
        if (lDAPAttribute.size() == 0) {
            this.selattrType = 0;
            return;
        }
        if (lDAPAttribute.size() > 2) {
            this.selattrNotRepresentable = true;
            this.selattrType = 0;
            return;
        }
        String string = (String)lDAPAttribute.getStringValues().nextElement();
        if (string == null || string.length() == 0) {
            this.selectedAttrs = null;
            this.selattrType = 0;
        } else {
            String string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "$", false);
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken().trim();
                if (!"(objectclass=*)".equalsIgnoreCase(string2)) {
                    this.selattrNotRepresentable = true;
                    return;
                }
            } else {
                this.selattrNotRepresentable = true;
                return;
            }
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                string2.trim();
                stringTokenizer = new StringTokenizer(string2, " ", false);
                if (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    this.selattrType = "include".equalsIgnoreCase(string3) ? 1 : ("exclude".equalsIgnoreCase(string3) ? 2 : 0);
                    String string4 = "";
                    while (stringTokenizer.hasMoreTokens()) {
                        string4 = string4 + stringTokenizer.nextToken() + " ";
                    }
                    this.setSelectedAttributes(string4);
                    bl = true;
                }
            }
            if (!bl) {
                this.selattrNotRepresentable = true;
            }
        }
    }

    protected String createReplicatedAttributesList() {
        if (this.selectedAttrs == null || this.selectedAttrs.size() == 0) {
            return null;
        }
        String string = "(objectclass=*) $ ";
        if (this.selattrType == 1) {
            string = string + "INCLUDE";
        } else if (this.selattrType == 2) {
            string = string + "EXCLUDE";
        } else {
            return null;
        }
        Enumeration enumeration = this.selectedAttrs.elements();
        while (enumeration.hasMoreElements()) {
            string = string + " " + (String)enumeration.nextElement();
        }
        return string;
    }

    void updateEntry(LDAPModificationSet lDAPModificationSet) throws LDAPException {
        if (lDAPModificationSet == null) {
            return;
        }
        this.modsDump(lDAPModificationSet);
        LDAPConnection lDAPConnection = this._serverInfo.getLDAPConnection();
        Debug.println((String)("Replication.updateEntry: " + this.entryDN));
        lDAPConnection.modify(this.entryDN, lDAPModificationSet);
    }

    protected void createNewEntry(LDAPEntry lDAPEntry) throws LDAPException {
        if (lDAPEntry == null) {
            return;
        }
        LDAPConnection lDAPConnection = this._serverInfo.getLDAPConnection();
        Debug.println((String)("Replication.createNewEntry: " + lDAPEntry.getDN()));
        lDAPConnection.add(lDAPEntry);
    }

    protected void deleteOldEntry() throws LDAPException {
        LDAPConnection lDAPConnection = this._serverInfo.getLDAPConnection();
        Debug.println((String)("Replication.deleteOldEntry: " + this.getOrigEntryDN()));
        lDAPConnection.delete(this.getOrigEntryDN());
    }

    protected void disconnect(LDAPConnection lDAPConnection) {
        if (lDAPConnection != null) {
            try {
                lDAPConnection.disconnect();
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
        }
    }

    private boolean isSpecialNamingContext(String string) {
        return false;
    }

    private boolean stringsEqualIgnoreCase(String string, String string2) {
        boolean bl = false;
        bl = string == null ? string2 == null : (string2 == null ? false : (string.length() != string2.length() ? false : string.equalsIgnoreCase(string2)));
        return bl;
    }

    private static String timeToString(String string) {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.set(Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(4, 6)) - 1, Integer.parseInt(string.substring(6, 8)), Integer.parseInt(string.substring(8, 10)), Integer.parseInt(string.substring(10, 12)), Integer.parseInt(string.substring(12, 14)));
        }
        catch (NumberFormatException numberFormatException) {
            return " ";
        }
        Date date = calendar.getTime();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 2);
        return dateFormat.format(date);
    }

    public String toString() {
        String string = "";
        string = string + "Type: ";
        string = this.agreementType == 2 ? string + "Multi Master" : (this.agreementType == 1 ? string + "Legacy" : string + "(unknown)");
        string = string + "\n";
        string = string + "Host: " + this.getRemoteHost() + "\n";
        string = string + "Port: " + this.getRemotePort() + "\n";
        string = string + "Subtree: " + this.replicatedSubtree;
        return string;
    }

    private void modsDump(LDAPModificationSet lDAPModificationSet) {
        Debug.println((String)"ReplicationAgreement.modsDump:");
        if (lDAPModificationSet == null) {
            Debug.println((String)"  null");
        } else {
            int n = 0;
            while (n < lDAPModificationSet.size()) {
                LDAPModification lDAPModification = lDAPModificationSet.elementAt(n);
                int n2 = lDAPModification.getOp();
                switch (n2) {
                    case 0: {
                        Debug.print((String)"add");
                        break;
                    }
                    case 1: {
                        Debug.print((String)"delete");
                        break;
                    }
                    case 2: {
                        Debug.print((String)"replace");
                        break;
                    }
                    default: {
                        Debug.print((String)("unknown op (" + n2 + "): "));
                    }
                }
                Debug.print((String)": ");
                LDAPAttribute lDAPAttribute = lDAPModification.getAttribute();
                Debug.println((String)lDAPAttribute.getName());
                Enumeration enumeration = lDAPAttribute.getStringValues();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    Debug.println((String)(lDAPAttribute.getName() + ": " + (String)enumeration.nextElement()));
                }
                Debug.println((String)"-");
                ++n;
            }
        }
    }

    private String getDataVersion() {
        String string = "cn=monitor";
        String string2 = "objectclass=*";
        String[] stringArray = new String[]{"dataversion"};
        LDAPConnection lDAPConnection = this._serverInfo.getLDAPConnection();
        try {
            LDAPAttribute lDAPAttribute;
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 0, string2, stringArray, false);
            LDAPEntry lDAPEntry = lDAPSearchResults.next();
            if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute(stringArray[0])) != null) {
                Enumeration enumeration = lDAPAttribute.getStringValues();
                String string3 = (String)enumeration.nextElement();
                Debug.println((String)("ReplicationAgreement.getDataversion: " + string3));
                return string3;
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("ReplicationAgreement.getDataversion: " + (Object)((Object)lDAPException)));
        }
        return "";
    }
}

