/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSContentListener;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.node.DataRootResourceObject;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.LDAPUrlDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.tree.TreeNode;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;

public class ReplicaSettingPanel
extends BlankPanel {
    private JButton _bAddBindDN = null;
    private JButton _bDeleteBindDN = null;
    private JButton _bConstructReferral = null;
    private JButton _bAddReferral = null;
    private JButton _bDeleteReferral = null;
    private JCheckBox _cbReplicaEnabled = null;
    private JCheckBox _cbPurgeDelayNever = null;
    private JCheckBox _cb4xConsumer = null;
    private JRadioButton _rbIsSimpleMaster = null;
    private JRadioButton _rbIsSlave = null;
    private JRadioButton _rbIsHub = null;
    private JRadioButton _rbIsMultiMaster = null;
    private GroupPanel _replicaTypePanel = null;
    private GroupPanel _commonAttributePanel = null;
    private GroupPanel _consumerPanel = null;
    private JTextField _tfReplicaID = null;
    private JTextField _tfPurgeDelay = null;
    private JTextField _tfNewBindDN = null;
    private JTextField _tfNewReferral = null;
    private JComboBox _cboPurgeUnit = null;
    private JList _bindDNList = null;
    private JList _referralList = null;
    private DefaultListModel _bindDNListData = null;
    private DefaultListModel _referralListData = null;
    private boolean _saveDS5ReplicaTypeExist = false;
    private boolean _saveReplicaIDExist = false;
    private boolean _saveBindDNExist = false;
    private boolean _saveReferralListExist = false;
    private boolean _savePurgeDelayExist = false;
    private boolean _saveDS5FlagsExist = false;
    private boolean _saveDS5ReplicaLegacyConsumerExist = false;
    private JLabel _lBindDNList = null;
    private JLabel _lReferralList = null;
    private JLabel _lPurgeDelay = null;
    private JLabel _lReplicaID = null;
    private JTextArea _lReplicaIDWarning = null;
    private boolean _saveIsSimpleMaster = false;
    private boolean _saveIsSlave = false;
    private boolean _saveIsMultiMaster = false;
    private boolean _saveIsHub = false;
    private boolean _saveReadOnly = false;
    private boolean _saveReplicaEnabled = false;
    private boolean _saveDS5Flags = false;
    private boolean _save4xConsumer = false;
    private int _saveReplicaID = 0;
    private String _savePurgeDelay = "";
    private Vector _saveBindDNList = new Vector();
    private Vector _saveReferralList = new Vector();
    private IDSModel _model;
    private IDSContentListener _idscListener;
    private LDAPEntry _instEntry;
    private LDAPEntry _mapTreeEntry;
    private String _repSettingDN;
    private static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.panel.replication.replication");
    private static final String _section = "replication-replica";
    private static final String REP_TYPE_READONLY = "2";
    private static final String REP_TYPE_UPDATEABLE = "3";
    private static final String REP_FLAG_NONE = "0";
    private static final String REP_FLAG_LOG_CHANGES = "1";
    private static final int READ_ONLY_REPLICA_ID = 65535;
    static final int DEFAULT_PADDING = 6;
    static final int REFERRAL_LIST_ROWS = 3;
    static final int BIND_DN_LIST_ROWS = 3;
    int[] CONVERSION_VALUES = new int[]{86400, 3600, 60, 1};

    public ReplicaSettingPanel(IDSModel iDSModel, IDSContentListener iDSContentListener, LDAPEntry lDAPEntry, LDAPEntry lDAPEntry2, LDAPEntry lDAPEntry3) {
        super(iDSModel, "replication");
        this.setTitle(_resource.getString("replication-replica-setting", "title"));
        this._model = iDSModel;
        this._helpToken = "configuration-replication-replicasettings-help";
        this._instEntry = lDAPEntry;
        this._mapTreeEntry = lDAPEntry2;
        if (lDAPEntry3 != null) {
            this._repSettingDN = lDAPEntry3.getDN();
        }
        this._idscListener = iDSContentListener;
        this._refreshWhenSelect = false;
    }

    public void init() {
        if (this._isInitialized) {
            return;
        }
        this._myPanel.setLayout(new GridBagLayout());
        this.createEnableReplicaArea(this._myPanel);
        this.createReplicaTypeArea(this._myPanel);
        this.createCommonAttributeArea(this._myPanel);
        this.createConsumerArea(this._myPanel);
        this.addBottomGlue();
        this.populateData();
        this._isInitialized = true;
        this.checkFields();
        this.checkEnablingState();
    }

    private void createEnableReplicaArea(Container container) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = (Insets)ReplicationTool.BOTTOM_INSETS.clone();
        this._cbReplicaEnabled = this.makeJCheckBox(_section, "enable", true, _resource);
        this._cbReplicaEnabled.setToolTipText(_resource.getString("replication-replica-enable", "ttip"));
        container.add((Component)this._cbReplicaEnabled, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        container.add(Box.createHorizontalGlue(), gridBagConstraints);
    }

    private void createReplicaTypeArea(Container container) {
        this._replicaTypePanel = new GroupPanel(_resource.getString(_section, "type-label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        container.add((Component)this._replicaTypePanel, gridBagConstraints);
        this._rbIsSimpleMaster = this.makeJRadioButton(_section, "simplemaster", false, _resource);
        this._rbIsSimpleMaster.setToolTipText(_resource.getString("replication-replica-simplemaster", "ttip"));
        this._rbIsSlave = this.makeJRadioButton(_section, "slave", true, _resource);
        this._rbIsSlave.setToolTipText(_resource.getString("replication-replica-slave", "ttip"));
        this._rbIsHub = this.makeJRadioButton(_section, "hub", false, _resource);
        this._rbIsHub.setToolTipText(_resource.getString("replication-replica-hub", "ttip"));
        this._rbIsMultiMaster = this.makeJRadioButton(_section, "multimaster", false, _resource);
        this._rbIsMultiMaster.setToolTipText(_resource.getString("replication-replica-multimaster", "ttip"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rbIsSimpleMaster);
        buttonGroup.add(this._rbIsMultiMaster);
        buttonGroup.add(this._rbIsHub);
        buttonGroup.add(this._rbIsSlave);
        gridBagConstraints.insets = (Insets)ReplicationTool.DEFAULT_INSETS.clone();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = -1;
        this._replicaTypePanel.add((Component)this._rbIsSimpleMaster, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this._replicaTypePanel.add((Component)this._rbIsMultiMaster, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        this._replicaTypePanel.add((Component)this._rbIsHub, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this._replicaTypePanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        this._replicaTypePanel.add((Component)this._rbIsSlave, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this._replicaTypePanel.add(Box.createHorizontalGlue(), gridBagConstraints);
    }

    private void createCommonAttributeArea(Container container) {
        this._commonAttributePanel = new GroupPanel(_resource.getString(_section, "common-panel-label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        container.add((Component)this._commonAttributePanel, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 0;
        this._commonAttributePanel.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 0;
        this._commonAttributePanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 0;
        this._commonAttributePanel.add((Component)jPanel3, gridBagConstraints);
        this._lReplicaID = this.makeJLabel(_section, "replicaid", _resource);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = (Insets)ReplicationTool.DEFAULT_INSETS.clone();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this._lReplicaID, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        this._tfReplicaID = this.makeNumericalJTextField(_section, "replicaid", _resource);
        this._lReplicaID.setLabelFor(this._tfReplicaID);
        this._tfReplicaID.getDocument().addDocumentListener(this);
        jPanel.add((Component)this._tfReplicaID, gridBagConstraints);
        this._lReplicaIDWarning = this.makeMultiLineLabel(2, 40, _resource.getString(_section, "replicaid-warning-label"));
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this._lReplicaIDWarning, gridBagConstraints);
        this._lPurgeDelay = this.makeJLabel(_section, "purgedelay", _resource);
        this._lPurgeDelay.setToolTipText(_resource.getString("replication-replica-purgedelay", "ttip"));
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this._lPurgeDelay, gridBagConstraints);
        this._tfPurgeDelay = this.makeNumericalJTextField(_section, "purgedelay", _resource);
        this._lPurgeDelay.setLabelFor(this._tfPurgeDelay);
        this._tfPurgeDelay.getDocument().addDocumentListener(this);
        --gridBagConstraints.gridwidth;
        jPanel2.add((Component)this._tfPurgeDelay, gridBagConstraints);
        this._cboPurgeUnit = this.makeJComboBox();
        this._lPurgeDelay.setLabelFor(this._cboPurgeUnit);
        this._cboPurgeUnit.addItem(_resource.getString("replication-replica-purgedelay", "days"));
        this._cboPurgeUnit.addItem(_resource.getString("replication-replica-purgedelay", "hours"));
        this._cboPurgeUnit.addItem(_resource.getString("replication-replica-purgedelay", "minutes"));
        this._cboPurgeUnit.addItem(_resource.getString("replication-replica-purgedelay", "seconds"));
        --gridBagConstraints.gridwidth;
        jPanel2.add((Component)this._cboPurgeUnit, gridBagConstraints);
        this._cbPurgeDelayNever = this.makeJCheckBox(_section, "purgedelay-never", true, _resource);
        this._cbPurgeDelayNever.setToolTipText(_resource.getString("replication-replica-purgedelay-never", "ttip"));
        gridBagConstraints.gridwidth = -1;
        jPanel2.add((Component)this._cbPurgeDelayNever, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(Box.createHorizontalGlue(), gridBagConstraints);
        this._cb4xConsumer = this.makeJCheckBox(_section, "4xcompatible", false, _resource);
        this._cb4xConsumer.setToolTipText(_resource.getString("replication-replica-4xcompatible", "ttip"));
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 18;
        jPanel3.add((Component)this._cb4xConsumer, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel3.add(Box.createHorizontalGlue(), gridBagConstraints);
    }

    private void createConsumerArea(Container container) {
        this._consumerPanel = new GroupPanel(_resource.getString(_section, "consumer-panel-label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        container.add((Component)this._consumerPanel, gridBagConstraints);
        gridBagConstraints.insets = (Insets)ReplicationTool.DEFAULT_INSETS.clone();
        gridBagConstraints.insets.bottom = 0;
        int n = gridBagConstraints.insets.right;
        int n2 = gridBagConstraints.insets.left;
        int n3 = gridBagConstraints.insets.top;
        this._lBindDNList = new JLabel(_resource.getString(_section, "bindDNlistlabel-label"));
        gridBagConstraints.weightx = 0.0;
        this._consumerPanel.add((Component)this._lBindDNList, gridBagConstraints);
        this._bindDNListData = new DefaultListModel();
        this._bindDNList = new JList(this._bindDNListData);
        this._lBindDNList.setLabelFor(this._bindDNList);
        this._bindDNList.setVisibleRowCount(3);
        this._bindDNList.setCellRenderer(new BindDNCellRenderer());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this._bindDNList);
        this._bDeleteBindDN = UIFactory.makeJButton(this, _section, "deleteBindDN", _resource);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 0;
        this._consumerPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = n2;
        this._consumerPanel.add((Component)this._bDeleteBindDN, gridBagConstraints);
        gridBagConstraints.insets.right = n;
        gridBagConstraints.insets.top = n3;
        JLabel jLabel = this.makeJLabel(_resource.getString(_section, "newBindDN-label"));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.bottom = 0;
        this._consumerPanel.add((Component)jLabel, gridBagConstraints);
        this._tfNewBindDN = this.makeJTextField();
        jLabel.setLabelFor(this._tfNewBindDN);
        this._tfNewBindDN.getDocument().addDocumentListener(this);
        this._bAddBindDN = UIFactory.makeJButton(this, _section, "addBindDN", _resource);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 0;
        this._consumerPanel.add((Component)this._tfNewBindDN, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = n2;
        this._consumerPanel.add((Component)this._bAddBindDN, gridBagConstraints);
        gridBagConstraints.insets.right = n;
        this._lReferralList = new JLabel(_resource.getString(_section, "referrallistlabel-label"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 2 * n3;
        this._consumerPanel.add((Component)this._lReferralList, gridBagConstraints);
        this._referralListData = new DefaultListModel();
        this._referralList = new JList(this._referralListData);
        this._lReferralList.setLabelFor(this._referralList);
        this._referralList.setVisibleRowCount(3);
        this._referralList.setCellRenderer(new ReferralCellRenderer());
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.getViewport().setView(this._referralList);
        this._bDeleteReferral = UIFactory.makeJButton(this, _section, "deleteReferral", _resource);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 0;
        this._consumerPanel.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = n2;
        this._consumerPanel.add((Component)this._bDeleteReferral, gridBagConstraints);
        gridBagConstraints.insets.top = n3;
        gridBagConstraints.insets.right = n;
        JLabel jLabel2 = this.makeJLabel(_resource.getString(_section, "newReferral-label"));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.bottom = 0;
        this._consumerPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.insets.bottom = n3;
        gridBagConstraints.insets.top = 0;
        this._tfNewReferral = this.makeJTextField();
        jLabel2.setLabelFor(this._tfNewReferral);
        this._bAddReferral = UIFactory.makeJButton(this, _section, "addReferral", _resource);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        this._consumerPanel.add((Component)this._tfNewReferral, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = n2;
        this._consumerPanel.add((Component)this._bAddReferral, gridBagConstraints);
        gridBagConstraints.insets.right = n;
        this._bConstructReferral = UIFactory.makeJButton(this, _section, "constructReferral", _resource);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        this._consumerPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = n3;
        gridBagConstraints.insets.right = n2;
        gridBagConstraints.insets.bottom = n3;
        this._consumerPanel.add((Component)this._bConstructReferral, gridBagConstraints);
    }

    private void populateData() {
        this.readValuesFromServer();
        this.populateFieldsWithValuesFromServer();
    }

    private void readValuesFromServer() {
        block15: {
            this._saveReplicaEnabled = false;
            this._saveDS5ReplicaTypeExist = false;
            this._saveDS5ReplicaLegacyConsumerExist = false;
            this._saveReplicaIDExist = false;
            this._saveReplicaIDExist = false;
            this._saveBindDNExist = false;
            this._saveReferralListExist = false;
            this._savePurgeDelayExist = false;
            this._saveDS5FlagsExist = false;
            this._saveReadOnly = false;
            this._savePurgeDelay = "604800";
            this._saveReplicaID = 0;
            this._saveBindDNList = new Vector();
            this._saveDS5Flags = true;
            this._saveReferralList = new Vector();
            this._save4xConsumer = false;
            this._saveIsSimpleMaster = false;
            this._saveIsSlave = false;
            this._saveIsMultiMaster = false;
            this._saveIsHub = false;
            if (this._repSettingDN == null) {
                this._repSettingDN = "cn=replica," + this._mapTreeEntry.getDN();
            }
            LDAPEntry lDAPEntry = null;
            LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
            try {
                String[] stringArray;
                Object object;
                lDAPEntry = lDAPConnection.read(this._repSettingDN);
                this._saveReplicaEnabled = true;
                String string = DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaType");
                boolean bl = this._saveReadOnly = string.length() != 0 && string.equalsIgnoreCase(REP_TYPE_READONLY);
                if (string.length() != 0) {
                    this._saveDS5ReplicaTypeExist = true;
                }
                boolean bl2 = this._save4xConsumer = (string = DSUtil.getAttrValue(lDAPEntry, "nsds5ReplicaLegacyConsumer")).length() != 0 && string.equalsIgnoreCase("on");
                if (string.length() != 0) {
                    this._saveDS5ReplicaLegacyConsumerExist = true;
                }
                if ((string = DSUtil.getAttrValue(lDAPEntry, "nsds5ReplicaPurgeDelay")).length() != 0) {
                    this._savePurgeDelayExist = true;
                    this._savePurgeDelay = string;
                }
                if ((string = DSUtil.getAttrValue(lDAPEntry, "nsDS5ReplicaID")).length() != 0) {
                    this._saveReplicaIDExist = true;
                    try {
                        object = Integer.valueOf(string);
                        this._saveReplicaID = (Integer)object;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this._saveReplicaID = 0;
                    }
                }
                if ((object = DSUtil.getAttrValues(lDAPEntry, "nsDS5ReplicaBindDN")) != null && ((String[])object).length > 0) {
                    int n = 0;
                    while (n < ((Object)object).length) {
                        this._saveBindDNList.addElement(object[n]);
                        ++n;
                    }
                    this._saveBindDNExist = true;
                }
                boolean bl3 = this._saveDS5Flags = (string = DSUtil.getAttrValue(lDAPEntry, "nsDS5Flags")).length() != 0 && string.equals(REP_FLAG_LOG_CHANGES);
                if (string.length() != 0) {
                    this._saveDS5FlagsExist = true;
                }
                if ((stringArray = DSUtil.getAttrValues(lDAPEntry, "nsDS5ReplicaReferral")) != null && stringArray.length > 0) {
                    int n = 0;
                    while (n < stringArray.length) {
                        this._saveReferralList.addElement(stringArray[n]);
                        ++n;
                    }
                    this._saveReferralListExist = true;
                }
                this._saveIsMultiMaster = this._saveDS5Flags && this._saveBindDNList.size() > 0 && !this._saveReadOnly;
                boolean bl4 = this._saveIsHub = this._saveDS5Flags && this._saveBindDNList.size() > 0 && this._saveReadOnly;
                if (!this._saveIsMultiMaster && !this._saveIsHub) {
                    this._saveIsSlave = !this._saveDS5Flags && this._saveReadOnly;
                    this._saveIsSimpleMaster = this._saveDS5Flags && !this._saveReadOnly;
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) break block15;
                DSUtil.showLDAPErrorDialog(this._model.getFrame(), lDAPException, "updating-server-unavailable-title");
            }
        }
    }

    private void populateFieldsWithValuesFromServer() {
        this._cbReplicaEnabled.setSelected(this._saveReplicaEnabled);
        if (!this._saveReplicaEnabled) {
            this._rbIsSlave.setSelected(true);
        } else if (this._saveIsMultiMaster) {
            this._rbIsMultiMaster.setSelected(true);
        } else if (this._saveIsSlave) {
            this._rbIsSlave.setSelected(true);
        } else if (this._saveIsSimpleMaster) {
            this._rbIsSimpleMaster.setSelected(true);
        } else {
            this._rbIsHub.setSelected(true);
        }
        if (this._saveReplicaID > 0) {
            this._tfReplicaID.setText(String.valueOf(this._saveReplicaID));
        } else {
            this._tfReplicaID.setText("");
        }
        this.populatePurgeDelay(this._savePurgeDelay);
        this._tfNewBindDN.setText("");
        this._bindDNListData.clear();
        int n = 0;
        while (n < this._saveBindDNList.size()) {
            this._bindDNListData.addElement(this._saveBindDNList.elementAt(n));
            ++n;
        }
        this._tfNewReferral.setText("");
        this._referralListData.clear();
        int n2 = 0;
        while (n2 < this._saveReferralList.size()) {
            this._referralListData.addElement(this._saveReferralList.elementAt(n2));
            ++n2;
        }
        if (this._save4xConsumer) {
            this._cb4xConsumer.setSelected(true);
        } else {
            this._cb4xConsumer.setSelected(false);
        }
    }

    private void populatePurgeDelay(String string) {
        try {
            long l = Integer.valueOf(string).longValue();
            if (l == 0L) {
                this._cbPurgeDelayNever.setSelected(true);
                return;
            }
            this._cbPurgeDelayNever.setSelected(false);
            int n = 0;
            while (n < this.CONVERSION_VALUES.length) {
                Debug.println((String)("ReplicaSettingPanel.populatePurgeDelay() " + l + " % " + this.CONVERSION_VALUES[n] + " = " + l % (long)this.CONVERSION_VALUES[n]));
                if (l % (long)this.CONVERSION_VALUES[n] == 0L) {
                    this._cboPurgeUnit.setSelectedIndex(n);
                    String string2 = String.valueOf(l / (long)this.CONVERSION_VALUES[n]);
                    this._tfPurgeDelay.setText(string2);
                    break;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            Debug.println((String)("ReplicaSettingPanel.populatePurgeDelay() " + exception));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this._isInitialized) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object.equals(this._cb4xConsumer) && this._cb4xConsumer.isSelected()) {
            boolean bl = false;
            try {
                LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
                String[] stringArray = new String[]{"dn"};
                LDAPEntry lDAPEntry = lDAPConnection.read("cn=legacy consumer,cn=replication,cn=config", stringArray);
                if (lDAPEntry != null) {
                    bl = true;
                }
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            if (!bl) {
                this._cb4xConsumer.setSelected(false);
                DSUtil.showErrorDialog((Component)this._model.getFrame(), "enable-legacy-error", (String[])null, _section, _resource);
            }
        } else if (object.equals(this._rbIsSimpleMaster) && this._rbIsSimpleMaster.isSelected() || object.equals(this._rbIsMultiMaster) && this._rbIsMultiMaster.isSelected() || object.equals(this._rbIsHub) && this._rbIsHub.isSelected()) {
            boolean bl = false;
            try {
                LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
                String[] stringArray = new String[]{"dn"};
                LDAPEntry lDAPEntry = lDAPConnection.read("cn=changelog5,cn=config", stringArray);
                if (lDAPEntry != null) {
                    bl = true;
                }
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
            if (!bl) {
                this._rbIsSlave.setSelected(true);
                DSUtil.showErrorDialog((Component)this._model.getFrame(), "enable-changelog-error", (String[])null, _section, _resource);
            } else if (!this._rbIsHub.isSelected() && this.isDatabaseReadOnly()) {
                this._rbIsSlave.setSelected(true);
                DSUtil.showErrorDialog((Component)this._model.getFrame(), "enable-master-error", (String[])null, _section, _resource);
            }
        } else if (object.equals(this._bAddBindDN)) {
            this.actionAddBindDN();
        } else if (object.equals(this._bDeleteBindDN)) {
            this.actionDeleteBindDN();
        } else if (object.equals(this._bConstructReferral)) {
            this.actionConstructReferral();
        } else if (object.equals(this._bAddReferral)) {
            this.actionAddReferral();
        } else if (object.equals(this._bDeleteReferral)) {
            this.actionDeleteReferral();
        }
        this.checkFields();
        this.checkEnablingState();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this._isInitialized) {
            return;
        }
        this.checkFields();
        this.checkAddReferralButton();
        this.checkAddBindDNButtonAndLabel();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void okCallback() {
        if (this.saveConfirmationDialog()) {
            this.readValuesFromServer();
            this.store();
            this.resetCallback();
        }
    }

    public void resetCallback() {
        this.populateData();
        this.checkFields();
        this.checkEnablingState();
    }

    public boolean refresh() {
        Debug.println((String)"ReplicaSettingPanel.refresh()");
        this.populateData();
        this.checkFields();
        this.checkEnablingState();
        return true;
    }

    public void refreshFromServer() {
        Debug.println((String)"ReplicaSettingPanel.refreshFromServer()");
        this.resetCallback();
    }

    private void actionConstructReferral() {
        String string = DSUtil.getAttrValue(this._instEntry, "nsslapd-suffix");
        LDAPUrl lDAPUrl = new LDAPUrl(null, 389, string);
        int n = 6;
        LDAPUrlDialog lDAPUrlDialog = new LDAPUrlDialog(this.getModel().getFrame(), lDAPUrl.getUrl(), n);
        lDAPUrlDialog.packAndShow();
        LDAPUrl lDAPUrl2 = lDAPUrlDialog.getLDAPUrl();
        if (lDAPUrl2 != null) {
            this._tfNewReferral.setText(lDAPUrl2.getUrl());
            this._bAddReferral.setEnabled(true);
        }
    }

    private void actionDeleteReferral() {
        Object[] objectArray = this._referralList.getSelectedValues();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this._referralListData.removeElement(objectArray[n]);
                ++n;
            }
        }
    }

    private void actionAddBindDN() {
        String string = this._tfNewBindDN.getText().trim();
        this._bindDNListData.addElement(string);
        this._tfNewBindDN.setText("");
        this._bAddBindDN.setEnabled(false);
    }

    private void actionDeleteBindDN() {
        Object[] objectArray = this._bindDNList.getSelectedValues();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this._bindDNListData.removeElement(objectArray[n]);
                ++n;
            }
        }
    }

    private void actionAddReferral() {
        int n;
        String string = this._tfNewReferral.getText().trim();
        boolean bl = true;
        if (!DSUtil.isValidLDAPUrl(string) && (n = DSUtil.showConfirmationDialog((Component)this.getModel().getFrame(), "LDAPUrl-no-good", (String)null, "mappingtree-referral")) != 0) {
            bl = false;
        }
        if (bl) {
            this._referralListData.addElement(string);
            this._tfNewReferral.setText("");
            this._bAddReferral.setEnabled(false);
        }
    }

    private boolean isDatabaseReadOnly() {
        String string;
        boolean bl = false;
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        String[] stringArray = new String[]{"nsslapd-readonly"};
        LDAPEntry lDAPEntry = null;
        try {
            lDAPEntry = lDAPConnection.read(this._instEntry.getDN(), stringArray);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("ReplicaSettingPanel.isDatabaseReadOnly(): " + (Object)((Object)lDAPException)));
        }
        if (lDAPEntry != null && (string = DSUtil.getAttrValue(lDAPEntry, "nsslapd-readonly")) != null && string.trim().equalsIgnoreCase("on")) {
            bl = true;
        }
        return bl;
    }

    private boolean saveConfirmationDialog() {
        int n;
        boolean bl = true;
        if (this._cbReplicaEnabled.isSelected() && this._cb4xConsumer.isSelected()) {
            if (this._rbIsMultiMaster.isSelected()) {
                int n2 = DSUtil.showConfirmationDialog((Component)this._model.getFrame(), "confirm-multimaster-4xcompatible", "", _section, _resource);
                if (n2 != 0) {
                    bl = false;
                }
            } else if (this._rbIsSimpleMaster.isSelected()) {
                int n3 = DSUtil.showConfirmationDialog((Component)this._model.getFrame(), "confirm-simplemaster-4xcompatible", "", _section, _resource);
                if (n3 != 0) {
                    bl = false;
                }
            } else {
                int n4 = DSUtil.showConfirmationDialog((Component)this._model.getFrame(), "confirm-readonly-4xcompatible", "", _section, _resource);
                if (n4 != 0) {
                    bl = false;
                }
            }
        } else if (this._rbIsSlave.isSelected() && !this._saveIsSlave && this._saveReplicaEnabled && this.hasReplicationAgreements() && (n = DSUtil.showConfirmationDialog((Component)this._model.getFrame(), "slave-defined-agreements-no-valid", "", _section, _resource)) != 0) {
            bl = false;
        }
        return bl;
    }

    private void store() {
        if (!this._cbReplicaEnabled.isSelected()) {
            if (this._saveReplicaEnabled) {
                this.deleteReplicaEntry();
            }
        } else if (!this._saveReplicaEnabled) {
            this.addReplicaEntry();
        } else {
            this.modifyReplicaEntry();
        }
    }

    private void deleteReplicaEntry() {
        int n = DSUtil.showConfirmationDialog((Component)this._model.getFrame(), "confirmrepdelete", "", _section, _resource);
        if (n != 0) {
            return;
        }
        try {
            this.getModel().setWaitCursor(true);
            LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
            if (DSUtil.deleteTree(this._repSettingDN, lDAPConnection)) {
                this._idscListener.contentChanged();
            } else {
                Debug.println((String)("ReplicaSettingPanel.deleteReplicaEntry(): error deleting replica " + this._repSettingDN));
            }
            if (!this._saveIsSimpleMaster && this.hasReferrals()) {
                String string = DSUtil.getAttrValue(this._instEntry, "nsslapd-suffix");
                String[] stringArray = new String[]{string};
                DSUtil.showInformationDialog(this._model.getFrame(), "delete-referrals-information", stringArray, _section, _resource);
            }
            Object var6_5 = null;
            this._model.setWaitCursor(false);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this._model.setWaitCursor(false);
            throw throwable;
        }
    }

    private boolean hasReferrals() {
        String[] stringArray = null;
        String[] stringArray2 = new String[]{"nsslapd-referral"};
        LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
        try {
            LDAPEntry lDAPEntry = lDAPConnection.read(this._mapTreeEntry.getDN(), stringArray2);
            if (lDAPEntry != null) {
                stringArray = DSUtil.getAttrValues(lDAPEntry, "nsslapd-referral");
            }
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        return stringArray != null && stringArray.length > 0;
    }

    private boolean hasReplicationAgreements() {
        boolean bl = false;
        LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
        LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
        lDAPSearchConstraints.setMaxResults(1);
        String[] stringArray = new String[]{"dn"};
        String string = "(objectclass=nsds5replicationagreement)";
        try {
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this._repSettingDN, 1, string, stringArray, false, lDAPSearchConstraints);
            while (lDAPSearchResults.hasMoreElements() && lDAPSearchResults.nextElement() != null) {
                bl = true;
            }
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        return bl;
    }

    private void addReplicaEntry() {
        Object object;
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        LDAPAttribute lDAPAttribute = new LDAPAttribute("objectClass", "nsDS5Replica");
        lDAPAttributeSet.add(lDAPAttribute);
        String string = DSUtil.getAttrValue(this._instEntry, "nsslapd-suffix");
        if (string.equals("")) {
            Debug.println((String)"ReplicaSettingPanel.addReplicaEntry: error, could not get suffix of replica");
            return;
        }
        lDAPAttribute = new LDAPAttribute("nsDS5ReplicaRoot", string);
        lDAPAttributeSet.add(lDAPAttribute);
        String string2 = this._rbIsSlave.isSelected() || this._rbIsHub.isSelected() ? REP_TYPE_READONLY : REP_TYPE_UPDATEABLE;
        lDAPAttribute = new LDAPAttribute("nsDS5ReplicaType", string2);
        lDAPAttributeSet.add(lDAPAttribute);
        if (this._cb4xConsumer.isSelected()) {
            string2 = "on";
            lDAPAttribute = new LDAPAttribute("nsds5ReplicaLegacyConsumer", string2);
            lDAPAttributeSet.add(lDAPAttribute);
        }
        string2 = !this._rbIsSlave.isSelected() ? REP_FLAG_LOG_CHANGES : REP_FLAG_NONE;
        lDAPAttribute = new LDAPAttribute("nsDS5Flags", string2);
        lDAPAttributeSet.add(lDAPAttribute);
        string2 = this._rbIsSimpleMaster.isSelected() || this._rbIsMultiMaster.isSelected() ? this._tfReplicaID.getText().trim() : Integer.toString(65535);
        lDAPAttribute = new LDAPAttribute("nsDS5ReplicaID", string2);
        lDAPAttributeSet.add(lDAPAttribute);
        try {
            if (!this._cbPurgeDelayNever.isSelected()) {
                string2 = this._tfPurgeDelay.getText().trim();
                long l = Integer.valueOf(string2).longValue();
                int n = this._cboPurgeUnit.getSelectedIndex();
                string2 = String.valueOf(l *= (long)this.CONVERSION_VALUES[n]);
            } else {
                string2 = REP_FLAG_NONE;
            }
            lDAPAttribute = new LDAPAttribute("nsds5ReplicaPurgeDelay", string2);
            lDAPAttributeSet.add(lDAPAttribute);
        }
        catch (Exception exception) {
            Debug.println((String)("ReplicaSettingPanel.addReplicaEntry(): " + exception));
        }
        if (!this._rbIsSimpleMaster.isSelected()) {
            lDAPAttribute = new LDAPAttribute("nsDS5ReplicaBindDN");
            Enumeration enumeration = this._bindDNListData.elements();
            while (enumeration.hasMoreElements()) {
                lDAPAttribute.addValue((String)enumeration.nextElement());
            }
            lDAPAttributeSet.add(lDAPAttribute);
        }
        if (!this._rbIsSimpleMaster.isSelected()) {
            boolean bl;
            lDAPAttribute = new LDAPAttribute("nsDS5ReplicaReferral");
            boolean bl2 = bl = this._referralListData.size() > 0;
            if (bl) {
                object = this._referralListData.elements();
                while (object.hasMoreElements()) {
                    lDAPAttribute.addValue((String)object.nextElement());
                }
                lDAPAttributeSet.add(lDAPAttribute);
            }
        }
        LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
        object = new LDAPEntry(this._repSettingDN, lDAPAttributeSet);
        try {
            Debug.println((String)("ReplicaSettingPanel.addReplicaEntry(): dn: " + this._repSettingDN + "\n" + object));
            lDAPConnection.add((LDAPEntry)object);
            this._idscListener.contentChanged();
            if (this._rbIsSlave.isSelected() || this._rbIsHub.isSelected()) {
                this.updateDataNode();
            }
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() != 68) {
                DSUtil.showLDAPErrorDialog(this._model.getFrame(), lDAPException, "111-title");
            }
            this.readValuesFromServer();
            this.modifyReplicaEntry();
        }
    }

    private void modifyReplicaEntry() {
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        int n = this._saveDS5ReplicaTypeExist ? 2 : 0;
        boolean bl = this._rbIsSlave.isSelected() || this._rbIsHub.isSelected();
        String string = bl ? REP_TYPE_READONLY : REP_TYPE_UPDATEABLE;
        if (!this._saveDS5ReplicaTypeExist || bl != this._saveReadOnly) {
            lDAPModificationSet.add(n, new LDAPAttribute("nsDS5ReplicaType", string));
        }
        int n2 = n = this._saveDS5ReplicaLegacyConsumerExist ? 2 : 0;
        if (this._cb4xConsumer.isSelected() && !this._save4xConsumer) {
            string = "on";
            lDAPModificationSet.add(n, new LDAPAttribute("nsds5ReplicaLegacyConsumer", string));
        } else if (!this._cb4xConsumer.isSelected() && this._save4xConsumer) {
            string = "off";
            lDAPModificationSet.add(n, new LDAPAttribute("nsds5ReplicaLegacyConsumer", string));
        }
        n = this._saveDS5FlagsExist ? 2 : 0;
        string = !this._rbIsSlave.isSelected() ? REP_FLAG_LOG_CHANGES : REP_FLAG_NONE;
        if (!this._saveDS5FlagsExist || this._rbIsSlave.isSelected() == this._saveDS5Flags) {
            lDAPModificationSet.add(n, new LDAPAttribute("nsDS5Flags", string));
        }
        n = this._saveReplicaIDExist ? 2 : 0;
        string = this._rbIsSimpleMaster.isSelected() || this._rbIsMultiMaster.isSelected() ? this._tfReplicaID.getText().trim() : Integer.toString(65535);
        if (!this._saveReplicaIDExist || !string.equals(String.valueOf(this._saveReplicaID))) {
            lDAPModificationSet.add(n, new LDAPAttribute("nsDS5ReplicaID", string));
        }
        n = this._savePurgeDelayExist ? 2 : 0;
        try {
            if (!this._cbPurgeDelayNever.isSelected()) {
                string = this._tfPurgeDelay.getText().trim();
                long l = Integer.valueOf(string).longValue();
                int n3 = this._cboPurgeUnit.getSelectedIndex();
                string = String.valueOf(l *= (long)this.CONVERSION_VALUES[n3]);
            } else {
                string = REP_FLAG_NONE;
            }
            if (!this._savePurgeDelayExist || !string.equals(this._savePurgeDelay)) {
                lDAPModificationSet.add(n, new LDAPAttribute("nsds5ReplicaPurgeDelay", string));
            }
        }
        catch (Exception exception) {
            Debug.println((String)("ReplicaSettingPanel.modifyReplicaEntry(): " + exception));
        }
        if (!this._rbIsSimpleMaster.isSelected()) {
            n = this._saveBindDNExist ? 2 : 0;
            LDAPAttribute lDAPAttribute = new LDAPAttribute("nsDS5ReplicaBindDN");
            Enumeration enumeration = this._bindDNListData.elements();
            while (enumeration.hasMoreElements()) {
                lDAPAttribute.addValue((String)enumeration.nextElement());
            }
            if (!this._saveBindDNExist || this.isBindDNListDirty()) {
                lDAPModificationSet.add(n, lDAPAttribute);
            }
        } else if (this._saveBindDNExist) {
            lDAPModificationSet.add(1, new LDAPAttribute("nsDS5ReplicaBindDN"));
        }
        if (!this._rbIsSimpleMaster.isSelected()) {
            boolean bl2;
            n = this._saveReferralListExist ? 2 : 0;
            LDAPAttribute lDAPAttribute = new LDAPAttribute("nsDS5ReplicaReferral");
            boolean bl3 = bl2 = this._referralListData.size() > 0;
            if (bl2) {
                Enumeration enumeration = this._referralListData.elements();
                while (enumeration.hasMoreElements()) {
                    lDAPAttribute.addValue((String)enumeration.nextElement());
                }
                if (!this._saveReferralListExist || this.isReferralListDirty()) {
                    lDAPModificationSet.add(n, lDAPAttribute);
                }
            } else if (this._saveReferralListExist) {
                lDAPModificationSet.add(1, new LDAPAttribute("nsDS5ReplicaReferral"));
            }
        } else if (this._saveReferralListExist) {
            lDAPModificationSet.add(1, new LDAPAttribute("nsDS5ReplicaReferral"));
        }
        LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
        try {
            if (lDAPModificationSet.size() > 0) {
                Debug.println((String)("ReplicaSettingPanel.modifyReplicaEntry(): dn: " + this._repSettingDN + "\n" + lDAPModificationSet));
                lDAPConnection.modify(this._repSettingDN, lDAPModificationSet);
                this._idscListener.contentChanged();
            }
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() != 32) {
                DSUtil.showLDAPErrorDialog(this._model.getFrame(), lDAPException, "111-title");
            }
            this.addReplicaEntry();
        }
    }

    protected void updateDataNode() {
        TreeNode treeNode = (TreeNode)this._model.getRoot();
        int n = treeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            TreeNode treeNode2 = treeNode.getChildAt(n2);
            if (treeNode2 instanceof DataRootResourceObject) {
                DataRootResourceObject dataRootResourceObject = (DataRootResourceObject)((Object)treeNode2);
                dataRootResourceObject.actionPerformed(new ActionEvent(this, 1001, "refresh"));
                Component component = dataRootResourceObject.getCustomPanel();
                if (component == null || !(component instanceof ActionListener)) break;
                ((ActionListener)((Object)component)).actionPerformed(new ActionEvent(this, 1001, "refresh"));
                break;
            }
            ++n2;
        }
    }

    protected void checkEnablingState() {
        if (!this._isInitialized) {
            return;
        }
        if (this._cbReplicaEnabled.isSelected()) {
            this.setEnabledPanel(this._replicaTypePanel, true);
            this.setEnabledPanel(this._commonAttributePanel, true);
            this.setEnabledPanel(this._consumerPanel, !this._rbIsSimpleMaster.isSelected());
            this._bindDNList.setBackground(this._tfNewBindDN.getBackground());
            this._referralList.setBackground(this._tfNewReferral.getBackground());
            this._tfPurgeDelay.setEnabled(!this._cbPurgeDelayNever.isSelected());
            this._cboPurgeUnit.setEnabled(!this._cbPurgeDelayNever.isSelected());
            boolean bl = !this._rbIsHub.isSelected() && !this._rbIsSlave.isSelected() && (!this._saveReplicaEnabled || this._saveIsHub || this._saveIsSlave);
            this._tfReplicaID.setEnabled(bl);
            this._lReplicaID.setEnabled(bl);
            this._lReplicaIDWarning.setEnabled(bl);
        } else {
            this.setEnabledPanel(this._replicaTypePanel, false);
            this.setEnabledPanel(this._commonAttributePanel, false);
            this.setEnabledPanel(this._consumerPanel, false);
            this._bindDNList.setBackground(this._tfNewBindDN.getBackground());
            this._referralList.setBackground(this._tfNewReferral.getBackground());
        }
        this.checkAddReferralButton();
        this.checkAddBindDNButtonAndLabel();
        this.checkDeleteBindDNButton();
        this.checkDeleteReferralButton();
    }

    protected void setEnabledPanel(JPanel jPanel, boolean bl) {
        Component[] componentArray = jPanel.getComponents();
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof JPanel) {
                    this.setEnabledPanel((JPanel)componentArray[n], bl);
                } else {
                    componentArray[n].setEnabled(bl);
                }
                ++n;
            }
        }
    }

    protected void checkDeleteBindDNButton() {
        this._bDeleteBindDN.setEnabled(!this._bindDNList.isSelectionEmpty());
    }

    protected void checkDeleteReferralButton() {
        this._bDeleteReferral.setEnabled(!this._referralList.isSelectionEmpty());
    }

    protected void checkAddBindDNButtonAndLabel() {
        String string = this._tfNewBindDN.getText().trim();
        boolean bl = DSUtil.isValidDN(string);
        boolean bl2 = bl && !string.equals("") && !this._rbIsSimpleMaster.isSelected() && this._cbReplicaEnabled.isSelected();
        this._bAddBindDN.setEnabled(bl2);
    }

    protected void checkAddReferralButton() {
        this._bAddReferral.setEnabled(!this._tfNewReferral.getText().trim().equals("") && !this._rbIsSimpleMaster.isSelected() && this._cbReplicaEnabled.isSelected());
    }

    protected void checkFields() {
        int n;
        int n2;
        boolean bl;
        if (!this._isInitialized) {
            return;
        }
        boolean bl2 = bl = this._cbReplicaEnabled.isSelected() != this._saveReplicaEnabled;
        if (!this._cbReplicaEnabled.isSelected()) {
            if (bl) {
                this.setChangeState(this._cbReplicaEnabled, 2);
                this.setDirtyFlag();
            } else {
                this.setChangeState(this._cbReplicaEnabled, 1);
                this.clearDirtyFlag();
            }
            this.setValidFlag();
            return;
        }
        boolean bl3 = false;
        if (this._rbIsSlave.isSelected() != this._saveIsSlave) {
            bl3 = true;
            this.setChangeState(this._rbIsSlave, 2);
        } else {
            this.setChangeState(this._rbIsSlave, 1);
        }
        if (this._rbIsSimpleMaster.isSelected() != this._saveIsSimpleMaster) {
            bl3 = true;
            this.setChangeState(this._rbIsSimpleMaster, 2);
        } else {
            this.setChangeState(this._rbIsSimpleMaster, 1);
        }
        if (this._rbIsMultiMaster.isSelected() != this._saveIsMultiMaster) {
            bl3 = true;
            this.setChangeState(this._rbIsMultiMaster, 2);
        } else {
            this.setChangeState(this._rbIsMultiMaster, 1);
        }
        if (this._rbIsHub.isSelected() != this._saveIsHub) {
            bl3 = true;
            this.setChangeState(this._rbIsHub, 2);
        } else {
            this.setChangeState(this._rbIsHub, 1);
        }
        boolean bl4 = false;
        boolean bl5 = true;
        if (this._rbIsSimpleMaster.isSelected() || this._rbIsMultiMaster.isSelected()) {
            String string = this._tfReplicaID.getText();
            try {
                n2 = Integer.parseInt(string);
                if (n2 <= 0 || n2 >= 65535) {
                    bl5 = false;
                } else if (n2 != this._saveReplicaID) {
                    bl4 = true;
                }
            }
            catch (Exception exception) {
                bl5 = false;
            }
        }
        boolean bl6 = false;
        n2 = 1;
        if (!this._cbPurgeDelayNever.isSelected()) {
            try {
                String string = this._tfPurgeDelay.getText();
                long l = Integer.valueOf(string).longValue();
                n = this._cboPurgeUnit.getSelectedIndex();
                if ((l *= (long)this.CONVERSION_VALUES[n]) <= 0L) {
                    n2 = 0;
                } else {
                    string = String.valueOf(l);
                    if (!string.trim().equals(this._savePurgeDelay)) {
                        bl6 = true;
                    }
                }
            }
            catch (Exception exception) {
                n2 = 0;
            }
        } else if (!this._savePurgeDelay.equals(REP_FLAG_NONE)) {
            bl6 = true;
        }
        boolean bl7 = false;
        if (this._cb4xConsumer.isSelected() != this._save4xConsumer) {
            bl7 = true;
        }
        boolean bl8 = false;
        boolean bl9 = true;
        if (!this._rbIsSimpleMaster.isSelected()) {
            bl9 = this._bindDNListData.getSize() > 0;
            bl8 = this.isBindDNListDirty();
        }
        n = 0;
        if (!this._rbIsSimpleMaster.isSelected()) {
            n = this.isReferralListDirty() ? 1 : 0;
        }
        if (bl) {
            this.setChangeState(this._cbReplicaEnabled, 2);
        } else {
            this.setChangeState(this._cbReplicaEnabled, 1);
        }
        if (!bl5) {
            this.setChangeState(this._lReplicaID, 3);
        } else if (bl4) {
            this.setChangeState(this._lReplicaID, 2);
        } else {
            this.setChangeState(this._lReplicaID, 1);
        }
        if (!bl9) {
            this.setChangeState(this._lBindDNList, 3);
        } else if (bl8) {
            this.setChangeState(this._lBindDNList, 2);
        } else {
            this.setChangeState(this._lBindDNList, 1);
        }
        if (bl7) {
            this.setChangeState(this._cb4xConsumer, 2);
        } else {
            this.setChangeState(this._cb4xConsumer, 1);
        }
        if (n2 == 0) {
            this.setChangeState(this._lPurgeDelay, 3);
            this.setChangeState(this._cbPurgeDelayNever, 3);
        } else if (bl6) {
            if (this._savePurgeDelay.equals(REP_FLAG_NONE) || this._cbPurgeDelayNever.isSelected()) {
                this.setChangeState(this._cbPurgeDelayNever, 2);
            } else {
                this.setChangeState(this._cbPurgeDelayNever, 1);
            }
            this.setChangeState(this._lPurgeDelay, 2);
        } else {
            this.setChangeState(this._lPurgeDelay, 1);
            this.setChangeState(this._cbPurgeDelayNever, 1);
        }
        if (n != 0) {
            this.setChangeState(this._lReferralList, 2);
        } else {
            this.setChangeState(this._lReferralList, 1);
        }
        if (bl4 || bl7 || bl8 || bl6 || n != 0 || bl3 || bl) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
        if (bl5 && bl9 && n2 != 0) {
            this.setValidFlag();
        } else {
            this.clearValidFlag();
        }
    }

    private boolean isBindDNListDirty() {
        boolean bl = false;
        if (this._bindDNList != null) {
            boolean bl2 = bl = this._bindDNListData.getSize() != this._saveBindDNList.size();
            if (!bl) {
                Enumeration enumeration = this._bindDNListData.elements();
                while (enumeration.hasMoreElements() && !bl) {
                    boolean bl3 = bl = !this._saveBindDNList.contains(enumeration.nextElement());
                }
            }
        }
        return bl;
    }

    private boolean isReferralListDirty() {
        boolean bl = false;
        if (this._referralList != null) {
            boolean bl2 = bl = this._referralListData.getSize() != this._saveReferralList.size();
            if (!bl) {
                Enumeration enumeration = this._referralListData.elements();
                while (enumeration.hasMoreElements() && !bl) {
                    boolean bl3 = bl = !this._saveReferralList.contains(enumeration.nextElement());
                }
            }
        }
        return bl;
    }

    class ReferralCellRenderer
    extends DefaultListCellRenderer {
        ReferralCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ReplicaSettingPanel.this.checkDeleteReferralButton();
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }

    class BindDNCellRenderer
    extends DefaultListCellRenderer {
        BindDNCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ReplicaSettingPanel.this.checkDeleteBindDNButton();
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }
}

