/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.SimpleProgressTask;
import com.netscape.admin.dirserv.Stoppable;
import com.netscape.admin.dirserv.panel.replication.ReplicationAgreement;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.util.StringTokenizer;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class ORCTask
extends SimpleProgressTask
implements Stoppable {
    public static final int STATUS_OK = 0;
    private ReplicationAgreement m_agreement;
    private int m_status;
    private int m_firstUpdateStatus;
    private String m_firstUpdateMessage;

    public ORCTask(ReplicationAgreement replicationAgreement) {
        this.m_agreement = replicationAgreement;
        this.m_status = 0;
    }

    public void run() {
        String string;
        this.m_status = 0;
        if (this.m_agreement.getAgreementType() == 1) {
            string = "replicaBeginORC";
        } else if (this.m_agreement.getAgreementType() == 2) {
            string = "nsds5BeginReplicaRefresh";
        } else {
            return;
        }
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        LDAPAttribute lDAPAttribute = new LDAPAttribute(string, "start");
        lDAPModificationSet.add(2, lDAPAttribute);
        try {
            this.m_agreement.updateEntry(lDAPModificationSet);
            this.m_firstUpdateStatus = 0;
            boolean bl = false;
            boolean bl2 = false;
            String string2 = null;
            ResourceSet resourceSet = new ResourceSet("com.netscape.admin.dirserv.panel.replication.replication");
            while (!bl && !bl2) {
                if (this.m_dlg.isCancelled()) {
                    bl2 = true;
                    continue;
                }
                this.m_agreement.updateReplicaStatus();
                if (this.m_agreement.getConsumerInitializationInProgress().equals(resourceSet.getString("replication-agreement", "initconsumer-inprogress-false-value"))) {
                    bl2 = true;
                }
                if ((string2 = this.m_agreement.getConsumerInitializationStatus()) == null || string2.length() <= 0 || string2.equals(resourceSet.getString("replication-info-status-code", "unknown"))) continue;
                bl = true;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                String string3 = stringTokenizer.nextToken();
                if (string3 == null || string3.length() <= 0) continue;
                try {
                    this.m_firstUpdateStatus = Integer.parseInt(string3);
                    if (this.m_firstUpdateStatus == 0) continue;
                    this.m_firstUpdateMessage = string2;
                }
                catch (Exception exception) {
                    Debug.println((String)("ORCTask.run() exception parsing " + string3 + ": " + exception));
                }
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("Exception occured during ORC: " + (Object)((Object)lDAPException)));
            this.m_status = lDAPException.getLDAPResultCode();
            this.m_firstUpdateMessage = lDAPException.getLDAPErrorMessage();
            this.m_dlg.stop();
        }
        this.m_dlg.stop();
        Debug.println((String)"ORCTask: all done");
    }

    public void stop() {
        String string;
        if (this.m_agreement.getAgreementType() == 1) {
            string = "replicaBeginORC";
        } else if (this.m_agreement.getAgreementType() == 2) {
            string = "nsds5BeginReplicaRefresh";
        } else {
            this.m_status = 0;
            return;
        }
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        LDAPAttribute lDAPAttribute = new LDAPAttribute(string, "cancel");
        lDAPModificationSet.add(2, lDAPAttribute);
        try {
            this.m_agreement.updateEntry(lDAPModificationSet);
            this.m_status = 0;
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("Exception occured while stopping ORC: " + (Object)((Object)lDAPException)));
            this.m_status = lDAPException.getLDAPResultCode();
            this.m_firstUpdateMessage = lDAPException.getLDAPErrorMessage();
        }
    }

    public int getStatus() {
        return this.m_status;
    }

    public int getFirstUpdateStatus() {
        return this.m_firstUpdateStatus;
    }

    public String getFirstUpdateMessage() {
        return this.m_firstUpdateMessage;
    }
}

