/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.panel.replication.AgreementWizardInfo;
import com.netscape.admin.dirserv.panel.replication.IAgreementPanel;
import com.netscape.admin.dirserv.panel.replication.ITabPanel;
import com.netscape.admin.dirserv.panel.replication.ReplicationBlankPanel;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;

public class AgreementSchedulePanel
extends ReplicationBlankPanel
implements ActionListener,
ITabPanel {
    private boolean[] _saveDay = new boolean[7];
    private boolean _saveInSync = false;
    private String _saveStartHr;
    private String _saveStartMin;
    private String _saveEndHr;
    private String _saveEndMin;
    private JRadioButton _inSync;
    private JRadioButton _syncOn;
    private JButton _allButton;
    private JCheckBox[] _dayButton = new JCheckBox[7];
    private JTextField _startHr;
    private JTextField _startMin;
    private JTextField _endHr;
    private JTextField _endMin;
    private JPanel syncPanel;
    protected JLabel _lBetween;
    protected JLabel _lAnd;
    private static final int LIMIT_MAX_VAL = Integer.MAX_VALUE;
    private static final int MAX_HOUR = 23;
    private static final int MAX_MIN = 59;
    private static final int MIN_TIME = 0;

    public AgreementSchedulePanel(IAgreementPanel iAgreementPanel, int n) {
        super(iAgreementPanel, n);
        this.setTitle(ReplicationBlankPanel._resource.getString("replication-schedule-tab", "label"));
        this._helpToken = "configuration-replication-schedule-help";
        this._refreshWhenSelect = false;
    }

    public void init() {
        if (this._isInitialized) {
            return;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ReplicationTool.resetGBC(gridBagConstraints);
        this._myPanel.setLayout(new GridBagLayout());
        this._myPanel.setBackground(this.getBackground());
        ButtonGroup buttonGroup = new ButtonGroup();
        this._inSync = this.makeJRadioButton(ReplicationBlankPanel._resource.getString("replication-schedule-inSyncButton", "label"));
        buttonGroup.add(this._inSync);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        this._myPanel.add((Component)this._inSync, gridBagConstraints);
        String string = ReplicationBlankPanel._resource.getString("replication-schedule-days", "label");
        this.syncPanel = new GroupPanel(string);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this._myPanel.add((Component)this.syncPanel, gridBagConstraints);
        this._syncOn = this.makeJRadioButton(ReplicationBlankPanel._resource.getString("replication-schedule-syncOnButton", "label"));
        buttonGroup.add(this._syncOn);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        this.syncPanel.add((Component)this._syncOn, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.syncPanel.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.syncPanel.add((Component)jPanel2, gridBagConstraints);
        this.makeDayButton(jPanel, 1, ReplicationBlankPanel._resource.getString("replication-schedule-dateMon", "label"));
        this.makeDayButton(jPanel, 2, ReplicationBlankPanel._resource.getString("replication-schedule-dateTue", "label"));
        this.makeDayButton(jPanel, 3, ReplicationBlankPanel._resource.getString("replication-schedule-dateWed", "label"));
        this.makeDayButton(jPanel, 4, ReplicationBlankPanel._resource.getString("replication-schedule-dateThu", "label"));
        this.makeDayButton(jPanel, 5, ReplicationBlankPanel._resource.getString("replication-schedule-dateFri", "label"));
        this.makeDayButton(jPanel, 6, ReplicationBlankPanel._resource.getString("replication-schedule-dateSat", "label"));
        this.makeDayButton(jPanel, 0, ReplicationBlankPanel._resource.getString("replication-schedule-dateSun", "label"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        this._allButton = UIFactory.makeJButton(this, "replication-schedule", "allButton", ReplicationBlankPanel._resource);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.insets.right = gridBagConstraints.insets.left;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this._allButton, gridBagConstraints);
        this._lBetween = this.makeJLabel(ReplicationBlankPanel._resource.getString("replication-schedule-between", "label"));
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this._lBetween, gridBagConstraints);
        this._startHr = this.makeJTextField("00", 3);
        this._lBetween.setLabelFor(this._startHr);
        this._activeColor = this._startHr.getBackground();
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this._startHr, gridBagConstraints);
        this._startMin = this.makeJTextField("00", 3);
        this._lBetween.setLabelFor(this._startMin);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this._startMin, gridBagConstraints);
        this._lAnd = this.makeJLabel(ReplicationBlankPanel._resource.getString("replication-schedule-and", "label"));
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this._lAnd, gridBagConstraints);
        this._endHr = this.makeJTextField("00", 3);
        this._lAnd.setLabelFor(this._endHr);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this._endHr, gridBagConstraints);
        this._endMin = this.makeJTextField("00", 3);
        this._lAnd.setLabelFor(this._endMin);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this._endMin, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        jPanel2.add(Box.createHorizontalGlue(), gridBagConstraints);
        this._isInitialized = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Debug.println((String)("AgreementSchedulePanel: actionPerformed()" + actionEvent.toString()));
        if (actionEvent.getSource().equals(this._allButton)) {
            this.checkDate(true);
        }
        if (actionEvent.getSource().equals(this._inSync)) {
            this.disableTimeSelection();
        }
        if (actionEvent.getSource().equals(this._syncOn)) {
            this.enableTimeSelection();
        }
        this.validateButtons();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.validateButtons();
    }

    public boolean validateEntries() {
        return true;
    }

    public void getUpdateInfo(Object object) {
        AgreementWizardInfo agreementWizardInfo = (AgreementWizardInfo)object;
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.createDateString());
        agreementWizardInfo.setDate(vector);
    }

    private void makeDayButton(JPanel jPanel, int n, String string) {
        this._dayButton[n] = this.makeJCheckBox(string);
        this._dayButton[n].setVerticalTextPosition(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ReplicationTool.resetGBC(gridBagConstraints);
        jPanel.add((Component)this._dayButton[n], gridBagConstraints);
    }

    private void disableTimeSelection() {
        int n = 0;
        while (n < 7) {
            this._dayButton[n].setEnabled(false);
            ++n;
        }
        this._allButton.setEnabled(false);
        this._startHr.setEnabled(false);
        this._startHr.setEditable(false);
        this._startHr.setBackground(this.getBackground());
        this._startMin.setEnabled(false);
        this._startMin.setEditable(false);
        this._startMin.setBackground(this.getBackground());
        this._endHr.setEnabled(false);
        this._endHr.setEditable(false);
        this._endHr.setBackground(this.getBackground());
        this._endMin.setEnabled(false);
        this._endMin.setEditable(false);
        this._endMin.setBackground(this.getBackground());
        this._lBetween.setEnabled(false);
        this._lAnd.setEnabled(false);
        this.syncPanel.invalidate();
        this.syncPanel.validate();
        this.syncPanel.repaint(1L);
    }

    private void enableTimeSelection() {
        int n = 0;
        while (n < 7) {
            this._dayButton[n].setEnabled(true);
            ++n;
        }
        this._allButton.setEnabled(true);
        this._startHr.setEnabled(true);
        this._startHr.setEditable(true);
        this._startHr.setBackground(this._activeColor);
        this._startMin.setEnabled(true);
        this._startMin.setEditable(true);
        this._startMin.setBackground(this._activeColor);
        this._endHr.setEnabled(true);
        this._endHr.setEditable(true);
        this._endHr.setBackground(this._activeColor);
        this._endMin.setEnabled(true);
        this._endMin.setEditable(true);
        this._endMin.setBackground(this._activeColor);
        this._lBetween.setEnabled(true);
        this._lAnd.setEnabled(true);
    }

    private void checkDate(boolean bl) {
        int n = 0;
        while (n < 7) {
            this._dayButton[n].setSelected(bl);
            ++n;
        }
    }

    public boolean refresh() {
        this.resetCallback();
        return true;
    }

    public void resetCallback() {
        this.populateData();
    }

    public void okCallback() {
        this.resetCallback();
    }

    protected void populateData() {
        this._agreement.updateAgreementFromServer();
        Vector vector = this._agreement.getUpdateSchedule();
        String string = "";
        if (vector != null && vector.size() > 0) {
            string = (String)vector.firstElement();
        }
        this.setSchedule(string);
        this.validateButtons();
    }

    private void setSchedule(String string) {
        if (!this._isInitialized) {
            return;
        }
        Debug.println((String)("AgreementSchedulePanel.setSchedule(): Schedule: " + string));
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        StringBuffer stringBuffer5 = new StringBuffer();
        if (!ReplicationTool.parseReplicaSchedule(string, stringBuffer, stringBuffer2, stringBuffer3, stringBuffer4, stringBuffer5)) {
            this._inSync.setSelected(true);
            this.disableTimeSelection();
            this._saveInSync = true;
        } else {
            this.enableTimeSelection();
            this._syncOn.setSelected(true);
            this._saveInSync = false;
            this._startHr.setText(stringBuffer.toString());
            this._saveStartHr = stringBuffer.toString();
            this._startMin.setText(stringBuffer2.toString());
            this._saveStartMin = stringBuffer2.toString();
            this._endHr.setText(stringBuffer3.toString());
            this._saveEndHr = stringBuffer3.toString();
            this._endMin.setText(stringBuffer4.toString());
            this._saveEndMin = stringBuffer4.toString();
            int n = 0;
            while (n < this._saveDay.length) {
                this._saveDay[n] = false;
                this._dayButton[n].setSelected(false);
                ++n;
            }
            int n2 = 0;
            while (n2 < stringBuffer5.length()) {
                String string2 = stringBuffer5.substring(n2, n2 + 1);
                try {
                    int n3 = Integer.parseInt(string2);
                    if (n3 >= 0 && n3 < 7) {
                        this._saveDay[n3] = true;
                        this._dayButton[n3].setSelected(true);
                    }
                }
                catch (Exception exception) {
                    Debug.println((String)("AgreementSchedulePanel.setSchedule error parsing " + string2));
                }
                ++n2;
            }
        }
    }

    protected void validateButtons() {
        int n;
        if (!this._isInitialized) {
            return;
        }
        boolean bl = false;
        if (this._inSync.isSelected()) {
            if (!this._saveInSync) {
                this.setChangeState(this._inSync, 2);
                this.setChangeState(this._syncOn, 2);
                this.setDirtyFlag();
            } else {
                this.setChangeState(this._inSync, 1);
                this.setChangeState(this._syncOn, 1);
                this.clearDirtyFlag();
            }
            this.setValidFlag();
            return;
        }
        if (this._saveInSync) {
            bl = true;
        }
        if (bl) {
            this.setChangeState(this._inSync, 2);
            this.setChangeState(this._syncOn, 2);
        } else {
            this.setChangeState(this._inSync, 1);
            this.setChangeState(this._syncOn, 1);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        while (n2 < this._dayButton.length) {
            int n3 = n = this._dayButton[n2].isSelected() != this._saveDay[n2] ? 1 : 0;
            if (n != 0) {
                bl2 = true;
                this.setChangeState(this._dayButton[n2], 2);
            } else {
                this.setChangeState(this._dayButton[n2], 1);
            }
            if (this._dayButton[n2].isSelected()) {
                bl3 = true;
            }
            ++n2;
        }
        if (!bl3) {
            n = 0;
            while (n < this._dayButton.length) {
                this.setChangeState(this._dayButton[n], 3);
                ++n;
            }
        }
        n = 1;
        boolean bl4 = true;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        try {
            n4 = Integer.parseInt(this._saveStartHr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n5 = Integer.parseInt(this._startHr.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n6 = Integer.parseInt(this._saveStartMin);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n7 = Integer.parseInt(this._startMin.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n8 = Integer.parseInt(this._saveEndHr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n9 = Integer.parseInt(this._endHr.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n10 = Integer.parseInt(this._saveEndMin);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n11 = Integer.parseInt(this._endMin.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n7 < 0 || n7 >= 60 || n11 < 0 || n11 >= 60 || n5 < 0 || n5 >= 24 || n9 < 0 || n9 >= 24 || n5 > n9 || n5 == n9 && n7 >= n11) {
            n = 0;
        }
        if (n7 == n6 && n5 == n4 && n11 == n10 && n9 == n8) {
            bl4 = false;
        }
        if (n == 0) {
            this.setChangeState(this._lAnd, 3);
            this.setChangeState(this._lBetween, 3);
        } else if (bl4) {
            this.setChangeState(this._lAnd, 2);
            this.setChangeState(this._lBetween, 2);
        } else {
            this.setChangeState(this._lAnd, 1);
            this.setChangeState(this._lBetween, 1);
        }
        if (bl || bl2 || bl4) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
        if (bl3 && n != 0) {
            this.setValidFlag();
        } else {
            this.clearValidFlag();
        }
    }

    private String createDateString() {
        if (this._inSync.isSelected()) {
            return "";
        }
        return ReplicationTool.createDateString(this._startHr, this._startMin, this._endHr, this._endMin, this._dayButton);
    }
}

