/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.replication.AgreementTable;
import com.netscape.admin.dirserv.panel.replication.MMRAgreement;
import com.netscape.admin.dirserv.panel.replication.ProgressStatusDialog;
import com.netscape.admin.dirserv.panel.replication.ReplicationAgreement;
import com.netscape.admin.dirserv.panel.replication.SIRAgreement;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class AgreementReader
extends Thread {
    private ConsoleInfo _bindInfo;
    private IDSModel _owner;
    private ProgressStatusDialog _dialog;
    private int _type;
    private AgreementTable _agreements;
    private boolean _success = false;
    private String _baseDN = null;
    private static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.panel.replication.replication");

    public AgreementReader(IDSModel iDSModel, AgreementTable agreementTable, String string) {
        this._owner = iDSModel;
        this._bindInfo = iDSModel.getServerInfo();
        this._agreements = agreementTable;
        this._baseDN = string;
    }

    public AgreementReader(ConsoleInfo consoleInfo, AgreementTable agreementTable, String string) {
        this._bindInfo = consoleInfo;
        this._agreements = agreementTable;
        this._baseDN = string;
    }

    public void setDisplay(ProgressStatusDialog progressStatusDialog) {
        this._dialog = progressStatusDialog;
    }

    public boolean isSuccess() {
        return this._success;
    }

    AgreementTable getAgreements() {
        return this._agreements;
    }

    void updateStatus(int n) {
        if (this._dialog != null) {
            this._dialog.setPercent(n);
        }
    }

    public void readAgreements() {
        Debug.println((String)"AgreementReader: start readAgreements()");
        LDAPConnection lDAPConnection = null;
        lDAPConnection = this._bindInfo.getLDAPConnection();
        if (lDAPConnection == null) {
            Debug.println((String)"ERROR: AgreementReader: readAgreements() - Connection Failed");
            this.terminate(_resource.getString("replication", "dialog-cannotConnect"));
            return;
        }
        try {
            this.updateStatus(10);
            Vector vector = this.getFromServer(lDAPConnection, this._baseDN);
            this.updateStatus(50);
            this.processAgreements(vector);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("ERROR: AgreementReader: readAgreements() " + lDAPException.toString()));
            this.terminate(_resource.getString("replication", "dialog-cannotConnect"));
        }
        this._success = true;
        Debug.println((String)"AgreementReader: end readAgreements()");
    }

    public void run() {
        Thread.yield();
        this._success = false;
        this.readAgreements();
        Debug.println((int)8, (String)"AgreementReader: run() - Done Reading...");
        if (this._dialog != null) {
            this._dialog.close();
        }
    }

    private void terminate(String string) {
        if (this._dialog != null) {
            this._dialog.close();
        }
        JFrame jFrame = this._owner != null ? this._owner.getFrame() : null;
        DSUtil.showErrorDialog((Component)jFrame, "error", string, "replication-dialog");
    }

    private Vector getFromServer(LDAPConnection lDAPConnection, String string) throws LDAPException {
        LDAPSearchResults lDAPSearchResults = null;
        String[] stringArray = new String[]{"objectclass"};
        Vector<LDAPEntry> vector = new Vector<LDAPEntry>();
        String string2 = "|(objectclass=nsDS5ReplicationAgreement)(objectclass=LDAPReplica)";
        int n = 2;
        Debug.println((String)"AgreementReader: getFromServer()");
        Debug.println((String)("     Agreement Base DN: " + string));
        Debug.println((String)("     Filter:            " + string2));
        try {
            lDAPSearchResults = lDAPConnection.search(string, n, string2, null, false);
        }
        catch (LDAPException lDAPException) {
            lDAPConnection = null;
            String string3 = lDAPException.getLDAPResultCode() == -1 ? _resource.getString("replication", "err-ReadAgreementsError") : _resource.getString("replication", "err-ReadAgreementsError") + " \n (" + lDAPException.getLDAPResultCode() + ") " + lDAPException.errorCodeToString();
            this.terminate(string3);
        }
        catch (NullPointerException nullPointerException) {
            Debug.println((String)("AgreementReader: getFromServer() " + nullPointerException.toString()));
        }
        boolean bl = false;
        while (lDAPSearchResults != null && lDAPSearchResults.hasMoreElements()) {
            vector.addElement(lDAPSearchResults.next());
        }
        return vector;
    }

    private void processAgreements(Vector vector) {
        int n;
        int n2;
        if (vector.size() == 0) {
            this.updateStatus(100);
            return;
        }
        if (vector.size() >= 50) {
            n2 = vector.size() % 50;
            n = (50 - n2) / 50;
            n2 += 50;
        } else {
            n2 = 50;
            n = 50 / vector.size() + 1;
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            ReplicationAgreement replicationAgreement = this.entry2Agreement((LDAPEntry)vector.elementAt(n3));
            if (replicationAgreement != null) {
                this._agreements.addAgreement(replicationAgreement);
            }
            if (this._dialog != null) {
                if ((n2 += n) >= 100) {
                    this.updateStatus(100);
                    this._success = true;
                } else {
                    this.updateStatus(n2);
                }
            }
            ++n3;
        }
    }

    private ReplicationAgreement entry2Agreement(LDAPEntry lDAPEntry) {
        if (lDAPEntry == null) {
            return null;
        }
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
        if (lDAPAttribute != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.equalsIgnoreCase("LDAPReplica")) {
                    return new SIRAgreement(this._bindInfo, lDAPEntry, null);
                }
                if (!string.equalsIgnoreCase("nsDS5ReplicationAgreement")) continue;
                return new MMRAgreement(this._bindInfo, lDAPEntry, null);
            }
        }
        return null;
    }
}

