/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.DSEntryBoolean;
import com.netscape.admin.dirserv.panel.DSEntryInteger;
import com.netscape.admin.dirserv.panel.DSEntrySet;
import com.netscape.admin.dirserv.panel.DSEntryText;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.task.SnmpCtrl;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ServerSNMPSettingsPanel
extends BlankPanel {
    private JCheckBox _cbSNMPEnabled;
    private JTextField _tfMasterHost;
    private JLabel _lfMasterHost;
    private JTextField _tfMasterPort;
    private JLabel _lfMasterPort;
    private JTextField _tfDescription;
    private JLabel _lfDescription;
    private JTextField _tfOrganization;
    private JLabel _lfOrganization;
    private JTextField _tfLocation;
    private JLabel _lfLocation;
    private JTextField _tfContact;
    private JLabel _lfContact;
    private JButton _bStartAgent;
    private JButton _bStopAgent;
    private JButton _bRestartAgent;
    private DSEntryText _masterHostDSEntry;
    private DSEntryInteger _masterPortDSEntry;
    private DSEntryBoolean _enabledDSEntry;
    private boolean _enabled = true;
    private boolean _isNT = false;
    private static final int PORT_NUM_MAX_VAL = 65535;
    private static final String SNMPSETTINGS_DN = "cn=SNMP,cn=config";
    private static final String SNMP_ENABLED_ATTR_NAM = "nssnmpenabled";
    private static final String SNMP_MASTERHOST_ATTR_NAM = "nssnmpmasterhost";
    private static final String SNMP_MASTERPORT_ATTR_NAM = "nssnmpmasterport";
    private static final String SNMP_DESCRIPTION_ATTR_NAM = "nssnmpdescription";
    private static final String SNMP_ORGANIZATION_ATTR_NAM = "nssnmporganization";
    private static final String SNMP_LOCATION_ATTR_NAM = "nssnmplocation";
    private static final String SNMP_CONTACT_ATTR_NAM = "nssnmpcontact";
    private static ResourceSet _resource = DSUtil._resource;
    private static final String _section = "snmpsettings";

    public ServerSNMPSettingsPanel(IDSModel iDSModel) {
        super(iDSModel, _section);
        this._helpToken = "configuration-system-snmp-help";
        this._refreshWhenSelect = false;
    }

    public void init() {
        JPanel jPanel;
        if (this._isInitialized) {
            return;
        }
        this._isNT = DSUtil.isNT(this.getModel().getServerInfo());
        this._cbSNMPEnabled = this.makeJCheckBox(_section, "snmpenabled");
        this._tfMasterHost = this.makeJTextField(_section, "masterhost");
        this._lfMasterHost = this.makeJLabel(_section, "masterhost");
        this._lfMasterHost.setLabelFor(this._tfMasterHost);
        this._tfMasterPort = this.makeNumericalJTextField(_section, "masterport");
        this._lfMasterPort = this.makeJLabel(_section, "masterport");
        this._lfMasterPort.setLabelFor(this._tfMasterPort);
        this._tfDescription = this.makeJTextField(_section, "description");
        this._lfDescription = this.makeJLabel(_section, "description");
        this._lfDescription.setLabelFor(this._tfDescription);
        this._tfOrganization = this.makeJTextField(_section, "organization");
        this._lfOrganization = this.makeJLabel(_section, "organization");
        this._lfOrganization.setLabelFor(this._tfOrganization);
        this._tfLocation = this.makeJTextField(_section, "location");
        this._lfLocation = this.makeJLabel(_section, "location");
        this._lfLocation.setLabelFor(this._tfLocation);
        this._tfContact = this.makeJTextField(_section, "contact");
        this._lfContact = this.makeJLabel(_section, "contact");
        this._lfContact.setLabelFor(this._tfContact);
        String string = this._isNT ? "snmp" : "agent";
        this._bStartAgent = this.makeJButton(_section, "subagent-start" + string);
        this._bStopAgent = this.makeJButton(_section, "subagent-stop" + string);
        this._bRestartAgent = this.makeJButton(_section, "subagent-restart" + string);
        DSEntrySet dSEntrySet = new DSEntrySet(false);
        this.setDSEntrySet(dSEntrySet);
        this._enabledDSEntry = new DSEntryBoolean("0", this._cbSNMPEnabled);
        dSEntrySet.add(SNMPSETTINGS_DN, SNMP_ENABLED_ATTR_NAM, this._enabledDSEntry);
        this.setComponentTable(this._cbSNMPEnabled, this._enabledDSEntry);
        this._masterHostDSEntry = new DSEntryText("", this._tfMasterHost, this._lfMasterHost);
        dSEntrySet.add(SNMPSETTINGS_DN, SNMP_MASTERHOST_ATTR_NAM, this._masterHostDSEntry);
        this.setComponentTable(this._tfMasterHost, this._masterHostDSEntry);
        this._masterPortDSEntry = new DSEntryInteger("", this._tfMasterPort, this._lfMasterPort, 1, 65535, 1, true);
        dSEntrySet.add(SNMPSETTINGS_DN, SNMP_MASTERPORT_ATTR_NAM, this._masterPortDSEntry);
        this.setComponentTable(this._tfMasterPort, this._masterPortDSEntry);
        DSEntryText dSEntryText = new DSEntryText("", this._tfDescription, this._lfDescription);
        dSEntrySet.add(SNMPSETTINGS_DN, SNMP_DESCRIPTION_ATTR_NAM, dSEntryText);
        this.setComponentTable(this._tfDescription, dSEntryText);
        DSEntryText dSEntryText2 = new DSEntryText("", this._tfOrganization, this._lfOrganization);
        dSEntrySet.add(SNMPSETTINGS_DN, SNMP_ORGANIZATION_ATTR_NAM, dSEntryText2);
        this.setComponentTable(this._tfOrganization, dSEntryText2);
        DSEntryText dSEntryText3 = new DSEntryText("", this._tfLocation, this._lfLocation);
        dSEntrySet.add(SNMPSETTINGS_DN, SNMP_LOCATION_ATTR_NAM, dSEntryText3);
        this.setComponentTable(this._tfLocation, dSEntryText3);
        DSEntryText dSEntryText4 = new DSEntryText("", this._tfContact, this._lfContact);
        dSEntrySet.add(SNMPSETTINGS_DN, SNMP_CONTACT_ATTR_NAM, dSEntryText4);
        this.setComponentTable(this._tfContact, dSEntryText4);
        JPanel jPanel2 = this._myPanel;
        jPanel2.setLayout(new GridBagLayout());
        this.addEntryField(jPanel2, new JLabel(" "), this._cbSNMPEnabled);
        if (!this._isNT) {
            jPanel = new GroupPanel(_resource.getString(_section, "masteragent-title"));
            jPanel.setLayout(new GridBagLayout());
            this.addEntryField(jPanel, this._lfMasterHost, this._tfMasterHost);
            this.addEntryField(jPanel, this._lfMasterPort, this._tfMasterPort);
            this.resetGBC();
            this._gbc.weightx = 1.0;
            this._gbc.gridwidth = 0;
            this._gbc.fill = 2;
            this._gbc.insets.bottom = UIFactory.getComponentSpace();
            jPanel2.add((Component)jPanel, this._gbc);
        }
        jPanel = new GroupPanel(_resource.getString(_section, "othersettings-title"));
        jPanel.setLayout(new GridBagLayout());
        this.addEntryField(jPanel, this._lfDescription, this._tfDescription);
        this.addEntryField(jPanel, this._lfOrganization, this._tfOrganization);
        this.addEntryField(jPanel, this._lfLocation, this._tfLocation);
        this.addEntryField(jPanel, this._lfContact, this._tfContact);
        this.resetGBC();
        this._gbc.weightx = 1.0;
        this._gbc.gridwidth = 0;
        this._gbc.fill = 2;
        this._gbc.insets.bottom = UIFactory.getComponentSpace();
        jPanel2.add((Component)jPanel, this._gbc);
        this.resetGBC();
        jPanel = jPanel2;
        JButton[] jButtonArray = new JButton[]{this._bStartAgent, this._bStopAgent, this._bRestartAgent};
        JPanel jPanel3 = UIFactory.makeJButtonPanel(jButtonArray);
        this._gbc.gridx = 0;
        this._gbc.weightx = 1.0;
        this._gbc.gridwidth = 0;
        this._gbc.anchor = 17;
        jPanel.add((Component)jPanel3, this._gbc);
        this.addBottomGlue();
        this._isInitialized = true;
    }

    public boolean refresh() {
        boolean bl = super.refresh();
        this._enabled = this._cbSNMPEnabled.isSelected();
        this.enableFields(this._enabled);
        this.updateStart();
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.getModel().setWaitCursor(true);
        if (actionEvent.getSource().equals(this._cbSNMPEnabled)) {
            super.actionPerformed(actionEvent);
            boolean bl = this._cbSNMPEnabled.isSelected();
            this.enableFields(bl);
        } else if (actionEvent.getSource().equals(this._bStartAgent)) {
            this.runSnmpCtrl("START");
        } else if (actionEvent.getSource().equals(this._bStopAgent)) {
            this.runSnmpCtrl("STOP");
        } else if (actionEvent.getSource().equals(this._bRestartAgent)) {
            this.runSnmpCtrl("RESTART");
        }
        this.getModel().setWaitCursor(false);
    }

    public void okCallback() {
        super.okCallback();
        this._enabled = this._cbSNMPEnabled.isSelected();
        this.updateStart();
    }

    private void updateStart() {
        boolean bl;
        boolean bl2 = bl = this._enabled && (this._isNT || this._masterHostDSEntry.getModel(0) != null && this._masterHostDSEntry.getModel(0).trim().length() > 0 && this._masterPortDSEntry.getModel(0) != null && this._masterPortDSEntry.getModel(0).length() > 0);
        if (bl && !this._isNT) {
            try {
                int n = Integer.parseInt(this._masterPortDSEntry.getModel(0));
                bl = n > 0 && n <= 65535;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        this._bStartAgent.setEnabled(bl);
        this._bRestartAgent.setEnabled(bl);
    }

    private void enableFields(boolean bl) {
        bl = !this._disabled && bl;
        this._tfMasterHost.setEnabled(bl);
        this._lfMasterHost.setEnabled(bl);
        this._lfMasterHost.repaint();
        this._tfMasterPort.setEnabled(bl);
        this._lfMasterPort.setEnabled(bl);
        this._lfMasterPort.repaint();
        this._tfDescription.setEnabled(bl);
        this._lfDescription.setEnabled(bl);
        this._lfDescription.repaint();
        this._tfOrganization.setEnabled(bl);
        this._lfOrganization.setEnabled(bl);
        this._lfOrganization.repaint();
        this._tfLocation.setEnabled(bl);
        this._lfLocation.setEnabled(bl);
        this._lfLocation.repaint();
        this._tfContact.setEnabled(bl);
        this._lfContact.setEnabled(bl);
        this._lfContact.repaint();
        this.updateStart();
    }

    private void runSnmpCtrl(String string) {
        SnmpCtrl snmpCtrl = new SnmpCtrl(string, this.getModel().getServerInfo());
        boolean bl = snmpCtrl.exec();
    }
}

