/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.DSEntryInteger;
import com.netscape.admin.dirserv.panel.DSEntrySet;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import netscape.ldap.LDAPException;

public class ServerPerformancePanel
extends BlankPanel {
    private JTextField _tfSizeLimit;
    private JLabel _lSizeLimit;
    private JTextField _tfTimeLimit;
    private JLabel _lTimeLimit;
    private JTextField _tfIdleTimeOut;
    private JLabel _lIdleTimeOut;
    private JTextField _tfMaxDescriptors;
    private JLabel _lMaxDescriptors;
    private JCheckBox _cbIsReadOnly;
    private DSEntryInteger _maxDescDSEntry;
    private static final String SERVERSETTINGS_DN = "cn=config";
    private static final int INT_MAX_VAL = Integer.MAX_VALUE;
    private static final String TIME_LIMIT_ATTR_NAM = "nsslapd-timeLimit";
    private static final String SIZE_LIMIT_ATTR_NAM = "nsslapd-sizelimit";
    private static final String LOOK_LIMIT_ATTR_NAM = "nsslapd-looklimit";
    private static final String IDLE_TIME_OUT_ATTR_NAM = "nsslapd-idletimeout";
    private static final String MAX_DESCRIPTORS_ATTR_NAM = "nsslapd-maxdescriptors";
    private static final String READ_ONLY_ATTR_NAM = "nsslapd-readonly";
    private int MAX_DESCRIPTORS = 65536;
    private static final int PORT_NUM_MIN_VAL = 1;
    private static final int PORT_NUM_MAX_VAL = 65535;
    private ResourceSet _resource = DSUtil._resource;
    private static final String _section = "serverperformance";

    public ServerPerformancePanel(IDSModel iDSModel) {
        super(iDSModel, _section);
        this._helpToken = "configuration-system-performance-help";
        this._refreshWhenSelect = false;
    }

    public void init() {
        if (this._isInitialized) {
            return;
        }
        boolean bl = true;
        String string = this.getModel().getServerInfo().getAdminOS();
        if (string.startsWith("Windows NT") || string.indexOf("AIX") != -1) {
            bl = false;
        }
        this._tfSizeLimit = this.makeNumericalJTextField(_section, "sizeLimit");
        JLabel jLabel = this.makeJLabel(_section, "sizeLimit");
        jLabel.setLabelFor(this._tfSizeLimit);
        JLabel jLabel2 = this.makeJLabel(_section, "sizeLimit-unit");
        jLabel2.setLabelFor(this._tfSizeLimit);
        this._tfTimeLimit = this.makeNumericalJTextField(_section, "timeLimit");
        this._lTimeLimit = this.makeJLabel(_section, "timeLimit");
        this._lTimeLimit.setLabelFor(this._tfTimeLimit);
        JLabel jLabel3 = this.makeJLabel(_section, "timeLimit-unit");
        jLabel3.setLabelFor(this._tfTimeLimit);
        this._tfIdleTimeOut = this.makeNumericalJTextField(_section, "idletimeout");
        JLabel jLabel4 = this.makeJLabel(_section, "idletimeout");
        jLabel4.setLabelFor(this._tfIdleTimeOut);
        JLabel jLabel5 = this.makeJLabel(_section, "idletimeout-unit");
        jLabel5.setLabelFor(this._tfIdleTimeOut);
        if (bl) {
            this._tfMaxDescriptors = this.makeJTextField(_section, "maxdescriptors");
            this._tfMaxDescriptors.setHorizontalAlignment(2);
            this._lMaxDescriptors = this.makeJLabel(_section, "maxdescriptors");
            this._lMaxDescriptors.setLabelFor(this._tfMaxDescriptors);
        }
        DSEntrySet dSEntrySet = this.getDSEntrySet();
        DSEntryInteger dSEntryInteger = new DSEntryInteger(null, (JComponent)this._tfSizeLimit, jLabel, -1, Integer.MAX_VALUE, 1);
        dSEntrySet.add(SERVERSETTINGS_DN, SIZE_LIMIT_ATTR_NAM, dSEntryInteger);
        this.setComponentTable(this._tfSizeLimit, dSEntryInteger);
        DSEntryInteger dSEntryInteger2 = new DSEntryInteger(null, (JComponent)this._tfTimeLimit, this._lTimeLimit, -1, Integer.MAX_VALUE, 1);
        dSEntrySet.add(SERVERSETTINGS_DN, TIME_LIMIT_ATTR_NAM, dSEntryInteger2);
        this.setComponentTable(this._tfTimeLimit, dSEntryInteger2);
        DSEntryInteger dSEntryInteger3 = new DSEntryInteger(null, (JComponent)this._tfIdleTimeOut, jLabel4, 0, Integer.MAX_VALUE, 1);
        dSEntrySet.add(SERVERSETTINGS_DN, IDLE_TIME_OUT_ATTR_NAM, dSEntryInteger3);
        this.setComponentTable(this._tfIdleTimeOut, dSEntryInteger3);
        if (bl) {
            this._maxDescDSEntry = new DSEntryInteger(null, (JComponent)this._tfMaxDescriptors, this._lMaxDescriptors, 1, this.MAX_DESCRIPTORS, 1);
            dSEntrySet.add(SERVERSETTINGS_DN, MAX_DESCRIPTORS_ATTR_NAM, this._maxDescDSEntry);
            this.setComponentTable(this._tfMaxDescriptors, this._maxDescDSEntry);
        }
        JPanel jPanel = this._myPanel;
        jPanel.setLayout(new GridBagLayout());
        this.addEntryField(jPanel, jLabel, this._tfSizeLimit, jLabel2);
        this.addEntryField(jPanel, this._lTimeLimit, this._tfTimeLimit, jLabel3);
        this.addEntryField(jPanel, jLabel4, this._tfIdleTimeOut, jLabel5);
        if (bl) {
            this.addEntryField(jPanel, this._lMaxDescriptors, this._tfMaxDescriptors);
        }
        this.addBottomGlue();
        this._isInitialized = true;
    }

    protected boolean processSaveErrors(LDAPException lDAPException) {
        int n;
        String string;
        if (lDAPException.getLDAPResultCode() == 53 && (string = lDAPException.getLDAPErrorMessage()) != null && string.indexOf("maxdescriptors") > 0 && (n = string.indexOf(" (the current process limit)")) >= 0) {
            int n2 = n;
            while (string.charAt(n2) == ' ') {
                --n2;
            }
            while (string.charAt(n2) != ' ') {
                --n2;
            }
            String string2 = string.substring(n2 + 1, n);
            try {
                this.MAX_DESCRIPTORS = Integer.parseInt(string2);
                this._maxDescDSEntry.setMaxValue(this.MAX_DESCRIPTORS);
                this.actionPerformed(new ActionEvent(this, 1, "VALIDATE"));
                this.setDirtyFlag();
            }
            catch (Exception exception) {
                Debug.println((String)("ServerPerformancePanel.processSaveErrors: parsing <" + string2 + ">, " + exception));
            }
            String[] stringArray = new String[]{this._tfMaxDescriptors.getText().trim(), string2};
            DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "104", stringArray);
            return false;
        }
        return super.processSaveErrors(lDAPException);
    }
}

