/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.admin.dirserv.task.ListDB;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;

public class RestorePanel
extends BlankPanel {
    private JComboBox _comboNames;
    private JTextField _tfExport;
    private JButton _bExport;
    private String _baseDir = "";
    private boolean _initialized = false;
    private static final String _section = "restore";

    public RestorePanel(IDSModel iDSModel) {
        super(iDSModel, _section);
        this._helpToken = "tasks-restore-help";
    }

    public void init() {
        if (!this._initialized) {
            SimpleDialog simpleDialog;
            ListDB listDB = new ListDB(this.getModel().getServerInfo());
            this.getModel().setWaitCursor(true);
            String[] stringArray = listDB.getBackupList();
            this.getModel().setWaitCursor(false);
            this._myPanel.setLayout(new GridBagLayout());
            this.createFileArea(this._myPanel, stringArray);
            String string = this.getInstanceDirectory();
            if (string != null) {
                this._baseDir = string + "/bak";
            }
            if ((simpleDialog = this.getSimpleDialog()) != null) {
                simpleDialog.setFocusComponent(this._tfExport);
            }
            this._initialized = true;
        }
    }

    protected void createFileArea(JPanel jPanel, String[] stringArray) {
        String string;
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.insets.bottom = this._gbc.insets.top;
        gridBagConstraints.gridwidth = 0;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this._comboNames = new JComboBox();
        this._comboNames.addItemListener(this);
        this._comboNames.addActionListener(this);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this._comboNames.addItem(stringArray[n]);
                ++n;
            }
            if (stringArray.length > 0) {
                this._comboNames.setSelectedIndex(0);
            }
        }
        if ((string = DSUtil._resource.getString(_section, "backups-ttip")) != null) {
            this._comboNames.setToolTipText(string);
        }
        JLabel jLabel = this.makeJLabel(_section, "backups");
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        jLabel.setLabelFor(this._comboNames);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this._comboNames, gridBagConstraints);
        JLabel jLabel2 = this.makeJLabel(_section, "filename");
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        this._tfExport = this.makeJTextField(_section, "filename");
        jLabel2.setLabelFor(this._tfExport);
        if (stringArray.length > 0) {
            this._tfExport.setText((String)this._comboNames.getSelectedItem());
            this.setOkay(true);
        } else {
            this.setOkay(false);
        }
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this._tfExport, gridBagConstraints);
        this._bExport = this.makeJButton(_section, "browse-file");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this._bExport, gridBagConstraints);
        this._bExport.setEnabled(this.isLocal());
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        jPanel.add(Box.createGlue(), gridBagConstraints);
    }

    private void setOkay(boolean bl) {
        SimpleDialog simpleDialog = this.getSimpleDialog();
        if (simpleDialog != null) {
            simpleDialog.setOKButtonEnabled(bl);
        }
    }

    private void checkOkay() {
        String string = this.getFilename();
        boolean bl = string != null && string.length() > 0;
        this.setOkay(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._bExport)) {
            String string = this.getFilename().trim();
            if (string != null && string.length() > 1) {
                File file = new File(string);
                if (!file.isAbsolute()) {
                    string = this._baseDir + File.separator + string;
                }
            } else {
                string = this._baseDir;
            }
            if ((string = DSFileDialog.getDirectoryName(string, true, this)) != null) {
                this._tfExport.setText(string.trim());
            }
        } else if (actionEvent.getSource().equals(this._comboNames)) {
            if (this._tfExport != null) {
                this._tfExport.setText((String)this._comboNames.getSelectedItem());
                this.checkOkay();
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void resetCallback() {
        this.clearDirtyFlag();
        this.hideDialog();
    }

    public void okCallback() {
        String string;
        int n = DSUtil.showConfirmationDialog((Component)this.getModel().getFrame(), "offlinePartition", (String[])null, "LDAPTask");
        if (n != 0) {
            return;
        }
        if (this.isLocal() && (string = this.getFilename()) != null) {
            File file = new File(string);
            if (!file.isAbsolute()) {
                string = this._baseDir + File.separator + string;
            }
            this._tfExport.setText(string);
        }
        this.clearDirtyFlag();
        this.hideDialog();
    }

    public String getFilename() {
        return this._tfExport.getText().trim();
    }

    public void setFileName(String string) {
        this._tfExport.setText(string);
    }

    protected SimpleDialog getSimpleDialog() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof SimpleDialog) {
                return (SimpleDialog)((Object)container);
            }
            container = container.getParent();
        }
        return null;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (this._tfExport.getText().trim().equals("")) {
            this.setOkay(false);
        } else {
            this.setOkay(true);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }
}

