/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.CustomDetailTable;
import com.netscape.admin.dirserv.panel.RefreshablePanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.panel.replication.AgreementReader;
import com.netscape.admin.dirserv.panel.replication.AgreementTable;
import com.netscape.admin.dirserv.panel.replication.ReplicationAgreement;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.management.client.components.Table;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class ReplicationStatusPanel
extends RefreshablePanel {
    private AgreementTableModel _repModel;
    private JScrollPane _scrollPane;
    private CustomDetailTable _repTable;
    private AgreementTable _agreementTable;
    private ImageIcon _icon;
    private static final int[] TABLE_WIDTHS = new int[]{120, 120, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.panel.replication.replication");
    private static final String _errorImage = "red-ball-small.gif";
    private static final String _taskImage = "task.gif";
    private static final String _okImage = "green-ball-small.gif";
    private static final String _hostImage = "DirectoryServer.gif";
    private static final String[] HEADERS = new String[]{_resource.getString("replication-statusTab-columnName-Name", "label"), _resource.getString("replication-statusTab-columnName-Subtree", "label"), _resource.getString("replication-statusTab-columnName-Consumer", "label"), _resource.getString("replication-statusTab-columnName-Supplier", "label"), _resource.getString("replication-statusTab-columnName-nChangesLast", "label"), _resource.getString("replication-statusTab-columnName-lastUpdateBegin", "label"), _resource.getString("replication-statusTab-columnName-lastUpdateEnd", "label"), _resource.getString("replication-statusTab-columnName-Status", "label"), _resource.getString("replication-statusTab-columnName-consumerInitializationInProgress", "label"), _resource.getString("replication-statusTab-columnName-consumerInitializationStatus", "label"), _resource.getString("replication-statusTab-columnName-consumerInitializationBegin", "label"), _resource.getString("replication-statusTab-columnName-consumerInitializationEnd", "label")};

    public ReplicationStatusPanel(IDSModel iDSModel, String string) {
        super(iDSModel, string, false);
        this._helpToken = "status-replication-help";
        this._agreementTable = new AgreementTable();
        this.init();
    }

    public void init() {
        if (this._isInitialized) {
            return;
        }
        Debug.println((String)"ReplicationStatusPanel.init");
        this._myPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Font font = jPanel.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize());
        jPanel.setFont(font2);
        this._myPanel.add("Center", jPanel);
        JPanel jPanel2 = jPanel;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel3 = this.createRefreshArea();
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.gridx = 0;
        int n = UIFactory.getDifferentSpace();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        this._repModel = new AgreementTableModel();
        int n2 = 0;
        while (n2 < HEADERS.length) {
            this._repModel.addColumn(HEADERS[n2]);
            ++n2;
        }
        this._repTable = new CustomDetailTable(this._repModel);
        Table table = this._repTable.getTable();
        table.getTableHeader().setReorderingAllowed(false);
        table.setAutoResizeMode(1);
        table.setRequestFocusEnabled(true);
        table.setRowSelectionAllowed(true);
        table.setColumnSelectionAllowed(false);
        table.setSelectionMode(0);
        table.getAccessibleContext().setAccessibleDescription(_resource.getString("replication-statusTab", "table-description"));
        int n3 = 0;
        while (n3 < 3) {
            TableColumn tableColumn = table.getColumn(HEADERS[n3]);
            tableColumn.setCellRenderer(new DefaultTableCellRenderer());
            tableColumn.setPreferredWidth(TABLE_WIDTHS[n3]);
            tableColumn.setResizable(true);
            ++n3;
        }
        int n4 = 3;
        while (n4 < HEADERS.length) {
            TableColumn tableColumn = table.getColumn(HEADERS[n4]);
            tableColumn.setCellRenderer(new DefaultTableCellRenderer());
            tableColumn.setResizable(false);
            tableColumn.setMinWidth(0);
            tableColumn.setMaxWidth(0);
            tableColumn.setPreferredWidth(0);
            ++n4;
        }
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)((Object)this._repTable), gridBagConstraints);
        this.refreshAgreement();
        if (table.getRowCount() > 0) {
            table.setRowSelectionInterval(0, 0);
            this._repTable.updateRow(0);
        }
        this._isInitialized = true;
    }

    public boolean refresh() {
        this.getModel().setWaitCursor(true);
        Debug.println((int)6, (String)"ReplicationStatusPanel.refresh()");
        if (ReplicationTool.authenticate(this.getModel())) {
            Table table = this._repTable.getTable();
            int n = table.getSelectedRow();
            Object object = null;
            if (n >= 0) {
                object = this._repModel.getValueAt(n, 0);
            }
            this.refreshAgreement();
            int n2 = this._repModel.getRowCount();
            n = 0;
            if (object != null) {
                int n3 = 0;
                while (n3 < n2) {
                    if (object.equals(this._repModel.getValueAt(n3, 0))) {
                        n = n3;
                        break;
                    }
                    ++n3;
                }
            }
            if (table.getRowCount() > n) {
                table.setRowSelectionInterval(n, n);
                this._repTable.updateRow(n);
            }
        }
        this.getModel().setWaitCursor(false);
        return true;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
    }

    public void removeUpdate(DocumentEvent documentEvent) {
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    private void refreshAgreement() {
        AgreementReader agreementReader = new AgreementReader(this.getModel().getServerInfo(), this._agreementTable, "cn=mapping tree,cn=config");
        this._agreementTable.removeAllElements();
        this._repModel.removeAllRows();
        agreementReader.readAgreements();
        if (agreementReader.isSuccess()) {
            Enumeration enumeration = this._agreementTable.elements();
            while (enumeration.hasMoreElements()) {
                ReplicationAgreement replicationAgreement = (ReplicationAgreement)enumeration.nextElement();
                this._repModel.addRow(this.createRow(replicationAgreement));
            }
        }
    }

    private Vector createRow(ReplicationAgreement replicationAgreement) {
        replicationAgreement.updateReplicaStatus();
        Vector<JLabel> vector = new Vector<JLabel>();
        RemoteImage remoteImage = null;
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        if (bl) {
            remoteImage = DSUtil.getPackageImage(_taskImage);
            bl2 = true;
            string = _resource.getString("replication-statusTab-unknown", "label");
        } else if (replicationAgreement.getInProgress().equalsIgnoreCase("true")) {
            remoteImage = DSUtil.getPackageImage(_taskImage);
            bl2 = true;
        } else {
            remoteImage = DSUtil.getPackageImage(_okImage);
        }
        JLabel jLabel = new JLabel(replicationAgreement.getNickname(), (Icon)remoteImage, 2);
        jLabel.setToolTipText(replicationAgreement.getNickname());
        vector.addElement(jLabel);
        JLabel jLabel2 = new JLabel(replicationAgreement.getReplicatedSubtree(), (Icon)remoteImage, 2);
        jLabel2.setToolTipText(_resource.getString("replication-content-replicate", "label") + replicationAgreement.getReplicatedSubtree());
        vector.addElement(jLabel2);
        JLabel jLabel3 = new JLabel(replicationAgreement.getConsumerHost() + ":" + replicationAgreement.getConsumerPort(), (Icon)DSUtil.getPackageImage(_hostImage), 2);
        jLabel3.setToolTipText(_resource.getString("replication-content-replicate", "label") + replicationAgreement.getReplicatedSubtree());
        vector.addElement(jLabel3);
        JLabel jLabel4 = new JLabel(replicationAgreement.getSupplierHost() + ":" + replicationAgreement.getSupplierPort(), (Icon)DSUtil.getPackageImage(_hostImage), 2);
        jLabel4.setToolTipText(_resource.getString("replication-content-replicate", "label") + replicationAgreement.getReplicatedSubtree());
        vector.addElement(jLabel4);
        JLabel jLabel5 = new JLabel(replicationAgreement.getNChangesLast(), 2);
        if (bl2) {
            jLabel5.setForeground(Color.red);
        }
        vector.addElement(jLabel5);
        JLabel jLabel6 = new JLabel(replicationAgreement.getLastUpdateBegin(), 2);
        if (bl2) {
            jLabel6.setForeground(Color.red);
        }
        vector.addElement(jLabel6);
        JLabel jLabel7 = new JLabel(replicationAgreement.getLastUpdateEnd(), 2);
        if (bl2) {
            jLabel7.setForeground(Color.red);
        }
        vector.addElement(jLabel7);
        JLabel jLabel8 = new JLabel(ReplicationTool.convertStatusMessage(replicationAgreement.getLastUpdateStatus()), 2);
        vector.addElement(jLabel8);
        JLabel jLabel9 = new JLabel(replicationAgreement.getConsumerInitializationInProgress(), 2);
        vector.addElement(jLabel9);
        JLabel jLabel10 = new JLabel(ReplicationTool.convertStatusMessage(replicationAgreement.getConsumerInitializationStatus()), 2);
        vector.addElement(jLabel10);
        JLabel jLabel11 = new JLabel(replicationAgreement.getConsumerInitializationBegin(), 2);
        vector.addElement(jLabel11);
        JLabel jLabel12 = new JLabel(replicationAgreement.getConsumerInitializationEnd(), 2);
        vector.addElement(jLabel12);
        return vector;
    }

    class AgreementTableModel
    extends AbstractTableModel {
        private Vector _columnNames = new Vector();
        private Vector _tableColumns = new Vector();

        AgreementTableModel() {
        }

        public int getColumnCount() {
            return this._columnNames.size();
        }

        public int getRowCount() {
            if (this.getColumnCount() > 0) {
                Vector vector = (Vector)this._tableColumns.elementAt(0);
                return vector.size();
            }
            return 0;
        }

        public String getColumnName(int n) {
            if (n >= this._columnNames.size()) {
                return "";
            }
            return (String)this._columnNames.elementAt(n);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            Vector vector = (Vector)this._tableColumns.elementAt(n2);
            vector.setElementAt(object, n);
        }

        public Object getValueAt(int n, int n2) {
            Vector vector;
            if (this.getColumnCount() > 0 && n2 < this._tableColumns.size() && n < (vector = (Vector)this._tableColumns.elementAt(n2)).size()) {
                Object e = vector.elementAt(n);
                if (e != null && e instanceof JLabel) {
                    return ((JLabel)e).getText();
                }
                return e;
            }
            return null;
        }

        void removeAllRows() {
            int n = 0;
            while (n < this._tableColumns.size()) {
                Vector vector = (Vector)this._tableColumns.elementAt(n);
                vector.removeAllElements();
                ++n;
            }
        }

        void addRow(Vector vector) {
            int n = 0;
            int n2 = 0;
            while (n2 < vector.size()) {
                Vector vector2 = (Vector)this._tableColumns.elementAt(n2);
                vector2.addElement(vector.elementAt(n2));
                if (n2 == 0) {
                    n = vector2.size() - 1;
                }
                ++n2;
            }
        }

        void addColumn(String string) {
            this._columnNames.addElement(string);
            this._tableColumns.addElement(new Vector());
        }

        public Class getColumnClass(int n) {
            Object object;
            Class<?> clazz = null;
            if (this.getColumnCount() > 0 && this._tableColumns != null && (object = (Vector)this._tableColumns.elementAt(n)) != null && ((Vector)object).size() > 0) {
                clazz = ((Vector)object).elementAt(0).getClass();
            }
            if (clazz == null) {
                object = "";
                clazz = object.getClass();
            }
            return clazz;
        }
    }
}

