/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSSchemaHelper;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.ArrowIcon;
import com.netscape.admin.dirserv.panel.OCCellRenderer;
import com.netscape.admin.dirserv.panel.SchemaUtility;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UITools;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSchemaElement;

public class ObjectClassDialog
extends AbstractDialog
implements ActionListener,
DocumentListener,
ListSelectionListener,
ItemListener {
    private int _status;
    private boolean _result = false;
    private JList _availAttrListBox;
    private JList _reqAttrListBox;
    private JList _allowAttrListBox;
    private JButton _OKButton;
    private JButton _cancelButton;
    private JButton _helpButton;
    private JButton removeReqButton;
    private JButton removeAllowButton;
    private JTextField _nameText;
    private JTextField _oidText;
    private IDSModel _model;
    private boolean _update;
    private LDAPSchema _schema;
    private JComboBox _ocComboBox;
    private DefaultListModel _availModel = new DefaultListModel();
    private DefaultListModel _reqAttrModel = new DefaultListModel();
    private DefaultListModel _allowAttrModel = new DefaultListModel();
    private Vector _extendedReqAttrVector = new Vector();
    private Vector _extendedAllowAttrVector = new Vector();
    private String _noParent = null;
    private LDAPObjectClassSchema _origEntry;
    private static final String REQ_ADD_STR = "ReqAdd";
    private static final String REQ_REMOVE_STR = "ReqRemove";
    private static final String ALLOW_ADD_STR = "AllowAdd";
    private static final String ALLOW_REMOVE_STR = "AllowRemove";
    private static final String OID_UNKNOWN_STR = "OID Unknown";
    private static final String _helpToken = "configuration-schema-objclass-create-dbox-help";
    private static final String _section = "objectclasses";
    ResourceSet _resource = DSUtil._resource;
    protected static final String _validsyntax = "abcdefghijklmnopqrstuvwxyz0123456789-_";

    public ObjectClassDialog(IDSModel iDSModel, boolean bl, LDAPSchema lDAPSchema) {
        super((Frame)iDSModel.getFrame(), true);
        this.initialize(iDSModel, bl, null, lDAPSchema);
        ((Dialog)((Object)this)).setTitle(this._resource.getString(_section, "create-title"));
        ((JDialog)((Object)this)).getAccessibleContext().setAccessibleDescription(this._resource.getString(_section, "create-description"));
    }

    public ObjectClassDialog(IDSModel iDSModel, boolean bl, LDAPObjectClassSchema lDAPObjectClassSchema, LDAPSchema lDAPSchema) {
        super((Frame)iDSModel.getFrame(), true);
        this.initialize(iDSModel, bl, lDAPObjectClassSchema, lDAPSchema);
        ((Dialog)((Object)this)).setTitle(this._resource.getString(_section, "edit-title"));
        ((JDialog)((Object)this)).getAccessibleContext().setAccessibleDescription(this._resource.getString(_section, "edit-description"));
    }

    public String getObject() {
        if (this._result) {
            return this._nameText.getText();
        }
        return null;
    }

    private void initialize(IDSModel iDSModel, boolean bl, LDAPObjectClassSchema lDAPObjectClassSchema, LDAPSchema lDAPSchema) {
        this._model = iDSModel;
        this._update = bl;
        this._schema = lDAPSchema;
        this._noParent = "top";
        ((Component)((Object)this)).setSize(500, 500);
        ((Dialog)((Object)this)).setResizable(true);
        this._origEntry = lDAPObjectClassSchema == null ? this._schema.getObjectClass("top") : this._schema.getObjectClass(lDAPObjectClassSchema.getName());
        this.updateAvailAttrList();
        this.init(lDAPObjectClassSchema);
        ((JDialog)((Object)this)).setContentPane(this.createDialogContent());
        ((Window)((Object)this)).setLocationRelativeTo(iDSModel.getFrame());
        ((Window)((Object)this)).addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ObjectClassDialog.this.dispose();
                DSUtil.dialogCleanup();
            }
        });
        this.checkOkay();
    }

    private void updateAvailAttrList() {
        if (this._availModel.size() != 0) {
            this._availModel.removeAllElements();
        }
        Enumeration enumeration = this._schema.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            SchemaUtility.InsertElement(this._availModel, enumeration.nextElement());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!(actionEvent.getSource() instanceof JButton) && !actionEvent.getActionCommand().equals("close")) {
            return;
        }
        this.setBusyCursor(true);
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton.getActionCommand().equals(REQ_ADD_STR)) {
            Object[] objectArray = this._availAttrListBox.getSelectedValues();
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    this._availModel.removeElement(objectArray[n]);
                    SchemaUtility.InsertElement(this._reqAttrModel, objectArray[n]);
                    this._reqAttrListBox.setSelectedValue(objectArray[n], true);
                    this._extendedReqAttrVector.addElement(objectArray[n]);
                    ++n;
                }
                this._availAttrListBox.clearSelection();
                this.redrawListBox(this._reqAttrListBox);
                this.redrawListBox(this._availAttrListBox);
                this._reqAttrListBox.clearSelection();
            }
            this.checkOkay();
        } else if (jButton.getActionCommand().equals(REQ_REMOVE_STR)) {
            Object[] objectArray = this._reqAttrListBox.getSelectedValues();
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    this._reqAttrModel.removeElement(objectArray[n]);
                    SchemaUtility.InsertElement(this._availModel, objectArray[n]);
                    this._availAttrListBox.setSelectedValue(objectArray[n], true);
                    this._extendedReqAttrVector.remove(objectArray[n]);
                    ++n;
                }
                this._reqAttrListBox.clearSelection();
                this.redrawListBox(this._reqAttrListBox);
                this.updateReqRemoveButton();
                this.redrawListBox(this._availAttrListBox);
            }
            this.checkOkay();
        } else if (jButton.getActionCommand().equals(ALLOW_ADD_STR)) {
            Object[] objectArray = this._availAttrListBox.getSelectedValues();
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    this._availModel.removeElement(objectArray[n]);
                    SchemaUtility.InsertElement(this._allowAttrModel, objectArray[n]);
                    this._allowAttrListBox.setSelectedValue(objectArray[n], true);
                    this._extendedAllowAttrVector.addElement(objectArray[n]);
                    ++n;
                }
                this._availAttrListBox.clearSelection();
                this.redrawListBox(this._allowAttrListBox);
                this.redrawListBox(this._availAttrListBox);
                this._allowAttrListBox.clearSelection();
            }
            this.checkOkay();
        } else if (jButton.getActionCommand().equals(ALLOW_REMOVE_STR)) {
            Object[] objectArray = this._allowAttrListBox.getSelectedValues();
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    this._allowAttrModel.removeElement(objectArray[n]);
                    SchemaUtility.InsertElement(this._availModel, objectArray[n]);
                    this._availAttrListBox.setSelectedValue(objectArray[n], true);
                    this._extendedAllowAttrVector.remove(objectArray[n]);
                    ++n;
                }
                this._allowAttrListBox.clearSelection();
                this.redrawListBox(this._allowAttrListBox);
                this.updateAllowRemoveButton();
                this.redrawListBox(this._availAttrListBox);
            }
            this.checkOkay();
        } else if (jButton.equals(this._OKButton)) {
            if (this.updateOC()) {
                this._result = true;
                ((Component)((Object)this)).setVisible(false);
                this.dispose();
                DSUtil.dialogCleanup();
            }
        } else if (jButton.equals(this._cancelButton) || actionEvent.getActionCommand().equals("close")) {
            this._result = false;
            ((Component)((Object)this)).setVisible(false);
            this.dispose();
            DSUtil.dialogCleanup();
        } else if (jButton.equals(this._helpButton)) {
            DSUtil.help(_helpToken);
        }
        this.setBusyCursor(false);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        LDAPObjectClassSchema lDAPObjectClassSchema = this._schema.getObjectClass((String)this._ocComboBox.getSelectedItem());
        if (listSelectionEvent.getSource().equals(this._reqAttrListBox)) {
            this.removeReqButton.setEnabled(false);
            Object[] objectArray = this._reqAttrListBox.getSelectedValues();
            if (objectArray != null && objectArray.length > 0) {
                Hashtable hashtable = new Hashtable();
                DSSchemaHelper.allRequiredAttributes(lDAPObjectClassSchema, this._schema, hashtable);
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    int n = 0;
                    while (n < objectArray.length) {
                        if (string.equals((String)objectArray[n])) {
                            return;
                        }
                        ++n;
                    }
                }
                this.updateReqRemoveButton();
            }
        } else if (listSelectionEvent.getSource().equals(this._allowAttrListBox)) {
            this.removeAllowButton.setEnabled(false);
            Object[] objectArray = this._allowAttrListBox.getSelectedValues();
            if (objectArray != null && objectArray.length > 0) {
                Hashtable hashtable = new Hashtable();
                DSSchemaHelper.allOptionalAttributes(lDAPObjectClassSchema, this._schema, hashtable);
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    int n = 0;
                    while (n < objectArray.length) {
                        if (string.equals((String)objectArray[n])) {
                            return;
                        }
                        ++n;
                    }
                }
                this.updateAllowRemoveButton();
            }
        }
    }

    private void updateReqRemoveButton() {
        boolean bl = false;
        if (this._reqAttrModel.getSize() > 0) {
            Object[] objectArray = this._reqAttrListBox.getSelectedValues();
            bl = objectArray != null && objectArray.length > 0;
        }
        this.removeReqButton.setEnabled(bl);
    }

    private void updateAllowRemoveButton() {
        boolean bl = false;
        if (this._allowAttrModel.getSize() > 0) {
            Object[] objectArray = this._allowAttrListBox.getSelectedValues();
            bl = objectArray != null && objectArray.length > 0;
        }
        this.removeAllowButton.setEnabled(bl);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getSource().equals(this._ocComboBox)) {
                this.updateAllListBoxes((String)this._ocComboBox.getSelectedItem());
            }
            if (this._availAttrListBox == null) {
                return;
            }
            this._availAttrListBox.clearSelection();
            this._allowAttrListBox.clearSelection();
            this._reqAttrListBox.clearSelection();
        }
    }

    private boolean updateOC() {
        int n;
        String string = this._nameText.getText();
        if (string.length() < 1) {
            return false;
        }
        String string2 = this._oidText.getText();
        if (string2.length() < 1) {
            string2 = string + "-oid";
        }
        boolean bl = false;
        LDAPObjectClassSchema lDAPObjectClassSchema = this._schema.getObjectClass(string);
        if (lDAPObjectClassSchema != null) {
            bl = DSUtil.isStandardSchema((LDAPSchemaElement)lDAPObjectClassSchema);
        }
        if (bl && (n = DSUtil.showConfirmationDialog((Component)this.getModel().getFrame(), "confirm-overwrite", string, _section)) != 0) {
            return false;
        }
        String string3 = (String)this._ocComboBox.getSelectedItem();
        if (!this._reqAttrModel.contains("objectclass")) {
            this._reqAttrModel.addElement("objectclass");
        }
        Object[] objectArray = new String[this._reqAttrModel.size()];
        Object[] objectArray2 = new String[this._allowAttrModel.size()];
        this._reqAttrModel.copyInto(objectArray);
        this._allowAttrModel.copyInto(objectArray2);
        LDAPObjectClassSchema lDAPObjectClassSchema2 = new LDAPObjectClassSchema(string, string2, string3, "", (String[])objectArray, (String[])objectArray2);
        Debug.println((String)("ObjectClassDialog.updateOC: modifying schema with " + lDAPObjectClassSchema2));
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        boolean bl2 = false;
        try {
            while (true) {
                try {
                    this.confirmUpdate(lDAPObjectClassSchema2, lDAPConnection, bl);
                    boolean bl3 = true;
                    Object var15_14 = null;
                    this.getModel().notifyAuthChangeListeners();
                    return bl3;
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() == 50) {
                        DSUtil.showPermissionDialog((Component)this.getModel().getFrame(), lDAPConnection);
                        if (this.getModel().getNewAuthentication(false)) continue;
                        boolean bl4 = false;
                        Object var15_15 = null;
                        this.getModel().notifyAuthChangeListeners();
                        return bl4;
                    }
                    try {
                        if (this._origEntry != null && this._schema.getObjectClass(this._origEntry.getName()) != null) {
                            this._origEntry.add(lDAPConnection);
                        }
                        DSUtil.showLDAPErrorDialog(this.getModel().getFrame(), lDAPException, "updating-directory-title");
                        boolean bl5 = false;
                        Object var15_16 = null;
                        this.getModel().notifyAuthChangeListeners();
                        return bl5;
                    }
                    catch (LDAPException lDAPException2) {
                        DSUtil.showLDAPErrorDialog(this.getModel().getFrame(), lDAPException, "updating-directory-title");
                        boolean bl6 = false;
                        Object var15_17 = null;
                        this.getModel().notifyAuthChangeListeners();
                        return bl6;
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            this.getModel().notifyAuthChangeListeners();
            throw throwable;
        }
    }

    private void confirmUpdate(LDAPObjectClassSchema lDAPObjectClassSchema, LDAPConnection lDAPConnection, boolean bl) throws LDAPException {
        String string = this._nameText.getText();
        boolean bl2 = false;
        if (this._update) {
            this._origEntry.remove(lDAPConnection);
            lDAPObjectClassSchema.add(lDAPConnection);
            DSUtil.showInformationDialog((Component)this.getModel().getFrame(), "successful-update", string, _section);
        } else {
            lDAPObjectClassSchema.add(lDAPConnection);
            String string2 = bl ? "successful-update" : "successful-add";
            DSUtil.showInformationDialog((Component)this.getModel().getFrame(), string2, string, _section);
        }
    }

    private void redrawListBox(JList jList) {
        jList.invalidate();
        jList.validate();
        jList.repaint(1L);
    }

    private void init(LDAPObjectClassSchema lDAPObjectClassSchema) {
        this._nameText = UIFactory.makeJTextField((Object)this, 20);
        this._oidText = UIFactory.makeJTextField((Object)this, 20);
        if (lDAPObjectClassSchema != null) {
            String string = lDAPObjectClassSchema.getID();
            if (string.length() == 0) {
                string = OID_UNKNOWN_STR;
            }
            this._nameText.setText(lDAPObjectClassSchema.getName());
            this._oidText.setText(string);
            this._ocComboBox = this.createComboBox(lDAPObjectClassSchema.getSuperior());
            this.updateAllListBoxes(lDAPObjectClassSchema);
        } else {
            this._ocComboBox = this.createComboBox("top");
            this.updateAllListBoxes(this._schema.getObjectClass("top"));
        }
    }

    private void updateAllListBoxes(LDAPObjectClassSchema lDAPObjectClassSchema) {
        String string;
        Object object;
        this.updateAvailAttrList();
        Hashtable hashtable = new Hashtable();
        DSSchemaHelper.allRequiredAttributes(lDAPObjectClassSchema, this._schema, hashtable);
        Enumeration enumeration = hashtable.elements();
        if (this._reqAttrModel.size() != 0) {
            this._reqAttrModel.removeAllElements();
        }
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            SchemaUtility.InsertElement(this._reqAttrModel, object);
            this._availModel.removeElement(object);
        }
        hashtable = new Hashtable();
        DSSchemaHelper.allOptionalAttributes(lDAPObjectClassSchema, this._schema, hashtable);
        object = hashtable.elements();
        if (this._allowAttrModel.size() != 0) {
            this._allowAttrModel.removeAllElements();
        }
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            if (this._reqAttrModel.contains(string2)) continue;
            SchemaUtility.InsertElement(this._allowAttrModel, string2);
            this._availModel.removeElement(string2);
        }
        int n = 0;
        n = this._extendedReqAttrVector.size() - 1;
        while (n >= 0) {
            string = (String)this._extendedReqAttrVector.elementAt(n);
            if (!this._reqAttrModel.contains(string) && !this._allowAttrModel.contains(string)) {
                SchemaUtility.InsertElement(this._reqAttrModel, string);
                this._availModel.removeElement(string);
            } else {
                this._extendedReqAttrVector.remove(string);
            }
            --n;
        }
        n = this._extendedAllowAttrVector.size() - 1;
        while (n >= 0) {
            string = (String)this._extendedAllowAttrVector.elementAt(n);
            if (!this._reqAttrModel.contains(string) && !this._allowAttrModel.contains(string)) {
                SchemaUtility.InsertElement(this._allowAttrModel, string);
                this._availModel.removeElement(string);
            } else {
                this._extendedAllowAttrVector.remove(string);
            }
            --n;
        }
    }

    private void updateAllListBoxes(String string) {
        this.updateAvailAttrList();
        LDAPObjectClassSchema lDAPObjectClassSchema = this._schema.getObjectClass(string);
        this.updateAllListBoxes(lDAPObjectClassSchema);
    }

    protected JPanel createDialogContent() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(UIFactory.getBorderInsets()));
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(UIFactory.getComponentInsets()));
        JLabel jLabel = UIFactory.makeJLabel(_section, "name");
        jLabel.setLabelFor(this._nameText);
        JLabel jLabel2 = UIFactory.makeJLabel(_section, "parent");
        jLabel2.setLabelFor(this._ocComboBox);
        JLabel jLabel3 = UIFactory.makeJLabel(_section, "optionalOID");
        jLabel3.setLabelFor(this._oidText);
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        int n = UIFactory.getComponentSpace();
        int n2 = UIFactory.getDifferentSpace();
        gridBagConstraints.insets = new Insets(0, 0, 0, n);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.5;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = -1;
        jPanel2.add((Component)this._nameText, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this._ocComboBox, gridBagConstraints);
        jPanel2.add(Box.createVerticalStrut(n), gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, n);
        jPanel2.add((Component)new JLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = 0;
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, n);
        jPanel2.add((Component)new JLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this._oidText, gridBagConstraints);
        int n3 = 108;
        int n4 = 23;
        Dimension dimension = new Dimension(n3, n4);
        ArrowIcon arrowIcon = new ArrowIcon(3);
        JButton jButton = this.createButton("addreq", dimension, REQ_ADD_STR, arrowIcon);
        jButton.setHorizontalTextPosition(2);
        ArrowIcon arrowIcon2 = new ArrowIcon(7);
        this.removeReqButton = this.createButton("removereq", dimension, REQ_REMOVE_STR, arrowIcon2);
        this.removeReqButton.setEnabled(false);
        JButton jButton2 = this.createButton("addallow", dimension, ALLOW_ADD_STR, arrowIcon);
        jButton2.setHorizontalTextPosition(2);
        this.removeAllowButton = this.createButton("removeallow", dimension, ALLOW_REMOVE_STR, arrowIcon2);
        this.removeAllowButton.setEnabled(false);
        JButton[] jButtonArray = new JButton[]{jButton, this.removeReqButton, jButton2, this.removeAllowButton};
        JButtonFactory.resize((JButton[])jButtonArray);
        this._ocComboBox.addItemListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JLabel jLabel4 = UIFactory.makeJLabel(_section, "availAttributesList");
        jPanel3.add(jLabel4);
        this._availAttrListBox = this.createListBox(this._availModel, 15, false);
        jLabel4.setLabelFor(this._availAttrListBox);
        JScrollPane jScrollPane = this.createScrollPane(this._availAttrListBox);
        jPanel3.add(jScrollPane);
        this._reqAttrListBox = this.createListBox(this._reqAttrModel, 8, true);
        JScrollPane jScrollPane2 = this.createScrollPane(this._reqAttrListBox);
        String string = "reqAttributesList";
        JPanel jPanel4 = this.createAttrPanel(jScrollPane2, string, jButton, this.removeReqButton);
        this._reqAttrListBox.addListSelectionListener(this);
        this._allowAttrListBox = this.createListBox(this._allowAttrModel, 8, true);
        JScrollPane jScrollPane3 = this.createScrollPane(this._allowAttrListBox);
        string = "allowAttributesList";
        JPanel jPanel5 = this.createAttrPanel(jScrollPane3, string, jButton2, this.removeAllowButton);
        this._allowAttrListBox.addListSelectionListener(this);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel6.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.top = n2;
        jPanel6.add((Component)jPanel5, gridBagConstraints);
        n3 = 80;
        dimension = new Dimension(n3, n4);
        this._OKButton = this.createButton("OK", dimension, null);
        this._cancelButton = this.createButton("Cancel", dimension, null);
        this._helpButton = this.createButton("Help", dimension, null);
        JButton[] jButtonArray2 = new JButton[]{this._OKButton, this._cancelButton, this._helpButton};
        JPanel jPanel7 = UIFactory.makeJButtonPanel(jButtonArray2, true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(n2, n, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(n, n, 0, n);
        jPanel.add((Component)jPanel6, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(n2, 0, 0, 0);
        jPanel.add((Component)jPanel7, gridBagConstraints);
        return jPanel;
    }

    protected JComboBox createComboBox() {
        JComboBox jComboBox = UIFactory.makeJComboBox(this);
        Enumeration enumeration = this._schema.getObjectClassNames();
        while (enumeration.hasMoreElements()) {
            SchemaUtility.InsertElement(jComboBox, enumeration.nextElement());
        }
        jComboBox.insertItemAt(this._noParent, 0);
        jComboBox.setSelectedIndex(0);
        return jComboBox;
    }

    protected JComboBox createComboBox(String string) {
        JComboBox jComboBox = this.createComboBox();
        int n = jComboBox.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)jComboBox.getItemAt(n2);
            if (string2.equalsIgnoreCase(string)) {
                jComboBox.setSelectedIndex(n2);
                return jComboBox;
            }
            ++n2;
        }
        if (n2 >= n) {
            jComboBox.setSelectedIndex(0);
        }
        return jComboBox;
    }

    protected JPanel createAttrPanel(JScrollPane jScrollPane, String string, JButton jButton, JButton jButton2) {
        int n = UIFactory.getComponentSpace();
        JLabel jLabel = UIFactory.makeJLabel(_section, string);
        jLabel.setLabelFor(jScrollPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jLabel);
        jPanel.add(jScrollPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel2.add(Box.createGlue(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(n, 0, 0, 0);
        jPanel2.add((Component)jButton2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add(Box.createGlue(), gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridwidth = -1;
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, n, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        jPanel3.add((Component)jPanel, gridBagConstraints);
        return jPanel3;
    }

    JList createListBox(DefaultListModel defaultListModel, int n, boolean bl) {
        JList<String> jList = new JList<String>(defaultListModel);
        if (bl) {
            jList.setCellRenderer(new OCCellRenderer(this));
        } else {
            jList.setCellRenderer(new OCCellRenderer());
        }
        jList.setPrototypeCellValue("1234567890 1234567890");
        jList.setVisibleRowCount(n);
        return jList;
    }

    JScrollPane createScrollPane(JList jList) {
        JScrollPane jScrollPane = new JScrollPane(jList, 20, 30);
        jScrollPane.setAlignmentX(0.0f);
        jScrollPane.setAlignmentY(0.0f);
        jScrollPane.setBorder(UITools.createLoweredBorder());
        return jScrollPane;
    }

    private JButton createButton(String string, Dimension dimension, String string2, Icon icon) {
        JButton jButton = UIFactory.makeJButton((Object)this, _section, string);
        if (string2 != null) {
            jButton.setActionCommand(string2);
        }
        if (icon != null) {
            jButton.setIcon(icon);
        }
        return jButton;
    }

    private JButton createButton(String string, Dimension dimension, String string2) {
        return this.createButton(string, dimension, string2, null);
    }

    private IDSModel getModel() {
        return this._model;
    }

    protected boolean isValidSchemaSyntax(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string, 0);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (_validsyntax.indexOf(Character.toLowerCase(c)) == -1) {
                return false;
            }
            c = stringCharacterIterator.next();
        }
        return true;
    }

    private void checkOkay() {
        if (this._OKButton != null) {
            String string = this._nameText.getText();
            String string2 = (String)this._ocComboBox.getSelectedItem();
            LDAPObjectClassSchema lDAPObjectClassSchema = this._schema.getObjectClass(string2);
            boolean bl = true;
            Hashtable hashtable = new Hashtable();
            DSSchemaHelper.allRequiredAttributes(lDAPObjectClassSchema, this._schema, hashtable);
            Enumeration enumeration = hashtable.elements();
            while (bl && enumeration.hasMoreElements()) {
                boolean bl2 = bl = !this._availModel.contains(enumeration.nextElement());
            }
            hashtable = new Hashtable();
            DSSchemaHelper.allOptionalAttributes(lDAPObjectClassSchema, this._schema, hashtable);
            Enumeration enumeration2 = hashtable.elements();
            while (bl && enumeration2.hasMoreElements()) {
                boolean bl3 = bl = !this._availModel.contains(enumeration2.nextElement());
            }
            this._OKButton.setEnabled(bl && string != null && string.length() > 0 && this.isValidSchemaSyntax(string));
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkOkay();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkOkay();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkOkay();
    }

    boolean isRemovable(String string) {
        String string2 = (String)this._ocComboBox.getSelectedItem();
        LDAPObjectClassSchema lDAPObjectClassSchema = this._schema.getObjectClass(string2);
        boolean bl = true;
        Hashtable hashtable = new Hashtable();
        DSSchemaHelper.allRequiredAttributes(lDAPObjectClassSchema, this._schema, hashtable);
        Enumeration enumeration = hashtable.elements();
        while (bl && enumeration.hasMoreElements()) {
            boolean bl2 = bl = !string.equals(enumeration.nextElement().toString());
        }
        hashtable = new Hashtable();
        DSSchemaHelper.allOptionalAttributes(lDAPObjectClassSchema, this._schema, hashtable);
        Enumeration enumeration2 = hashtable.elements();
        while (bl && enumeration2.hasMoreElements()) {
            boolean bl3 = bl = !string.equals(enumeration2.nextElement().toString());
        }
        return bl;
    }

    public void packAndShow() {
        super.pack();
        super.show();
    }
}

