/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.util.DN;

public class NewSuffixPanel
extends BlankPanel
implements SuiConstants {
    private JTextField _newSuffixText;
    private JLabel _newSuffixLabel;
    private JLabel _subordinationText;
    private JLabel _subordinationLabel;
    private JLabel _resSuffixLabel;
    private JLabel _resSuffixText;
    private JCheckBox _cbCreateLDBM;
    private JTextField _newDBText;
    private JLabel _newDBLabel;
    private IDSModel _model = null;
    private boolean _isRoot;
    private boolean _isNewMappingNodeValid = false;
    private boolean _initialized = false;
    private static final String _section = "mappingtree";
    private final int ROWS = 4;
    private LDAPEntry _entry = null;

    public NewSuffixPanel(IDSModel iDSModel, LDAPEntry lDAPEntry) {
        this(iDSModel, lDAPEntry, false);
    }

    public NewSuffixPanel(IDSModel iDSModel, LDAPEntry lDAPEntry, boolean bl) {
        super(iDSModel, _section);
        this._helpToken = "configuration-new-mapping-sub-suffix-dbox-help";
        if (bl) {
            this.setTitle(DSUtil._resource.getString(_section, "new-root-title"));
        } else {
            this.setTitle(DSUtil._resource.getString(_section, "new-title"));
        }
        this._model = iDSModel;
        this._entry = lDAPEntry;
        this._isRoot = bl;
    }

    public void init() {
        if (!this._initialized) {
            this._myPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = this.getGBC();
            this.createTypeArea(this._myPanel);
            AbstractDialog abstractDialog = this.getAbstractDialog();
            if (abstractDialog != null) {
                abstractDialog.setOKButtonEnabled(false);
            }
            this._initialized = true;
        }
    }

    protected void createTypeArea(JPanel jPanel) {
        JPanel jPanel2 = this._myPanel;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 9, 6, 9);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this._newSuffixLabel = this.makeJLabel(_section, "new-node-suffix");
        this._newSuffixLabel.resetKeyboardActions();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this._newSuffixLabel, gridBagConstraints);
        this._newSuffixText = this.makeJTextField(_section, "new-node-suffix");
        this._newSuffixLabel.setLabelFor(this._newSuffixText);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this._newSuffixText, gridBagConstraints);
        if (!this._isRoot) {
            String string = MappingUtils.unQuote(LDAPDN.explodeDN((String)this._entry.getDN(), (boolean)true)[0]);
            this._subordinationLabel = this.makeJLabel(_section, "new-subordination");
            this._subordinationLabel.resetKeyboardActions();
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            jPanel2.add((Component)this._subordinationLabel, gridBagConstraints);
            this._subordinationText = new JLabel();
            this._subordinationLabel.setLabelFor(this._subordinationText);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            this._subordinationText.setText(string);
            jPanel2.add((Component)this._subordinationText, gridBagConstraints);
            this._resSuffixLabel = this.makeJLabel(_section, "new-result-suffix");
            this._resSuffixLabel.resetKeyboardActions();
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.0;
            jPanel2.add((Component)this._resSuffixLabel, gridBagConstraints);
            this._resSuffixText = new JLabel();
            this._resSuffixLabel.setLabelFor(this._resSuffixText);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            StringBuffer stringBuffer = new StringBuffer("        ");
            stringBuffer.append("," + string);
            this._resSuffixText.setText(stringBuffer.toString());
            jPanel2.add((Component)this._resSuffixText, gridBagConstraints);
        }
        this._cbCreateLDBM = this.makeJCheckBox(_section, "new-cb-create-db");
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        this._cbCreateLDBM.setSelected(true);
        jPanel2.add((Component)this._cbCreateLDBM, gridBagConstraints);
        this._newDBLabel = this.makeJLabel(_section, "new-db");
        this._newDBLabel.resetKeyboardActions();
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this._newDBLabel, gridBagConstraints);
        this._newDBText = this.makeJTextField(_section, "new-db");
        this._newDBLabel.setLabelFor(this._newDBText);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this._newDBText, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
    }

    public JComponent getFocusComponent() {
        return this._newSuffixText;
    }

    private void setOkay(boolean bl) {
        AbstractDialog abstractDialog = this.getAbstractDialog();
        if (abstractDialog != null) {
            abstractDialog.setOKButtonEnabled(bl);
        }
    }

    private void checkOkay() {
        String string = this._newSuffixText.getText().trim();
        boolean bl = string != null && string.length() > 0;
        boolean bl2 = bl = bl && this._isNewMappingNodeValid;
        if (this._cbCreateLDBM.isSelected()) {
            bl = bl && this._newDBText.getText() != null && this._newDBText.getText().trim().length() > 0 && DSUtil.isValidBckName(this._newDBText.getText());
        }
        this.setOkay(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._cbCreateLDBM)) {
            super.actionPerformed(actionEvent);
            boolean bl = this._cbCreateLDBM.isSelected();
            this._newDBText.setEnabled(bl);
        }
        this.checkOkay();
    }

    public void resetCallback() {
        this.clearDirtyFlag();
        this.hideDialog();
    }

    public void okCallback() {
        int n;
        String[] stringArray;
        Object object;
        Object object2;
        String string;
        AbstractDialog abstractDialog = this.getAbstractDialog();
        if (abstractDialog != null) {
            abstractDialog.setBusyCursor(true);
        }
        String[] stringArray2 = MappingUtils.getSuffixList(this._model.getServerInfo().getLDAPConnection());
        if (this._isRoot) {
            string = "is root suffix";
            if (stringArray2 != null) {
                object2 = new DN(this._newSuffixText.getText());
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    object = new DN(stringArray2[n2]);
                    if (object2.isDescendantOf(object)) {
                        stringArray = new String[]{stringArray2[n2]};
                        n = DSUtil.showConfirmationDialog((Component)this, "new-root-confirm-parent-exists", stringArray, _section);
                        if (n != 0) {
                            if (abstractDialog != null) {
                                abstractDialog.setBusyCursor(false);
                            }
                            return;
                        }
                        break;
                    }
                    if (object.isDescendantOf(object2)) {
                        stringArray = new String[]{stringArray2[n2]};
                        n = DSUtil.showConfirmationDialog((Component)this, "new-root-confirm-child-exists", stringArray, _section);
                        if (n != 0) {
                            if (abstractDialog != null) {
                                abstractDialog.setBusyCursor(false);
                            }
                            return;
                        }
                        break;
                    }
                    ++n2;
                }
            }
        } else {
            string = this._subordinationText.getText();
        }
        if (this._cbCreateLDBM.isSelected()) {
            object2 = this._newDBText.getText();
            String[] stringArray3 = new String[]{object2};
            object = MappingUtils.getDefaultDBLoc(this._model, _section) + (String)object2;
            stringArray = this._model.getServerInfo().getLDAPConnection();
            n = 0;
            if (!MappingUtils.checkUnique(this._model, (String)object2)) {
                if (abstractDialog != null) {
                    abstractDialog.setBusyCursor(false);
                }
                return;
            }
            n = this._isRoot ? (int)(DSUtil.addLDBMBackend(this._model, (String)object2, "cn=ldbm database, cn=plugins, cn=config", (String)object, this._newSuffixText.getText(), _section) ? 1 : 0) : (int)(DSUtil.addLDBMBackend(this._model, (String)object2, "cn=ldbm database, cn=plugins, cn=config", (String)object, this._resSuffixText.getText(), _section) ? 1 : 0);
            if (n != 0 && MappingUtils.addMappingNode((LDAPConnection)stringArray, _section, this._newSuffixText.getText(), string, "Backend", stringArray3, null)) {
                this.hideDialog();
                if (abstractDialog != null) {
                    abstractDialog.setBusyCursor(false);
                }
                return;
            }
        } else if (MappingUtils.addMappingNode(this._model.getServerInfo().getLDAPConnection(), _section, this._newSuffixText.getText(), string, "Disabled", null, null)) {
            this.hideDialog();
            if (abstractDialog != null) {
                abstractDialog.setBusyCursor(false);
            }
            return;
        }
        DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "new-mapping-node", "");
        if (abstractDialog != null) {
            abstractDialog.setBusyCursor(false);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.suffixUpdate();
        super.changedUpdate(documentEvent);
        this.checkOkay();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.suffixUpdate();
        super.removeUpdate(documentEvent);
        this.checkOkay();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.suffixUpdate();
        super.insertUpdate(documentEvent);
        this.checkOkay();
    }

    private void suffixUpdate() {
        if (!this._isRoot) {
            this._resSuffixText.setText(this._newSuffixText.getText() + "," + this._subordinationText.getText());
        }
        if (DN.isDN((String)this._newSuffixText.getText())) {
            this.setChangeState(this._newSuffixLabel, 1);
            if (!this._isRoot) {
                this.setChangeState(this._resSuffixLabel, 1);
            }
            this._isNewMappingNodeValid = true;
        } else {
            this.setChangeState(this._newSuffixLabel, 3);
            if (!this._isRoot) {
                this.setChangeState(this._resSuffixLabel, 3);
            }
            this._isNewMappingNodeValid = false;
        }
        if (DSUtil.isValidBckName(this._newDBText.getText())) {
            this.setChangeState(this._newDBLabel, 1);
        } else {
            this.setChangeState(this._newDBLabel, 3);
        }
    }
}

