/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class NewMappingNodePanel
extends BlankPanel {
    private JTextField _mappingNameText;
    private JLabel _mappingNameLabel;
    private JTextField _NewNodeText;
    private JLabel _NewNodeLabel;
    private JTextField _subordinationText;
    private JLabel _subordinationLabel;
    private IDSModel _model = null;
    private JComboBox _comboNewNodeMapping;
    private JLabel _comboNewNodeLabel;
    private JComboBox _comboStatus;
    private JLabel _comboStatusLabel;
    private JLabel _bckListLabel;
    private JList _bckList;
    private JButton _bAdd;
    private JButton _bDelete;
    private JLabel _refListLabel;
    private JTextField _refNewRefText;
    private JLabel _refNewRefLabel;
    private JList _refList;
    private DefaultListModel _refData;
    private boolean _isNewMappingNodeValid = false;
    private static final String _section = "mappingtree";
    static final String CONFIG_BASEDN = "cn=plugins, cn=config";
    static final String CONFIG_MAPPING = "cn=mapping tree, cn=config";
    static final String ROOT_MAPPING_NODE = "is root suffix";
    static final String DISABLE = "Disabled";
    static final String BACKEND = "Backend";
    static final String REFERRAL = "Referral";
    static final String REFERRAL_UPDATE = "Referral on Update";
    static final String ADD_REF = "addReferral";
    private final String DELETE_REF = "deleteReferral";
    private final int ROWS = 4;
    private LDAPEntry _entry = null;

    public NewMappingNodePanel(IDSModel iDSModel, LDAPEntry lDAPEntry) {
        super(iDSModel, _section);
        this._helpToken = "configuration-new-mapping-node-dbox-help";
        this.setTitle(DSUtil._resource.getString(_section, "new-title"));
        this._model = iDSModel;
        this._entry = lDAPEntry;
    }

    public void init() {
        this._myPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getGBC();
        this.createTypeArea(this._myPanel);
        this.createValueArea(this._myPanel);
        AbstractDialog abstractDialog = this.getAbstractDialog();
        if (abstractDialog != null) {
            abstractDialog.setOKButtonEnabled(false);
        }
    }

    protected void createValueArea(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = this.getGBC();
        GroupPanel groupPanel = new GroupPanel(DSUtil._resource.getString(_section, "bck-title"), true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)groupPanel, gridBagConstraints);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.ipadx = 0;
        gridBagConstraints2.ipady = 0;
        groupPanel.setLayout(gridBagLayout);
        this._bckListLabel = this.makeJLabel(_section, "bck-list");
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        groupPanel.add((Component)this._bckListLabel, gridBagConstraints2);
        String[] stringArray = this.getBackendList();
        this._bckList = new JList<String>(stringArray);
        this._bckList.setVisibleRowCount(4);
        this._bckList.setCellRenderer(new ReferralCellRenderer());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this._bckList);
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        groupPanel.add((Component)jScrollPane, gridBagConstraints2);
        this._refListLabel = this.makeJLabel(_section, "ref-list");
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        ++gridBagConstraints2.gridy;
        groupPanel.add((Component)this._refListLabel, gridBagConstraints2);
        this._refNewRefText = this.makeJTextField(_section, "ref-new");
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints2.anchor = 10;
        groupPanel.add((Component)this._refNewRefText, gridBagConstraints2);
        this._bAdd = UIFactory.makeJButton(this, _section, "badd", null);
        this._bAdd.setActionCommand(ADD_REF);
        this._bAdd.setEnabled(false);
        gridBagConstraints2.gridwidth = 1;
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets = new Insets(0, 9, 6, 0);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 13;
        groupPanel.add((Component)this._bAdd, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        this._refData = new DefaultListModel();
        this._refList = new JList(this._refData);
        this._refList.setVisibleRowCount(4);
        this._refList.setCellRenderer(new ReferralCellRenderer());
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.getViewport().setView(this._refList);
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        groupPanel.add((Component)jScrollPane2, gridBagConstraints2);
        this._bDelete = UIFactory.makeJButton(this, _section, "bdelete", null);
        this._bDelete.setActionCommand("deleteReferral");
        this._bDelete.setEnabled(false);
        gridBagConstraints2.gridwidth = 1;
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets = new Insets(0, 9, 0, 0);
        gridBagConstraints2.anchor = 12;
        groupPanel.add((Component)this._bDelete, gridBagConstraints2);
    }

    protected void createTypeArea(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.insets.bottom = this._gbc.insets.top;
        gridBagConstraints.gridwidth = 0;
        String[] stringArray = MappingUtils.getMappingNode(this._model.getServerInfo().getLDAPConnection());
        GroupPanel groupPanel = new GroupPanel(DSUtil._resource.getString(_section, "new-mapping-title"));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)groupPanel, gridBagConstraints);
        this._NewNodeLabel = this.makeJLabel(_section, "new-node-suffix");
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        groupPanel.add((Component)this._NewNodeLabel, gridBagConstraints);
        this._NewNodeText = this.makeJTextField(_section, "new-node-suffix");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        groupPanel.add((Component)this._NewNodeText, gridBagConstraints);
        this._comboNewNodeMapping = new JComboBox();
        this._comboNewNodeMapping.addItemListener(this);
        this._comboNewNodeMapping.addActionListener(this);
        if (stringArray != null) {
            int n = 0;
            this._comboNewNodeMapping.addItem(ROOT_MAPPING_NODE);
            int n2 = 0;
            while (n2 < stringArray.length) {
                this._comboNewNodeMapping.addItem(stringArray[n2]);
                if (this._entry != null && stringArray[n2].compareTo(MappingUtils.unQuote(LDAPDN.explodeDN((String)this._entry.getDN(), (boolean)true)[0])) == 0) {
                    n = n2 + 1;
                }
                ++n2;
            }
            if (stringArray.length > 0) {
                this._comboNewNodeMapping.setSelectedIndex(n);
            }
        }
        this._comboNewNodeLabel = this.makeJLabel(_section, "new-node-subordination");
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        groupPanel.add((Component)this._comboNewNodeLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        groupPanel.add((Component)this._comboNewNodeMapping, gridBagConstraints);
        this._comboStatus = new JComboBox();
        this._comboStatus.addItemListener(this);
        this._comboStatus.addActionListener(this);
        this._comboStatus.addItem(BACKEND);
        this._comboStatus.addItem(REFERRAL);
        this._comboStatus.addItem(REFERRAL_UPDATE);
        this._comboStatus.addItem(DISABLE);
        this._comboStatusLabel = this.makeJLabel(_section, "new-node-status");
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        groupPanel.add((Component)this._comboStatusLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        groupPanel.add((Component)this._comboStatus, gridBagConstraints);
    }

    private String[] getBackendList() {
        String[] stringArray;
        Vector<String> vector = new Vector<String>(1);
        try {
            try {
                stringArray = this._model.getServerInfo().getLDAPConnection();
                this._model.setWaitCursor(true);
                LDAPSearchResults lDAPSearchResults = stringArray.search(CONFIG_BASEDN, 2, "objectclass=nsBackendInstance", null, false);
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                    String string = lDAPEntry.getDN();
                    Debug.println((String)"NewMappingNodePanel.getBackendList() {");
                    Debug.println((String)("*** backend : " + string));
                    vector.addElement(LDAPDN.explodeDN((String)lDAPEntry.getDN(), (boolean)true)[0]);
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("NewMappingNodePanel.getBackendList() " + (Object)((Object)lDAPException)));
                Object var7_8 = null;
                this._model.setWaitCursor(false);
            }
            Object var7_7 = null;
            this._model.setWaitCursor(false);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this._model.setWaitCursor(false);
            throw throwable;
        }
        Debug.println((String)("*** Nb : " + vector.size() + " Dir :" + vector.toString()));
        stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    private boolean isListEmpty(JList jList) {
        boolean bl = jList.getModel().getSize() == 0;
        return bl;
    }

    private String[] getReferralsInList() {
        Vector vector = new Vector();
        int n = 0;
        while (n < this._refList.getModel().getSize()) {
            vector.addElement(this._refList.getModel().getElementAt(n));
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    private String[] getBackendsInList() {
        Vector<String> vector = new Vector<String>(1);
        Object[] objectArray = this._bckList.getSelectedValues();
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        n = 0;
        while (n < objectArray.length) {
            vector.addElement(objectArray[n].toString());
            Debug.println((String)("*** backends : " + objectArray[n].toString()));
            ++n;
        }
        vector.toArray(stringArray);
        return stringArray;
    }

    private void setOkay(boolean bl) {
        AbstractDialog abstractDialog = this.getAbstractDialog();
        if (abstractDialog != null) {
            abstractDialog.setOKButtonEnabled(bl);
        }
    }

    private void checkOkay() {
        String string = this._NewNodeText.getText().trim();
        boolean bl = string != null && string.length() > 0;
        bl = bl && this._isNewMappingNodeValid && (!this._bckList.isSelectionEmpty() || !this.isListEmpty(this._refList));
        this.setOkay(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(ADD_REF)) {
            this._refData.addElement(this._refNewRefText.getText());
            this._refNewRefText.setText("");
            this._bAdd.setEnabled(false);
        } else if (actionEvent.getActionCommand().equals("deleteReferral")) {
            int[] nArray = this._refList.getSelectedIndices();
            int n = nArray.length - 1;
            while (n >= 0) {
                this._refData.removeElementAt(nArray[n]);
                --n;
            }
            this._bDelete.setEnabled(false);
        }
        this.checkOkay();
    }

    public void resetCallback() {
        this.clearDirtyFlag();
        this.hideDialog();
    }

    public void okCallback() {
        if (this._NewNodeText.getText() != null && this._NewNodeText.getText().trim().length() > 0) {
            if (MappingUtils.addMappingNode(this._model.getServerInfo().getLDAPConnection(), _section, this._NewNodeText.getText(), (String)this._comboNewNodeMapping.getSelectedItem(), (String)this._comboStatus.getSelectedItem(), this.getBackendsInList(), this.getReferralsInList())) {
                return;
            }
        } else {
            DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "new-mapping-node", "");
            return;
        }
        this.hideDialog();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this._NewNodeText.getDocument()) {
            if (DN.isDN((String)this._NewNodeText.getText())) {
                this.setChangeState(this._NewNodeLabel, 1);
                this._isNewMappingNodeValid = true;
            } else {
                this.setChangeState(this._NewNodeLabel, 3);
                this._isNewMappingNodeValid = false;
            }
        }
        super.changedUpdate(documentEvent);
        this.checkOkay();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this._NewNodeText.getDocument()) {
            if (DN.isDN((String)this._NewNodeText.getText())) {
                this.setChangeState(this._NewNodeLabel, 1);
                this._isNewMappingNodeValid = true;
            } else {
                this.setChangeState(this._NewNodeLabel, 3);
                this._isNewMappingNodeValid = false;
            }
        }
        super.removeUpdate(documentEvent);
        this.checkOkay();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this._refNewRefText.getDocument()) {
            boolean bl = this._refNewRefText.getText().trim().length() > 0;
            this._bAdd.setEnabled(bl);
        } else if (documentEvent.getDocument() == this._NewNodeText.getDocument()) {
            if (DN.isDN((String)this._NewNodeText.getText())) {
                this.setChangeState(this._NewNodeLabel, 1);
                this._isNewMappingNodeValid = true;
            } else {
                this.setChangeState(this._NewNodeLabel, 3);
                this._isNewMappingNodeValid = false;
            }
        }
        super.insertUpdate(documentEvent);
        this.checkOkay();
    }

    class ReferralCellRenderer
    extends DefaultListCellRenderer {
        ReferralCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (jList == NewMappingNodePanel.this._refList) {
                if (jList.isSelectionEmpty()) {
                    NewMappingNodePanel.this._bDelete.setEnabled(false);
                } else {
                    NewMappingNodePanel.this._bDelete.setEnabled(true);
                }
            }
            NewMappingNodePanel.this.checkOkay();
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }
}

