/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.DSTabbedPanel;
import com.netscape.admin.dirserv.panel.MonitorDatabasePanel;
import com.netscape.admin.dirserv.panel.MonitorServerPanel;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.util.Debug;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class MonitorPanel
extends DSTabbedPanel {
    private boolean _monInitialized = false;

    public MonitorPanel(IDSModel iDSModel) {
        super(iDSModel, true);
        this.getOKButton().setVisible(false);
        this.getCancelButton().setVisible(false);
    }

    public void select(IResourceObject iResourceObject, IPage iPage) {
        if (!this._monInitialized) {
            int n = 0;
            LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
            try {
                LDAPEntry lDAPEntry = lDAPConnection.read("cn=monitor");
                if (lDAPEntry == null) {
                    Debug.println((String)"MonitorPanel.select: unable to read cn=monitor");
                    return;
                }
                this.addTab(new MonitorServerPanel(this.getModel()));
                this._monInitialized = true;
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("backendmonitordn");
                int n2 = lDAPAttribute.size();
                Enumeration enumeration = lDAPAttribute.getStringValues();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    MonitorDatabasePanel monitorDatabasePanel = n2 > 1 ? new MonitorDatabasePanel(this.getModel(), string) : new MonitorDatabasePanel(this.getModel());
                    this.addTab(monitorDatabasePanel);
                    ++n;
                    if (n2 <= 1) continue;
                    this._tabbedPane.setTitleAt(n, monitorDatabasePanel.getTitle());
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("MonitorPanel.select: " + (Object)((Object)lDAPException)));
            }
        }
        this._tabbedPane.setSelectedIndex(0);
        super.select(iResourceObject, iPage);
    }
}

