/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.MonitorBasePanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class MonitorDatabasePanel
extends MonitorBasePanel {
    private static final String _section = "monitordatabase";
    static final ResourceSet _resource = DSUtil._resource;
    private Hashtable _hTables = null;
    private JTable _summaryTable = null;

    public MonitorDatabasePanel(IDSModel iDSModel) {
        super(iDSModel, _section);
        this._helpToken = "status-perfcounters-database-help";
        this._entryName = null;
    }

    public MonitorDatabasePanel(IDSModel iDSModel, String string) {
        super(iDSModel, _section);
        this._helpToken = "status-perfcounters-database-help";
        this._entryName = string;
        this.reload();
        this.setTitle(this.getAttrValue("database"));
    }

    public void init() {
        this._myPanel.setLayout(new GridBagLayout());
        if (this._entryName == null) {
            this.reload();
        }
        if (this._entry == null) {
            return;
        }
        this.createVersionArea(this._myPanel);
        JPanel jPanel = this.createRefreshArea();
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.gridx = 0;
        int n = UIFactory.getDifferentSpace();
        gridBagConstraints.insets = new Insets(0, n, 0, n);
        gridBagConstraints.gridwidth = 0;
        this._myPanel.add((Component)jPanel, gridBagConstraints);
        this.createSummaryArea(this._myPanel);
        this._hTables = new Hashtable();
        this.createFileAreas(this._myPanel);
        this.validate();
    }

    private boolean reload() {
        if (this._ldc == null) {
            this._ldc = this.getModel().getServerInfo().getLDAPConnection();
        }
        if (this._entryName == null) {
            try {
                LDAPEntry lDAPEntry = this._ldc.read("cn=monitor");
                if (lDAPEntry == null) {
                    return false;
                }
                this._entryName = DSUtil.getAttrValue(lDAPEntry, "backendmonitordn");
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("ERROR: LDAPConnection.read:" + (Object)((Object)lDAPException)));
                return false;
            }
        }
        try {
            this._entry = this._ldc.read(this._entryName);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("ERROR: LDAPConnection.read:" + (Object)((Object)lDAPException)));
            return false;
        }
        return true;
    }

    public boolean refresh() {
        if (!this.reload()) {
            return false;
        }
        if (this._summaryTable != null) {
            ((MonitorBasePanel.PerfTableModel)this._summaryTable.getModel()).updEntry(this._entry);
        }
        this.updateFileAreas();
        return super.refresh();
    }

    private void updateFileAreas() {
        String[] stringArray = new String[]{"dbfilecachehit", "dbfilecachemiss", "dbfilepagein", "dbfilepageout"};
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = _resource.getString(_section, "fileTable-" + stringArray[n2] + "-label");
            ++n2;
        }
        int n3 = 2;
        String[] stringArray3 = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            stringArray3[n4] = _resource.getString(_section, "fileHeader" + n4 + "-label");
            ++n4;
        }
        int[] nArray = new int[]{250, 100};
        boolean bl = false;
        LDAPAttributeSet lDAPAttributeSet = this._entry.getAttributeSet();
        int n5 = 0;
        while (n5 < lDAPAttributeSet.size()) {
            String string;
            LDAPAttribute lDAPAttribute = lDAPAttributeSet.elementAt(n5);
            String[] stringArray4 = new String[n];
            if (lDAPAttribute != null && (string = lDAPAttribute.getName()).startsWith("dbfilename-")) {
                Serializable serializable;
                String string2 = string.substring(11);
                String string3 = this.getAttrValue(string);
                JTable jTable = (JTable)this._hTables.get(string3);
                int n6 = 0;
                while (n6 < n) {
                    stringArray4[n6] = stringArray[n6] + "-" + string2;
                    ++n6;
                }
                if (jTable != null) {
                    serializable = (MonitorBasePanel.PerfTableModel)jTable.getModel();
                    if (serializable != null) {
                        ((MonitorBasePanel.PerfTableModel)serializable).updEntry(this._entry, false);
                        ((MonitorBasePanel.PerfTableModel)serializable).updDataNames(stringArray4, true);
                    }
                } else {
                    serializable = this.makeTable(stringArray2, stringArray3, stringArray4, nArray);
                    this.rightAlignColumns((JTable)serializable, 1, n3 - 1);
                    this.addTable((JTable)serializable, this._myPanel, this.getAttrValue(string));
                    this.rightAlignColumns((JTable)serializable, 1, n3 - 1);
                    this._hTables.put(this.getAttrValue(string), serializable);
                    this._myPanel.revalidate();
                }
            }
            ++n5;
        }
    }

    private JTable makeTable(String[] stringArray, String[] stringArray2, String[] stringArray3, int[] nArray) {
        MonitorBasePanel.PerfTableModel perfTableModel = new MonitorBasePanel.PerfTableModel(stringArray, stringArray2, stringArray3);
        JTable jTable = new JTable(perfTableModel);
        this._tables.addElement(jTable);
        this.setColumnWidths(jTable, nArray);
        this.setColumnHeaders(jTable, stringArray2);
        return jTable;
    }

    private void createVersionArea(JComponent jComponent) {
        GroupPanel groupPanel = new GroupPanel(_resource.getString(_section, "versionGroup-title"));
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jComponent.add((Component)groupPanel, gridBagConstraints);
        String string = _resource.getString(_section, "summary-database-label");
        string = string + " " + this.getAttrValue("database");
        JLabel jLabel = new JLabel(string);
        jLabel.setLabelFor(groupPanel);
        groupPanel.add((Component)jLabel, gridBagConstraints);
        string = _resource.getString(_section, "summary-configDN-label");
        string = string + " " + this._entryName;
        jLabel = new JLabel(string);
        jLabel.setLabelFor(groupPanel);
        groupPanel.add((Component)jLabel, gridBagConstraints);
    }

    private void createSummaryArea(JComponent jComponent) {
        String[] stringArray = new String[]{"readonly", "entrycachehits", "entrycachetries", "entrycachehitratio", "currententrycachesize", "maxentrycachesize", "currententrycachecount", "maxentrycachecount"};
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = _resource.getString(_section, "summaryTable-" + stringArray[n2] + "-label");
            ++n2;
        }
        int n3 = 2;
        String[] stringArray3 = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            stringArray3[n4] = _resource.getString(_section, "summaryHeader" + n4 + "-label");
            ++n4;
        }
        int[] nArray = new int[]{250, 100};
        this._summaryTable = this.makeTable(stringArray2, stringArray3, stringArray, nArray);
        this._summaryTable.getAccessibleContext().setAccessibleDescription(_resource.getString(_section, "summaryGroup-title"));
        this.rightAlignColumns(this._summaryTable, 1, n3 - 1);
        this.addTable(this._summaryTable, jComponent, _resource.getString(_section, "summaryGroup-title"));
    }

    private void createFileAreas(JComponent jComponent) {
        String[] stringArray = new String[]{"dbfilecachehit", "dbfilecachemiss", "dbfilepagein", "dbfilepageout"};
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = _resource.getString(_section, "fileTable-" + stringArray[n2] + "-label");
            ++n2;
        }
        int n3 = 2;
        String[] stringArray3 = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            stringArray3[n4] = _resource.getString(_section, "fileHeader" + n4 + "-label");
            ++n4;
        }
        int[] nArray = new int[]{250, 100};
        boolean bl = false;
        LDAPAttributeSet lDAPAttributeSet = this._entry.getAttributeSet();
        int n5 = 0;
        while (n5 < lDAPAttributeSet.size()) {
            String string;
            String[] stringArray4 = new String[n];
            LDAPAttribute lDAPAttribute = lDAPAttributeSet.elementAt(n5);
            if (lDAPAttribute != null && (string = lDAPAttribute.getName()).startsWith("dbfilename-")) {
                String string2 = string.substring(11);
                int n6 = 0;
                while (n6 < n) {
                    stringArray4[n6] = stringArray[n6] + "-" + string2;
                    ++n6;
                }
                JTable jTable = this.makeTable(stringArray2, stringArray3, stringArray4, nArray);
                this.rightAlignColumns(jTable, 1, n3 - 1);
                this.addTable(jTable, jComponent, this.getAttrValue(string));
                jTable.getAccessibleContext().setAccessibleDescription(_resource.getString(_section, "file-table-description", this.getAttrValue(string)));
                this._hTables.put(this.getAttrValue(string), jTable);
            }
            ++n5;
        }
    }
}

