/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BckListPanel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.DSEntrySet;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class MappingNodeBckPanel
extends BlankPanel
implements SuiConstants {
    private IDSModel _model = null;
    private JLabel _bckListLabel;
    private JList _bckList;
    private String[] _savebckList;
    private JButton _bAddBck;
    private JButton _bDeleteBck;
    private DefaultListModel _bckData;
    private boolean _isBckDirty = false;
    private JLabel _LibLabel;
    private JTextField _LibText;
    private String _saveLib = null;
    private JButton _bLibBrowse;
    private JLabel _functDistribLabel;
    private JTextField _functDistribText;
    private String _saveFunct = null;
    private boolean _isLibDirty = false;
    private boolean _isFctDirty = false;
    private static final String _section = "mappingtree-backend";
    static final String CONFIG_BASEDN = "cn=plugins, cn=config";
    static final String CONFIG_MAPPING = "cn=mapping tree, cn=config";
    static final String ROOT_MAPPING_NODE = "is root suffix";
    static final String ADD_BCK = "addBackend";
    static final String DELETE_BCK = "deleteBackend";
    static final String BROWSE = "browseDistribLib";
    static final int OPADD = 0;
    static final int OPDEL = 1;
    static final int OPREPLACE = 2;
    private final int ROWS = 4;
    private LDAPEntry _entry = null;

    public MappingNodeBckPanel(IDSModel iDSModel, LDAPEntry lDAPEntry) {
        super(iDSModel, _section);
        this._helpToken = "configuration-mapping-database-help";
        this._model = iDSModel;
        this._entry = lDAPEntry;
        this._refreshWhenSelect = false;
    }

    public void init() {
        if (this._isInitialized) {
            return;
        }
        this._myPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getGBC();
        DSEntrySet dSEntrySet = this.getDSEntrySet();
        this.createDataArea(this._myPanel, dSEntrySet);
        this.createValueArea(this._myPanel, dSEntrySet);
        this.addBottomGlue();
        this._isInitialized = true;
    }

    public void reloadDBList(LDAPEntry lDAPEntry) {
        this._entry = lDAPEntry;
        this._savebckList = this.getBackendListInEntry();
        if (this._bckData != null) {
            this._bckData.removeAllElements();
            int n = 0;
            while (this._savebckList != null && n < this._savebckList.length) {
                this._bckData.addElement(this._savebckList[n]);
                ++n;
            }
            this.checkBckNumber();
        }
    }

    public int nbBck() {
        if (this._isInitialized) {
            return this._bckList == null ? 0 : this._bckList.getModel().getSize();
        }
        String[] stringArray = this.getBackendListInEntry();
        if (stringArray != null) {
            return stringArray.length;
        }
        return 0;
    }

    protected void createDataArea(JPanel jPanel, DSEntrySet dSEntrySet) {
        GridBagConstraints gridBagConstraints = this.getGBC();
        GroupPanel groupPanel = new GroupPanel(DSUtil._resource.getString(_section, "general-title"), true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)groupPanel, gridBagConstraints);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.ipadx = 0;
        gridBagConstraints2.ipady = 0;
        groupPanel.setLayout(gridBagLayout);
        this._bckListLabel = this.makeJLabel(_section, "bck-list");
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        groupPanel.add((Component)this._bckListLabel, gridBagConstraints2);
        this._bckData = new DefaultListModel();
        this._bckList = new JList(this._bckData);
        this._bckListLabel.setLabelFor(this._bckList);
        this._bckList.setVisibleRowCount(4);
        this._bckList.setCellRenderer(new BackendCellRenderer());
        this._savebckList = this.getBackendListInEntry();
        int n = 0;
        while (this._savebckList != null && n < this._savebckList.length) {
            this._bckData.addElement(this._savebckList[n]);
            ++n;
        }
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this._bckList);
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        groupPanel.add((Component)jScrollPane, gridBagConstraints2);
        this._bAddBck = UIFactory.makeJButton(this, _section, "badd", null);
        this._bAddBck.setActionCommand(ADD_BCK);
        this._bAddBck.setEnabled(true);
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets = new Insets(0, 9, 6, 0);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 12;
        groupPanel.add((Component)this._bAddBck, gridBagConstraints2);
        this._bDeleteBck = UIFactory.makeJButton(this, _section, "bdelete", null);
        this._bDeleteBck.setActionCommand(DELETE_BCK);
        this._bDeleteBck.setEnabled(false);
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 9, 0, 0);
        gridBagConstraints2.anchor = 13;
        groupPanel.add((Component)this._bDeleteBck, gridBagConstraints2);
    }

    protected void createValueArea(JPanel jPanel, DSEntrySet dSEntrySet) {
        GridBagConstraints gridBagConstraints = this.getGBC();
        GroupPanel groupPanel = new GroupPanel(DSUtil._resource.getString(_section, "distrib-title"), true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)groupPanel, gridBagConstraints);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.ipadx = 0;
        gridBagConstraints2.ipady = 0;
        groupPanel.setLayout(gridBagLayout);
        this._LibLabel = this.makeJLabel(_section, "distrib");
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 0, 6, 0);
        groupPanel.add((Component)this._LibLabel, gridBagConstraints2);
        this._LibText = this.makeJTextField(_section, "distrib");
        this._LibLabel.setLabelFor(this._LibText);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.insets = new Insets(0, 0, 6, 0);
        this._saveLib = this._entry.getAttribute("nsslapd-distribution-plugin") == null ? "" : this._entry.getAttribute("nsslapd-distribution-plugin").getStringValueArray()[0];
        this._LibText.setText(this._saveLib);
        groupPanel.add((Component)this._LibText, gridBagConstraints2);
        this._bLibBrowse = UIFactory.makeJButton(this, _section, "distrib-button", null);
        this._bLibBrowse.setActionCommand(BROWSE);
        gridBagConstraints2.gridwidth = 1;
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets = new Insets(0, 9, 6, 0);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 13;
        groupPanel.add((Component)this._bLibBrowse, gridBagConstraints2);
        this._functDistribLabel = this.makeJLabel(_section, "distrib-function");
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 0, 6, 0);
        groupPanel.add((Component)this._functDistribLabel, gridBagConstraints2);
        this._functDistribText = this.makeJTextField(_section, "distrib-function");
        this._functDistribLabel.setLabelFor(this._functDistribText);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.insets = new Insets(0, 0, 6, 0);
        this._saveFunct = this._entry.getAttribute("nsslapd-distribution-funct") == null ? "" : this._entry.getAttribute("nsslapd-distribution-funct").getStringValueArray()[0];
        this._functDistribText.setText(this._saveFunct);
        groupPanel.add((Component)this._functDistribText, gridBagConstraints2);
        this.checkBckNumber();
        this.addBottomGlue();
    }

    private String[] getBackendListInEntry() {
        Vector vector = new Vector(1);
        LDAPAttribute lDAPAttribute = this._entry.getAttribute("nsslapd-backend");
        if (lDAPAttribute != null) {
            return lDAPAttribute.getStringValueArray();
        }
        return null;
    }

    private String[] getReferralListInEntry() {
        Vector vector = new Vector(1);
        LDAPAttribute lDAPAttribute = this._entry.getAttribute("nsslapd-Referral");
        if (lDAPAttribute != null) {
            return lDAPAttribute.getStringValueArray();
        }
        return null;
    }

    private boolean isListEmpty(JList jList) {
        boolean bl = jList.getModel().getSize() == 0;
        return bl;
    }

    private void clearBackendsChanges() {
        this.clearListChanges(this._bckListLabel, this._bckData, this._savebckList);
        this._isBckDirty = false;
    }

    private void clearDistribution() {
        this._LibText.setText(this._saveLib);
        this.setChangeState(this._LibLabel, 1);
        this._functDistribText.setText(this._saveFunct);
        this.setChangeState(this._functDistribLabel, 1);
    }

    private void clearListChanges(JComponent jComponent, DefaultListModel defaultListModel, String[] stringArray) {
        int n = defaultListModel.getSize() - 1;
        while (n >= 0) {
            defaultListModel.removeElementAt(n);
            --n;
        }
        int n2 = 0;
        while (stringArray != null && n2 < stringArray.length) {
            defaultListModel.addElement(stringArray[n2]);
            ++n2;
        }
        this.setChangeState(jComponent, 1);
    }

    private String[] getAllBackendsInList() {
        Vector vector = new Vector();
        int n = 0;
        while (n < this._bckList.getModel().getSize()) {
            vector.addElement(this._bckList.getModel().getElementAt(n));
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    private void checkBckDirty() {
        String[] stringArray = this.getAllBackendsInList();
        Debug.println((String)"MappingNodeBckPanel.checkBckDirty():");
        String[] stringArray2 = MappingUtils.whatsMoreInThisList(this._savebckList, stringArray);
        String[] stringArray3 = MappingUtils.whatsMoreInThisList(stringArray, this._savebckList);
        boolean bl = this._isBckDirty = stringArray2 != null && stringArray2.length > 0 || stringArray3 != null && stringArray3.length > 0;
        if (this._isLibDirty || this._isFctDirty || this._isBckDirty) {
            this.setDirtyFlag();
            this.setChangeState(this._bckListLabel, 2);
        } else {
            this.clearDirtyFlag();
            this.setChangeState(this._bckListLabel, 1);
        }
    }

    public void checkDistribDirty() {
        boolean bl;
        if (this._LibText == null || this._functDistribText == null) {
            return;
        }
        String string = this._LibText.getText();
        String string2 = this._functDistribText.getText();
        boolean bl2 = string == null || string.trim().length() == 0;
        boolean bl3 = string2 == null || string2.trim().length() == 0;
        boolean bl4 = this._saveLib == null || this._saveLib.trim().length() == 0;
        boolean bl5 = bl = this._saveFunct == null || this._saveFunct.trim().length() == 0;
        if (bl2) {
            this._isLibDirty = !bl4;
        } else if (bl4) {
            this._isLibDirty = true;
        } else {
            this._isLibDirty = string.trim().compareTo(this._saveLib.trim()) != 0;
            Debug.println((String)(" (compare) _isLibDirty:" + this._isLibDirty));
        }
        if (this._isLibDirty) {
            this.setChangeState(this._LibLabel, 2);
        } else {
            this.setChangeState(this._LibLabel, 1);
        }
        if (bl3) {
            this._isFctDirty = !bl;
        } else if (bl) {
            this._isFctDirty = true;
        } else {
            this._isFctDirty = string2.trim().compareTo(this._saveFunct.trim()) != 0;
            Debug.println((String)(" (compare) _isFctDirty:" + this._isLibDirty));
        }
        if (this._isFctDirty) {
            this.setChangeState(this._functDistribLabel, 2);
        } else {
            this.setChangeState(this._functDistribLabel, 1);
        }
        if (this._isLibDirty || this._isFctDirty || this._isBckDirty) {
            Debug.println((String)"MappingNodeBckPanel.checkDistribDirty Dirty");
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
    }

    private void checkBckNumber() {
        boolean bl = this._bckList.getModel().getSize() > 1;
        Debug.println((String)("MappingNodeBckPanel.checkBckNumber() nb =" + this._bckList.getModel().getSize()));
        this._functDistribText.setEnabled(bl);
        this._functDistribLabel.setEnabled(bl);
        this._LibText.setEnabled(bl);
        this._LibLabel.setEnabled(bl);
        this._bLibBrowse.setEnabled(bl);
    }

    private void setOkay(boolean bl) {
        AbstractDialog abstractDialog = this.getAbstractDialog();
        if (abstractDialog != null) {
            abstractDialog.setOKButtonEnabled(bl);
        }
    }

    private void checkOkay() {
        if (this._LibText != null && this._functDistribText != null) {
            String string = this._LibText.getText();
            String string2 = this._functDistribText.getText();
            boolean bl = string == null || string.trim().length() == 0;
            boolean bl2 = string2 == null || string2.trim().length() == 0;
            boolean bl3 = !bl && !bl2;
            this.setOkay(bl3);
        }
        this.modelUpdate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(ADD_BCK)) {
            String[] stringArray = this.addBackend();
            if (stringArray != null) {
                int n = stringArray.length - 1;
                while (n >= 0) {
                    this._bckData.addElement(stringArray[n]);
                    --n;
                }
                this.checkBckDirty();
                this.checkBckNumber();
            }
        } else if (actionEvent.getActionCommand().equals(DELETE_BCK)) {
            int[] nArray = this._bckList.getSelectedIndices();
            int n = nArray.length - 1;
            while (n >= 0) {
                this._bckData.removeElementAt(nArray[n]);
                --n;
            }
            this.checkBckDirty();
            this.checkBckNumber();
        } else if (actionEvent.getSource().equals(this._bLibBrowse)) {
            String string = this.getInstanceDirectory();
            String[] stringArray = new String[]{"so", "dll", "sl", "dl", "a"};
            String[] stringArray2 = new String[]{DSUtil._resource.getString("filefilter", "dynamic-lib-so"), DSUtil._resource.getString("filefilter", "dynamic-lib-dll"), DSUtil._resource.getString("filefilter", "dynamic-lib-sl"), DSUtil._resource.getString("filefilter", "dynamic-lib-dl"), DSUtil._resource.getString("filefilter", "dynamic-lib-a")};
            if ((string = DSFileDialog.getFileName(string, false, stringArray, stringArray2, this)) != null) {
                this._LibText.setText(string);
            }
        } else {
            Debug.println((String)" MappingNodeSettingPanel.actionPerformed() : wrong action performed");
        }
        this.checkOkay();
    }

    public void resetCallback() {
        this.reloadEntry();
        this.clearBackendsChanges();
        this.clearDistribution();
        this.checkBckNumber();
        this.clearDirtyFlag();
    }

    public boolean refresh() {
        this.resetCallback();
        return true;
    }

    public void reloadEntry() {
        if (this._entry == null) {
            return;
        }
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        try {
            this._entry = lDAPConnection.read(this._entry.getDN());
            this._saveLib = this._entry.getAttribute("nsslapd-distribution-plugin") == null ? "" : this._entry.getAttribute("nsslapd-distribution-plugin").getStringValueArray()[0];
            this._saveFunct = this._entry.getAttribute("nsslapd-distribution-funct") == null ? "" : this._entry.getAttribute("nsslapd-distribution-funct").getStringValueArray()[0];
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("MappingNodeBckPanel.reloadEntry(): " + (Object)((Object)lDAPException)));
        }
    }

    public void okCallback() {
        String string;
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        if (this._isBckDirty) {
            this.prepSaveBck(lDAPModificationSet);
        }
        if (this._LibText.isEnabled()) {
            string = this._LibText.getText();
            String string2 = this._functDistribText.getText();
            if (this._isLibDirty && (string2 == null || string2.trim().length() == 0)) {
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "error-no-funct", "");
                return;
            }
            if (this._isFctDirty && (string == null || string.trim().length() == 0)) {
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "error-no-lib", "");
                return;
            }
            this.prepSaveDistrib(lDAPModificationSet);
        }
        if (this._isLibDirty || this._isFctDirty || this._isBckDirty) {
            string = this._model.getServerInfo().getLDAPConnection();
            try {
                Debug.println((String)("******** :" + this._entry.getDN()));
                string.modify(this._entry.getDN(), lDAPModificationSet);
                this._saveLib = this._LibText.getText();
                this._saveFunct = this._functDistribText.getText();
                this._savebckList = this.getAllBackendsInList();
                this.checkDistribDirty();
                this._isBckDirty = false;
                this.clearDirtyFlag();
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("******** :" + lDAPException.toString()));
                String[] stringArray = new String[]{this._entry.getDN(), lDAPException.toString()};
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "update-error", stringArray, _section);
            }
        }
    }

    public boolean doDel() {
        boolean bl = true;
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        if (this._isBckDirty && this.prepDelBck(lDAPModificationSet)) {
            LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
            try {
                Debug.println((String)("******** doDel: modify " + this._entry.getDN()));
                lDAPConnection.modify(this._entry.getDN(), lDAPModificationSet);
                this._savebckList = this.getAllBackendsInList();
                this._isBckDirty = false;
                this.clearDirtyFlag();
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{this._entry.getDN(), lDAPException.toString()};
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "update-error", stringArray, _section);
                bl = false;
            }
        }
        return bl;
    }

    public boolean doAdd() {
        String string;
        boolean bl = true;
        boolean bl2 = false;
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        if (this._isBckDirty) {
            bl2 = this.prepAddBck(lDAPModificationSet);
        }
        if (this._LibText.isEnabled()) {
            string = this._LibText.getText();
            String string2 = this._functDistribText.getText();
            if (this._isLibDirty && (string2 == null || string2.trim().length() == 0)) {
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "error-no-funct", "");
                return false;
            }
            if (this._isFctDirty && (string == null || string.trim().length() == 0)) {
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "error-no-lib", "");
                return false;
            }
            this.prepSaveDistrib(lDAPModificationSet);
        }
        if (this._isLibDirty || this._isFctDirty || this._isBckDirty && bl2) {
            string = this._model.getServerInfo().getLDAPConnection();
            try {
                string.modify(this._entry.getDN(), lDAPModificationSet);
                this._saveLib = this._LibText.getText();
                this._saveFunct = this._functDistribText.getText();
                this._savebckList = this.getAllBackendsInList();
                this.checkDistribDirty();
                this._isBckDirty = false;
                this.clearDirtyFlag();
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("******** :" + lDAPException.toString()));
                String[] stringArray = new String[]{this._entry.getDN(), lDAPException.toString()};
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "update-error", stringArray, _section);
                bl = false;
            }
        }
        return bl;
    }

    private boolean prepAddBck(LDAPModificationSet lDAPModificationSet) {
        String[] stringArray = this.getAllBackendsInList();
        Debug.println((String)"MappingNodeSettingPanel.prepSaveBck");
        if (this._savebckList == null || this._savebckList.length == 0) {
            if (stringArray != null) {
                lDAPModificationSet.add(0, new LDAPAttribute("nsslapd-backend", stringArray));
                return true;
            }
            return false;
        }
        String[] stringArray2 = MappingUtils.whatsMoreInThisList(this._savebckList, stringArray);
        if (stringArray2 != null && stringArray2.length != 0) {
            lDAPModificationSet.add(0, new LDAPAttribute("nsslapd-backend", stringArray2));
            return true;
        }
        return false;
    }

    private boolean prepDelBck(LDAPModificationSet lDAPModificationSet) {
        String[] stringArray = this.getAllBackendsInList();
        Debug.println((String)"MappingNodeSettingPanel.prepSaveBck");
        if (this._savebckList == null || this._savebckList.length == 0) {
            return false;
        }
        String[] stringArray2 = MappingUtils.whatsMoreInThisList(stringArray, this._savebckList);
        if (stringArray2 != null && stringArray2.length != 0) {
            lDAPModificationSet.add(1, new LDAPAttribute("nsslapd-backend", stringArray2));
            return true;
        }
        return false;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        super.changedUpdate(documentEvent);
        this.checkOkay();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkDistribDirty();
        super.removeUpdate(documentEvent);
        this.checkOkay();
    }

    private void modelUpdate() {
        if (this._isBckDirty || this._isLibDirty || this._isFctDirty) {
            this.setDirtyFlag();
            this.setValidFlag();
        }
    }

    private void prepSaveBck(LDAPModificationSet lDAPModificationSet) {
        String[] stringArray = this.getAllBackendsInList();
        Debug.println((String)"MappingNodeSettingPanel.prepSaveBck");
        if (this._savebckList == null || this._savebckList.length == 0) {
            if (stringArray != null) {
                Debug.println((String)("*** new Add:nsslapd-backend" + stringArray));
                lDAPModificationSet.add(0, new LDAPAttribute("nsslapd-backend", stringArray));
            }
        } else {
            String[] stringArray2 = MappingUtils.whatsMoreInThisList(this._savebckList, stringArray);
            String[] stringArray3 = MappingUtils.whatsMoreInThisList(stringArray, this._savebckList);
            if (stringArray2 != null && stringArray2.length != 0) {
                Debug.println((String)("*** upd Add:nsslapd-backend" + stringArray2));
                lDAPModificationSet.add(0, new LDAPAttribute("nsslapd-backend", stringArray2));
            }
            if (stringArray3 != null && stringArray3.length != 0) {
                Debug.println((String)("*** upd Del:nsslapd-backend" + stringArray3));
                lDAPModificationSet.add(1, new LDAPAttribute("nsslapd-backend", stringArray3));
            }
        }
    }

    private void prepSaveDistrib(LDAPModificationSet lDAPModificationSet) {
        int n;
        String string = this._LibText.getText();
        String string2 = this._functDistribText.getText();
        Debug.println((String)"MappingNodeSettingPanel.prepSaveDistrib");
        if (this._isLibDirty) {
            if (string != null && string.trim().length() > 0) {
                if (this._saveLib == null && this._saveLib.trim().length() == 0) {
                    n = 0;
                    Debug.println((String)"***  add:");
                } else {
                    n = 2;
                    Debug.println((String)"***  upd:");
                }
                Debug.println((String)("***  nsslapd-distribution-plugin" + string));
                lDAPModificationSet.add(n, new LDAPAttribute("nsslapd-distribution-plugin", string));
            } else {
                Debug.println((String)("***  del : nsslapd-distribution-plugin" + string));
                lDAPModificationSet.add(1, new LDAPAttribute("nsslapd-distribution-plugin", string));
            }
        }
        if (this._isFctDirty) {
            if (string2 != null && string2.trim().length() > 0) {
                if (this._saveFunct == null && this._saveFunct.trim().length() == 0) {
                    n = 0;
                    Debug.println((String)"***  add:");
                } else {
                    n = 2;
                    Debug.println((String)"***  upd:");
                }
                Debug.println((String)("*** nsslapd-distribution-funct" + string2));
                lDAPModificationSet.add(n, new LDAPAttribute("nsslapd-distribution-funct", string2));
            } else {
                Debug.println((String)("***  del : nsslapd-distribution-funct" + string2));
                lDAPModificationSet.add(1, new LDAPAttribute("nsslapd-distribution-funct", string2));
            }
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkDistribDirty();
        super.insertUpdate(documentEvent);
        this.checkOkay();
    }

    protected String[] addBackend() {
        String[] stringArray = MappingUtils.getBackendList(this._model.getServerInfo().getLDAPConnection());
        String[] stringArray2 = this.getAllBackendsInList();
        BckListPanel bckListPanel = new BckListPanel(this._model, stringArray, stringArray2, "configuration-mapping-add-backend-dbox-help");
        SimpleDialog simpleDialog = new SimpleDialog(this.getModel().getFrame(), bckListPanel.getTitle(), 11, bckListPanel);
        simpleDialog.setComponent(bckListPanel);
        simpleDialog.setOKButtonEnabled(false);
        simpleDialog.setDefaultButton(1);
        ((JDialog)((Object)simpleDialog)).getAccessibleContext().setAccessibleDescription(DSUtil._resource.getString(_section, "add-backend-description"));
        simpleDialog.packAndShow();
        String[] stringArray3 = (String[])bckListPanel.getSelectedItem();
        if (stringArray3 != null) {
            return stringArray3;
        }
        return null;
    }

    class BackendCellRenderer
    extends DefaultListCellRenderer {
        BackendCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (jList.isSelectionEmpty()) {
                MappingNodeBckPanel.this._bDeleteBck.setEnabled(false);
            } else {
                MappingNodeBckPanel.this._bDeleteBck.setEnabled(true);
            }
            MappingNodeBckPanel.this.checkOkay();
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }
}

