/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSExportImport;
import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.IEntryChangeListener;
import com.netscape.admin.dirserv.panel.FilePanel;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import netscape.ldap.LDAPConnection;

public class LDAPAddPanel
extends FilePanel {
    private JCheckBox _cbContinuous;
    private JCheckBox _cbAddOnly;
    private JLabel _lblRejects;
    private JButton _bRejects;
    private JTextField _tfRejects;
    private static final String _section = "import";

    public LDAPAddPanel(IDSModel iDSModel) {
        super(iDSModel, _section, true, false);
        this._helpToken = "configuration-database-import-ldap-dbox-help";
    }

    public void init() {
        JPanel jPanel = this._myPanel;
        jPanel.setLayout(new GridBagLayout());
        this.createFileArea(jPanel);
        this.createOptionsArea(jPanel);
        this.addBottomGlue();
        this.setLocalState(true);
        this.getAbstractDialog().setFocusComponent((JComponent)this._tfExport);
        this.getAbstractDialog().getAccessibleContext().setAccessibleDescription(this._resource.getString(_section, "description"));
    }

    private void createOptionsArea(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = this.getGBC();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = this.getComponentInsets();
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this._cbAddOnly = this.makeJCheckBox(_section, "addonly");
        this._cbAddOnly.setSelected(false);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this._cbAddOnly, gridBagConstraints);
        this._cbContinuous = this.makeJCheckBox(_section, "continuous");
        this._cbContinuous.setSelected(true);
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this._cbContinuous, gridBagConstraints);
        JLabel jLabel = this.makeJLabel(_section, "rejects");
        gridBagConstraints.gridwidth = 4;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this._tfRejects = this.makeJTextField(_section, "rejects", "", 30);
        jLabel.setLabelFor(this._tfRejects);
        gridBagConstraints.gridwidth = 3;
        jPanel2.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this._tfRejects, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        this._bRejects = this.makeJButton(_section, "browse-rejects-file");
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this._bRejects, gridBagConstraints);
    }

    protected void setLocalState(boolean bl) {
        if (this.isLocal()) {
            return;
        }
        super.setLocalState(bl);
    }

    protected void checkOkay() {
        String string = this.getFilename();
        String string2 = this._tfRejects.getText().trim();
        AbstractDialog abstractDialog = this.getAbstractDialog();
        if (abstractDialog != null) {
            boolean bl = false;
            if (string != null && string.length() > 0) {
                File file;
                File file2;
                bl = true;
                if (string2 != null && (file2 = new File(string2)).equals(file = new File(string))) {
                    bl = false;
                }
            }
            abstractDialog.setOKButtonEnabled(bl);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        super.changedUpdate(documentEvent);
        this.checkOkay();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        super.removeUpdate(documentEvent);
        this.checkOkay();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        super.insertUpdate(documentEvent);
        this.checkOkay();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._bExport)) {
            File file;
            String string = this.getFilename();
            String[] stringArray = new String[]{"ldif"};
            String[] stringArray2 = new String[]{this._resource.getString("filefilter", "ldif-label")};
            String string2 = this.getDefaultPath(this.getModel());
            if ((string = string == null || string.trim().length() < 1 ? DSFileDialog.getFileName(false, stringArray, stringArray2, this, "*.ldif", string2) : ((file = new File(string)).isAbsolute() ? DSFileDialog.getFileName(string, false, stringArray, stringArray2, this) : DSFileDialog.getFileName(false, stringArray, stringArray2, this, string, string2))) != null) {
                this.setFilename(string);
            }
        } else if (actionEvent.getSource().equals(this._bRejects)) {
            File file;
            String string = this._tfRejects.getText();
            String string3 = this.getDefaultPath(this.getModel());
            if ((string = string == null || string.trim().length() < 1 ? DSFileDialog.getFileName(false, null, null, this, "rejects", string3) : ((file = new File(string)).isAbsolute() ? DSFileDialog.getFileName(string, false, this) : DSFileDialog.getFileName(false, null, null, this, string, string3))) != null) {
                this._tfRejects.setText(string);
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void okCallback() {
        boolean bl = false;
        String string = this.getFilename();
        if (string.trim().equals("") && !this.validateFilename()) {
            return;
        }
        Object var3_3 = null;
        ConsoleInfo consoleInfo = this.getModel().getServerInfo();
        LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
        try {
            String[] stringArray;
            Object object;
            File file = new File(string);
            if (!file.isAbsolute()) {
                string = DSFileDialog.getPath() != null ? DSFileDialog.getPath() + string : this.getDefaultPath(this.getModel()) + string;
            }
            file = new File(string);
            try {
                object = new FileInputStream(file);
            }
            catch (Exception exception) {
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "cantopen", string, _section);
                return;
            }
            string = file.getCanonicalPath();
            object = this._tfRejects.getText();
            if (((String)object).length() < 1) {
                object = null;
            } else {
                int n;
                File file2 = new File((String)object);
                if (!file2.isAbsolute()) {
                    object = DSFileDialog.getPath() != null ? DSFileDialog.getPath() + (String)object : this.getDefaultPath(this.getModel()) + (String)object;
                }
                if ((file2 = new File((String)object)).equals(file)) {
                    DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "rejectsfileisimportfile", "", _section);
                    return;
                }
                if (DSUtil.fileExists(file2) && (n = DSUtil.showConfirmationDialog((Component)this.getModel().getFrame(), "confirm-delete-reject-file", DSUtil.inverseAbreviateString((String)object, 30), _section)) != 0) {
                    return;
                }
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                }
                catch (Exception exception) {
                    String[] stringArray2 = new String[]{DSUtil.inverseAbreviateString((String)object, 40)};
                    DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "unwritable-check", stringArray2, _section);
                    return;
                }
            }
            boolean bl2 = this._cbAddOnly.isSelected();
            boolean bl3 = this._cbContinuous.isSelected();
            DSExportImport dSExportImport = new DSExportImport(lDAPConnection, string, bl2, bl3, (String)object);
            String string2 = this._resource.getString(_section, "title");
            LDAPAddProgressDialog lDAPAddProgressDialog = new LDAPAddProgressDialog(this.getModel().getFrame(), string2, this, dSExportImport, (String)object);
            dSExportImport.addEntryChangeListener(lDAPAddProgressDialog);
            this.hideDialog();
            try {
                stringArray = new Thread(dSExportImport);
                stringArray.start();
            }
            catch (Exception exception) {
                Debug.println((String)("LDAPAddPanel.okCallback: " + exception));
                exception.printStackTrace();
                return;
            }
            lDAPAddProgressDialog.packAndShow();
            bl = dSExportImport.getStatus();
            if (lDAPAddProgressDialog.hasBeenCancelled()) {
                if (bl) {
                    stringArray = new String[]{Integer.toString(dSExportImport.getEntryCount()), Integer.toString(dSExportImport.getRejectCount())};
                    DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "succeeded", stringArray, _section);
                } else if (dSExportImport.getError() == 3) {
                    stringArray = new String[]{DSUtil.inverseAbreviateString((String)object, 40), Integer.toString(3)};
                    DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "unwritable", stringArray, _section);
                } else if (dSExportImport.getError() == 4) {
                    stringArray = new String[]{DSUtil.abreviateString(dSExportImport.getLastDN(), 30), Integer.toString(4)};
                    DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "BulkAddError-ldifSyntaxError", stringArray, "general");
                } else if (dSExportImport.getError() == 5) {
                    int n = dSExportImport.getEntryCount() + dSExportImport.getRejectCount() + 1;
                    String string3 = dSExportImport.getLastDN();
                    if (string3 == null) {
                        String[] stringArray3 = new String[]{Integer.toString(n), Integer.toString(5)};
                        DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "malformed-expression-error-number", stringArray3, _section);
                    } else {
                        String[] stringArray4 = new String[]{DSUtil.abreviateString(string3, 30), Integer.toString(5)};
                        DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "malformed-expression-error-dn", stringArray4, _section);
                    }
                } else {
                    DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "failed", Integer.toString(dSExportImport.getError()), _section);
                }
            }
        }
        catch (Exception exception) {
            Debug.println((String)("LDAPAddPanel.okCallback: import failed - " + exception));
            exception.printStackTrace();
        }
        if (bl) {
            this.getModel().contentChanged();
        }
        this.clearDirtyFlag();
    }

    public void resetCallback() {
        this.clearDirtyFlag();
        this.hideDialog();
    }

    class LDAPAddProgressDialog
    extends GenericProgressDialog
    implements IEntryChangeListener,
    ActionListener {
        private String _rejects;
        private DSExportImport _ds;
        private boolean _continue = true;
        private boolean _done = false;

        public LDAPAddProgressDialog(JFrame jFrame, String string, Component component, DSExportImport dSExportImport, String string2) {
            super(jFrame, true, 7, string, component);
            this.addActionListener(this);
            this.setLabelRows(2);
            this.setTextInTextAreaLabel(LDAPAddPanel.this._resource.getString(LDAPAddPanel._section, "rejects-progressdialog-label"));
            this._ds = dSExportImport;
            this._rejects = string2;
        }

        public boolean entryChanged(String string, String string2) {
            if (string == null) {
                this._done = true;
            }
            if (this._continue && string != null) {
                if (this._ds.getCurrentEntry() % 5 == 0) {
                    String[] stringArray = new String[]{String.valueOf(this._ds.getCurrentEntry()), DSUtil.abreviateString(string, 60)};
                    this.setTextInLabel(LDAPAddPanel.this._resource.getString(LDAPAddPanel._section, "addingentrynumber-label", stringArray));
                }
                if (string2 != null) {
                    if (!string.trim().equals("")) {
                        this.appendTextToTextArea(string + ": " + string2 + "\n");
                    } else {
                        this.appendTextToTextArea(string2 + "\n");
                    }
                }
                return true;
            }
            if (this._continue) {
                boolean bl = this._ds.getStatus();
                if (bl) {
                    String[] stringArray = new String[]{Integer.toString(this._ds.getEntryCount()), Integer.toString(this._ds.getRejectCount())};
                    this.setTextInLabel(LDAPAddPanel.this._resource.getString(LDAPAddPanel._section, "succeeded-msg", stringArray));
                } else if (this._ds.getError() == 3) {
                    String[] stringArray = new String[2];
                    stringArray[0] = this._rejects;
                    stringArray[1] = Integer.toString(3);
                    String[] stringArray2 = stringArray;
                    this.setTextInLabel(LDAPAddPanel.this._resource.getString(LDAPAddPanel._section, "unwritable-msg", stringArray2));
                } else if (this._ds.getError() == 4) {
                    String[] stringArray = new String[2];
                    stringArray[0] = DSUtil.abreviateString(this._ds.getLastDN(), 45);
                    stringArray[1] = Integer.toString(4);
                    String[] stringArray3 = stringArray;
                    this.setTextInLabel(LDAPAddPanel.this._resource.getString("general", "BulkAddError-ldifSyntaxError-msg", stringArray3));
                } else if (this._ds.getError() == 5) {
                    int n = this._ds.getEntryCount() + this._ds.getRejectCount() + 1;
                    String string3 = this._ds.getLastDN();
                    if (string3 == null) {
                        String[] stringArray = new String[2];
                        stringArray[0] = Integer.toString(n);
                        stringArray[1] = Integer.toString(5);
                        String[] stringArray4 = stringArray;
                        this.setTextInLabel(LDAPAddPanel.this._resource.getString(LDAPAddPanel._section, "malformed-expression-error-number-msg", stringArray4));
                    } else {
                        String[] stringArray = new String[2];
                        stringArray[0] = DSUtil.abreviateString(string3, 45);
                        stringArray[1] = Integer.toString(5);
                        String[] stringArray5 = stringArray;
                        this.setTextInLabel(LDAPAddPanel.this._resource.getString(LDAPAddPanel._section, "malformed-expression-error-dn-msg", stringArray5));
                    }
                } else {
                    String[] stringArray = new String[]{Integer.toString(this._ds.getError())};
                    this.setTextInLabel(LDAPAddPanel.this._resource.getString(LDAPAddPanel._section, "failed-msg", stringArray));
                }
                this.waitForClose();
                return false;
            }
            this.closeCallBack();
            return false;
        }

        public boolean entryChanged(String string) {
            return this.entryChanged(string, null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("Cancel-GenericProgressDialog")) {
                this._continue = false;
                if (this._done) {
                    this.closeCallBack();
                }
            } else if (actionEvent.getActionCommand().equals("Close-GenericProgressDialog")) {
                this.closeCallBack();
            }
        }

        public boolean hasBeenCancelled() {
            return !this._continue;
        }
    }
}

