/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.DefaultResourceModel;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.GlobalConstants;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.CenterAlignedHeaderRenderer;
import com.netscape.admin.dirserv.panel.CheckBoxTableCellRenderer;
import com.netscape.admin.dirserv.panel.CheckboxTableKeyListener;
import com.netscape.admin.dirserv.panel.IndexAttrUtility;
import com.netscape.admin.dirserv.panel.LabelTableCellRenderer;
import com.netscape.admin.dirserv.panel.NewIndexPanel;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.task.AddIndex;
import com.netscape.admin.dirserv.task.LDAPBasicProgressDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.UITools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSearchResults;

public class IndexManagementPanel
extends BlankPanel {
    private static final String ADD = "add";
    private static final String DELETE = "delete";
    private static final String RDN_INDEX = "cn=index,";
    private static final String RDN_MONITOR = "cn=monitor,";
    private static final int SUCCESS = 0;
    private static final int FAILURE = 1;
    private static final int MODIFYAGAIN = 2;
    private static final String _section = "index";
    private static final String DN_PREFIX = "cn=index,cn=config,cn=ldbm database,cn=plugins,cn=config";
    private static final String[] FILTERS = new String[]{"approx", "eq", "pres", "sub"};
    private static final String[] OCLASSES = new String[]{"top", "nsIndex"};
    private Vector _addedEntries = null;
    private String[] headers = null;
    private JTable _indexTableSystem = null;
    private JTable _indexTableUser = null;
    private Hashtable _attributes = null;
    private Hashtable _changedAttributes = null;
    private Hashtable _newAttributes = null;
    private Hashtable _systemIndexes = null;
    private Hashtable _matchingRules = null;
    private IndexAttrTableModel _systemDataModel = null;
    private IndexAttrTableModel _userDataModel = null;
    private int numColumns;
    private JButton _bAdd;
    private JButton _bDelete;
    private String _dnEntry = null;
    private String _conf_prefix = null;
    private JSplitPane _splitPane = null;
    LDAPBasicProgressDialog _statusProgressDialog;
    GenericProgressDialog _progressDialog;
    private boolean _taskCancelled = false;
    Component _comp;
    String _msg;
    String _arg;

    public IndexManagementPanel(IDSModel iDSModel) {
        this(iDSModel, DN_PREFIX);
        Debug.println((String)"IndexManagementPanel() : default applied");
    }

    public IndexManagementPanel(IDSModel iDSModel, String string) {
        super(iDSModel, _section, false);
        this._helpToken = "configuration-database-indexes-help";
        this._dnEntry = string;
        this._conf_prefix = this.isPluginEntry(string) ? "cn=config," : "";
        Debug.println((String)("IndexManagementPanel() dnEntry:" + string));
        this._refreshWhenSelect = false;
    }

    public void init() {
        this._attributes = new Hashtable();
        this._changedAttributes = new Hashtable();
        this._newAttributes = new Hashtable();
        this._systemIndexes = new Hashtable();
        this._matchingRules = new Hashtable();
        this._myPanel.setLayout(new GridBagLayout());
        JComponent jComponent = this.createIndexTable(this._myPanel);
        this._splitPane = (JSplitPane)jComponent;
        this.resetGBC();
        this._gbc.fill = 1;
        this._gbc.gridwidth = 0;
        this._gbc.gridheight = -1;
        this._gbc.weighty = 1.0;
        this._gbc.insets = new Insets(0, 0, 0, 0);
        this._myPanel.add((Component)jComponent, this._gbc);
        this._bAdd = this.makeJButton(_section, ADD);
        this._bAdd.setActionCommand(ADD);
        this._bDelete = this.makeJButton(_section, DELETE);
        this._bDelete.setActionCommand(DELETE);
        this._bDelete.setEnabled(false);
        JButton[] jButtonArray = new JButton[]{this._bAdd, this._bDelete};
        JPanel jPanel = UIFactory.makeJButtonPanel(jButtonArray);
        this.resetGBC();
        this._gbc.gridwidth = 0;
        this._gbc.fill = 2;
        this._gbc.weightx = 1.0;
        this._gbc.weighty = 0.0;
        this._gbc.insets = new Insets(UIFactory.getDifferentSpace(), 0, 0, 0);
        this._myPanel.add((Component)jPanel, this._gbc);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.modelUpdate();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.modelUpdate();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.modelUpdate();
    }

    private void modelUpdate() {
        int n = this._indexTableUser.getEditingRow();
        int n2 = this._indexTableUser.getEditingColumn();
        if (n != -1 && n2 != -1) {
            this.setValidFlag();
            this.setDirtyFlag();
        }
    }

    protected JTable createTable(IndexAttrTableModel indexAttrTableModel) {
        Serializable serializable;
        JTable jTable = new JTable(indexAttrTableModel);
        jTable.setColumnSelectionAllowed(false);
        int n = 0;
        while (n < this.numColumns) {
            int n2 = Integer.parseInt(DSUtil._resource.getString(_section, "index-table-columnwidth-" + n));
            serializable = jTable.getColumn(this.headers[n]);
            ((TableColumn)serializable).setPreferredWidth(n2);
            ((TableColumn)serializable).setHeaderRenderer((TableCellRenderer)((Object)new CenterAlignedHeaderRenderer()));
            if (n > 0 && n < this.numColumns - 1) {
                ((TableColumn)serializable).setCellRenderer(new CheckBoxTableCellRenderer());
            }
            ++n;
        }
        TableColumn tableColumn = jTable.getColumn(this.headers[this.numColumns - 1]);
        serializable = new JTextField();
        ((JTextComponent)serializable).getDocument().addDocumentListener(this);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor((JTextField)serializable);
        defaultCellEditor.setClickCountToStart(1);
        tableColumn.setCellEditor(defaultCellEditor);
        tableColumn.setCellRenderer(new LabelTableCellRenderer());
        return jTable;
    }

    protected JComponent createIndexTable(JPanel jPanel) {
        Insets insets;
        int n = UIFactory.getDifferentSpace();
        this.numColumns = Integer.parseInt(DSUtil._resource.getString(_section, "table-columns"));
        this._attributes = this.getIndexedAttributes();
        this.constructDataModel(false);
        JLabel jLabel = this.makeJLabel(_section, "system");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 0);
        jPanel2.setBorder(emptyBorder);
        this.resetGBC();
        this._gbc.gridwidth = 0;
        this._gbc.insets = insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)jLabel, this._gbc);
        this._indexTableSystem = this.createTable(this._systemDataModel);
        jLabel.setLabelFor(this._indexTableSystem);
        this._indexTableSystem.setRowSelectionAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(this._indexTableSystem);
        jScrollPane.setBorder(UITools.createLoweredBorder());
        this.resetGBC();
        this._gbc.weightx = 1.0;
        this._gbc.weighty = 1.0;
        this._gbc.fill = 1;
        this._gbc.gridwidth = 0;
        this._gbc.insets = insets;
        jPanel2.add((Component)jScrollPane, this._gbc);
        JLabel jLabel2 = this.makeJLabel(_section, "user");
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(emptyBorder);
        this._indexTableUser = this.createTable(this._userDataModel);
        jLabel2.setLabelFor(this._indexTableUser);
        this._indexTableUser.getSelectionModel().setSelectionMode(0);
        this._indexTableUser.getSelectionModel().addListSelectionListener(this);
        this._indexTableUser.setAutoResizeMode(1);
        this._indexTableUser.setRequestFocusEnabled(false);
        this._indexTableUser.addKeyListener(new CheckboxTableKeyListener());
        this.resetGBC();
        this._gbc.gridwidth = 0;
        this._gbc.insets = insets;
        jPanel3.add((Component)jLabel2, this._gbc);
        JScrollPane jScrollPane2 = new JScrollPane(this._indexTableUser);
        jScrollPane2.setBorder(UITools.createLoweredBorder());
        this.resetGBC();
        this._gbc.weightx = 1.0;
        this._gbc.weighty = 1.0;
        this._gbc.fill = 1;
        this._gbc.gridwidth = 0;
        this._gbc.insets = insets;
        jPanel3.add((Component)jScrollPane2, this._gbc);
        final JSplitPane jSplitPane = new JSplitPane(0, jPanel2, jPanel3);
        jSplitPane.setBorder(emptyBorder);
        jSplitPane.resetToPreferredSizes();
        int n2 = 4 * this._indexTableSystem.getRowHeight();
        jScrollPane.setMinimumSize(new Dimension(100, n2));
        jScrollPane2.setMinimumSize(jScrollPane.getMinimumSize());
        int n3 = 7 * this._indexTableSystem.getRowHeight();
        jScrollPane.setPreferredSize(new Dimension(100, n3));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jSplitPane.setDividerLocation(0.5);
            }
        });
        return jSplitPane;
    }

    private double getSystemWeightY() {
        int n = this._indexTableSystem.getRowCount();
        int n2 = this._indexTableUser.getRowCount();
        return (double)n / (double)(n + n2);
    }

    private void constructDataModel(boolean bl) {
        Enumeration enumeration = this._attributes.keys();
        if (!bl) {
            this._userDataModel = new IndexAttrTableModel();
            this._systemDataModel = new IndexAttrTableModel();
            this.headers = new String[this.numColumns];
            int n = 0;
            while (n < this.numColumns) {
                this.headers[n] = DSUtil._resource.getString(_section, "index-table-columnheading-" + n);
                this._userDataModel.addColumn(this.headers[n]);
                this._systemDataModel.addColumn(this.headers[n]);
                ++n;
            }
        } else {
            this._userDataModel.removeAllRows();
            this._systemDataModel.removeAllRows();
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.isSystemIndex(string)) {
                this.fillRow(this._systemDataModel, string);
                continue;
            }
            this.fillRow(this._userDataModel, string);
        }
    }

    public boolean refresh() {
        this._attributes = this.getIndexedAttributes();
        this.constructDataModel(true);
        this._changedAttributes.clear();
        this._newAttributes.clear();
        this.clearDirtyFlag();
        int n = this._indexTableUser.getSelectedRow();
        if (n >= 0) {
            this._bDelete.setEnabled(true);
        } else {
            this._bDelete.setEnabled(false);
        }
        return true;
    }

    public void resetCallback() {
        int n;
        if (this.isDirty()) {
            this._attributes = this.getIndexedAttributes();
            this.constructDataModel(true);
            this._changedAttributes.clear();
            this._newAttributes.clear();
            this.clearDirtyFlag();
        }
        if ((n = this._indexTableUser.getSelectedRow()) >= 0) {
            this._bDelete.setEnabled(true);
        } else {
            this._bDelete.setEnabled(false);
        }
    }

    private Vector getNewIndexesInVector(Hashtable hashtable) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector2 = (Vector)hashtable.get(string);
            int n = vector2.size();
            if (n < 1) continue;
            String string2 = string + ":";
            int n2 = 0;
            while (n2 < n) {
                string2 = string2 + (String)vector2.elementAt(n2);
                if (n2 < n - 1) {
                    string2 = string2 + ',';
                }
                ++n2;
            }
            String string3 = (String)this._matchingRules.get(string);
            if (string3 != null && (string3 = string3.trim()).length() > 0) {
                string2 = string2 + ":" + string3;
            }
            vector.addElement(string2);
        }
        return vector;
    }

    private String getNewIndexes(Hashtable hashtable) {
        String string = "";
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(string2);
            int n = vector.size();
            if (n < 1) continue;
            string = string + string2 + ":";
            int n2 = 0;
            while (n2 < n) {
                string = string + (String)vector.elementAt(n2);
                if (n2 < n - 1) {
                    string = string + ',';
                }
                ++n2;
            }
            String string3 = (String)this._matchingRules.get(string2);
            if (string3 != null && (string3 = string3.trim()).length() > 0) {
                string = string + ":" + string3;
            }
            string = string + ' ';
        }
        return string.trim();
    }

    public void okCallback() {
        Object object;
        Object[] objectArray;
        Object object2;
        if (!this.isDirty()) {
            return;
        }
        TableCellEditor tableCellEditor = this._indexTableUser.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        if (BlankPanel.requiresConfirmation(GlobalConstants.PREFERENCES_CONFIRM_DELETE_INDEX)) {
            int n;
            object2 = this._changedAttributes.keys();
            boolean bl = false;
            String string = "";
            Vector<Object[]> vector = new Vector<Object[]>();
            while (object2.hasMoreElements()) {
                objectArray = (Object[])object2.nextElement();
                object = (Vector)this._changedAttributes.get(objectArray);
                if (((Vector)object).size() >= 1) continue;
                bl = true;
                string = string + (String)objectArray + ' ';
                vector.addElement(objectArray);
            }
            if (bl && (n = DSUtil.showConfirmationDialog((Component)this.getModel().getFrame(), "confirm-delete", string.trim(), _section)) != 0) {
                object = vector.elements();
                while (object.hasMoreElements()) {
                    this.fillRow(this._userDataModel, (String)object.nextElement());
                }
                return;
            }
        }
        object2 = this.getNewIndexesInVector(this._newAttributes);
        Vector vector = this.getNewIndexesInVector(this._changedAttributes);
        int n = 0;
        while (n < vector.size()) {
            ((Vector)object2).addElement(vector.elementAt(n));
            ++n;
        }
        boolean bl = false;
        objectArray = null;
        if (((Vector)object2).size() > 0) {
            objectArray = new String[((Vector)object2).size()];
            ((Vector)object2).copyInto(objectArray);
            bl = true;
            object = DSUtil._resource.getString(_section, "title");
            this._progressDialog = new GenericProgressDialog(this.getModel().getFrame(), true, 6, (String)object, null, this);
            if (objectArray != null) {
                this._progressDialog.addStep(DSUtil._resource.getString(_section, "LDAPMode-firstStep-title"));
                this._progressDialog.addStep(DSUtil._resource.getString(_section, "LDAPMode-secondStep-title"));
            } else {
                this._progressDialog.addStep(DSUtil._resource.getString(_section, "LDAPMode-firstStep-title"));
            }
            this._progressDialog.disableCancelButton();
            this._statusProgressDialog = new LDAPBasicProgressDialog(this.getModel().getFrame(), DSUtil._resource.getString(_section, "LDAPMode-Status-title"), true, null, this);
            this._statusProgressDialog.waitForClose();
        } else {
            if (this._changedAttributes.size() < 1) {
                this.resetCallback();
                return;
            }
            object = DSUtil._resource.getString(_section, "title");
            this._progressDialog = new GenericProgressDialog(this.getModel().getFrame(), true, 5, (String)object, null, this);
            this._progressDialog.addStep(DSUtil._resource.getString(_section, "LDAPMode-deleteStep-title"));
            this._progressDialog.disableCancelButton();
        }
        object = new Thread(new IndexRunnable((String[])objectArray));
        try {
            ((Thread)object).start();
            this._progressDialog.packAndShow();
        }
        catch (Exception exception) {
            Debug.println((String)("IndexManagementPanel.okCallBack(): " + exception));
        }
        int n2 = this._indexTableUser.getSelectedRow();
        if (n2 >= 0) {
            this._bDelete.setEnabled(true);
        } else {
            this._bDelete.setEnabled(false);
        }
    }

    private boolean updateDirectoryEntries() {
        boolean bl = true;
        Enumeration enumeration = this._changedAttributes.keys();
        while (bl && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)this._changedAttributes.get(string);
            String string2 = "cn=" + string + "," + RDN_INDEX + this._conf_prefix + this._dnEntry;
            if (this._taskCancelled) {
                return false;
            }
            Debug.println((String)("IndexManagement.updateDirectoryEntries() : deleting dn :" + string2));
            this._progressDialog.setTextInLabel(DSUtil._resource.getString(_section, "delete-entry-title", string2));
            if (vector.size() < 1) {
                if (!IndexAttrUtility.deleteAttribute(this.getModel(), string2)) continue;
                this._attributes = this.getIndexedAttributes();
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            IndexManagementPanel.this.constructDataModel(true);
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this._changedAttributes.remove(string);
                continue;
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            String string3 = (String)this._matchingRules.get(string);
            if (string3 != null && (string3 = string3.trim()).length() < 1) {
                string3 = null;
            }
            Debug.print((String)("IndexManagement.updateDirectoryEntries: " + string + " < "));
            int n = 0;
            while (n < objectArray.length) {
                Debug.print((String)((String)objectArray[n] + " "));
                ++n;
            }
            if (string3 != null) {
                Debug.print((String)("> < " + string3 + " "));
            }
            Debug.println((String)">");
            LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
            lDAPModificationSet.add(1, new LDAPAttribute("nsindextype"));
            lDAPModificationSet.add(2, new LDAPAttribute("nsmatchingrule"));
            lDAPModificationSet.add(0, new LDAPAttribute("nsindextype", (String[])objectArray));
            if (string3 != null) {
                lDAPModificationSet.add(0, new LDAPAttribute("nsmatchingrule", string3));
            }
            if (this._taskCancelled) {
                return false;
            }
            Debug.println((String)("IndexManagement.updateDirectoryEntries: modifying dn:" + string2));
            this._progressDialog.setTextInLabel(DSUtil._resource.getString(_section, "modify-entry-title", DSUtil.abreviateString(string2, 20)));
            if (!IndexAttrUtility.modifyAttributes(this.getModel(), string2, lDAPModificationSet)) {
                Debug.println((String)("IndexManagementPanel.updateDirectoryEntries: failed to modify " + string2));
                try {
                    SwingUtilities.invokeAndWait(new ErrorMessageDisplayer(this._progressDialog, "errorupdatingentries", DSUtil.abreviateString(string2, 20)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bl = false;
                continue;
            }
            this._changedAttributes.remove(string);
        }
        return bl;
    }

    private boolean addNewIndexEntries() {
        this._addedEntries = new Vector();
        boolean bl = true;
        Enumeration enumeration = this._newAttributes.keys();
        while (bl && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)this._newAttributes.get(string);
            if (vector.size() <= 0) continue;
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            String string2 = "cn=" + string + "," + RDN_INDEX + this._conf_prefix + this._dnEntry;
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", OCLASSES));
            lDAPAttributeSet.add(new LDAPAttribute("nsSystemIndex", "false"));
            lDAPAttributeSet.add(new LDAPAttribute("cn", string));
            lDAPAttributeSet.add(new LDAPAttribute("nsindextype", (String[])objectArray));
            String string3 = (String)this._matchingRules.get(string);
            if (string3 != null && (string3 = string3.trim()).length() > 0) {
                lDAPAttributeSet.add(new LDAPAttribute("nsmatchingrule", string3));
            }
            LDAPEntry lDAPEntry = new LDAPEntry(string2, lDAPAttributeSet);
            if (this._taskCancelled) {
                return false;
            }
            Debug.println((String)("IndexManagementPanel.okCallback(): adding dn:" + string2));
            this._progressDialog.setTextInLabel(DSUtil._resource.getString(_section, "add-entry-title", string2));
            if (!IndexAttrUtility.addAttribute(this.getModel(), lDAPEntry)) {
                Debug.println((String)("IndexManagementPanel.okCallback: failed to add " + string2));
                bl = false;
            } else {
                this._addedEntries.addElement(string);
                this._newAttributes.remove(string);
            }
            if (bl) continue;
            try {
                SwingUtilities.invokeAndWait(new ErrorMessageDisplayer(this._progressDialog, "errorupdatingentries", DSUtil.abreviateString(string2, 20)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    private void cleanUpEntries() {
        if (this._addedEntries != null) {
            int n = 0;
            while (n < this._addedEntries.size()) {
                String string = (String)this._addedEntries.elementAt(n);
                IndexAttrUtility.deleteAttribute(this.getModel(), string);
                ++n;
            }
        }
    }

    protected void addAttribute() {
        Vector vector = this.getAvailAttributes();
        Object[] objectArray = null;
        String string = null;
        if (vector != null) {
            NewIndexPanel newIndexPanel = new NewIndexPanel((IDSModel)new DefaultResourceModel(), vector);
            SimpleDialog simpleDialog = new SimpleDialog(this.getModel().getFrame(), newIndexPanel.getTitle(), 11, newIndexPanel);
            simpleDialog.setComponent(newIndexPanel);
            simpleDialog.setOKButtonEnabled(false);
            simpleDialog.setDefaultButton(1);
            ((JDialog)((Object)simpleDialog)).getAccessibleContext().setAccessibleDescription(DSUtil._resource.getString(_section, "selectAttribute-description"));
            simpleDialog.packAndShow();
            objectArray = newIndexPanel.getSelectedItems();
        }
        if (objectArray != null) {
            int n = objectArray.length - 1;
            int n2 = 0;
            while (n2 < objectArray.length) {
                string = (String)objectArray[n2];
                Vector<Boolean> vector2 = new Vector<Boolean>();
                this.initRow(string, vector2);
                vector2.setElementAt(new Boolean(true), 2);
                vector2.setElementAt(new Boolean(true), 3);
                this.dumpVector("addAttribute " + string, vector2);
                this._userDataModel.addRow(vector2);
                Vector<String> vector3 = new Vector<String>();
                vector3.addElement(FILTERS[1]);
                vector3.addElement(FILTERS[2]);
                if (!this._changedAttributes.containsKey(string)) {
                    this._newAttributes.put(string, vector3);
                } else {
                    this._changedAttributes.put(string, vector3);
                }
                if (n2 == n) {
                    int n3 = this._userDataModel.getRowIndex(string);
                    this._indexTableUser.setRowSelectionInterval(n3, n3);
                    this.setDirtyFlag();
                    this.setValidFlag();
                }
                ++n2;
            }
        }
    }

    protected void deleteAttribute() {
        int n = this._indexTableUser.getSelectedRow();
        if (n >= 0) {
            this._userDataModel.removeRow(n);
            this.setDirtyFlag();
            this.setValidFlag();
        }
    }

    private void cancel() {
        this._progressDialog.setTextInLabel(DSUtil._resource.getString(_section, "LDAPMode-cancelled-title"));
        this.cleanUpEntries();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    IndexManagementPanel.this.resetCallback();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this._statusProgressDialog != null) {
            this._statusProgressDialog.hide();
        }
        this._progressDialog.closeCallBack();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = listSelectionEvent.getFirstIndex();
        int n2 = listSelectionEvent.getLastIndex();
        int n3 = this._indexTableUser.getSelectionModel().getMaxSelectionIndex();
        boolean bl = n <= n3 && n3 <= n2;
        this._bDelete.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TableCellEditor tableCellEditor;
        Object object = actionEvent.getSource();
        this._bAdd.setEnabled(false);
        this._bDelete.setEnabled(false);
        if (((JButton)object).getActionCommand().equals(ADD)) {
            this.getModel().setWaitCursor(true);
            tableCellEditor = this._indexTableUser.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            this.addAttribute();
            this.getModel().setWaitCursor(false);
        } else if (((JButton)object).getActionCommand().equals(DELETE)) {
            tableCellEditor = this._indexTableUser.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            this.deleteAttribute();
        } else if (actionEvent.getActionCommand().equals("Show_Logs-GenericProgressDialog")) {
            Debug.println((String)"IndexManagement.okcallback.actionPerformed: SHOW_LOGS");
            if (this._statusProgressDialog != null) {
                this._statusProgressDialog.pack();
                this._statusProgressDialog.setLocationRelativeTo(this._progressDialog);
                ((Component)this._statusProgressDialog).setLocation(this._progressDialog.getWidth(), this._progressDialog.getHeight());
                this._statusProgressDialog.show();
            }
        } else if (actionEvent.getActionCommand().equals("Close-GenericProgressDialog")) {
            if (this._statusProgressDialog != null) {
                this._statusProgressDialog.hide();
            }
            this._progressDialog.closeCallBack();
        } else if (actionEvent.getActionCommand().equals("Close")) {
            if (this._statusProgressDialog != null) {
                this._statusProgressDialog.hide();
                this._statusProgressDialog.dispose();
            }
        } else if (actionEvent.getActionCommand().equals("Cancel-GenericProgressDialog")) {
            this._progressDialog.disableCancelButton();
            this._taskCancelled = true;
        }
        this._bAdd.setEnabled(true);
        int n = this._indexTableUser.getSelectedRow();
        if (n >= 0) {
            this._bDelete.setEnabled(true);
        } else {
            this._bDelete.setEnabled(false);
        }
    }

    private void dumpVector(String string, Vector vector) {
    }

    private Vector getAvailAttributes() {
        LDAPSchema lDAPSchema = this.getModel().getSchema();
        if (lDAPSchema == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        Vector vector2 = this._userDataModel.getColumn(0);
        int n = 0;
        while (n < vector2.size()) {
            vector2.setElementAt(((String)vector2.elementAt(n)).toLowerCase(), n);
            ++n;
        }
        Vector vector3 = this._systemDataModel.getColumn(0);
        int n2 = 0;
        while (n2 < vector3.size()) {
            vector3.setElementAt(((String)vector3.elementAt(n2)).toLowerCase(), n2);
            ++n2;
        }
        this.dumpVector("System", vector3);
        this.dumpVector("User", vector2);
        Enumeration enumeration = lDAPSchema.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (vector3.indexOf(string) >= 0 || vector2.indexOf(string) >= 0) continue;
            if (vector.size() == 0) {
                vector.addElement(string);
                continue;
            }
            int n3 = 0;
            while (n3 < vector.size()) {
                if (string.compareTo((String)vector.elementAt(n3)) < 0) {
                    vector.insertElementAt(string, n3);
                    break;
                }
                ++n3;
            }
            if (n3 != vector.size()) continue;
            vector.insertElementAt(string, n3);
        }
        return vector;
    }

    private boolean isSystemIndex(String string) {
        return this._systemIndexes.containsKey(string);
    }

    private void fillRow(IndexAttrTableModel indexAttrTableModel, String string) {
        Vector vector = (Vector)this._attributes.get(string);
        this.dumpVector("fillRow in " + string, vector);
        Vector<Object> vector2 = new Vector<Object>();
        if (vector != null) {
            String string2;
            this.initRow(string, vector2);
            this.dumpVector("fillRow after initRow " + string, vector2);
            int n = 0;
            while (n < vector.size()) {
                string2 = (String)vector.elementAt(n);
                int n2 = 0;
                while (n2 < FILTERS.length) {
                    if (string2.equals(FILTERS[n2])) {
                        vector2.setElementAt(new Boolean(true), n2 + 1);
                        break;
                    }
                    ++n2;
                }
                if (n2 == FILTERS.length) {
                    System.err.println("IndexManagementPanel.fillRow: unkown index type <" + string2 + ">");
                }
                ++n;
            }
            string2 = (String)this._matchingRules.get(string);
            if (string2 == null) {
                string2 = "";
            }
            vector2.setElementAt(string2, this.headers.length - 1);
            this.dumpVector("fillRow out " + string, vector2);
            indexAttrTableModel.addRow(vector2);
        }
    }

    private void initRow(String string, Vector vector) {
        vector.addElement(string);
        int n = 1;
        while (n < this.headers.length - 1) {
            vector.addElement(new Boolean(false));
            ++n;
        }
        vector.addElement("");
    }

    private boolean isPluginEntry(String string) {
        boolean bl = false;
        LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
        try {
            String[] stringArray = new String[]{"objectclass"};
            LDAPEntry lDAPEntry = lDAPConnection.read(string, stringArray);
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
            if (lDAPAttribute != null && lDAPAttribute.size() > 0) {
                Enumeration enumeration = lDAPAttribute.getStringValues();
                while (!bl && enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    Debug.println((String)("****** IndexManagementPanel.isPluginEntry() value :" + string2));
                    boolean bl2 = bl = string2 != null && string2.compareToIgnoreCase("nsSlapdPlugin") == 0;
                }
            } else {
                bl = false;
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("****** IndexManagementPanel.isPluginEntry() error reading :" + string + " Error is " + lDAPException.toString()));
            return false;
        }
        return bl;
    }

    private Hashtable getIndexedAttributes() {
        LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
        String string = RDN_INDEX + this._conf_prefix + this._dnEntry;
        Hashtable hashtable = new Hashtable();
        String[] stringArray = new String[]{"cn", "nsindextype", "nssystemindex", "nsmatchingrule"};
        try {
            Debug.println((String)("getIndexedAttributes() search base :" + string));
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 1, "objectclass=nsIndex", null, false);
            while (lDAPSearchResults.hasMoreElements()) {
                String string2;
                LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                String string3 = this.getAttribute(lDAPEntry, stringArray[0]);
                Debug.println((String)("getIndexedAttributes() index cn:" + string3));
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(stringArray[1]);
                if (lDAPAttribute == null) continue;
                Vector<String> vector = new Vector<String>();
                Enumeration enumeration = lDAPAttribute.getStringValues();
                while (enumeration.hasMoreElements()) {
                    vector.addElement((String)enumeration.nextElement());
                }
                if (this.getAttribute(lDAPEntry, stringArray[2]).equals("true")) {
                    this._systemIndexes.put(string3, string3);
                }
                if ((string2 = this.getAttribute(lDAPEntry, stringArray[3])) != null) {
                    this._matchingRules.put(string3, string2);
                }
                if (string3.equals("default")) continue;
                hashtable.put(string3, vector);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("IndexManagementPanel.createIndexTable: " + (Object)((Object)lDAPException)));
            hashtable.clear();
        }
        return hashtable;
    }

    private String getAttribute(LDAPEntry lDAPEntry, String string) {
        Enumeration enumeration;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        String string2 = "";
        if (lDAPAttribute != null && (enumeration = lDAPAttribute.getStringValues()).hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
        }
        return string2;
    }

    class ErrorMessageDisplayer
    implements Runnable {
        public ErrorMessageDisplayer(Component component, String string, String string2) {
            IndexManagementPanel.this._comp = component;
            IndexManagementPanel.this._msg = string;
            IndexManagementPanel.this._arg = string2;
        }

        public void run() {
            DSUtil.showInformationDialog(IndexManagementPanel.this._comp, IndexManagementPanel.this._msg, IndexManagementPanel.this._arg, IndexManagementPanel._section);
        }
    }

    class IndexAttrTableModel
    extends AbstractTableModel {
        protected Vector _columnNames = new Vector();
        protected Vector _tableColumns = new Vector();

        IndexAttrTableModel() {
        }

        public int getColumnCount() {
            return this._columnNames.size();
        }

        public int getRowCount() {
            if (this.getColumnCount() > 0) {
                Vector vector = (Vector)this._tableColumns.elementAt(0);
                return vector.size();
            }
            return 0;
        }

        public String getColumnName(int n) {
            if (n >= this._columnNames.size()) {
                return "";
            }
            return (String)this._columnNames.elementAt(n);
        }

        public Object getValueAt(int n, int n2) {
            if (this.getColumnCount() > 0) {
                Vector vector = (Vector)this._tableColumns.elementAt(n2);
                return vector.elementAt(n);
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return this != IndexManagementPanel.this._systemDataModel && n2 != 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public void setValueAt(Object object, int n, int n2) {
            if (this.isCellEditable(n, n2)) {
                Vector vector = (Vector)this._tableColumns.elementAt(n2);
                vector.setElementAt(object, n);
                Vector<String> vector2 = new Vector<String>();
                int n3 = 1;
                while (n3 < IndexManagementPanel.this.headers.length - 1) {
                    if (((Boolean)this.getValueAt(n, n3)).equals(new Boolean("true"))) {
                        vector2.addElement(FILTERS[n3 - 1]);
                    }
                    ++n3;
                }
                String string = (String)this.getValueAt(n, 0);
                if (IndexManagementPanel.this._newAttributes.containsKey(string)) {
                    IndexManagementPanel.this._newAttributes.put(string, vector2);
                } else {
                    IndexManagementPanel.this._changedAttributes.put(string, vector2);
                }
                if (n2 == IndexManagementPanel.this.headers.length - 1) {
                    IndexManagementPanel.this._matchingRules.put(string, object);
                }
                IndexManagementPanel.this.setDirtyFlag();
                IndexManagementPanel.this.setValidFlag();
            }
        }

        void removeRow(int n) {
            int n2 = 0;
            while (n2 < this._tableColumns.size()) {
                Vector vector = (Vector)this._tableColumns.elementAt(n2);
                if (n2 == 0) {
                    String string = (String)vector.elementAt(n);
                    IndexManagementPanel.this._newAttributes.remove(string);
                    IndexManagementPanel.this._changedAttributes.put(string, new Vector());
                }
                vector.removeElementAt(n);
                ++n2;
            }
            this.fireTableRowsDeleted(n, n);
        }

        void removeAllRows() {
            int n = 0;
            while (n < this._tableColumns.size()) {
                Vector vector = (Vector)this._tableColumns.elementAt(n);
                vector.removeAllElements();
                ++n;
            }
            this.fireTableRowsDeleted(0, this._tableColumns.size());
        }

        void insertRowAt(Vector vector, int n) {
            int n2 = 0;
            while (n2 < vector.size()) {
                Vector vector2 = (Vector)this._tableColumns.elementAt(n2);
                vector2.insertElementAt(vector.elementAt(n2), n);
                ++n2;
            }
            this.fireTableRowsInserted(n, n);
        }

        void addRow(Vector vector) {
            int n = 0;
            Vector vector2 = (Vector)this._tableColumns.elementAt(0);
            String string = (String)vector.elementAt(0);
            while (n < vector2.size() && !((String)vector2.elementAt(n)).equals("") && string.compareTo((String)vector2.elementAt(n)) > 0) {
                ++n;
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                vector2 = (Vector)this._tableColumns.elementAt(n2);
                vector2.insertElementAt(vector.elementAt(n2), n);
                ++n2;
            }
            this.fireTableRowsInserted(n, n);
        }

        void addColumn(String string) {
            this._columnNames.addElement(string);
            this._tableColumns.addElement(new Vector());
        }

        int getRowIndex(String string) {
            Vector vector = (Vector)this._tableColumns.elementAt(0);
            int n = 0;
            while (n < vector.size()) {
                if (string.equals((String)vector.elementAt(n))) {
                    return n;
                }
                ++n;
            }
            return 0;
        }

        Vector getColumn(int n) {
            return (Vector)this._tableColumns.elementAt(n);
        }
    }

    class IndexRunnable
    implements Runnable {
        String[] _attrNames = null;

        IndexRunnable(String[] stringArray) {
            this._attrNames = stringArray;
        }

        public void run() {
            IndexManagementPanel.this._addedEntries = null;
            boolean bl = IndexManagementPanel.this.updateDirectoryEntries();
            if (IndexManagementPanel.this._taskCancelled) {
                IndexManagementPanel.this.cancel();
                IndexManagementPanel.this._taskCancelled = false;
                return;
            }
            if (!bl) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(this){
                        private final /* synthetic */ IndexRunnable this$1;
                        {
                            this.this$1 = indexRunnable;
                        }

                        public void run() {
                            IndexRunnable.access$400(this.this$1).resetCallback();
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                IndexManagementPanel.this._progressDialog.closeCallBack();
                IndexManagementPanel.this._taskCancelled = false;
                return;
            }
            bl = IndexManagementPanel.this.addNewIndexEntries();
            if (IndexManagementPanel.this._taskCancelled) {
                IndexManagementPanel.this.cancel();
                IndexManagementPanel.this._taskCancelled = false;
                return;
            }
            if (!bl) {
                IndexManagementPanel.this._progressDialog.disableCancelButton();
                IndexManagementPanel.this.cleanUpEntries();
                if (IndexManagementPanel.this._statusProgressDialog != null) {
                    IndexManagementPanel.this._statusProgressDialog.hide();
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(this){
                        private final /* synthetic */ IndexRunnable this$1;
                        {
                            this.this$1 = indexRunnable;
                        }

                        public void run() {
                            IndexRunnable.access$400(this.this$1).resetCallback();
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                IndexManagementPanel.this._progressDialog.closeCallBack();
                IndexManagementPanel.this._taskCancelled = false;
                return;
            }
            boolean bl2 = true;
            if (this._attrNames == null) {
                bl2 = false;
            }
            if (bl2 && bl) {
                Debug.println((String)("IndexManagement.IndexRunnable: indexing <" + this._attrNames + ">"));
                IndexManagementPanel.this._progressDialog.stepCompleted(0);
                String string = LDAPDN.explodeDN((String)IndexManagementPanel.this._dnEntry, (boolean)true)[0];
                AddIndex addIndex = new AddIndex(IndexManagementPanel.this.getModel().getServerInfo());
                bl = addIndex.exec(this._attrNames, string, null, IndexManagementPanel.RDN_INDEX + IndexManagementPanel.this._dnEntry, IndexManagementPanel.this._progressDialog, IndexManagementPanel.this._statusProgressDialog);
                if (IndexManagementPanel.this._taskCancelled) {
                    IndexManagementPanel.this.cancel();
                    IndexManagementPanel.this._taskCancelled = false;
                    return;
                }
            }
            if (bl) {
                if (bl2) {
                    IndexManagementPanel.this._progressDialog.stepCompleted(1);
                } else {
                    IndexManagementPanel.this._progressDialog.stepCompleted(0);
                }
                IndexManagementPanel.this._progressDialog.setTextInLabel(DSUtil._resource.getString(IndexManagementPanel._section, "LDAPMode-finished-title"));
            } else {
                IndexManagementPanel.this._progressDialog.setTextInLabel(DSUtil._resource.getString(IndexManagementPanel._section, "error-cleanup-title"));
                IndexManagementPanel.this._progressDialog.disableCancelButton();
                IndexManagementPanel.this.cleanUpEntries();
                IndexManagementPanel.this._progressDialog.setTextInLabel(DSUtil._resource.getString(IndexManagementPanel._section, "LDAPMode-endError-title"));
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(this){
                    private final /* synthetic */ IndexRunnable this$1;
                    {
                        this.this$1 = indexRunnable;
                    }

                    public void run() {
                        IndexRunnable.access$400(this.this$1).resetCallback();
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            IndexManagementPanel.this._taskCancelled = false;
            IndexManagementPanel.this._progressDialog.enableButtons(true);
            IndexManagementPanel.this._progressDialog.waitForClose();
        }

        static /* synthetic */ IndexManagementPanel access$400(IndexRunnable indexRunnable) {
            return indexRunnable.IndexManagementPanel.this;
        }
    }
}

