/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.DSEntryBitList;
import com.netscape.admin.dirserv.panel.DSEntrySet;
import com.netscape.admin.dirserv.panel.ErrorLogContentPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.LogContentPanel;
import com.netscape.admin.dirserv.panel.LogPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class ErrorLogConfigurePanel
extends LogPanel {
    private static final String ERROR_LEVEL_ATTR_NAME = "nsslapd-errorlog-level";
    private JList _liLogLevel;
    private static final int[] _masks = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 1024, 2048, 4096, 8192, 32768, 65536};

    public ErrorLogConfigurePanel(IDSModel iDSModel) {
        super(iDSModel, "errorlog-configure");
        this._helpToken = "configuration-logs-error-help";
    }

    public void init() {
        this.LOG_ATTR_NAME = "nsslapd-errorlog";
        this.LOG_PER_DIR_ATTR_NAME = "nsslapd-errorlog-maxlogsperdir";
        this.LOG_SIZE_ATTR_NAME = "nsslapd-errorlog-maxlogsize";
        this.ROTATION_TIME_ATTR_NAME = "nsslapd-errorlog-logrotationtime";
        this.ROTATION_UNITS_ATTR_NAME = "nsslapd-errorlog-logrotationtimeunit";
        this.MAX_DISK_SPACE_ATTR_NAME = "nsslapd-errorlog-logmaxdiskspace";
        this.MIN_FREE_SPACE_ATTR_NAME = "nsslapd-errorlog-logminfreediskspace";
        this.MAX_DAYS_OLD_ATTR_NAME = "nsslapd-errorlog-logexpirationtime";
        this.EXPIRATION_UNITS_ATTR_NAME = "nsslapd-errorlog-logexpirationtimeunit";
        this.ENABLED_ATTR_NAME = "nsslapd-errorlog-logging-enabled";
        this.LOG_BASE_NAME = "errors";
        super.init();
        this.createEnableArea();
        this.createConfigArea();
        this.createLevelArea();
        this.addBottomGlue();
        this.enableFields(this._cbEnabled.isSelected());
        super.postInit();
    }

    private void createLevelArea() {
        this._liLogLevel = this.makeJList("log", "logLevel", "");
        JScrollPane jScrollPane = new JScrollPane(this._liLogLevel);
        DSEntrySet dSEntrySet = this.getDSEntrySet();
        DSEntryBitList dSEntryBitList = new DSEntryBitList(this._liLogLevel, _masks);
        dSEntrySet.add("cn=config", ERROR_LEVEL_ATTR_NAME, dSEntryBitList);
        this.setComponentTable(this._liLogLevel, dSEntryBitList);
        GroupPanel groupPanel = new GroupPanel(this._resource.getString("log", "logLevel-title"));
        groupPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.insets = this.getComponentInsets();
        gridBagConstraints.insets.bottom = UIFactory.getDifferentSpace();
        this._myPanel.add((Component)groupPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = this.getComponentInsets();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        groupPanel.add((Component)jScrollPane, gridBagConstraints);
    }

    protected void enableFields(boolean bl) {
        if (this._liLogLevel != null) {
            this._liLogLevel.setEnabled(bl);
        }
        super.enableFields(bl);
    }

    LogContentPanel getViewerPanel() {
        return new ErrorLogContentPanel(this.getModel());
    }
}

