/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSAdmin;
import com.netscape.admin.dirserv.DSAdminEvent;
import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSResourceModel;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSAdminEventListener;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.CipherSetup;
import com.netscape.admin.dirserv.panel.DSEntryBoolean;
import com.netscape.admin.dirserv.panel.EncryptionConfigData;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.PortConfigData;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.security.CipherPreferenceDialog;
import com.netscape.management.client.security.EncryptionOptions;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class EncryptionPanel
extends BlankPanel
implements EncryptionOptions,
IDSAdminEventListener,
SuiConstants {
    private EncryptionConfigData _configData;
    private boolean _securityIsDomestic;
    private DSEntryBoolean _offDSEntry;
    private DSEntryBoolean _allowDSEntry;
    private DSEntryBoolean _requireDSEntry;
    private DSEntryBoolean _consoleSSLDSEntry;
    private com.netscape.management.client.security.EncryptionPanel _encrypt;
    private JPanel _encryptParent;
    private JRadioButton _rbOff;
    private JRadioButton _rbAllowed;
    private JRadioButton _rbRequired;
    private JCheckBox _cbConsoleSSL;
    private static ResourceSet _resource = DSUtil._resource;
    private static final String _section = "encryption";

    public EncryptionPanel(IDSModel iDSModel) {
        super(iDSModel, _section);
        this._helpToken = "configuration-system-encryption-help";
        this._refreshWhenSelect = false;
    }

    public void init() {
        ConsoleInfo consoleInfo;
        ConsoleInfo consoleInfo2;
        block9: {
            DSFramework dSFramework;
            if (this._isInitialized) {
                return;
            }
            DSResourceModel dSResourceModel = (DSResourceModel)this.getModel();
            consoleInfo2 = dSResourceModel.getServerInfo();
            consoleInfo = dSResourceModel.getConsoleInfo();
            if (dSResourceModel.getSelectedPage() != null) {
                dSFramework = (DSFramework)dSResourceModel.getSelectedPage().getFramework();
                dSFramework.getServerObject().addDSAdminEventListener(this);
            } else {
                Debug.println((int)0, (String)"EncryptionPanel.init: can't listen to DSAdminEvent");
            }
            try {
                dSFramework = consoleInfo2.getLDAPConnection();
                LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
                String string = consoleInfo.getCurrentDN();
                this._configData = new EncryptionConfigData();
                this._configData.readFromDirectory((LDAPConnection)dSFramework, lDAPConnection, string);
            }
            catch (LDAPException lDAPException) {
                Debug.println((int)0, (String)"EncryptionPanel.init: failure while reading config data");
                if (!Debug.getTrace()) break block9;
                lDAPException.printStackTrace();
            }
        }
        this._encrypt = new com.netscape.management.client.security.EncryptionPanel(consoleInfo, (String)consoleInfo2.get("SIE"), (EncryptionOptions)this);
        this._encryptParent = new JPanel();
        this._rbOff = this.makeJRadioButton(_section, "clientAuth-off", true);
        this._rbAllowed = this.makeJRadioButton(_section, "clientAuth-allowed");
        this._rbRequired = this.makeJRadioButton(_section, "clientAuth-required");
        this._cbConsoleSSL = this.makeJCheckBox(_section, "consoleSSL");
        this.layoutComponents();
        this._offDSEntry = new DSEntryBoolean("off", this._rbOff);
        this.setComponentTable(this._rbOff, this._offDSEntry);
        this._allowDSEntry = new DSEntryBoolean("off", this._rbAllowed);
        this.setComponentTable(this._rbAllowed, this._allowDSEntry);
        this._requireDSEntry = new DSEntryBoolean("off", this._rbRequired);
        this.setComponentTable(this._rbRequired, this._requireDSEntry);
        this._consoleSSLDSEntry = new DSEntryBoolean("off", this._cbConsoleSSL);
        this.setComponentTable(this._cbConsoleSSL, this._consoleSSLDSEntry);
        switch (this._configData.clientAuth) {
            case 1: {
                this._offDSEntry.fakeInitModel("off");
                this._allowDSEntry.fakeInitModel("on");
                this._requireDSEntry.fakeInitModel("off");
                break;
            }
            case 2: {
                this._offDSEntry.fakeInitModel("off");
                this._allowDSEntry.fakeInitModel("off");
                this._requireDSEntry.fakeInitModel("on");
                break;
            }
            default: {
                this._offDSEntry.fakeInitModel("on");
                this._allowDSEntry.fakeInitModel("off");
                this._requireDSEntry.fakeInitModel("off");
            }
        }
        this._consoleSSLDSEntry.fakeInitModel(this._configData.sslConsoleOn ? "on" : "off");
        this.showAll();
        this.updateComponentState();
        this._isInitialized = true;
    }

    void layoutComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this._myPanel.setLayout(gridBagLayout);
        this._encryptParent.setLayout(new GridLayout());
        this._encryptParent.add("Center", (Component)this._encrypt);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        int n = 2;
        gridBagConstraints.insets.left += n;
        gridBagConstraints.insets.right += n;
        this._myPanel.add((Component)this._encryptParent, gridBagConstraints);
        GroupPanel groupPanel = new GroupPanel(_resource.getString(_section, "clientAuth-title"), true);
        int n2 = UIFactory.getComponentSpace();
        groupPanel.setLayout(new GridLayout(4, 1, n2, n2 / 2));
        groupPanel.add(this._rbOff);
        groupPanel.add(this._rbAllowed);
        groupPanel.add(this._rbRequired);
        groupPanel.add(this._cbConsoleSSL);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.left -= n;
        gridBagConstraints.insets.right -= n;
        this._myPanel.add((Component)groupPanel, gridBagConstraints);
        Component component = Box.createVerticalGlue();
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        this._myPanel.add(component, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rbOff);
        buttonGroup.add(this._rbAllowed);
        buttonGroup.add(this._rbRequired);
    }

    public void okCallback() {
        block14: {
            DSFramework dSFramework = (DSFramework)this.getModel().getSelectedPage().getFramework();
            JFrame jFrame = dSFramework.getJFrame();
            if (!this.validateEntries()) {
                return;
            }
            super.okCallback();
            try {
                ConsoleInfo consoleInfo = this.getModel().getServerInfo();
                ConsoleInfo consoleInfo2 = this.getModel().getConsoleInfo();
                if (this._rbOff.isSelected()) {
                    this._configData.clientAuth = 0;
                } else if (this._rbAllowed.isSelected()) {
                    this._configData.clientAuth = 1;
                } else if (this._rbRequired.isSelected()) {
                    this._configData.clientAuth = 2;
                }
                this._configData.sslConsoleOn = this._cbConsoleSSL.isSelected();
                LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
                LDAPConnection lDAPConnection2 = consoleInfo2.getLDAPConnection();
                String string = consoleInfo2.getCurrentDN();
                this._configData.writeToDirectory(lDAPConnection, lDAPConnection2, string);
                if (this._configData.sslServerOn) {
                    dSFramework.getServerObject().setSecurityState(DSAdmin.SECURITY_ENABLE);
                } else {
                    dSFramework.getServerObject().setSecurityState(DSAdmin.SECURITY_DISABLE);
                }
                this._encrypt.setSaved();
                this.setDirty(false);
                this.resetAll();
                DSUtil.showInformationDialog((Component)jFrame, "requires-restart", (String)null);
                if (!this._configData.sslServerOn || DSUtil.isNT(consoleInfo2)) break block14;
                PortConfigData portConfigData = new PortConfigData();
                try {
                    portConfigData.readFromDirectory(lDAPConnection);
                    if (portConfigData.port >= 1024 && portConfigData.securePort < 1024) {
                        DSUtil.showInformationDialog((Component)jFrame, "confirm-sslport", Integer.toString(portConfigData.securePort), _section);
                    }
                }
                catch (LDAPException lDAPException) {
                    Debug.println((int)0, (String)("EncryptionPanel.okCallback: caught " + (Object)((Object)lDAPException)));
                    Debug.println((int)0, (String)"EncryptionPanel.okCallback: skipping the SSL port checking");
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("LDAPEncryptionPanel.okCallback: exception " + (Object)((Object)lDAPException)));
                if (Debug.getTrace()) {
                    lDAPException.printStackTrace();
                }
                DSUtil.showLDAPErrorDialog(jFrame, lDAPException, "111-title");
            }
        }
    }

    public void resetCallback() {
        block2: {
            ConsoleInfo consoleInfo = this.getModel().getServerInfo();
            ConsoleInfo consoleInfo2 = this.getModel().getConsoleInfo();
            try {
                LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
                LDAPConnection lDAPConnection2 = consoleInfo2.getLDAPConnection();
                String string = consoleInfo2.getCurrentDN();
                this._configData.readFromDirectory(lDAPConnection, lDAPConnection2, string);
            }
            catch (LDAPException lDAPException) {
                Debug.println((int)0, (String)"EncryptionPanel.resetCallback: failure while reading config data");
                if (!Debug.getTrace()) break block2;
                lDAPException.printStackTrace();
            }
        }
        this._encrypt.reset();
        super.resetCallback();
        this.updateComponentState();
    }

    public boolean refresh() {
        ConsoleInfo consoleInfo;
        ConsoleInfo consoleInfo2;
        block2: {
            consoleInfo2 = this.getModel().getServerInfo();
            consoleInfo = this.getModel().getConsoleInfo();
            try {
                LDAPConnection lDAPConnection = consoleInfo2.getLDAPConnection();
                LDAPConnection lDAPConnection2 = consoleInfo.getLDAPConnection();
                String string = consoleInfo.getCurrentDN();
                this._configData.readFromDirectory(lDAPConnection, lDAPConnection2, string);
            }
            catch (LDAPException lDAPException) {
                Debug.println((int)0, (String)"EncryptionPanel.resetCallback: failure while reading config data");
                if (!Debug.getTrace()) break block2;
                lDAPException.printStackTrace();
            }
        }
        this._encryptParent.remove((Component)this._encrypt);
        this._encrypt = new com.netscape.management.client.security.EncryptionPanel(consoleInfo, (String)consoleInfo2.get("SIE"), (EncryptionOptions)this);
        this._encryptParent.add("Center", (Component)this._encrypt);
        this._encryptParent.revalidate();
        return super.refresh();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        this.setDirty(true);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        if (itemEvent.getSource() == this._rbRequired) {
            boolean bl = this._rbRequired.isSelected();
            this._cbConsoleSSL.setEnabled(!bl);
            if (bl && this._cbConsoleSSL.isSelected()) {
                this._cbConsoleSSL.setSelected(false);
                DSUtil.showInformationDialog((Component)this.getModel().getFrame(), "confirm-clientauth", "", _section);
            }
        }
    }

    public void showCipherPreferenceDialog(String string) {
        JFrame jFrame = this.getModel().getFrame();
        Debug.println((int)4, (String)("EncryptionPanel.showCipherPreferenceDialog: cipher = " + string));
        CipherPreferenceDialog cipherPreferenceDialog = new CipherPreferenceDialog((Frame)jFrame, null, "-rsa_null_md5,-rsa_rc4_128_md5,-rsa_rc4_40_md5,-rsa_rc2_40_md5,-rsa_des_sha,-rsa_fips_des_sha,-rsa_3des_sha,-rsa_fips_3des_sha,-fortezza,-fortezza_rc4_128_sha,-fortezza_null", "-tls_rsa_export1024_with_rc4_56_sha,-tls_rsa_export1024_with_des_cbc_sha");
        cipherPreferenceDialog.setCipherEnabled("V3", this._configData.cipherPrefs);
        cipherPreferenceDialog.setCipherEnabled("TLS", this._configData.cipherPrefs);
        cipherPreferenceDialog.showModal();
        if (!cipherPreferenceDialog.isCancel()) {
            this._configData.cipherPrefs = cipherPreferenceDialog.getCipherPreference("V3") + "," + cipherPreferenceDialog.getCipherPreference("TLS");
            this.setDirty(true);
            Debug.println((String)("EncryptionPanel.showCipherPreferenceDialog: preferences = " + this._configData.cipherPrefs));
        }
    }

    public boolean isSecurityEnabled() {
        Debug.println((int)4, (String)("EncryptionPanel.isSecurityEnabled: _configData.sslServerOn = " + this._configData.sslServerOn));
        return this._configData.sslServerOn;
    }

    public void securityEnabledChanged(boolean bl) {
        Debug.println((int)4, (String)("EncryptionPanel.securityEnabledChanged: enable = " + bl));
        this._configData.sslServerOn = bl;
        this.updateComponentState();
        this.setDirty(true);
    }

    public boolean isCipherFamilyEnabled(String string) {
        Debug.println((int)4, (String)("EncryptionPanel.isCipherFamilyEnabled: cipher = " + string));
        CipherSetup cipherSetup = (CipherSetup)this._configData.cipherSetupTable.get(string);
        return cipherSetup != null && cipherSetup.enabled;
    }

    public void cipherFamilyEnabledChanged(String string, boolean bl) {
        Debug.println((int)4, (String)("EncryptionPanel.cipherFamilyEnabledChanged: cipher = " + string + ", enabled = " + bl));
        CipherSetup cipherSetup = this.findOrCreateCipherSetup(string);
        cipherSetup.enabled = bl;
        this.setDirty(true);
    }

    public String getSelectedCertificate(String string) {
        Debug.println((int)4, (String)("EncryptionPanel.getSelectedCertificate: cipher = " + string));
        CipherSetup cipherSetup = (CipherSetup)this._configData.cipherSetupTable.get(string);
        return cipherSetup == null ? null : cipherSetup.selectedCertificate;
    }

    public void selectedCertificateChanged(String string, String string2) {
        Debug.println((int)4, (String)("EncryptionPanel.selectedCertificateChanged: cipher = " + string + ", cert = " + string2));
        CipherSetup cipherSetup = this.findOrCreateCipherSetup(string);
        cipherSetup.selectedCertificate = string2;
        this.setDirty(true);
    }

    public String getSelectedDevice(String string) {
        Debug.println((int)4, (String)("EncryptionPanel.getSelectedDevice: cipher = " + string));
        CipherSetup cipherSetup = (CipherSetup)this._configData.cipherSetupTable.get(string);
        return cipherSetup == null ? null : cipherSetup.selectedDevice;
    }

    public void selectedDeviceChanged(String string, String string2) {
        Debug.println((int)4, (String)("EncryptionPanel.selectedDeviceChanged: cipher = " + string + ", dev = " + string2));
        CipherSetup cipherSetup = this.findOrCreateCipherSetup(string);
        cipherSetup.selectedDevice = string2;
        this.setDirty(true);
    }

    public void setSecurityIsDomestic(boolean bl) {
        Debug.println((int)4, (String)("EncryptionPanel.setSecurityIsDomestic: yes = " + bl));
        this._securityIsDomestic = bl;
    }

    public void processDSAdminEvent(DSAdminEvent dSAdminEvent) {
        this.refresh();
    }

    private void setDirty(boolean bl) {
        if (bl) {
            this.setDirtyFlag();
            this.setValidFlag();
        } else {
            this.clearDirtyFlag();
        }
    }

    private boolean validateEntries() {
        String string = null;
        if (this._rbOff.isSelected()) {
            this._configData.clientAuth = 0;
        } else if (this._rbAllowed.isSelected()) {
            this._configData.clientAuth = 1;
        } else if (this._rbRequired.isSelected()) {
            this._configData.clientAuth = 2;
        }
        if (this._configData.sslServerOn) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            Enumeration enumeration = this._configData.cipherSetupTable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                CipherSetup cipherSetup = (CipherSetup)this._configData.cipherSetupTable.get(k);
                if (!cipherSetup.enabled) continue;
                ++n;
                if (cipherSetup.selectedDevice.length() == 0) {
                    ++n2;
                }
                if (cipherSetup.selectedCertificate.length() != 0) continue;
                ++n3;
            }
            if (n == 0) {
                string = "nosslpreferences";
            } else if (n2 >= 1) {
                string = "nosslfamily";
            } else if (n3 >= 1) {
                string = "nocertificate";
            }
        }
        if (string != null) {
            DSUtil.showErrorDialog((Component)this.getModel().getFrame(), string, "", _section);
        }
        return string == null;
    }

    private void updateComponentState() {
        this._rbOff.setEnabled(this._configData.sslServerOn);
        this._rbAllowed.setEnabled(this._configData.sslServerOn);
        this._rbRequired.setEnabled(this._configData.sslServerOn);
        this._cbConsoleSSL.setEnabled(this._configData.sslServerOn && !this._rbRequired.isSelected());
    }

    private CipherSetup findOrCreateCipherSetup(String string) {
        CipherSetup cipherSetup = (CipherSetup)this._configData.cipherSetupTable.get(string);
        if (cipherSetup == null) {
            cipherSetup = new CipherSetup();
            cipherSetup.family = string;
            this._configData.cipherSetupTable.put(cipherSetup.family, cipherSetup);
        }
        return cipherSetup;
    }
}

