/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.CipherSetup;
import com.netscape.management.client.util.Debug;
import java.util.Enumeration;
import java.util.Hashtable;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;

class EncryptionConfigData {
    public boolean sslConsoleOn = false;
    public int clientAuth = 1;
    public boolean sslServerOn = false;
    public String cipherPrefs = "-rsa_null_md5,+rsa_rc4_128_md5,+rsa_rc4_40_md5,+rsa_rc2_40_md5,+rsa_des_sha,+rsa_fips_des_sha,+rsa_3des_sha,+rsa_fips_3des_sha,+fortezza,+fortezza_rc4_128_sha,+fortezza_null,+tls_rsa_export1024_with_rc4_56_sha,+tls_rsa_export1024_with_des_cbc_sha";
    public Hashtable cipherSetupTable = new Hashtable(5);
    public static final int CLIENT_AUTH_DISABLED = 0;
    public static final int CLIENT_AUTH_ALLOWED = 1;
    public static final int CLIENT_AUTH_REQUIRED = 2;
    static final String CIPHER_PREFS = "-rsa_null_md5,+rsa_rc4_128_md5,+rsa_rc4_40_md5,+rsa_rc2_40_md5,+rsa_des_sha,+rsa_fips_des_sha,+rsa_3des_sha,+rsa_fips_3des_sha,+fortezza,+fortezza_rc4_128_sha,+fortezza_null,+tls_rsa_export1024_with_rc4_56_sha,+tls_rsa_export1024_with_des_cbc_sha";
    static final String CIPHER_SSL3_OFF = "-rsa_null_md5,-rsa_rc4_128_md5,-rsa_rc4_40_md5,-rsa_rc2_40_md5,-rsa_des_sha,-rsa_fips_des_sha,-rsa_3des_sha,-rsa_fips_3des_sha,-fortezza,-fortezza_rc4_128_sha,-fortezza_null";
    static final String CIPHER_TLS_OFF = "-tls_rsa_export1024_with_rc4_56_sha,-tls_rsa_export1024_with_des_cbc_sha";

    EncryptionConfigData() {
    }

    public void readFromDirectory(LDAPConnection lDAPConnection, LDAPConnection lDAPConnection2, String string) throws LDAPException {
        String string2;
        String string3 = "cn=config";
        String string4 = "cn=encryption,cn=config";
        String[] stringArray = new String[]{"nsslapd-security"};
        String[] stringArray2 = new String[]{"nsserversecurity"};
        LDAPEntry lDAPEntry = lDAPConnection2.read(string, stringArray2);
        LDAPEntry lDAPEntry2 = lDAPConnection.read(string3, stringArray);
        LDAPEntry lDAPEntry3 = lDAPConnection.read(string4);
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string4, 1, "objectclass=*", null, false);
        if (lDAPEntry != null) {
            string2 = DSUtil.getAttrValue(lDAPEntry, stringArray2[0]);
            this.sslConsoleOn = string2.equalsIgnoreCase("on");
        } else {
            Debug.println((int)0, (String)"EncryptionConfigData.readFromDirectory: sieEntry is null");
        }
        if (lDAPEntry2 != null) {
            string2 = DSUtil.getAttrValue(lDAPEntry2, stringArray[0]);
            this.sslServerOn = string2.equalsIgnoreCase("on");
        } else {
            Debug.println((int)0, (String)"EncryptionConfigData.readFromDirectory: configEntry is null");
        }
        if (lDAPEntry3 != null) {
            string2 = DSUtil.getAttrValue(lDAPEntry3, "nssslclientauth");
            this.clientAuth = string2.equalsIgnoreCase("allowed") ? 1 : (string2.equalsIgnoreCase("required") ? 2 : 0);
            this.cipherPrefs = DSUtil.getAttrValue(lDAPEntry3, "nsssl3ciphers");
            if (this.cipherPrefs == null || this.cipherPrefs.length() == 0) {
                this.cipherPrefs = CIPHER_PREFS;
            }
        } else {
            Debug.println((int)0, (String)"EncryptionConfigData.readFromDirectory: encryptionEntry is null");
        }
        if (lDAPSearchResults != null) {
            while (lDAPSearchResults.hasMoreElements()) {
                string2 = (LDAPEntry)lDAPSearchResults.nextElement();
                CipherSetup cipherSetup = new CipherSetup();
                String string5 = string2.getDN();
                int n = string5.indexOf(44);
                cipherSetup.family = string5.substring(string5.indexOf(61) + 1, n);
                String string6 = DSUtil.getAttrValue((LDAPEntry)string2, "nssslactivation");
                cipherSetup.enabled = string6.equalsIgnoreCase("on");
                cipherSetup.selectedDevice = DSUtil.getAttrValue((LDAPEntry)string2, "nsssltoken");
                cipherSetup.selectedCertificate = DSUtil.getAttrValue((LDAPEntry)string2, "nssslpersonalityssl");
                if (this.cipherSetupTable.put(cipherSetup.family, cipherSetup) != null) {
                    Debug.println((int)0, (String)"EncryptionConfigData.readFromDirectory: cipher conflict ignored");
                }
                Debug.println((String)("EncryptionConfigData.readFromDirectory: read prefs for " + cipherSetup.family));
            }
        } else {
            Debug.println((String)"EncryptionConfigData.readFromDirectory: encryptionEntry is null");
        }
    }

    public void writeToDirectory(LDAPConnection lDAPConnection, LDAPConnection lDAPConnection2, String string) throws LDAPException {
        String[] stringArray;
        String string2;
        String string3;
        Object object;
        Enumeration enumeration = this.cipherSetupTable.keys();
        while (enumeration.hasMoreElements()) {
            object = (CipherSetup)this.cipherSetupTable.get(enumeration.nextElement());
            string3 = new LDAPAttributeSet();
            if (object.selectedDevice.length() >= 1) {
                string3.add(new LDAPAttribute("nsssltoken", object.selectedDevice));
            }
            if (object.selectedCertificate.length() >= 1) {
                string3.add(new LDAPAttribute("nssslpersonalityssl", object.selectedCertificate));
            }
            string2 = object.enabled && this.sslServerOn ? "on" : "off";
            string3.add(new LDAPAttribute("nssslactivation", string2));
            stringArray = new String[]{"top", "nsEncryptionModule"};
            string3.add(new LDAPAttribute("objectclass", stringArray));
            String string4 = "cn=" + object.family + ",cn=encryption,cn=config";
            LDAPEntry lDAPEntry = new LDAPEntry(string4, (LDAPAttributeSet)string3);
            EncryptionConfigData.addOrModifyLDAPEntry(lDAPConnection, lDAPEntry);
        }
        object = new LDAPModificationSet();
        string3 = this.sslServerOn ? "on" : "off";
        object.add(2, new LDAPAttribute("nsssl3", string3));
        switch (this.clientAuth) {
            case 1: {
                string3 = "allowed";
                break;
            }
            case 2: {
                string3 = "required";
                break;
            }
            default: {
                string3 = "off";
            }
        }
        object.add(2, new LDAPAttribute("nssslclientauth", string3));
        object.add(2, new LDAPAttribute("nsssl3ciphers", this.cipherPrefs));
        string2 = LDAPDN.explodeDN((String)string, (boolean)true)[0];
        string3 = "alias/" + string2.toLowerCase() + "-key3.db";
        object.add(2, new LDAPAttribute("nskeyfile", string3));
        string3 = "alias/" + string2.toLowerCase() + "-cert7.db";
        object.add(2, new LDAPAttribute("nscertfile", string3));
        lDAPConnection.modify("cn=encryption,cn=config", object);
        object = new LDAPModificationSet();
        string3 = this.sslServerOn ? "on" : "off";
        object.add(2, new LDAPAttribute("nsslapd-security", string3));
        lDAPConnection.modify("cn=config", object);
        string3 = this.sslConsoleOn ? "on" : "off";
        stringArray = new LDAPAttribute("nsserversecurity", string3);
        lDAPConnection2.modify(string, new LDAPModification(2, (LDAPAttribute)stringArray));
    }

    /*
     * Unable to fully structure code
     */
    static void addOrModifyLDAPEntry(LDAPConnection var0, LDAPEntry var1_1) throws LDAPException {
        block4: {
            try {
                var0.add(var1_1);
                break block4;
            }
            catch (LDAPException var2_2) {
                if (var2_2.getLDAPResultCode() != 68) {
                    Debug.println((int)0, (String)("EncryptionPanel.addOrModifyEntry: exception for " + var1_1));
                    throw var2_2;
                }
                var3_3 = new LDAPModificationSet();
                var4_4 = var1_1.getAttributeSet().getAttributes();
                ** while (var4_4.hasMoreElements())
            }
lbl-1000:
            // 1 sources

            {
                var5_5 = (LDAPAttribute)var4_4.nextElement();
                var3_3.add(2, var5_5);
                continue;
            }
lbl14:
            // 1 sources

            var0.modify(var1_1.getDN(), var3_3);
        }
    }
}

