/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.BulkImport;
import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.GlobalConstants;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.CenterAlignedHeaderRenderer;
import com.netscape.admin.dirserv.panel.CheckBoxTableCellRenderer;
import com.netscape.admin.dirserv.panel.FilePanel;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.admin.dirserv.task.LDAPImport;
import com.netscape.management.client.components.Table;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;

public class DatabaseImportPanel
extends FilePanel {
    private String _backend;
    private String[] _backends;
    protected CustomTableModel _model;
    private static final String _section = "import";
    private final int TABLE_ROWS = 5;
    private final int[] TABLE_WIDTH = new int[]{70, 100, 50};
    public static final int ERROR = -1;
    public static final int SUCCESS = 0;
    private final String CONFIG_BACKEND = "NetscapeRoot";

    public DatabaseImportPanel(IDSModel iDSModel, String string) {
        super(iDSModel, _section);
        this._helpToken = string != null ? "configuration-database-initialize-backend-dbox-help" : "configuration-database-import-fastwire-dbox-help";
        this._backend = string;
    }

    public DatabaseImportPanel(IDSModel iDSModel) {
        this(iDSModel, null);
    }

    public void init() {
        JPanel jPanel = this._myPanel;
        jPanel.setLayout(new GridBagLayout());
        this.createFileArea(jPanel);
        if (this._backend == null) {
            if (!(this.isLocal() || this._onlyRemote || this._onlyLocal)) {
                this.createSeparator(jPanel);
            }
            this.createBackendSelectionPanel(jPanel);
        }
        this.addBottomGlue();
        this.setLocalState(this._rbLocal.isSelected());
        this.getAbstractDialog().setFocusComponent((JComponent)this._tfExport);
        this.getAbstractDialog().getAccessibleContext().setAccessibleDescription(this._resource.getString(_section, "initializedb-description"));
    }

    protected void setLocalState(boolean bl) {
        if (this.isLocal()) {
            return;
        }
        super.setLocalState(bl);
    }

    protected void checkOkay() {
        String string = this.getFilename();
        AbstractDialog abstractDialog = this.getAbstractDialog();
        if (abstractDialog != null) {
            boolean bl = string != null && string.length() > 0 && this.isBackendSelected();
            abstractDialog.setOKButtonEnabled(bl);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        super.changedUpdate(documentEvent);
        this.checkOkay();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        super.removeUpdate(documentEvent);
        this.checkOkay();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        super.insertUpdate(documentEvent);
        this.checkOkay();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._bExport)) {
            File file;
            String string = this.getFilename();
            String[] stringArray = new String[]{"ldif"};
            String[] stringArray2 = new String[]{this._resource.getString("filefilter", "ldif-label")};
            String string2 = this.getDefaultPath(this.getModel());
            if ((string = string == null || string.trim().length() < 1 ? DSFileDialog.getFileName(false, stringArray, stringArray2, this, "*.ldif", string2) : ((file = new File(string)).isAbsolute() ? DSFileDialog.getFileName(string, false, stringArray, stringArray2, this) : DSFileDialog.getFileName(false, stringArray, stringArray2, this, string, string2))) != null) {
                this.setFilename(string);
            }
        } else if (actionEvent.getSource().equals(this._rbLocal)) {
            this.setLocalState(true);
        } else if (actionEvent.getSource().equals(this._rbRemote)) {
            this.setLocalState(false);
        } else {
            super.actionPerformed(actionEvent);
        }
        this.revalidate();
        this.repaint();
    }

    public void okCallback() {
        Object object;
        Serializable serializable;
        boolean bl = false;
        boolean bl2 = this._rbLocal.isSelected() || this.isLocal();
        String string = this.getFilename();
        if (string.trim().equals("") && !this.validateFilename()) {
            return;
        }
        Object var4_4 = null;
        ConsoleInfo consoleInfo = this.getModel().getServerInfo();
        LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
        if (bl2) {
            serializable = new File(string);
            if (!((File)serializable).isAbsolute()) {
                string = DSFileDialog.getPath() != null ? DSFileDialog.getPath() + string : this.getDefaultPath(this.getModel()) + string;
            }
            object = new File(string);
            string = object.getAbsolutePath();
            if (!DSUtil.fileExists((File)object)) {
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "file-does-not-exist", string, _section);
                return;
            }
        }
        if (this.isLocal() || this._rbRemote.isSelected()) {
            serializable = new Hashtable();
            ((Hashtable)serializable).put("nsFilename", new LDAPAttribute("nsFilename", string));
            if (this._backend != null) {
                int n;
                int n2;
                ((Hashtable)serializable).put("nsInstance", new LDAPAttribute("nsInstance", this._backend));
                if (BlankPanel.requiresConfirmation(GlobalConstants.PREFERENCES_CONFIRM_OVERWRITE_DATABASE) && (this._backend.equalsIgnoreCase("NetscapeRoot".trim()) ? 0 != (n2 = DSUtil.showConfirmationDialog((Component)this.getModel().getFrame(), "remoteoverwritewarning-configbackend", "", _section)) : 0 != (n = DSUtil.showConfirmationDialog((Component)this.getModel().getFrame(), "remoteoverwritewarning", "", _section)))) {
                    return;
                }
            } else {
                int n;
                object = this.getSelectedBackendList();
                ((Hashtable)serializable).put("nsInstance", new LDAPAttribute("nsInstance", object));
                if (BlankPanel.requiresConfirmation(GlobalConstants.PREFERENCES_CONFIRM_OVERWRITE_DATABASE) && 0 != (n = DSUtil.showConfirmationDialog((Component)this.getModel().getFrame(), "remoteoverwritewarning-confignotimported", "", _section))) {
                    return;
                }
            }
            this.clearDirtyFlag();
            this.hideDialog();
            object = new LDAPImport(this.getModel(), (Hashtable)serializable);
        } else {
            serializable = new File(string);
            try {
                object = new FileInputStream((File)serializable);
            }
            catch (Exception exception) {
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "cantopen", string, _section);
                return;
            }
            if (this._backend != null) {
                int n;
                int n3;
                if (BlankPanel.requiresConfirmation(GlobalConstants.PREFERENCES_CONFIRM_OVERWRITE_DATABASE) && (this._backend.equalsIgnoreCase("NetscapeRoot".trim()) ? 0 != (n3 = DSUtil.showConfirmationDialog((Component)this.getModel().getFrame(), "localoverwritewarning-configbackend", "", _section)) : 0 != (n = DSUtil.showConfirmationDialog((Component)this.getModel().getFrame(), "localoverwritewarning", "", _section)))) {
                    return;
                }
                object = new String[]{this._backend};
            } else {
                int n;
                if (BlankPanel.requiresConfirmation(GlobalConstants.PREFERENCES_CONFIRM_OVERWRITE_DATABASE) && 0 != (n = DSUtil.showConfirmationDialog((Component)this.getModel().getFrame(), "localoverwritewarning-confignotimported", "", _section))) {
                    return;
                }
                object = this.getSelectedBackendList();
            }
            this.clearDirtyFlag();
            this.hideDialog();
            this.bulkImport((String[])object, string, null);
        }
        if (bl) {
            this.getModel().contentChanged();
        }
    }

    public void resetCallback() {
        this.clearDirtyFlag();
        this.hideDialog();
    }

    private int bulkImport(String string, String string2, String string3) {
        String[] stringArray = new String[]{string};
        return this.bulkImport(stringArray, string2, string3);
    }

    private int bulkImport(String[] stringArray, String string, String string2) {
        GenericProgressDialog genericProgressDialog = new GenericProgressDialog(this.getModel().getFrame(), true, 7, this.getTitle());
        BulkImport bulkImport = new BulkImport(stringArray, string, string2, this.getModel(), genericProgressDialog);
        try {
            Thread thread = new Thread(bulkImport);
            thread.start();
            genericProgressDialog.packAndShow();
        }
        catch (Exception exception) {
            Debug.println((String)("DatabaseImportPanel.bulkImport: " + exception));
            exception.printStackTrace();
        }
        return bulkImport.getResult();
    }

    protected boolean isBackendSelected() {
        boolean bl = false;
        if (this._backend == null) {
            if (this._model != null && this._backends != null) {
                int n = 0;
                while (n < this._backends.length && !bl) {
                    if (((Boolean)this._model.getValueAt(n, 2)).booleanValue()) {
                        bl = true;
                    }
                    ++n;
                }
            }
        } else {
            bl = true;
        }
        return bl;
    }

    protected String[] getSelectedBackendList() {
        Object[] objectArray = null;
        if (this._model != null && this._backends != null) {
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < this._backends.length) {
                if (((Boolean)this._model.getValueAt(n, 2)).booleanValue()) {
                    vector.addElement(this._backends[n]);
                }
                ++n;
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            Debug.println((String)("DatabaseImportPanel.getSelectedBackendList(): " + vector));
        }
        return objectArray;
    }

    protected void createBackendSelectionPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = this.getGBC();
        LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
        this._backends = MappingUtils.getBackendList(lDAPConnection, 2);
        if (this._backends != null) {
            Boolean bl;
            Table table;
            int n;
            String[] stringArray = MappingUtils.getSuffixesForBackends(lDAPConnection, this._backends);
            Vector<Table> vector = new Vector<Table>();
            if (stringArray != null && stringArray.length == this._backends.length) {
                n = 0;
                while (n < this._backends.length) {
                    table = new Vector();
                    bl = new Boolean(false);
                    table.addElement(this._backends[n]);
                    table.addElement(stringArray[n]);
                    table.addElement(bl);
                    vector.addElement(table);
                    ++n;
                }
            } else {
                n = 0;
                while (n < this._backends.length) {
                    table = new Vector();
                    bl = new Boolean(false);
                    table.addElement(this._backends[n]);
                    table.addElement("");
                    table.addElement(bl);
                    vector.addElement(table);
                    ++n;
                }
            }
            Vector<String> vector2 = new Vector<String>();
            vector2.addElement(this._resource.getString(_section, "initialize-multiple-backends-table-dbName-label"));
            vector2.addElement(this._resource.getString(_section, "initialize-multiple-backends-table-dbSuffix-label"));
            vector2.addElement(this._resource.getString(_section, "initialize-multiple-backends-table-dbInitialize-label"));
            this._model = new CustomTableModel(vector, vector2);
            table = new Table((TableModel)this._model);
            table.setToolTipText(this._resource.getString(_section, "initialize-multiple-backends-table-description"));
            int n2 = 0;
            while (n2 < vector2.size()) {
                TableColumn tableColumn = table.getColumn(vector2.elementAt(n2));
                tableColumn.setPreferredWidth(this.TABLE_WIDTH[n2]);
                if (n2 == 2) {
                    tableColumn.setCellRenderer(new CustomCheckBoxTableCellRenderer());
                    tableColumn.setHeaderRenderer((TableCellRenderer)((Object)new CenterAlignedHeaderRenderer()));
                }
                ++n2;
            }
            table.setColumnSelectionAllowed(false);
            table.getSelectionModel().addListSelectionListener(this);
            table.setAutoResizeMode(1);
            int n3 = table.getPreferredScrollableViewportSize().width;
            int n4 = Math.min(5, this._backends.length);
            int n5 = 5 * (table.getRowMargin() + table.getRowHeight());
            Dimension dimension = new Dimension(n3, n5);
            table.setPreferredScrollableViewportSize(dimension);
            JScrollPane jScrollPane = new JScrollPane((Component)table);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setVerticalScrollBarPolicy(20);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)jScrollPane, gridBagConstraints);
        } else {
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)this.makeMultiLineLabel(2, 50, this._resource.getString(_section, "initialize-multiple-backends-list-not-found-label")), gridBagConstraints);
        }
    }

    public String getTitle() {
        String string;
        if (this._backend != null) {
            String[] stringArray = new String[]{this._backend};
            string = this._resource.getString(_section, "initializebackend-title", stringArray);
        } else {
            string = this._resource.getString(_section, "initialize-multiple-backends-title");
        }
        return string;
    }

    protected class CustomCheckBoxTableCellRenderer
    extends CheckBoxTableCellRenderer {
        private Vector _oldValues = new Vector();

        public CustomCheckBoxTableCellRenderer() {
            this._oldValues.setSize(DatabaseImportPanel.this._backends.length);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null && !object.equals(this._oldValues.elementAt(n))) {
                Debug.println((String)"CheckBoxTableCellRenderer.getTableCellRendererComponent(): checkOkay()");
                DatabaseImportPanel.this.checkOkay();
                this._oldValues.insertElementAt(object, n);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    protected class CustomTableModel
    extends DefaultTableModel {
        public CustomTableModel(Vector vector, Vector vector2) {
            super(vector, vector2);
        }

        public boolean isCellEditable(int n, int n2) {
            boolean bl = false;
            if (n2 == 2) {
                bl = true;
            }
            return bl;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

