/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.DSEntry;
import com.netscape.admin.dirserv.panel.IDSEntry;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;

public class DSEntrySet {
    private Hashtable _attributeNameToDNMap = null;
    private Hashtable _dnToAttributeNameArrayMap = null;
    private Hashtable _attrNametoDSAVectorMap = null;
    private Hashtable _DSAToAttributeMap = null;
    private boolean _validate = true;
    private boolean _allowNoEntry = true;
    private LDAPEntry _newEntry = null;
    private static final String CONFIG_DN = "cn=config";

    public DSEntrySet() {
        this(true, false);
    }

    public DSEntrySet(boolean bl) {
        this(bl, false);
    }

    public DSEntrySet(boolean bl, boolean bl2) {
        this._validate = bl;
        this._allowNoEntry = bl2;
        this._attributeNameToDNMap = new Hashtable();
        this._dnToAttributeNameArrayMap = new Hashtable();
        this._attrNametoDSAVectorMap = new Hashtable();
        this._DSAToAttributeMap = new Hashtable();
    }

    public DSEntrySet(boolean bl, boolean bl2, LDAPEntry lDAPEntry) {
        this._validate = bl;
        this._allowNoEntry = bl2;
        this._attributeNameToDNMap = new Hashtable();
        this._dnToAttributeNameArrayMap = new Hashtable();
        this._attrNametoDSAVectorMap = new Hashtable();
        this._DSAToAttributeMap = new Hashtable();
        this._newEntry = lDAPEntry;
    }

    public void add(String string, String string2, IDSEntry iDSEntry) {
        this._dnToAttributeNameArrayMap.put(string, new Boolean(false));
        this._attributeNameToDNMap.put(string2, string);
        String string3 = string + ':' + string2;
        this._DSAToAttributeMap.put(iDSEntry, string3.toLowerCase());
        if (!this._attrNametoDSAVectorMap.containsKey(string2)) {
            this._attrNametoDSAVectorMap.put(string2, new Vector());
        }
        Vector vector = (Vector)this._attrNametoDSAVectorMap.get(string2);
        vector.addElement(iDSEntry);
    }

    public void removeAll() {
        this._dnToAttributeNameArrayMap.clear();
        this._attributeNameToDNMap.clear();
        this._DSAToAttributeMap.clear();
        this._attrNametoDSAVectorMap.clear();
    }

    private boolean getAttributes(IDSModel iDSModel) throws LDAPException {
        LDAPConnection lDAPConnection = iDSModel.getServerInfo().getLDAPConnection();
        Enumeration enumeration = this._dnToAttributeNameArrayMap.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            LDAPEntry lDAPEntry = null;
            String[] stringArray = this.getAttributeNames(string);
            Debug.println((int)9, (String)("DSEntrySet.getAttributes(): attempting to read entry " + string + " from the server attrNames = " + stringArray));
            try {
                lDAPEntry = lDAPConnection.read(string, stringArray);
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32 && this._allowNoEntry) {
                    lDAPEntry = null;
                }
                throw lDAPException;
            }
            if (lDAPEntry == null && !this._allowNoEntry) {
                Debug.println((String)("DSEntrySet.getAttribytes: failed to read " + string));
                return false;
            }
            Debug.println((String)("DSEntrySet.getAttributes(): read entry from DS:" + lDAPEntry));
            Debug.println((String)("DSEntrySet.getAttributes(): attributes for this entry:" + stringArray));
            boolean bl = true;
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                LDAPAttribute lDAPAttribute = null;
                if (lDAPEntry != null) {
                    lDAPAttribute = lDAPEntry.getAttribute(string2);
                }
                if (lDAPAttribute == null && lDAPEntry != null) {
                    Debug.println((String)("DSEntrySet.getAttributes(): failed to get attribute " + string2 + " in " + lDAPEntry.getDN()));
                    bl = false;
                }
                Vector vector = (Vector)this._attrNametoDSAVectorMap.get(string2);
                int n2 = 0;
                while (vector != null && n2 < vector.size()) {
                    IDSEntry iDSEntry = (IDSEntry)vector.elementAt(n2);
                    if (lDAPAttribute != null) {
                        iDSEntry.remoteToLocal(lDAPAttribute.getStringValues());
                    } else {
                        iDSEntry.remoteToLocal("");
                    }
                    iDSEntry.show();
                    ++n2;
                }
                ++n;
            }
            if (bl) continue;
            Debug.println((String)("DSEntrySet.show(): some of the attributes of " + lDAPEntry.getDN() + " could not be read.  Either they " + "are not present in the entry or there is an ACI " + "which prevents that attribute from being read. " + "Try authenticating as a user with more access"));
            if (!this._validate) continue;
            return false;
        }
        return true;
    }

    public void show(IDSModel iDSModel) throws LDAPException {
        Debug.println((int)9, (String)("DSEntrySet.show: model=" + iDSModel));
        LDAPConnection lDAPConnection = iDSModel.getServerInfo().getLDAPConnection();
        Debug.println((int)9, (String)("DSEntrySet.show: ldc=" + DSUtil.format(lDAPConnection)));
        boolean bl = false;
        while (!bl) {
            String string;
            block5: {
                try {
                    bl = this.getAttributes(iDSModel);
                }
                catch (LDAPException lDAPException) {
                    Debug.println((String)("DSEntrySet.show(): LDAP error code=" + lDAPException.getLDAPResultCode() + " error=" + (Object)((Object)lDAPException)));
                    if (lDAPException.getLDAPResultCode() == 32 && this._allowNoEntry) {
                        bl = true;
                    }
                    if (lDAPException.getLDAPResultCode() == 50) break block5;
                    iDSModel.notifyAuthChangeListeners();
                    throw lDAPException;
                }
            }
            if (!bl && (string = (String)iDSModel.getServerInfo().get("rootdn")) != null) {
                bl = string.equalsIgnoreCase(lDAPConnection.getAuthenticationDN());
            }
            if (bl) continue;
            DSUtil.showPermissionDialog((Component)iDSModel.getFrame(), lDAPConnection);
            if (iDSModel.getNewAuthentication(false)) continue;
            bl = true;
        }
        iDSModel.notifyAuthChangeListeners();
    }

    public boolean store(IDSModel iDSModel) throws LDAPException {
        LDAPConnection lDAPConnection = iDSModel.getServerInfo().getLDAPConnection();
        boolean bl = false;
        boolean bl2 = false;
        Enumeration enumeration = this._dnToAttributeNameArrayMap.keys();
        while (enumeration.hasMoreElements()) {
            boolean bl3;
            String string = (String)enumeration.nextElement();
            String[] stringArray = this.getAttributeNames(string);
            if (stringArray == null) continue;
            LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
            int n = 0;
            while (n < stringArray.length) {
                Object[] objectArray;
                Object object;
                bl3 = false;
                String string2 = stringArray[n];
                Vector vector = (Vector)this._attrNametoDSAVectorMap.get(string2);
                boolean bl4 = true;
                int n2 = 0;
                while (bl4 && n2 < vector.size()) {
                    object = (IDSEntry)vector.elementAt(n2);
                    bl4 = object.dsValidate();
                    ++n2;
                }
                if (!bl4) {
                    return bl;
                }
                object = new Vector();
                int n3 = 0;
                while (vector != null && n3 < vector.size()) {
                    IDSEntry iDSEntry = (IDSEntry)vector.elementAt(n3);
                    iDSEntry.store();
                    objectArray = iDSEntry.localToRemote();
                    if (((DSEntry)iDSEntry).getDirty()) {
                        if (!bl2) {
                            bl2 = DSUtil.requiresRestart(string, string2);
                        }
                        bl3 = true;
                        ((DSEntry)iDSEntry).reset();
                    }
                    int n4 = 0;
                    while (objectArray != null && n4 < objectArray.length) {
                        ((Vector)object).addElement(objectArray[n4]);
                        ++n4;
                    }
                    ++n3;
                }
                if (bl3) {
                    int n5 = ((Vector)object).size();
                    objectArray = new String[n5];
                    ((Vector)object).copyInto(objectArray);
                    lDAPModificationSet.add(2, new LDAPAttribute(string2, (String[])objectArray));
                }
                ++n;
            }
            if (lDAPModificationSet.size() == 0) {
                return true;
            }
            bl3 = false;
            bl = false;
            boolean bl5 = false;
            boolean bl6 = this._newEntry != null;
            while (!bl3) {
                try {
                    Debug.println((String)("DSEntrySet.store: Saving " + lDAPModificationSet + " to " + string + " haveEntry=" + bl6));
                    if (bl5 && bl6) {
                        LDAPEntry lDAPEntry = this.addMods(this._newEntry, lDAPModificationSet);
                        lDAPConnection.add(lDAPEntry);
                        bl6 = false;
                        bl5 = false;
                        lDAPModificationSet = null;
                    } else {
                        lDAPConnection.modify(string, lDAPModificationSet);
                        lDAPModificationSet = null;
                    }
                    bl3 = true;
                    bl = true;
                }
                catch (LDAPException lDAPException) {
                    Debug.println((String)("DSEntrySet.store(): LDAP error code=" + lDAPException.getLDAPResultCode() + " dn=" + string + " error=" + (Object)((Object)lDAPException)));
                    if (lDAPException.getLDAPResultCode() == 50) {
                        DSUtil.showPermissionDialog((Component)iDSModel.getFrame(), lDAPConnection);
                        if (iDSModel.getNewAuthentication(false)) continue;
                        bl3 = true;
                        bl = false;
                        continue;
                    }
                    if (lDAPException.getLDAPResultCode() == 32 && bl6) {
                        bl5 = true;
                        continue;
                    }
                    iDSModel.notifyAuthChangeListeners();
                    throw lDAPException;
                }
            }
        }
        iDSModel.notifyAuthChangeListeners();
        if (bl2) {
            DSUtil.showInformationDialog((Component)iDSModel.getFrame(), "requires-restart", (String)null);
        }
        return bl;
    }

    String getAttributeForEntry(IDSEntry iDSEntry) {
        return (String)this._DSAToAttributeMap.get(iDSEntry);
    }

    private String[] getAttributeNames(String string) {
        if (string == null) {
            return null;
        }
        Object[] objectArray = null;
        if (this._dnToAttributeNameArrayMap.get(string) instanceof Boolean) {
            Vector<String> vector = new Vector<String>();
            Enumeration enumeration = this._attributeNameToDNMap.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)this._attributeNameToDNMap.get(string2);
                if (!string3.equals(string)) continue;
                vector.addElement(string2);
            }
            int n = vector.size();
            if (n > 0) {
                objectArray = new String[n];
                vector.copyInto(objectArray);
                this._dnToAttributeNameArrayMap.put(string, objectArray);
            }
        } else {
            objectArray = (String[])this._dnToAttributeNameArrayMap.get(string);
        }
        return objectArray;
    }

    private boolean reconnect(IDSModel iDSModel) {
        String string = iDSModel.getConsoleInfo().getCurrentDN();
        String[] stringArray = new String[]{"port", "serverhost"};
        LDAPConnection lDAPConnection = iDSModel.getConsoleInfo().getLDAPConnection();
        LDAPEntry lDAPEntry = null;
        boolean bl = false;
        try {
            lDAPEntry = lDAPConnection.read(string, stringArray);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("DSEntrySet.reconnect(): caught exception " + (Object)((Object)lDAPException) + " reading entry " + string));
        }
        if (lDAPEntry == null) {
            return bl;
        }
        String string2 = this.getAttribute(lDAPEntry, "serverhost");
        String string3 = this.getAttribute(lDAPEntry, "port");
        int n = 0;
        try {
            n = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        lDAPConnection = iDSModel.getServerInfo().getLDAPConnection();
        if (!(string2 != null && !lDAPConnection.getHost().equals(string2) || n != 0 && lDAPConnection.getPort() != n)) {
            return true;
        }
        boolean bl2 = false;
        while (!bl2) {
            try {
                lDAPConnection.connect(string2, n, lDAPConnection.getAuthenticationDN(), lDAPConnection.getAuthenticationPassword());
                bl2 = true;
                bl = true;
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("DSEntrySet.reconnect(): LDAP error code=" + lDAPException.getLDAPResultCode() + " error=" + (Object)((Object)lDAPException)));
                if (lDAPException.getLDAPResultCode() == 50) {
                    DSUtil.showPermissionDialog((Component)iDSModel.getFrame(), lDAPConnection);
                    if (iDSModel.getNewAuthentication(false)) continue;
                    bl2 = true;
                    bl = false;
                    continue;
                }
                bl2 = true;
                bl = false;
            }
        }
        iDSModel.notifyAuthChangeListeners();
        return bl;
    }

    private String getAttribute(LDAPEntry lDAPEntry, String string) {
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        if (lDAPAttribute != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            if (enumeration.hasMoreElements()) {
                return (String)enumeration.nextElement();
            }
        }
        return null;
    }

    private LDAPEntry addMods(LDAPEntry lDAPEntry, LDAPModificationSet lDAPModificationSet) {
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        int n = 0;
        while (n < lDAPModificationSet.size()) {
            LDAPModification lDAPModification = lDAPModificationSet.elementAt(n);
            if (lDAPModification.getOp() == 1 || lDAPModification.getOp() == 2) {
                lDAPAttributeSet.remove(lDAPModification.getAttribute().getName());
            }
            if (lDAPModification.getOp() == 0 || lDAPModification.getOp() == 2) {
                lDAPAttributeSet.add(lDAPModification.getAttribute());
            }
            ++n;
        }
        return new LDAPEntry(lDAPEntry.getDN(), lDAPAttributeSet);
    }

    private String printArray(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        if (stringArray == null) {
            stringBuffer.append("null");
        } else {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append("{" + stringArray[n] + "}");
                ++n;
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    String getConfigDN() {
        return CONFIG_DN;
    }
}

