/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.panel.DSEntry;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class DSEntryInteger
extends DSEntry {
    protected int _minValue;
    protected int _maxValue;
    protected int _scaleFactor = 1;
    protected boolean _blankOkay;

    public DSEntryInteger(String string, JTextField jTextField, int n, int n2, int n3, boolean bl) {
        super(string, (JComponent)jTextField);
        this._minValue = n;
        this._maxValue = n2;
        this._scaleFactor = n3;
        this._blankOkay = bl;
    }

    public DSEntryInteger(String string, JTextField jTextField, int n, int n2, int n3) {
        this(string, jTextField, n, n2, n3, false);
    }

    public DSEntryInteger(String string, JComponent jComponent, JComponent jComponent2, int n, int n2, int n3) {
        this(string, jComponent, jComponent2, n, n2, n3, false);
    }

    public DSEntryInteger(String string, JComponent jComponent, JComponent jComponent2, int n, int n2, int n3, boolean bl) {
        super(string, jComponent, jComponent2);
        this._minValue = n;
        this._maxValue = n2;
        this._scaleFactor = n3;
        this._blankOkay = bl;
    }

    public void show() {
        String string = this.getModel(0);
        if (!this._blankOkay || string.length() > 0) {
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (this._scaleFactor != 0) {
                n /= this._scaleFactor;
            }
            string = Integer.toString(n);
        }
        JTextField jTextField = (JTextField)this.getView(0);
        jTextField.setText(string);
        this.viewInitialized();
    }

    public void store() {
    }

    protected void updateModel() {
        JTextField jTextField = (JTextField)this.getView(0);
        String string = jTextField.getText();
        if (string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            string = Integer.toString(n *= this._scaleFactor);
        }
        this.setModelAt(string, 0);
    }

    public int validate() {
        JTextField jTextField = (JTextField)this.getView(0);
        String string = jTextField.getText();
        if (!jTextField.isEnabled()) {
            return 0;
        }
        if (this._blankOkay && string.length() < 1) {
            return 0;
        }
        int n = 0;
        if (string == null || string.length() == 0) {
            return 101;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 102;
        }
        if (n < this._minValue) {
            return 103;
        }
        if (n > this._maxValue) {
            return 104;
        }
        return 0;
    }

    public boolean dsValidate() {
        JTextField jTextField = (JTextField)this.getView(0);
        String string = jTextField.getText();
        String string2 = null;
        String[] stringArray = null;
        switch (this.validate()) {
            case 101: {
                string2 = "101";
                break;
            }
            case 102: {
                string2 = "102";
                stringArray = new String[]{string};
                break;
            }
            case 103: {
                string2 = "103";
                stringArray = new String[]{string, Integer.toString(this._minValue)};
                break;
            }
            case 104: {
                string2 = "104";
                stringArray = new String[]{string, Integer.toString(this._maxValue)};
                break;
            }
            default: {
                return true;
            }
        }
        DSEntry.reportError(string2, stringArray, jTextField);
        return false;
    }

    public int getValue() {
        int n;
        JTextField jTextField = (JTextField)this.getView(0);
        String string = jTextField.getText().trim();
        if (string.length() > 0) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        } else {
            n = 0;
        }
        return n;
    }

    public int getModelValue() {
        int n;
        String string = this.getModel(0);
        if (string.length() > 0) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        } else {
            n = 0;
        }
        return n;
    }

    public void setMinValue(int n) {
        this._minValue = n;
    }

    public int getMinValue() {
        return this._minValue;
    }

    public void setMaxValue(int n) {
        this._maxValue = n;
    }

    public int getMaxValue() {
        return this._maxValue;
    }
}

