/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.DSEntry;
import com.netscape.admin.dirserv.panel.DSEntryText;
import com.netscape.management.client.util.Debug;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.util.DN;

public class DSEntryDN
extends DSEntryText {
    private String _attrName;
    private JTextField _tf;
    private IDSModel _dsModel;
    private String _label;
    private static final int ERROR_EMPTY_FIELD = 1;
    private static final int ERROR_NOT_A_DN = 2;

    public DSEntryDN(String string, JComponent jComponent, JComponent jComponent2, String string2, IDSModel iDSModel) {
        super(string, jComponent, jComponent2);
        this._attrName = string2;
        this._tf = (JTextField)jComponent;
        if (jComponent2 instanceof JLabel) {
            this._label = ((JLabel)jComponent2).getText();
        }
        this._dsModel = iDSModel;
    }

    public void store() {
        super.store();
        String string = this.getModel(0);
        String string2 = this._dsModel.getConsoleInfo().getCurrentDN();
        String string3 = this._tf.getText().trim();
        LDAPConnection lDAPConnection = this._dsModel.getConsoleInfo().getLDAPConnection();
        try {
            LDAPModification lDAPModification = new LDAPModification(2, new LDAPAttribute(this._attrName, string3));
            lDAPConnection.modify(string2, lDAPModification);
            Debug.println((String)("ServerManagerPanel.DSEntryDN.store(): modified " + lDAPModification + " for " + string2));
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("ServerManagerPanel.DSEntryDN.store(): to " + string2 + " " + (Object)((Object)lDAPException)));
        }
    }

    public int validate() {
        String string = this._tf.getText().trim();
        if (!this._tf.isEnabled()) {
            return 0;
        }
        if (string.equals("")) {
            return 1;
        }
        if (!DN.isDN((String)string)) {
            return 2;
        }
        return 0;
    }

    public boolean dsValidate() {
        String string = this._tf.getText();
        String string2 = null;
        String[] stringArray = null;
        switch (this.validate()) {
            case 1: {
                string2 = "101";
                break;
            }
            case 2: {
                string2 = "122";
                stringArray = new String[]{this._label};
                break;
            }
            default: {
                DSUtil.checkForLDAPv2Quoting(string, this._dsModel.getFrame(), this._label);
                return true;
            }
        }
        DSEntry.reportError(string2, stringArray, this._tf);
        return false;
    }
}

