/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.IDSEntry;
import com.netscape.management.client.util.Debug;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public abstract class DSEntry
implements IDSEntry {
    public static final int DSE_VALID_NOMOD = 0;
    public static final int DSE_INVALID_NOMOD = 1;
    public static final int DSE_VALID_MOD = 2;
    public static final int DSE_INVALID_MOD = 3;
    public static final int DSE_INVALID = 1;
    public static final int DSE_MOD = 2;
    private Vector _model = null;
    private Vector _origModel = null;
    private JComponent[] _view = null;
    private boolean dirty = false;
    private boolean _viewInit = false;

    public DSEntry(JComponent jComponent) {
        JComponent[] jComponentArray = new JComponent[]{jComponent};
        this.init(null, jComponentArray);
    }

    public DSEntry(String string, JComponent jComponent) {
        JComponent[] jComponentArray = new JComponent[]{jComponent};
        if (string == null) {
            this.init(null, jComponentArray);
        } else {
            String[] stringArray = new String[]{string};
            this.init(stringArray, jComponentArray);
        }
    }

    public DSEntry(String[] stringArray, JComponent jComponent) {
        JComponent[] jComponentArray = new JComponent[]{jComponent};
        this.init(stringArray, jComponentArray);
    }

    public DSEntry(String string, JComponent[] jComponentArray) {
        if (string == null) {
            this.init(null, jComponentArray);
        } else {
            String[] stringArray = new String[]{string};
            this.init(stringArray, jComponentArray);
        }
    }

    public DSEntry(String string, JComponent jComponent, JComponent jComponent2) {
        JComponent[] jComponentArray = new JComponent[]{jComponent, jComponent2};
        if (string == null) {
            this.init(null, jComponentArray);
        } else {
            String[] stringArray = new String[]{string};
            this.init(stringArray, jComponentArray);
        }
    }

    public DSEntry(String[] stringArray, JComponent[] jComponentArray) {
        this.init(stringArray, jComponentArray);
    }

    public void remoteToLocal(String string) {
        this._model = new Vector(1);
        this._model.addElement(string);
        this.setInitModel();
        this._origModel = (Vector)this._model.clone();
        this._viewInit = false;
    }

    public void remoteToLocal(Enumeration enumeration) {
        this._model = new Vector();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            this._model.addElement(enumeration.nextElement());
            ++n;
        }
        if (this._model.size() < 1) {
            this._model = new Vector();
            this._model.addElement("");
        }
        this.setInitModel();
        this._origModel = (Vector)this._model.clone();
        this._viewInit = false;
    }

    public String[] localToRemote() {
        Object[] objectArray = null;
        objectArray = new String[this._model.size()];
        this._model.copyInto(objectArray);
        return objectArray;
    }

    public int doValidate() {
        boolean bl;
        if (this._viewInit) {
            this.updateModel();
        }
        boolean bl2 = this.dirty || this.isModified();
        boolean bl3 = bl = this.validate() == 0;
        if (bl2 && bl) {
            return 2;
        }
        if (bl2 && !bl) {
            return 3;
        }
        if (!bl2 && bl) {
            return 0;
        }
        return 1;
    }

    protected abstract void updateModel();

    protected void setInitModel() {
    }

    public void fakeInitModel(String string) {
        this.setModelAt(string, 0);
        this._origModel = null;
        this._origModel = (Vector)this._model.clone();
        this._viewInit = false;
    }

    public boolean isModified() {
        int n = 0;
        while (this._view != null && n < this._view.length) {
            if (this._view[n] != null && !this._view[n].isEnabled()) {
                Debug.println((int)8, (String)("DSEntry.isModified: some views are null disabled: " + this.toString()));
                return false;
            }
            ++n;
        }
        if (this._model == null || this._origModel == null) {
            Debug.println((int)8, (String)("DSEntry.isModified: model is null " + this._model + " " + this._origModel + " " + this.toString()));
            return false;
        }
        if (this._model.size() != this._origModel.size()) {
            Debug.println((int)8, (String)("DSEntry.isModified: model is null " + this._model + " " + this._origModel + " " + this.toString()));
            return true;
        }
        n = 0;
        while (n < this._model.size()) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < this._origModel.size()) {
                if (this._model.elementAt(n).equals(this._origModel.elementAt(n2))) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                return true;
            }
            ++n;
        }
        Debug.println((int)8, (String)("DSEntry.isModified: model size = " + this._model.size() + " orig " + this._origModel.size() + " every element is unmodified " + this.toString()));
        return false;
    }

    public boolean getDirty() {
        return this.dirty || this.isModified();
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public void reset() {
        this.dirty = false;
        this._origModel = null;
        this._origModel = (Vector)this._model.clone();
    }

    public abstract void show();

    public abstract void store();

    public boolean dsValidate() {
        return this.validate() == 0;
    }

    public abstract int validate();

    private void init(String[] stringArray, JComponent[] jComponentArray) {
        this._model = null;
        if (stringArray != null && stringArray[0] != null) {
            this._model = new Vector(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this._model.addElement(stringArray[n]);
                ++n;
            }
        } else {
            this._model = new Vector();
            this._model.addElement("");
        }
        this._origModel = (Vector)this._model.clone();
        this._view = jComponentArray;
        this.setDirty(false);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Model {");
        int n = 0;
        while (this._model != null && n < this._model.size()) {
            stringBuffer.append("{model[" + n + "]=" + this._model.elementAt(n) + "}");
            ++n;
        }
        if (this._model == null) {
            stringBuffer.append("null");
        }
        stringBuffer.append("Original Model {");
        int n2 = 0;
        while (this._origModel != null && n2 < this._origModel.size()) {
            stringBuffer.append("{model[" + n2 + "]=" + this._origModel.elementAt(n2) + "}");
            ++n2;
        }
        if (this._origModel == null) {
            stringBuffer.append("null");
        }
        stringBuffer.append("} View {");
        int n3 = 0;
        while (this._view != null && n3 < this._view.length) {
            stringBuffer.append("{view[" + n3 + "]=" + this._view[n3] + "}");
            ++n3;
        }
        stringBuffer.append("} ");
        return stringBuffer.toString();
    }

    protected String getModel(int n) {
        String string = null;
        if (this._model != null && n >= 0 && n < this._model.size()) {
            string = (String)this._model.elementAt(n);
        }
        return string;
    }

    protected int getModelSize() {
        int n = 0;
        if (this._model != null) {
            n = this._model.size();
        }
        return n;
    }

    public JComponent getView(int n) {
        JComponent jComponent = null;
        if (n >= 0 && n < this._view.length) {
            jComponent = this._view[n];
        }
        return jComponent;
    }

    public int getViewCount() {
        return this._view.length;
    }

    protected void setModelAt(String string, int n) {
        if (this._model == null) {
            this._model = new Vector();
        }
        if (this._model.size() <= n) {
            this._model.setSize(n + 1);
        }
        this._model.setElementAt(string, n);
    }

    protected void clearModel() {
        if (this._model != null) {
            this._model.removeAllElements();
        }
    }

    public static void reportError(String string, String[] stringArray, JComponent jComponent, String string2) {
        if (string2 == null) {
            string2 = "general";
        }
        DSUtil.showErrorDialog(null, string, stringArray, string2);
        if (jComponent != null) {
            if (jComponent instanceof JTextComponent) {
                ((JTextComponent)jComponent).selectAll();
            }
            jComponent.grabFocus();
        }
    }

    public static void reportError(String string, String[] stringArray, JComponent jComponent) {
        DSEntry.reportError(string, stringArray, jComponent, null);
    }

    public static void reportError(String string) {
        DSEntry.reportError(string, null, null, null);
    }

    protected void viewInitialized() {
        this._viewInit = true;
    }

    protected void disableAllComponents() {
        int n = 0;
        while (this._view != null && n < this._view.length) {
            this._view[n].setEnabled(false);
            ++n;
        }
    }
}

