/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.IChangeClient;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.IDSResourceSelectionListener;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.util.RemoteImage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ContainerPanel
extends JPanel
implements IChangeClient,
ActionListener,
IDSResourceSelectionListener,
ChangeListener {
    protected static final boolean _verbose = false;
    protected BlankPanel _selectedPanel = null;
    private IDSModel _dsModel;
    protected JButton _bOK = null;
    protected JButton _bReset = null;
    protected JButton _bHelp = null;
    protected JPanel _buttonPanel = null;
    private JPanel _clientPanel = null;
    private RemoteImage _markImage = null;

    public ContainerPanel(IDSModel iDSModel, boolean bl) {
        this.setLayout(new BorderLayout(0, 0));
        if (bl) {
            JPanel jPanel = this.createButtonPanel();
            this.add((Component)jPanel, "South");
            this._bOK.setEnabled(false);
            this._bReset.setEnabled(false);
        }
        if (System.getProperty("ShowColors") != null) {
            this.setBackground(Color.yellow);
        }
        iDSModel.addIDSResourceSelectionListener(this);
        iDSModel.addChangeClient(this);
        this._dsModel = iDSModel;
    }

    public ContainerPanel(IDSModel iDSModel) {
        this(iDSModel, true);
    }

    public ContainerPanel(IDSModel iDSModel, BlankPanel blankPanel, boolean bl) {
        this(iDSModel, bl);
        this.add((Component)blankPanel, "Center");
        this._selectedPanel = blankPanel;
    }

    public void select(IResourceObject iResourceObject, IPage iPage) {
        this._selectedPanel = this.getSelectedPanel();
    }

    public void unselect(IResourceObject iResourceObject, IPage iPage) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        Component component = jTabbedPane.getSelectedComponent();
        BlankPanel blankPanel = this.getSelectedPanel();
        if (component instanceof BlankPanel) {
            this._selectedPanel = (BlankPanel)component;
            if (blankPanel != component) {
                blankPanel.unselect(null, null);
            }
            this._selectedPanel.select(null, null);
        }
    }

    protected BlankPanel getSelectedPanel() {
        return this._selectedPanel;
    }

    protected JPanel createButtonPanel() {
        this._bOK = UIFactory.makeJButton((Object)this, "general", "Apply");
        this._bReset = UIFactory.makeJButton((Object)this, "general", "Reset");
        this._bOK.setRequestFocusEnabled(false);
        this._bReset.setRequestFocusEnabled(false);
        this._bHelp = UIFactory.makeJButton((Object)this, "general", "Help");
        JButton[] jButtonArray = new JButton[]{this._bOK, this._bReset, this._bHelp};
        this._buttonPanel = UIFactory.makeJButtonPanel(jButtonArray, true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("Center", this._buttonPanel);
        jPanel.add("North", Box.createVerticalStrut(UIFactory.getDifferentSpace()));
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("refresh")) {
            BlankPanel blankPanel = this.getSelectedPanel();
            if (blankPanel != null) {
                blankPanel.refresh();
            }
        } else if (actionEvent.getSource().equals(this._bOK)) {
            this.okCallback();
        } else if (actionEvent.getSource().equals(this._bReset)) {
            this.resetCallback();
        } else if (actionEvent.getSource().equals(this._bHelp)) {
            this.helpCallback();
        }
    }

    public void okCallback() {
        BlankPanel blankPanel = this.getSelectedPanel();
        if (blankPanel._isInitialized) {
            blankPanel.okCallback();
        }
        if (!this.isDirty()) {
            this._bOK.setEnabled(false);
            this._bReset.setEnabled(false);
        }
    }

    public void resetCallback() {
        BlankPanel blankPanel = this.getSelectedPanel();
        if (blankPanel._isInitialized) {
            blankPanel.resetCallback();
        }
        if (!this.isDirty()) {
            this._bOK.setEnabled(false);
            this._bReset.setEnabled(false);
        }
    }

    public boolean isDirty() {
        BlankPanel blankPanel = this.getSelectedPanel();
        return blankPanel.isDirty();
    }

    protected void helpCallback() {
        this._selectedPanel = this.getSelectedPanel();
        if (this._selectedPanel != null) {
            this._selectedPanel.helpCallback();
        }
    }

    public void setDirtyFlag() {
        if (this._bReset != null) {
            this._bReset.setEnabled(true);
        }
    }

    public void setDirtyFlag(JPanel jPanel) {
        this.setDirtyFlag();
    }

    public void clearDirtyFlag() {
        if (this._bReset != null && !this.isDirty()) {
            this._bReset.setEnabled(false);
        }
        if (this._bOK != null) {
            this._bOK.setEnabled(false);
        }
    }

    public void clearDirtyFlag(JPanel jPanel) {
        this.clearDirtyFlag();
    }

    public void setValidFlag() {
        if (this._bOK != null) {
            this._bOK.setEnabled(true);
        }
    }

    public void setValidFlag(JPanel jPanel) {
        this.setValidFlag();
    }

    public void clearValidFlag() {
        if (this._bOK != null) {
            this._bOK.setEnabled(false);
        }
    }

    public void clearValidFlag(JPanel jPanel) {
        this.clearValidFlag();
    }

    public JButton getOKButton() {
        return this._bOK;
    }

    public JButton getCancelButton() {
        return this._bReset;
    }

    public void updateButtons() {
        if (this._buttonPanel != null) {
            this._buttonPanel.invalidate();
            this._buttonPanel.validate();
            this._buttonPanel.repaint();
        }
    }

    protected IDSModel getModel() {
        return this._dsModel;
    }
}

