/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.node;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.node.DSResourceObject;
import com.netscape.admin.dirserv.node.MappingNodeObject;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.admin.dirserv.panel.NewMappingNodePanel;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.util.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class MappingTreeRootResourceObject
extends DSResourceObject
implements IMenuInfo,
ActionListener,
TreeExpansionListener {
    private boolean _isLoaded = false;
    private boolean _isInitiallyExpanded = false;
    private boolean _isLeaf = false;
    private static final String ID = "nsslapd-pluginid";
    private static final String BCKD = "nsslapd-backend";
    static final String NEWMAPP = "mappingtree";
    private static String _dbFilter;
    private static final String mappingIconName = "mappnode.gif";
    private static final String mappingIconNameL = "mappnodeL.gif";
    private static final String ENABLED = "nsslapd-pluginenabled";
    static final String REFRESH = "refresh";
    static final String RESTORE = "restore";

    public MappingTreeRootResourceObject(IDSModel iDSModel) {
        super(DSResourceObject._resource.getString("resourcepage", "Mapping"), DSUtil.getPackageImage(mappingIconName), DSUtil.getPackageImage(mappingIconNameL), iDSModel);
    }

    public boolean run(IPage iPage) {
        Debug.println((String)("MappingTreeRootResourceObject.run(" + iPage.getClass().getName() + ")"));
        this.reload();
        if (super.getChildCount() != 0) {
            this.expandPath((ResourcePage)iPage);
        }
        this.refreshTree();
        return true;
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        return this.run(iPage);
    }

    public void reload() {
        this.cleanTree();
        this._isLeaf = true;
        try {
            try {
                this._model.fireChangeFeedbackCursor(null, 3);
                LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=mapping tree, cn=config", 2, "(&(objectclass=nsMappingTree)(!(nsslapd-parent-suffix=*)))", null, false);
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                    String string = lDAPEntry.getDN();
                    Debug.println((String)("Mapping node: " + string));
                    string = MappingUtils.unQuote(LDAPDN.explodeDN((String)lDAPEntry.getDN(), (boolean)true)[0]);
                    this._isLeaf = false;
                    MappingNodeObject mappingNodeObject = new MappingNodeObject(string, this._model, lDAPEntry);
                    ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)((Object)mappingNodeObject));
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("MappingTreeRootResourceObject.reload: " + (Object)((Object)lDAPException)));
                Object var7_8 = null;
                this._model.fireChangeFeedbackCursor(null, 0);
            }
            Object var7_7 = null;
            this._model.fireChangeFeedbackCursor(null, 0);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this._model.fireChangeFeedbackCursor(null, 0);
            throw throwable;
        }
        this.refreshTree();
        this._isLoaded = true;
    }

    public void select(IPage iPage) {
        if (!this.isLoaded()) {
            this.reload();
        }
        super.select(iPage);
    }

    public boolean isLoaded() {
        return this._isLoaded;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(REFRESH)) {
            this.reload();
            this.refreshTree();
        }
    }

    public String[] getMenuCategoryIDs() {
        return new String[]{"OBJECT", "CONTEXT"};
    }

    public IMenuItem[] getMenuItems(String string) {
        return new IMenuItem[]{new MenuItemText(NEWMAPP, DSResourceObject._resource.getString("menu", "newmappingnode"), DSResourceObject._resource.getString("menu", "newmappingnode-description"))};
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        if (iMenuItem.getID().equals(NEWMAPP)) {
            NewMappingNodePanel newMappingNodePanel = new NewMappingNodePanel(this._model, null);
            SimpleDialog simpleDialog = new SimpleDialog(this._model.getFrame(), newMappingNodePanel.getTitle(), 11, newMappingNodePanel);
            simpleDialog.setComponent(newMappingNodePanel);
            simpleDialog.setOKButtonEnabled(false);
            simpleDialog.setDefaultButton(1);
            simpleDialog.packAndShow();
            this.reload();
        }
    }

    public boolean isLeaf() {
        return this._isLeaf;
    }

    void refreshTree() {
        this._model.fireTreeStructureChanged(this);
    }

    private void expandPath(ResourcePage resourcePage) {
        TreePath treePath = new TreePath(((DefaultMutableTreeNode)((Object)this)).getPath());
        resourcePage.expandTreePath(treePath);
    }

    private void cleanTree() {
        ((DefaultMutableTreeNode)((Object)this)).removeAllChildren();
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        IResourceObject iResourceObject = (IResourceObject)treeExpansionEvent.getPath().getLastPathComponent();
        if (this.equals(iResourceObject) && !this._isInitiallyExpanded) {
            this._isInitiallyExpanded = true;
            Debug.println((String)"PluginResourceObject.treeExpanded: this");
            if (!this.isLoaded()) {
                this.reload();
            }
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }
}

