/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.node;

import com.netscape.admin.dirserv.DSResourcePage;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.node.DSResourceObject;
import com.netscape.admin.dirserv.node.MappingTreeRootResourceObject;
import com.netscape.admin.dirserv.panel.MappingNodePanel;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.admin.dirserv.panel.NewMappingNodePanel;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.RemoteImage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class MappingNodeObject
extends DSResourceObject
implements IMenuInfo,
ActionListener,
TreeExpansionListener {
    private LDAPEntry _entry = null;
    private boolean _isLeaf = false;
    private boolean _isLoaded = false;
    private boolean _isInitiallyExpanded = false;
    private static RemoteImage _icon = DSUtil.getPackageImage("split-16.gif");
    private static final String _mappingNodeImageName = "split-16.gif";
    static final String DELETE = "delete_map_node";
    static final String NEWMAPP = "newmappingnode";
    static final String REFRESH = "refresh";
    static final String RESTORE = "restore";
    private MappingNodePanel _mainPanel = null;
    static final String CONFIG_MAPPING = "cn=mapping tree,cn=config";
    static final String SECTION = "mappingtree";
    static final int YES = 0;
    static final int NO = 1;

    public MappingNodeObject(String string, IDSModel iDSModel, LDAPEntry lDAPEntry) {
        this(string, _icon, iDSModel, lDAPEntry);
    }

    public MappingNodeObject(String string, RemoteImage remoteImage, IDSModel iDSModel, LDAPEntry lDAPEntry) {
        super(string, remoteImage, null, iDSModel);
        Debug.println((String)("MappingNodeObject() : entry =" + lDAPEntry.getDN()));
        this._entry = lDAPEntry;
    }

    public Component getCustomPanel() {
        if (this._mainPanel == null) {
            this._mainPanel = new MappingNodePanel(this._model, this._entry);
        }
        this._panel = this._mainPanel;
        return this._mainPanel;
    }

    public boolean run(IPage iPage) {
        Debug.println((String)("MappingNodeObject.run(" + iPage.getClass().getName() + ")"));
        this.reload();
        if (super.getChildCount() != 0) {
            this.expandPath((ResourcePage)iPage);
        }
        this.refreshTree();
        return true;
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        return this.run(iPage);
    }

    public void reload() {
        this.cleanTree();
        this._isLeaf = true;
        try {
            try {
                this._model.fireChangeFeedbackCursor(null, 3);
                LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
                String string = LDAPDN.explodeDN((String)this._entry.getDN(), (boolean)true)[0];
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=mapping tree, cn=config", 1, "(nsslapd-parent-suffix=" + MappingUtils.Quote(string) + ")", null, false);
                Debug.println((String)(" *** ((objectclass=nsMappingTree)(nsslapd-parent-suffix=" + MappingUtils.Quote(string) + ")): res.getCount()=" + lDAPSearchResults.getCount()));
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                    String string2 = lDAPEntry.getDN();
                    Debug.println((String)("*** Mapping node: " + string2));
                    string2 = MappingUtils.unQuote(LDAPDN.explodeDN((String)lDAPEntry.getDN(), (boolean)true)[0]);
                    this._isLeaf = false;
                    MappingNodeObject mappingNodeObject = new MappingNodeObject(string2, this._model, lDAPEntry);
                    ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)((Object)mappingNodeObject));
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("MappingNodeObject.reload: " + (Object)((Object)lDAPException)));
                Object var8_9 = null;
                this._model.fireChangeFeedbackCursor(null, 0);
            }
            Object var8_8 = null;
            this._model.fireChangeFeedbackCursor(null, 0);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this._model.fireChangeFeedbackCursor(null, 0);
            throw throwable;
        }
        this.refreshTree();
        this._isLoaded = true;
    }

    public void select(IPage iPage) {
        if (!this.isLoaded()) {
            this.reload();
        }
        super.select(iPage);
    }

    public boolean isLoaded() {
        return this._isLoaded;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(REFRESH)) {
            this.reload();
            this.refreshTree();
        }
    }

    public String[] getMenuCategoryIDs() {
        return new String[]{"OBJECT", "CONTEXT"};
    }

    public IMenuItem[] getMenuItems(String string) {
        return new IMenuItem[]{new MenuItemText(NEWMAPP, DSResourceObject._resource.getString("menu", NEWMAPP), DSResourceObject._resource.getString("menu", "newmappingnode-description")), new MenuItemText(DELETE, DSResourceObject._resource.getString("menu", "delmappingnode"), DSResourceObject._resource.getString("menu", "delmappingnode-description"))};
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        if (iMenuItem.getID().equals(NEWMAPP)) {
            this.create_mapping_node(this._entry);
            this.reload();
        } else if (iMenuItem.getID().equals(DELETE)) {
            DSResourcePage dSResourcePage = (DSResourcePage)iPage;
            dSResourcePage.getTree().getSelectionModel().clearSelection();
            this.delete_mapping_node(this._entry);
            TreeNode treeNode = ((DefaultMutableTreeNode)((Object)this)).getParent();
            if (treeNode instanceof MappingNodeObject) {
                ((MappingNodeObject)((Object)treeNode)).reload();
            } else {
                ((MappingTreeRootResourceObject)((Object)treeNode)).reload();
            }
        }
    }

    public boolean isLeaf() {
        return this.isLeafMappingNode();
    }

    void refreshTree() {
        this._model.fireTreeStructureChanged(this);
    }

    private void expandPath(ResourcePage resourcePage) {
        TreePath treePath = new TreePath(((DefaultMutableTreeNode)((Object)this)).getPath());
        resourcePage.expandTreePath(treePath);
    }

    private void cleanTree() {
        ((DefaultMutableTreeNode)((Object)this)).removeAllChildren();
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        IResourceObject iResourceObject = (IResourceObject)treeExpansionEvent.getPath().getLastPathComponent();
        if (this.equals(iResourceObject) && !this._isInitiallyExpanded) {
            this._isInitiallyExpanded = true;
            Debug.println((String)"MappingNodeObject.treeExpanded: this");
            if (!this.isLoaded()) {
                this.reload();
            }
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    private void create_mapping_node(LDAPEntry lDAPEntry) {
        NewMappingNodePanel newMappingNodePanel = new NewMappingNodePanel(this._model, lDAPEntry);
        SimpleDialog simpleDialog = new SimpleDialog(this._model.getFrame(), newMappingNodePanel.getTitle(), 11, newMappingNodePanel);
        simpleDialog.setComponent(newMappingNodePanel);
        simpleDialog.setOKButtonEnabled(false);
        simpleDialog.setDefaultButton(1);
        simpleDialog.packAndShow();
    }

    private void delete_mapping_node(LDAPEntry lDAPEntry) {
        String string = lDAPEntry.getDN();
        String string2 = new DN(string).explodeDN(true)[0];
        String[] stringArray = new String[]{string2};
        int n = DSUtil.showConfirmationDialog(null, "confirm-del-mapnode", stringArray, SECTION);
        if (n == 1) {
            return;
        }
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        if (!DSUtil.deleteTree(string, lDAPConnection)) {
            String[] stringArray2 = new String[]{string};
            DSUtil.showErrorDialog((Component)this._model.getFrame(), "remove", stringArray2, SECTION);
        }
    }

    private boolean isLeafMappingNode() {
        DN dN = new DN(this._entry.getDN());
        String string = LDAPDN.explodeDN((String)this._entry.getDN(), (boolean)true)[0];
        String string2 = "nsslapd-parent-suffix=" + MappingUtils.Quote(string);
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        try {
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(CONFIG_MAPPING, 1, string2, null, false);
            return lDAPSearchResults == null || !lDAPSearchResults.hasMoreElements();
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("MappingNodeObject.isLeafMappingNode() :" + (Object)((Object)lDAPException)));
            return false;
        }
    }
}

