/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.node;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.node.BackupResourceObject;
import com.netscape.admin.dirserv.node.ChainingPluginObject;
import com.netscape.admin.dirserv.node.DSResourceObject;
import com.netscape.admin.dirserv.node.DatabasePluginObject;
import com.netscape.admin.dirserv.node.RootResourceObject;
import com.netscape.admin.dirserv.node.SuffixResourceObject;
import com.netscape.admin.dirserv.panel.DatabaseRootPanel;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.admin.dirserv.panel.NewSuffixPanel;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.admin.dirserv.panel.replication.ReplicationResourceObject;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.RemoteImage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JDialog;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class DataRootResourceObject
extends DSResourceObject
implements ActionListener,
IMenuInfo,
TreeExpansionListener {
    protected String[] _categoryID;
    protected IMenuItem[] _contextMenuItems;
    protected IMenuItem[] _objectMenuItems;
    private boolean _isLoaded = false;
    private boolean _isInitiallyExpanded = false;
    private boolean _isLeaf = false;
    private static final String _dbinstImageName = "plugin.gif";
    private static final String ID = "nsslapd-pluginid";
    private static final String BCKD = "nsslapd-backend";
    static final String IMPORT = "import";
    static final String EXPORT = "export";
    static final String NEWDB = "newbackend";
    static final String NEWMAPP = "newmappingnode";
    private static String _dbFilter;
    private static final String databaseIconName = "dbcontainer.gif";
    private static final String databaseIconNameL = "dbcontainerL.gif";
    private static final String ENABLED = "nsslapd-pluginenabled";
    static final String REFRESH = "refresh";
    static final String RESTORE = "restore";
    private DatabaseRootPanel _mainPanel = null;

    public DataRootResourceObject(IDSModel iDSModel) {
        super(DSResourceObject._resource.getString("resourcepage", "Data"), DSUtil.getPackageImage(databaseIconName), DSUtil.getPackageImage(databaseIconNameL), iDSModel);
    }

    public Component getCustomPanel() {
        if (this._mainPanel == null) {
            this._mainPanel = new DatabaseRootPanel(this._model);
        }
        this._panel = this._mainPanel;
        return this._mainPanel;
    }

    public boolean run(IPage iPage) {
        Debug.println((String)("DataRootResourceObject.run(" + iPage.getClass().getName() + ")"));
        this.reload();
        if (super.getChildCount() != 0) {
            this.expandPath((ResourcePage)iPage);
        }
        this.refreshTree();
        return true;
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        return this.run(iPage);
    }

    public void reload() {
        this.cleanTree();
        this.addDBPlugin();
        ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)((Object)new BackupResourceObject(this._model)));
        this.addSuffixes();
        this.refreshTree();
        this._isLoaded = true;
    }

    private void addDBPlugin() {
        RemoteImage remoteImage = DSUtil.getPackageImage(_dbinstImageName);
        try {
            try {
                this._model.fireChangeFeedbackCursor(null, 3);
                LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=plugins, cn=config", 2, "nsslapd-plugintype=database", null, false);
                while (lDAPSearchResults.hasMoreElements()) {
                    DSResourceObject dSResourceObject;
                    Enumeration enumeration;
                    LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                    String string = lDAPEntry.getDN();
                    Debug.println((String)("Plugin: " + string));
                    LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("cn");
                    if (lDAPAttribute == null) {
                        lDAPAttribute = lDAPEntry.getAttribute(ID);
                    }
                    if (lDAPAttribute == null) {
                        lDAPAttribute = lDAPEntry.getAttribute(BCKD);
                    }
                    if (lDAPAttribute != null) {
                        this._isLeaf = false;
                        enumeration = lDAPAttribute.getStringValues();
                        if (enumeration.hasMoreElements()) {
                            string = (String)enumeration.nextElement();
                        }
                    }
                    string = this.getDBServiceName(string);
                    enumeration = lDAPEntry.getAttribute(ID);
                    Debug.println((String)("attr_type:" + enumeration.toString()));
                    if (enumeration == null) continue;
                    StringBuffer stringBuffer = new StringBuffer();
                    String string2 = null;
                    Enumeration enumeration2 = enumeration.getStringValues();
                    if (enumeration2.hasMoreElements()) {
                        stringBuffer.append((String)enumeration2.nextElement());
                    }
                    string2 = stringBuffer.toString();
                    Debug.println((String)("Plugin Type:" + string2));
                    if (string2.compareTo("ldbm-backend") == 0) {
                        dSResourceObject = new DatabasePluginObject(string, remoteImage, this._model, lDAPEntry, true);
                        ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)((Object)dSResourceObject));
                        continue;
                    }
                    if (string2.compareTo("chaining database") != 0) continue;
                    dSResourceObject = new ChainingPluginObject(string, remoteImage, this._model, lDAPEntry, true);
                    ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)((Object)dSResourceObject));
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("DataRootResourceObject.reload: " + (Object)((Object)lDAPException)));
                Object var13_14 = null;
                this._model.fireChangeFeedbackCursor(null, 0);
            }
            Object var13_13 = null;
            this._model.fireChangeFeedbackCursor(null, 0);
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this._model.fireChangeFeedbackCursor(null, 0);
            throw throwable;
        }
    }

    private String getDBServiceName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case ' ': {
                    stringBuffer.append('-');
                    break;
                }
                default: {
                    stringBuffer.append(string.charAt(n));
                }
            }
            ++n;
        }
        return DSResourceObject._resource.getString("resourcepage", stringBuffer.toString());
    }

    private void addSuffixes() {
        try {
            try {
                this._model.fireChangeFeedbackCursor(null, 3);
                LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=mapping tree, cn=config", 2, "(&(objectclass=nsMappingTree)(!(nsslapd-parent-suffix=*)))", null, false);
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                    String string = lDAPEntry.getDN();
                    Debug.println((String)("Mapping node: " + string));
                    string = MappingUtils.unQuote(LDAPDN.explodeDN((String)lDAPEntry.getDN(), (boolean)true)[0]);
                    this._isLeaf = false;
                    SuffixResourceObject suffixResourceObject = new SuffixResourceObject(string, this._model, lDAPEntry);
                    ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)((Object)suffixResourceObject));
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("DataRootResourceObject.reload: " + (Object)((Object)lDAPException)));
                Object var7_8 = null;
                this._model.fireChangeFeedbackCursor(null, 0);
            }
            Object var7_7 = null;
            this._model.fireChangeFeedbackCursor(null, 0);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this._model.fireChangeFeedbackCursor(null, 0);
            throw throwable;
        }
    }

    public void select(IPage iPage) {
        if (!this.isLoaded()) {
            this.reload();
        }
        super.select(iPage);
    }

    public boolean isLoaded() {
        return this._isLoaded;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(REFRESH)) {
            this.reload();
            this.refreshTree();
        }
    }

    public boolean isLeaf() {
        return this._isLeaf;
    }

    void refreshTree() {
        this._model.fireTreeStructureChanged(this);
    }

    private void expandPath(ResourcePage resourcePage) {
        TreePath treePath = new TreePath(((DefaultMutableTreeNode)((Object)this)).getPath());
        resourcePage.expandTreePath(treePath);
    }

    private void cleanTree() {
        ((DefaultMutableTreeNode)((Object)this)).removeAllChildren();
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        IResourceObject iResourceObject = (IResourceObject)treeExpansionEvent.getPath().getLastPathComponent();
        if (this.equals(iResourceObject) && !this._isInitiallyExpanded) {
            this._isInitiallyExpanded = true;
            Debug.println((String)"PluginResourceObject.treeExpanded: this");
            if (!this.isLoaded()) {
                this.reload();
            }
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public String[] getMenuCategoryIDs() {
        return new String[]{"OBJECT", "CONTEXT"};
    }

    public IMenuItem[] getMenuItems(String string) {
        if (string.equals("CONTEXT")) {
            if (this._contextMenuItems == null) {
                this._contextMenuItems = this.createMenuItems();
            }
            return this._contextMenuItems;
        }
        if (string.equals("OBJECT")) {
            if (this._objectMenuItems == null) {
                this._objectMenuItems = this.createMenuItems();
            }
            return this._objectMenuItems;
        }
        return null;
    }

    private IMenuItem[] createMenuItems() {
        return new IMenuItem[]{new MenuItemText(NEWMAPP, DSResourceObject._resource.getString("menu", "newrootmappingnode"), DSResourceObject._resource.getString("menu", "newmappingnode-description")), new MenuItemSeparator(), new MenuItemText(REFRESH, DSUtil._resource.getString("menu", REFRESH), DSUtil._resource.getString("menu", "refresh-description"))};
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        if (iMenuItem.getID().equals(REFRESH)) {
            ((IMenuInfo)this._model).actionMenuSelected(iPage, iMenuItem);
        } else if (iMenuItem.getID().equals(NEWMAPP)) {
            this.create_mapping_node(null);
            this.reload();
            this.refreshReplication();
        }
    }

    private void create_mapping_node(LDAPEntry lDAPEntry) {
        NewSuffixPanel newSuffixPanel = new NewSuffixPanel(this._model, lDAPEntry, true);
        SimpleDialog simpleDialog = new SimpleDialog(this._model.getFrame(), newSuffixPanel.getTitle(), 11, newSuffixPanel);
        simpleDialog.setComponent(newSuffixPanel);
        simpleDialog.setOKButtonEnabled(false);
        newSuffixPanel.init();
        simpleDialog.setFocusComponent(newSuffixPanel.getFocusComponent());
        ((JDialog)((Object)simpleDialog)).getAccessibleContext().setAccessibleDescription(DSUtil._resource.getString("mappingtree-new-root", "description"));
        simpleDialog.packAndShow();
    }

    public void refreshReplication() {
        this.refreshReplication((TreeNode)((Object)this));
    }

    private void refreshReplication(TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        TreeNode treeNode2 = treeNode.getParent();
        while (treeNode2 != null) {
            if (treeNode2 instanceof RootResourceObject) break;
            treeNode2 = treeNode2.getParent();
        }
        if (treeNode2 != null) {
            ReplicationResourceObject replicationResourceObject = ((RootResourceObject)((Object)treeNode2)).getReplicationObject();
            if (replicationResourceObject != null) {
                replicationResourceObject.refreshReplicationNode();
            }
        } else {
            Debug.println((String)"DataRootResourceObject.refreshReplicationNode() No RootResourceObject found");
        }
    }
}

