/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.node;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.node.DSResourceObject;
import com.netscape.admin.dirserv.panel.GalleryPanel;
import com.netscape.admin.dirserv.task.Backup;
import com.netscape.admin.dirserv.task.ListDB;
import com.netscape.admin.dirserv.task.Restore;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class BackupResourceObject
extends DSResourceObject
implements IMenuInfo,
TreeExpansionListener,
ActionListener {
    private boolean _isLoaded = false;
    private boolean _isInitiallyExpanded = false;
    private Icon _backupIcon = null;
    private Icon _backupIconL = null;
    private boolean _isLeaf = false;
    private static final String BACKUP = "backup";
    private static final String backupsIconName = "backupc.gif";
    private static final String backupsIconNameL = "backupcL.gif";
    private static final String _defaultIconName = "backup.gif";
    private static final String _defaultIconNameL = "backupL.gif";
    private static ResourceSet _resource = DSUtil._resource;
    protected String[] _categoryID;
    protected IMenuItem[] _contextMenuItems;
    protected IMenuItem[] _objectMenuItems;
    static JPanel _blankPanel = null;
    static final String REFRESH = "refresh";
    static final String RESTORE = "restore";

    public BackupResourceObject(IDSModel iDSModel) {
        super(_resource.getString("resourcepage", "Backups"), DSUtil.getPackageImage(backupsIconName), DSUtil.getPackageImage(backupsIconNameL), iDSModel);
    }

    public Component getCustomPanel() {
        if (_blankPanel == null) {
            _blankPanel = new GalleryPanel(this._model);
        }
        return _blankPanel;
    }

    public boolean run(IPage iPage) {
        Debug.println((String)("BackupResourceObject.run(" + iPage.getClass().getName() + ")"));
        this.reload();
        if (super.getChildCount() != 0) {
            this.expandPath((ResourcePage)iPage);
        }
        this.refreshTree();
        return true;
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        return this.run(iPage);
    }

    public void reload() {
        try {
            try {
                this._model.setWaitCursor(true);
                this.cleanTree();
                ListDB listDB = new ListDB(this._model.getServerInfo());
                String[] stringArray = listDB.getBackupList();
                if (stringArray != null) {
                    Icon icon = this.getBackupIcon();
                    Icon icon2 = this.getBackupIconL();
                    int n = 0;
                    while (n < stringArray.length) {
                        String string = stringArray[n];
                        int n2 = string.lastIndexOf(47);
                        String string2 = n2 >= 0 ? string.substring(n2 + 1) : string;
                        Debug.println((String)("Add backup node: " + string));
                        BackupFolderResourceObject backupFolderResourceObject = new BackupFolderResourceObject(string2, icon, icon2, string, this._model);
                        ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)((Object)backupFolderResourceObject));
                        ++n;
                    }
                    this._isLeaf = stringArray.length == 0;
                } else {
                    this._isLeaf = true;
                }
                this.refreshTree();
                this._isLoaded = true;
            }
            catch (Exception exception) {
                Debug.println((String)("BackupResourceObject.reload: " + exception));
                Object var11_12 = null;
                this._model.setWaitCursor(false);
            }
            Object var11_11 = null;
            this._model.setWaitCursor(false);
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this._model.setWaitCursor(false);
            throw throwable;
        }
    }

    public void select(IPage iPage) {
        if (!this.isLoaded()) {
            this.reload();
        }
        if (_blankPanel != null && _blankPanel instanceof GalleryPanel) {
            ((GalleryPanel)_blankPanel).select((IResourceObject)this, iPage);
        }
    }

    public void unselect(IPage iPage) {
        if (_blankPanel != null && _blankPanel instanceof GalleryPanel) {
            ((GalleryPanel)_blankPanel).unselect((IResourceObject)this, iPage);
        }
    }

    public boolean isLoaded() {
        return this._isLoaded;
    }

    public String[] getMenuCategoryIDs() {
        if (this._categoryID == null) {
            this._categoryID = new String[]{"OBJECT", "CONTEXT"};
        }
        return this._categoryID;
    }

    public IMenuItem[] getMenuItems(String string) {
        if (string.equals("CONTEXT")) {
            if (this._contextMenuItems == null) {
                this._contextMenuItems = this.createMenuItems();
            }
            return this._contextMenuItems;
        }
        if (string.equals("OBJECT")) {
            if (this._objectMenuItems == null) {
                this._objectMenuItems = this.createMenuItems();
            }
            return this._objectMenuItems;
        }
        return null;
    }

    private IMenuItem[] createMenuItems() {
        return new IMenuItem[]{new MenuItemText(BACKUP, _resource.getString("menu", BACKUP), _resource.getString("menu", "backup-description")), new MenuItemSeparator(), new MenuItemText(REFRESH, _resource.getString("menu", REFRESH), _resource.getString("menu", "refresh-description"))};
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        Debug.println((String)("BackupResourceObject.actionMenuSelected(" + iPage.getClass().getName() + "," + iMenuItem + ")"));
        if (iMenuItem.getID().equals(REFRESH)) {
            this.run(iPage);
        } else if (iMenuItem.getID().equals(BACKUP)) {
            Backup backup = new Backup();
            backup.setConsoleInfo(this._model.getServerInfo());
            backup.run(iPage);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(REFRESH)) {
            this.reload();
            this.refreshTree();
        }
    }

    public boolean isLeaf() {
        return this._isLeaf;
    }

    void refreshTree() {
        this._model.fireTreeStructureChanged(this);
    }

    private void expandPath(ResourcePage resourcePage) {
        TreePath treePath = new TreePath(((DefaultMutableTreeNode)((Object)this)).getPath());
        resourcePage.expandTreePath(treePath);
    }

    private void cleanTree() {
        ((DefaultMutableTreeNode)((Object)this)).removeAllChildren();
    }

    private Icon getBackupIcon() {
        if (this._backupIcon == null) {
            this._backupIcon = DSUtil.getPackageImage(_defaultIconName);
        }
        return this._backupIcon;
    }

    private Icon getBackupIconL() {
        if (this._backupIconL == null) {
            this._backupIconL = DSUtil.getPackageImage(_defaultIconNameL);
        }
        return this._backupIconL;
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        IResourceObject iResourceObject = (IResourceObject)treeExpansionEvent.getPath().getLastPathComponent();
        if (this.equals(iResourceObject) && !this._isInitiallyExpanded) {
            this._isInitiallyExpanded = true;
            Debug.println((String)"PluginResourceObject.treeExpanded: this");
            if (!this.isLoaded()) {
                this.reload();
            }
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    class BackupFolderResourceObject
    extends ResourceObject
    implements IMenuInfo {
        protected String[] _categoryID;
        protected IMenuItem[] _contextMenuItems;
        protected IMenuItem[] _objectMenuItems;
        private String _name = null;
        private IDSModel _model = null;

        public BackupFolderResourceObject(String string, Icon icon, Icon icon2, String string2, IDSModel iDSModel) {
            super(string, icon, icon2);
            this._name = string2;
            BackupResourceObject.this._backupIcon = icon;
            BackupResourceObject.this._backupIconL = icon2;
            this._model = iDSModel;
        }

        public Component getCustomPanel() {
            return _blankPanel;
        }

        public boolean run(IPage iPage) {
            Debug.println((String)("BackupResourceFolderObject.run(" + iPage.getClass().getName() + ")"));
            return true;
        }

        public String[] getMenuCategoryIDs() {
            if (this._categoryID == null) {
                this._categoryID = new String[]{"OBJECT", "CONTEXT"};
            }
            return this._categoryID;
        }

        public IMenuItem[] getMenuItems(String string) {
            if (string.equals("CONTEXT")) {
                if (this._contextMenuItems == null) {
                    this._contextMenuItems = this.createMenuItems();
                }
                return this._contextMenuItems;
            }
            if (string.equals("OBJECT")) {
                if (this._objectMenuItems == null) {
                    this._objectMenuItems = this.createMenuItems();
                }
                return this._objectMenuItems;
            }
            return null;
        }

        private IMenuItem[] createMenuItems() {
            return new IMenuItem[]{new MenuItemText(BackupResourceObject.RESTORE, _resource.getString("menu", BackupResourceObject.RESTORE), _resource.getString("menu", "restore-description"))};
        }

        public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
            Debug.println((String)("BackupResourceFolderObject.actionMenuSelected(" + iPage.getClass().getName() + "," + iMenuItem + ")"));
            if (iMenuItem.getID().equals(BackupResourceObject.RESTORE)) {
                Debug.println((String)("Restoring " + this._name));
                Restore restore = new Restore();
                restore.setConsoleInfo(this._model.getServerInfo());
                boolean bl = restore.restore(this._model.getSelectedPage(), this._name);
            }
        }
    }
}

