/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.logging;

import com.netscape.admin.dirserv.task.CGIReportTask;
import com.netscape.management.client.comm.CommClient;
import com.netscape.management.client.comm.CommManager;
import com.netscape.management.client.comm.HttpManager;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.table.DefaultTableModel;

public class DSLogViewerModel
extends DefaultTableModel {
    private boolean _finished = false;
    private int _lineCount = 25;
    private String _filter = null;
    protected String _url;
    String _username;
    String _password;
    private String _logName = null;
    protected static ResourceSet _resource;
    protected static String _section;
    boolean _updating = false;
    protected Thread _thread = null;

    public DSLogViewerModel(ConsoleInfo consoleInfo, String string) {
        this._url = consoleInfo.getAdminURL() + consoleInfo.get("ServerInstance") + "/" + string;
        this._password = consoleInfo.getAuthenticationPassword();
        this._username = (String)consoleInfo.get("AdminUsername");
        this._password = (String)consoleInfo.get("AdminUserPassword");
    }

    protected void init(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = _resource.getString(_section, "header-" + stringArray[n]);
            this.addColumn(string);
            ++n;
        }
    }

    public void updateNow() {
        this.updateLogData();
    }

    public int getRowCount() {
        this.updateLogLength();
        return super.getRowCount();
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void updateLogData() {
        if (!this._updating) {
            this._updating = true;
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("logfile", this.getLogFileName());
            hashtable.put("num", Integer.toString(this.getLineCount()));
            if (this.getFilter() != null) {
                hashtable.put("str", this.getFilter());
            }
            try {
                URL uRL = new URL(this._url);
                Debug.println((String)("DSLogViewerModel.updateLogData: " + uRL));
                HttpManager httpManager = new HttpManager();
                CommManager.setSendUTF8((boolean)true);
                ByteArrayInputStream byteArrayInputStream = CGIReportTask.encode(hashtable);
                httpManager.post(uRL, this.getCommClient(), null, (InputStream)byteArrayInputStream, ((InputStream)byteArrayInputStream).available(), 3);
                this.waitForFinish();
            }
            catch (Exception exception) {
                Debug.println((String)("DSLogViewerModel.updateLogData for " + this._url + ": " + exception));
            }
            this.fireTableDataChanged();
            Debug.println((String)"DSLogViewerModel done requesting");
        }
    }

    public void updateLogLength() {
    }

    CommClient getCommClient() {
        return null;
    }

    public String getLogFileName() {
        return this._logName;
    }

    public void setLogFileName(String string) {
        this._logName = string;
    }

    public int getLineCount() {
        return this._lineCount;
    }

    public void setLineCount(int n) {
        this._lineCount = n;
    }

    public String getFilter() {
        return this._filter;
    }

    public void setFilter(String string) {
        this._filter = string;
    }

    public static String unEscape(String string) {
        byte[] byArray;
        byte[] byArray2;
        int n = string.indexOf(92);
        if (n < 0) {
            return string;
        }
        try {
            byArray2 = string.getBytes("UTF8");
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.println((String)("DSLogViewModel.unEscape: " + unsupportedEncodingException + " , getBytes " + string));
            return string;
        }
        catch (Exception exception) {
            Debug.println((String)("DSLogViewModel.unEscape: " + exception + " , getBytes " + string));
            return string;
        }
        int n2 = 0;
        int n3 = byArray2.length;
        n2 = n;
        int n4 = n;
        while (n4 < n3) {
            char c = (char)byArray2[n4];
            if (c == '\\') {
                if (n4 > n3 - 3) break;
                ++n4;
                String string2 = "";
                try {
                    string2 = new String(byArray2, n4, 2);
                    int n5 = Integer.parseInt(string2, 16);
                    byArray[n2++] = (byte)n5;
                    n4 += 2;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    byArray[n2++] = 92;
                    byArray[n2++] = byArray2[n4++];
                    continue;
                }
                catch (Exception exception) {
                    Debug.println((String)("DSLogViewModel.unEscape: " + exception + " , parsing " + string2));
                    return string;
                }
            }
            byArray[n2++] = byArray2[n4++];
        }
        try {
            return new String(byArray, 0, n2, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.println((String)("DSLogViewModel.unEscape: " + unsupportedEncodingException + " , forming new String from " + string));
            return string;
        }
    }

    public synchronized void waitForFinish() {
        this._thread = Thread.currentThread();
        try {
            this._finished = false;
            while (!this._finished) {
                Debug.println((String)"DSLogViewerModel.waitForFinish: going to wait");
                this.wait();
                Debug.println((String)"DSLogViewerModel.waitForFinish: wait done");
            }
        }
        catch (Exception exception) {
            Debug.println((String)("DSLogViewerModel.waitForFinish: Exception: " + exception));
        }
    }

    synchronized void finish() {
        try {
            Debug.println((String)"DSLogViewerModel.finish: going to notify");
            this._finished = true;
            this.notify();
            Debug.println((String)"DSLogViewerModel.finish: notify done");
        }
        catch (Exception exception) {
            Debug.println((String)("DSLogViewerModel.finish: Exception: " + exception));
        }
    }
}

