/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.browser;

import com.netscape.admin.dirserv.browser.AbstractNodeTask;
import com.netscape.admin.dirserv.browser.BasicNode;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class NodeTaskQueue
implements Runnable {
    String _name;
    Vector _waitingQueue = new Vector();
    Hashtable _workingList = new Hashtable();
    Hashtable _cancelList = new Hashtable();
    ThreadGroup _threadGroup;

    public NodeTaskQueue(String string, int n) {
        this._name = string;
        this._threadGroup = new ThreadGroup(string);
        int n2 = 0;
        while (n2 < n) {
            Thread thread = new Thread(this._threadGroup, this, string + "[" + n2 + "]");
            thread.setPriority(1);
            thread.start();
            ++n2;
        }
    }

    public String getName() {
        return this._name;
    }

    public void shutdown() {
        this._threadGroup.interrupt();
    }

    public synchronized void queue(AbstractNodeTask abstractNodeTask) {
        if (abstractNodeTask == null) {
            throw new IllegalArgumentException("null argument");
        }
        this._waitingQueue.addElement(abstractNodeTask);
        this.notify();
    }

    public synchronized void cancelForNode(BasicNode basicNode) {
        AbstractNodeTask abstractNodeTask;
        if (basicNode == null) {
            throw new IllegalArgumentException("null argument");
        }
        int n = this._waitingQueue.size() - 1;
        while (n >= 0) {
            abstractNodeTask = (AbstractNodeTask)this._waitingQueue.elementAt(n);
            if (abstractNodeTask.getNode() == basicNode) {
                this._waitingQueue.removeElementAt(n);
            }
            --n;
        }
        abstractNodeTask = (AbstractNodeTask)this._workingList.get(basicNode);
        if (abstractNodeTask != null) {
            this._cancelList.put(basicNode, basicNode);
            abstractNodeTask.cancel();
        }
        this.notify();
    }

    public synchronized void cancelAll() {
        this._waitingQueue.removeAllElements();
        Enumeration enumeration = this._workingList.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            AbstractNodeTask abstractNodeTask = (AbstractNodeTask)this._workingList.get(k);
            this._cancelList.put(k, k);
            abstractNodeTask.cancel();
        }
    }

    private synchronized AbstractNodeTask fetch() throws InterruptedException {
        AbstractNodeTask abstractNodeTask = null;
        do {
            int n = this._waitingQueue.size();
            int n2 = 0;
            while (n2 < n && !this.canBeFetched(n2)) {
                ++n2;
            }
            if (n2 == n) {
                this.wait();
                continue;
            }
            abstractNodeTask = (AbstractNodeTask)this._waitingQueue.elementAt(n2);
            this._waitingQueue.removeElementAt(n2);
            this._workingList.put(abstractNodeTask.getNode(), abstractNodeTask);
        } while (abstractNodeTask == null);
        return abstractNodeTask;
    }

    private boolean canBeFetched(int n) {
        AbstractNodeTask abstractNodeTask = (AbstractNodeTask)this._waitingQueue.elementAt(n);
        return this._workingList.get(abstractNodeTask.getNode()) == null;
    }

    private synchronized void flush(AbstractNodeTask abstractNodeTask) {
        if (abstractNodeTask == null) {
            throw new IllegalArgumentException("null argument");
        }
        this._workingList.remove(abstractNodeTask.getNode());
        this._cancelList.remove(abstractNodeTask.getNode());
        this.notify();
    }

    public int size() {
        return this._waitingQueue.size() + this._workingList.size();
    }

    public void run() {
        boolean bl = false;
        while (!bl) {
            try {
                AbstractNodeTask abstractNodeTask = this.fetch();
                abstractNodeTask.run();
                this.flush(abstractNodeTask);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
            catch (Exception exception) {
                if (exception instanceof InterruptedException) continue;
                exception.printStackTrace();
            }
        }
    }
}

