/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.browser;

import com.netscape.admin.dirserv.browser.BasicNode;
import com.netscape.admin.dirserv.browser.BrowserCellRenderer;
import com.netscape.admin.dirserv.browser.BrowserEvent;
import com.netscape.admin.dirserv.browser.BrowserEventListener;
import com.netscape.admin.dirserv.browser.IBrowserNodeInfo;
import com.netscape.admin.dirserv.browser.IconPool;
import com.netscape.admin.dirserv.browser.LDAPConnectionPool;
import com.netscape.admin.dirserv.browser.NodeTaskQueue;
import com.netscape.admin.dirserv.browser.NumSubordinateHacker;
import com.netscape.admin.dirserv.browser.RefreshTask;
import com.netscape.admin.dirserv.browser.RootNode;
import com.netscape.admin.dirserv.browser.SuffixNode;
import com.netscape.management.client.util.RemoteImage;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.LDAPUrl;
import netscape.ldap.controls.LDAPSortControl;

public class BrowserController
implements TreeExpansionListener {
    public static final int DISPLAY_ACI_COUNT = 1;
    public static final int DISPLAY_ROLE_COUNT = 2;
    public static final int DISPLAY_ACTIVATION_STATE = 4;
    public static final String[] SORT_ATTRIBUTES = new String[]{"cn", "givenname", "o", "ou", "sn"};
    JTree _tree;
    DefaultTreeModel _treeModel;
    RootNode _rootNode;
    int _displayFlags;
    LDAPConnection _ldc;
    boolean _followReferrals;
    boolean _sorted;
    boolean _showContainerOnly;
    String[] _containerClasses;
    NumSubordinateHacker _numSubordinateHacker;
    int _queueTotalSize;
    int _maxChildren = 0;
    Vector _listeners;
    LDAPConnectionPool _connectionPool;
    IconPool _iconPool;
    LDAPSearchConstraints _searchConstraints;
    NodeTaskQueue _refreshQueue;

    public BrowserController(JTree jTree, LDAPConnectionPool lDAPConnectionPool) {
        this(jTree, lDAPConnectionPool, new IconPool());
    }

    public BrowserController(JTree jTree, LDAPConnectionPool lDAPConnectionPool, IconPool iconPool) {
        this._tree = jTree;
        this._iconPool = iconPool;
        this._rootNode = new RootNode();
        this._rootNode.setIcon((Icon)this._iconPool.getIconForRootNode());
        this._treeModel = new DefaultTreeModel(this._rootNode);
        this._tree.setModel(this._treeModel);
        this._tree.addTreeExpansionListener(this);
        this._tree.setCellRenderer((TreeCellRenderer)((Object)new BrowserCellRenderer(this)));
        this._displayFlags = 1;
        this._followReferrals = true;
        this._sorted = false;
        this._showContainerOnly = true;
        this._containerClasses = new String[0];
        this._queueTotalSize = 0;
        this._listeners = new Vector(2);
        this._connectionPool = lDAPConnectionPool;
        this._searchConstraints = null;
        this._refreshQueue = new NodeTaskQueue("New red", 2);
        this._numSubordinateHacker = new NumSubordinateHacker();
    }

    public BrowserController(JTree jTree) {
        this(jTree, new LDAPConnectionPool());
    }

    public void setLDAPConnection(LDAPConnection lDAPConnection) {
        String string;
        this._ldc = lDAPConnection;
        if (this._ldc != null) {
            LDAPConnection lDAPConnection2 = (LDAPConnection)this._ldc.clone();
            if (lDAPConnection2 != null) {
                this._connectionPool.registerConnection(lDAPConnection2);
            }
            string = this._ldc.getHost() + ":" + this._ldc.getPort();
        } else {
            string = "";
        }
        this._rootNode.setDisplayName(string);
        this.startRefresh(null);
    }

    public LDAPConnection getLDAPConnection() {
        return this._ldc;
    }

    public JTree getTree() {
        return this._tree;
    }

    public LDAPConnectionPool getConnectionPool() {
        return this._connectionPool;
    }

    public IconPool getIconPool() {
        return this._iconPool;
    }

    public TreePath addSuffix(String string, String string2) {
        int n;
        SuffixNode suffixNode;
        if (string2 != null) {
            suffixNode = this.findSuffixNode(string2, this._rootNode);
            if (suffixNode == null) {
                throw new IllegalArgumentException("Invalid suffix dn " + string2);
            }
        } else {
            suffixNode = this._rootNode;
        }
        if ((n = this.findChildNode(suffixNode, string)) >= 0) {
            throw new IllegalArgumentException("Duplicate suffix dn " + string2);
        }
        n = -(n + 1);
        SuffixNode suffixNode2 = new SuffixNode(string);
        this._treeModel.insertNodeInto(suffixNode2, suffixNode, n);
        this.startRefreshNode(suffixNode2, null, true);
        return new TreePath(this._treeModel.getPathToRoot(suffixNode2));
    }

    public TreePath removeSuffix(String string) {
        SuffixNode suffixNode = this.findSuffixNode(string, this._rootNode);
        TreeNode treeNode = suffixNode.getParent();
        this.removeOneNode(suffixNode);
        return new TreePath(this._treeModel.getPathToRoot(treeNode));
    }

    public TreePath removeAllSuffixes() {
        this.stopRefresh();
        this.removeAllChildNodes(this._rootNode, false);
        return new TreePath(this._treeModel.getPathToRoot(this._rootNode));
    }

    public int getDisplayFlags() {
        return this._displayFlags;
    }

    public void setDisplayFlags(int n) {
        this._displayFlags = n;
        this.startRefresh(null);
    }

    public void setMaxChildren(int n) {
        this._maxChildren = n;
    }

    public int getMaxChildren() {
        return this._maxChildren;
    }

    public boolean getFollowReferrals() {
        return this._followReferrals;
    }

    public void setFollowReferrals(boolean bl) {
        this._followReferrals = bl;
        this.startRefreshReferralNodes(this._rootNode);
    }

    public boolean isSorted() {
        return this._sorted;
    }

    public void setSorted(boolean bl) {
        this.stopRefresh();
        this.removeAllChildNodes(this._rootNode, true);
        this._sorted = bl;
        this._searchConstraints = null;
        this.startRefresh(null);
    }

    public boolean isShowContainerOnly() {
        return this._showContainerOnly;
    }

    public void setShowContainerOnly(boolean bl) {
        this._showContainerOnly = bl;
        this.startRefresh(null);
    }

    public IBrowserNodeInfo getNodeInfoFromPath(TreePath treePath) {
        BasicNode basicNode = (BasicNode)treePath.getLastPathComponent();
        return new BrowserNodeInfo(basicNode);
    }

    public String[] getContainerClasses() {
        return this._containerClasses;
    }

    public void setContainerClasses(String[] stringArray) {
        this._containerClasses = stringArray;
        this.startRefresh(null);
    }

    public NumSubordinateHacker getNumSubordinateHacker() {
        return this._numSubordinateHacker;
    }

    public void setNumSubordinateHacker(NumSubordinateHacker numSubordinateHacker) {
        if (numSubordinateHacker == null) {
            throw new IllegalArgumentException("hacker cannot be null");
        }
        this._numSubordinateHacker = numSubordinateHacker;
    }

    public void addBrowserEventListener(BrowserEventListener browserEventListener) {
        this._listeners.addElement(browserEventListener);
    }

    public void removeBrowserEventListener(BrowserEventListener browserEventListener) {
        this._listeners.removeElement(browserEventListener);
    }

    public TreePath notifyEntryAdded(IBrowserNodeInfo iBrowserNodeInfo, String string) {
        int n;
        BasicNode basicNode = ((BrowserNodeInfo)iBrowserNodeInfo).getNode();
        BasicNode basicNode2 = new BasicNode(string);
        if (this._sorted) {
            n = this.findChildNode(basicNode, string);
            if (n >= 0) {
                throw new IllegalArgumentException("Duplicate DN " + string);
            }
            n = -(n + 1);
        } else {
            n = basicNode.getChildCount();
        }
        basicNode.setLeaf(false);
        this._treeModel.insertNodeInto(basicNode2, basicNode, n);
        this.startRefreshNode(basicNode2, null, false);
        return new TreePath(this._treeModel.getPathToRoot(basicNode2));
    }

    public TreePath notifyEntryDeleted(IBrowserNodeInfo iBrowserNodeInfo) {
        BasicNode basicNode = ((BrowserNodeInfo)iBrowserNodeInfo).getNode();
        if (basicNode == this._rootNode) {
            throw new IllegalArgumentException("Root node cannot be removed");
        }
        TreeNode treeNode = basicNode.getParent();
        this.removeOneNode(basicNode);
        return new TreePath(this._treeModel.getPathToRoot(treeNode));
    }

    public void notifyEntryChanged(IBrowserNodeInfo iBrowserNodeInfo) {
        BasicNode basicNode = ((BrowserNodeInfo)iBrowserNodeInfo).getNode();
        this.startRefreshNode(basicNode, null, false);
    }

    public void notifyChildEntryChanged(IBrowserNodeInfo iBrowserNodeInfo, String string) {
        BasicNode basicNode = ((BrowserNodeInfo)iBrowserNodeInfo).getNode();
        this.startRefreshNode(basicNode, null, true);
    }

    public void notifyChildEntryAdded(IBrowserNodeInfo iBrowserNodeInfo, String string) {
        BasicNode basicNode = ((BrowserNodeInfo)iBrowserNodeInfo).getNode();
        this.startRefreshNode(basicNode, null, true);
    }

    public void notifyChildEntryDeleted(IBrowserNodeInfo iBrowserNodeInfo, String string) {
        BasicNode basicNode = ((BrowserNodeInfo)iBrowserNodeInfo).getNode();
        if (basicNode.getParent() != null) {
            this.startRefreshNode((BasicNode)basicNode.getParent(), null, true);
        } else {
            this.startRefreshNode(basicNode, null, true);
        }
    }

    public void notifyAuthDataChanged(LDAPUrl lDAPUrl) {
        this.startRefreshReferralNodes(this._rootNode);
    }

    public void startRefresh(IBrowserNodeInfo iBrowserNodeInfo) {
        BasicNode basicNode = iBrowserNodeInfo == null ? this._rootNode : ((BrowserNodeInfo)iBrowserNodeInfo).getNode();
        this.stopRefreshNode(basicNode);
        this.startRefreshNode(basicNode, null, true);
    }

    public void startRefresh() {
        this.startRefresh(null);
    }

    public void stopRefresh() {
        this.stopRefreshNode(this._rootNode);
    }

    public void shutDown() {
        this._tree.removeTreeExpansionListener(this);
        this._refreshQueue.shutdown();
        this._connectionPool.flush();
    }

    void startRefreshNode(BasicNode basicNode, LDAPEntry lDAPEntry, boolean bl) {
        block4: {
            block3: {
                if (basicNode != this._rootNode) break block3;
                if (!bl) break block4;
                Enumeration<TreeNode> enumeration = this._rootNode.children();
                while (enumeration.hasMoreElements()) {
                    BasicNode basicNode2 = (BasicNode)enumeration.nextElement();
                    this.startRefreshNode(basicNode2, null, true);
                }
                break block4;
            }
            this._refreshQueue.queue(new RefreshTask(basicNode, this, lDAPEntry, bl));
            if (bl && basicNode instanceof SuffixNode) {
                Enumeration<TreeNode> enumeration = basicNode.children();
                while (enumeration.hasMoreElements()) {
                    BasicNode basicNode3 = (BasicNode)enumeration.nextElement();
                    if (!(basicNode3 instanceof SuffixNode)) continue;
                    this.startRefreshNode(basicNode3, null, true);
                }
            }
        }
    }

    void stopRefreshNode(BasicNode basicNode) {
        if (basicNode == this._rootNode) {
            this._refreshQueue.cancelAll();
        } else {
            Enumeration<TreeNode> enumeration = basicNode.children();
            while (enumeration.hasMoreElements()) {
                BasicNode basicNode2 = (BasicNode)enumeration.nextElement();
                this.stopRefreshNode(basicNode2);
            }
            this._refreshQueue.cancelForNode(basicNode);
        }
    }

    void startRefreshReferralNodes(BasicNode basicNode) {
        Enumeration<TreeNode> enumeration = basicNode.children();
        while (enumeration.hasMoreElements()) {
            BasicNode basicNode2 = (BasicNode)enumeration.nextElement();
            if (basicNode2.getReferral() != null || basicNode2.getRemoteUrl() != null) {
                this.startRefreshNode(basicNode2, null, true);
                continue;
            }
            this.startRefreshReferralNodes(basicNode2);
        }
    }

    void removeAllChildNodes(BasicNode basicNode, boolean bl) {
        int n = basicNode.getChildCount() - 1;
        while (n >= 0) {
            BasicNode basicNode2 = (BasicNode)basicNode.getChildAt(n);
            if (basicNode2 instanceof SuffixNode && bl) {
                this.removeAllChildNodes(basicNode2, true);
                basicNode2.setRefreshNeededOnExpansion(true);
            } else {
                basicNode2.removeFromParent();
            }
            --n;
        }
        this._treeModel.nodeStructureChanged(basicNode);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        BasicNode basicNode = (BasicNode)treeExpansionEvent.getPath().getLastPathComponent();
        if (basicNode.isRefreshNeededOnExpansion()) {
            basicNode.setRefreshNeededOnExpansion(false);
            this.startRefreshNode(basicNode, null, true);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        Object object = treeExpansionEvent.getPath().getLastPathComponent();
        if (!(object instanceof RootNode)) {
            BasicNode basicNode = (BasicNode)object;
            this.stopRefreshNode(basicNode);
        }
    }

    DefaultTreeModel getTreeModel() {
        return this._treeModel;
    }

    String getChildSearchFilter() {
        String string;
        if (this._showContainerOnly) {
            string = "(|(&(numsubordinates=*)(numsubordinates>=1)(|(objectclass=*)(objectclass=ldapsubentry)))";
            int n = 0;
            while (n < this._containerClasses.length) {
                string = string + "(objectclass=" + this._containerClasses[n] + ")";
                ++n;
            }
            string = string + ")";
        } else {
            string = "(|(objectclass=*)(objectclass=ldapsubentry))";
        }
        return string;
    }

    LDAPConnection findConnectionForLocalEntry(BasicNode basicNode) throws LDAPException {
        LDAPConnection lDAPConnection = basicNode == this._rootNode ? this._ldc : this.findConnectionForDisplayedEntry((BasicNode)basicNode.getParent());
        return lDAPConnection;
    }

    LDAPConnection findConnectionForDisplayedEntry(BasicNode basicNode) throws LDAPException {
        LDAPConnection lDAPConnection = this._followReferrals && basicNode.getRemoteUrl() != null ? this._connectionPool.getConnection(basicNode.getRemoteUrl()) : this.findConnectionForLocalEntry(basicNode);
        return lDAPConnection;
    }

    void releaseLDAPConnection(LDAPConnection lDAPConnection) {
        if (lDAPConnection != this._ldc) {
            this._connectionPool.releaseConnection(lDAPConnection);
        }
    }

    LDAPUrl findUrlForLocalEntry(BasicNode basicNode) {
        LDAPUrl lDAPUrl;
        if (basicNode == this._rootNode) {
            lDAPUrl = LDAPConnectionPool.makeLDAPUrl(this._ldc, "");
        } else {
            BasicNode basicNode2 = (BasicNode)basicNode.getParent();
            LDAPUrl lDAPUrl2 = this.findUrlForDisplayedEntry(basicNode2);
            lDAPUrl = LDAPConnectionPool.makeLDAPUrl(lDAPUrl2, basicNode.getDN());
        }
        return lDAPUrl;
    }

    LDAPUrl findUrlForDisplayedEntry(BasicNode basicNode) {
        LDAPUrl lDAPUrl = this._followReferrals && basicNode.getRemoteUrl() != null ? basicNode.getRemoteUrl() : this.findUrlForLocalEntry(basicNode);
        return lDAPUrl;
    }

    String findBaseDNForChildEntries(BasicNode basicNode) {
        String string = this._followReferrals && basicNode.getRemoteUrl() != null ? basicNode.getRemoteUrl().getDN() : basicNode.getDN();
        return string;
    }

    boolean isDisplayedEntryRemote(BasicNode basicNode) {
        boolean bl = this._followReferrals ? (basicNode == this._rootNode ? false : (basicNode.getRemoteUrl() != null ? true : this.isDisplayedEntryRemote((BasicNode)basicNode.getParent()))) : false;
        return bl;
    }

    String[] getAttrsForRedSearch() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("objectclass");
        vector.addElement("numsubordinates");
        vector.addElement("ref");
        if ((this._displayFlags & 1) != 0) {
            vector.addElement("aci");
        }
        if ((this._displayFlags & 2) != 0) {
            vector.addElement("nsrole");
        }
        if ((this._displayFlags & 4) != 0) {
            vector.addElement("nsaccountlock");
        }
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    String[] getAttrsForGreenSearch() {
        return new String[]{"aci", "nsrole", "nsaccountlock"};
    }

    String[] getAttrsForBlackSearch() {
        return new String[]{"objectclass", "numsubordinates", "ref", "aci", "nsrole", "nsaccountlock"};
    }

    LDAPSearchConstraints getSearchConstraints() {
        if (this._searchConstraints == null) {
            LDAPControl[] lDAPControlArray = new LDAPControl[this._sorted ? 2 : 1];
            lDAPControlArray[0] = new LDAPControl("2.16.840.1.113730.3.4.2", true, null);
            if (this._sorted) {
                LDAPSortKey[] lDAPSortKeyArray = new LDAPSortKey[SORT_ATTRIBUTES.length];
                int n = 0;
                while (n < lDAPSortKeyArray.length) {
                    lDAPSortKeyArray[n] = new LDAPSortKey(SORT_ATTRIBUTES[n]);
                    ++n;
                }
                lDAPControlArray[1] = new LDAPSortControl(lDAPSortKeyArray, true);
            }
            this._searchConstraints = (LDAPSearchConstraints)this._ldc.getSearchConstraints().clone();
            this._searchConstraints.setMaxResults(this._maxChildren);
            this._searchConstraints.setServerControls(lDAPControlArray);
        }
        return this._searchConstraints;
    }

    private void refreshTaskDidProgress(RefreshTask refreshTask, int n, int n2) {
        BasicNode basicNode = refreshTask.getNode();
        boolean bl = false;
        if (n == 0) {
            this.checkUpdateEvent(true);
        }
        if (refreshTask.isInFinalState()) {
            this.checkUpdateEvent(false);
        }
        if (n2 == 10) {
            if (this.isNoSuchObjectLDAPException(refreshTask.getException()) && n != 2) {
                this.removeOneNode(basicNode);
            } else {
                if (n == 2) {
                    basicNode.setRemoteUrl(refreshTask.getRemoteUrl());
                    if (refreshTask.getRemoteEntry() != null) {
                        this.updateNodeRendering(basicNode, refreshTask.getRemoteEntry());
                    }
                }
                basicNode.setError(new BasicNode.Error(n, refreshTask.getException(), refreshTask.getExceptionArg()));
                bl = this.updateNodeRendering(basicNode, refreshTask.getDisplayedEntry());
            }
        } else if (n2 == 8 && n2 == 9) {
            this._tree.collapsePath(new TreePath(this._treeModel.getPathToRoot(basicNode)));
        } else {
            BasicNode basicNode2;
            Object object;
            if (n != 5 && n2 == 5) {
                if (this.canDoDifferentialUpdate(refreshTask)) {
                    object = basicNode.children();
                    while (object.hasMoreElements()) {
                        basicNode2 = (BasicNode)object.nextElement();
                        basicNode2.setObsolete(true);
                    }
                } else {
                    this.removeAllChildNodes(basicNode, true);
                }
            }
            if (n == 1) {
                basicNode.setRemoteUrl(null);
                object = refreshTask.getLocalEntry();
                bl = this.updateNodeRendering(basicNode, (LDAPEntry)object);
            } else if (n == 2) {
                basicNode.setRemoteUrl(refreshTask.getRemoteUrl());
                this.updateNodeRendering(basicNode, refreshTask.getRemoteEntry());
                bl = true;
            } else if (n == 4) {
                if (basicNode.isLeaf() != refreshTask.isLeafNode()) {
                    basicNode.setLeaf(refreshTask.isLeafNode());
                    this.updateNodeRendering(basicNode, refreshTask.getDisplayedEntry());
                    bl = true;
                    if (basicNode.isLeaf()) {
                        this.removeAllChildNodes(basicNode, false);
                    }
                }
            } else if (n == 5) {
                this.updateChildNodes(refreshTask);
                if (n2 == 7) {
                    if (this.canDoDifferentialUpdate(refreshTask)) {
                        int n3 = basicNode.getChildCount() - 1;
                        while (n3 >= 0) {
                            basicNode2 = (BasicNode)basicNode.getChildAt(n3);
                            if (basicNode2.isObsolete()) {
                                this.removeOneNode(basicNode2);
                            }
                            --n3;
                        }
                    }
                    if (basicNode.getChildCount() == 0) {
                        basicNode.setLeaf(true);
                        this.updateNodeRendering(basicNode, refreshTask.getDisplayedEntry());
                        bl = true;
                    }
                }
            }
            if (n2 == 7 && basicNode.getError() != null) {
                basicNode.setError(null);
                bl = this.updateNodeRendering(basicNode, refreshTask.getDisplayedEntry());
            }
        }
        if (bl) {
            this._treeModel.nodeChanged(refreshTask.getNode());
        }
        if (basicNode.isLeaf() && basicNode.getChildCount() >= 1) {
            throw new IllegalStateException("Inconsistent node: " + basicNode.getDN());
        }
    }

    void invokeRefreshTaskDidProgress(final RefreshTask refreshTask, final int n, final int n2) throws InterruptedException {
        Runnable runnable = new Runnable(){
            RefreshTask _task;
            int _oldState;
            int _newState;
            {
                this._task = refreshTask;
                this._oldState = n;
                this._newState = n2;
            }

            public void run() {
                try {
                    BrowserController.this.refreshTaskDidProgress(this._task, this._oldState, this._newState);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        BrowserController.swingInvoke(runnable);
    }

    private void updateChildNodes(RefreshTask refreshTask) {
        BasicNode basicNode = refreshTask.getNode();
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        boolean bl = this.canDoDifferentialUpdate(refreshTask);
        LDAPUrl lDAPUrl = this.findUrlForDisplayedEntry(basicNode);
        boolean bl2 = this._numSubordinateHacker.containsChildrenOf(lDAPUrl);
        Enumeration enumeration = refreshTask.getChildEntries().elements();
        while (enumeration.hasMoreElements()) {
            boolean bl3;
            BasicNode basicNode2;
            LDAPEntry lDAPEntry = (LDAPEntry)enumeration.nextElement();
            int n = bl ? this.findChildNode(basicNode, lDAPEntry.getDN()) : -(basicNode.getChildCount() + 1);
            if (n < 0) {
                n = -(n + 1);
                basicNode2 = new BasicNode(lDAPEntry.getDN());
                basicNode.insert(basicNode2, n);
                this.updateNodeRendering(basicNode2, lDAPEntry);
                vector.addElement(new Integer(n));
            } else {
                basicNode2 = (BasicNode)basicNode.getChildAt(n);
                if (this.updateNodeRendering(basicNode2, lDAPEntry)) {
                    vector2.addElement(new Integer(n));
                }
                basicNode2.setObsolete(false);
            }
            int n2 = basicNode2.getNumSubOrdinates();
            if (n2 == 0 && bl2) {
                LDAPUrl lDAPUrl2 = this.findUrlForDisplayedEntry(basicNode2);
                bl3 = !this._numSubordinateHacker.contains(lDAPUrl2);
            } else {
                boolean bl4 = bl3 = n2 == 0;
            }
            if (bl3 && basicNode2.getReferral() == null) continue;
            this.startRefreshNode(basicNode2, lDAPEntry, true);
        }
        if (vector.size() >= 1) {
            this._treeModel.nodesWereInserted(basicNode, BrowserController.intArrayFromVector(vector));
        }
        if (vector2.size() >= 1) {
            this._treeModel.nodesChanged(basicNode, BrowserController.intArrayFromVector(vector2));
        }
    }

    private boolean canDoDifferentialUpdate(RefreshTask refreshTask) {
        return refreshTask.getNode().getChildCount() >= 1 && refreshTask.getNode().getNumSubOrdinates() <= 100;
    }

    private boolean updateNodeRendering(BasicNode basicNode, LDAPEntry lDAPEntry) {
        boolean bl;
        CharSequence charSequence;
        Object object;
        RemoteImage remoteImage;
        boolean bl2;
        LDAPAttribute lDAPAttribute;
        LDAPAttribute lDAPAttribute2;
        LDAPAttribute lDAPAttribute3;
        if (lDAPEntry != null) {
            basicNode.setNumSubOrdinates(BrowserController.getNumSubOrdinates(lDAPEntry));
            basicNode.setReferral(BrowserController.getReferral(lDAPEntry));
        }
        int n = (this._displayFlags & 1) != 0 && lDAPEntry != null ? ((lDAPAttribute3 = lDAPEntry.getAttribute("aci")) != null ? lDAPAttribute3.size() : 0) : 0;
        int n2 = (this._displayFlags & 2) != 0 && lDAPEntry != null ? ((lDAPAttribute2 = lDAPEntry.getAttribute("nsrole")) != null ? lDAPAttribute2.size() : 0) : 0;
        if ((this._displayFlags & 4) != 0 && lDAPEntry != null) {
            LDAPAttribute lDAPAttribute4 = lDAPEntry.getAttribute("nsaccountlock");
            if (lDAPAttribute4 != null) {
                lDAPAttribute = lDAPAttribute4.getStringValueArray();
                if (((String[])lDAPAttribute).length >= 1) {
                    bl2 = lDAPAttribute[0].equalsIgnoreCase("true");
                    if (bl2 && (remoteImage = lDAPEntry.getAttribute("objectclass")) != null) {
                        object = remoteImage.getStringValues();
                        boolean bl3 = false;
                        boolean bl4 = false;
                        while (!(!object.hasMoreElements() || bl3 && bl4)) {
                            charSequence = (String)object.nextElement();
                            if (((String)charSequence).equalsIgnoreCase("nsroledefinition")) {
                                bl3 = true;
                                continue;
                            }
                            if (!((String)charSequence).equalsIgnoreCase("ldapsubentry")) continue;
                            bl4 = true;
                        }
                        if (bl3 && bl4) {
                            bl2 = false;
                        }
                    }
                } else {
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
        } else {
            bl2 = false;
        }
        int n3 = 0;
        if (basicNode.isLeaf() && basicNode.getNumSubOrdinates() <= 0) {
            n3 |= 1;
        }
        if (basicNode.getReferral() != null) {
            n3 |= 2;
        }
        if (basicNode.getError() != null) {
            n3 |= 8;
        }
        if (bl2) {
            n3 |= 4;
        }
        lDAPAttribute = null;
        if (lDAPEntry != null) {
            lDAPAttribute = lDAPEntry.getAttribute("objectclass");
        }
        remoteImage = this._iconPool.getIcon(lDAPAttribute, n3);
        object = new StringBuffer();
        if (n >= 1) {
            ((StringBuffer)object).append(String.valueOf(n));
            if (n == 1) {
                ((StringBuffer)object).append(" aci");
            } else {
                ((StringBuffer)object).append(" acis");
            }
        }
        if (n2 >= 1) {
            if (((StringBuffer)object).length() >= 1) {
                ((StringBuffer)object).append(", ");
            }
            ((StringBuffer)object).append(String.valueOf(n2));
            if (n2 == 1) {
                ((StringBuffer)object).append(" role");
            } else {
                ((StringBuffer)object).append(" roles");
            }
        }
        charSequence = new StringBuffer();
        String string = this._followReferrals && basicNode.getRemoteUrl() != null ? basicNode.getRemoteRDN() : basicNode.getRDN();
        ((StringBuffer)charSequence).append(string);
        if (((StringBuffer)object).length() >= 1) {
            ((StringBuffer)charSequence).append("  (");
            ((StringBuffer)charSequence).append(object);
            ((StringBuffer)charSequence).append(")");
        }
        String string2 = ((StringBuffer)charSequence).toString();
        int n4 = 0;
        if (this.isDisplayedEntryRemote(basicNode)) {
            n4 |= 2;
        }
        if (basicNode instanceof SuffixNode) {
            n4 |= 1;
        }
        boolean bl5 = bl = basicNode.getIcon() != remoteImage || basicNode.getDisplayName() != string2 || basicNode.getFontStyle() != n4;
        if (bl) {
            basicNode.setIcon((Icon)remoteImage);
            basicNode.setDisplayName(string2);
            basicNode.setFontStyle(n4);
        }
        return bl;
    }

    int findChildNode(BasicNode basicNode, String string) {
        int n = this._sorted ? this.findSortedChildNode(basicNode, string, 0, basicNode.getChildCount() - 1) : this.findUnSortedChildNode(basicNode, string);
        return n;
    }

    int findSortedChildNode(BasicNode basicNode, String string, int n, int n2) {
        int n3;
        if (n > n2) {
            if (n != n2 + 1) {
                throw new IllegalStateException("Bug in findSortedChildNode");
            }
            n3 = -(n + 1);
        } else {
            int n4;
            int n5 = this.compareDnToChildNode(string, basicNode, n);
            n3 = n5 < 0 ? -(n + 1) : (n5 == 0 ? n : (n == n2 ? -(n2 + 1 + 1) : ((n5 = this.compareDnToChildNode(string, basicNode, n2)) > 0 ? -(n2 + 1 + 1) : (n5 == 0 ? n2 : ((n5 = this.compareDnToChildNode(string, basicNode, n4 = (n + n2) / 2)) < 0 ? this.findSortedChildNode(basicNode, string, n + 1, n4 - 1) : (n5 == 0 ? n4 : this.findSortedChildNode(basicNode, string, n4 + 1, n2 - 1)))))));
        }
        return n3;
    }

    int findUnSortedChildNode(BasicNode basicNode, String string) {
        int n = basicNode.getChildCount();
        int n2 = 0;
        int n3 = -1;
        while (n2 < n && !string.equals(((BasicNode)basicNode.getChildAt(n2)).getDN())) {
            ++n2;
        }
        if (n2 >= n) {
            n2 = -(n + 1);
        }
        return n2;
    }

    int compareDnToChildNode(String string, BasicNode basicNode, int n) {
        BasicNode basicNode2 = (BasicNode)basicNode.getChildAt(n);
        return Collator.getInstance().compare(string, basicNode2.getDN());
    }

    private void removeOneNode(BasicNode basicNode) {
        this.stopRefreshNode(basicNode);
        this._treeModel.removeNodeFromParent(basicNode);
    }

    private void checkUpdateEvent(boolean bl) {
        int n = this._refreshQueue.size();
        if (!bl) {
            --n;
        }
        if (n != this._queueTotalSize) {
            if (this._queueTotalSize == 0 && n >= 1) {
                this.fireEvent(1);
            } else if (this._queueTotalSize >= 1 && n == 0) {
                this.fireEvent(2);
            }
            this._queueTotalSize = n;
        }
    }

    private void fireEvent(int n) {
        BrowserEvent browserEvent = new BrowserEvent(this, n);
        Enumeration enumeration = this._listeners.elements();
        while (enumeration.hasMoreElements()) {
            BrowserEventListener browserEventListener = (BrowserEventListener)enumeration.nextElement();
            browserEventListener.processBrowserEvent(browserEvent);
        }
    }

    SuffixNode findSuffixNode(String string, SuffixNode suffixNode) {
        SuffixNode suffixNode2;
        if (suffixNode.dnEquals(string)) {
            suffixNode2 = suffixNode;
        } else {
            int n = suffixNode.getChildCount();
            if (n == 0) {
                suffixNode2 = null;
            } else {
                BasicNode basicNode;
                int n2 = 0;
                boolean bl = false;
                do {
                    if (!(basicNode = (BasicNode)suffixNode.getChildAt(n2)).dnEquals(string)) continue;
                    bl = true;
                } while (++n2 < n && !bl);
                if (!bl) {
                    suffixNode2 = null;
                } else if (basicNode instanceof SuffixNode) {
                    suffixNode2 = (SuffixNode)basicNode;
                } else {
                    throw new IllegalArgumentException(string + " is not a suffix node");
                }
            }
        }
        return suffixNode2;
    }

    private boolean isNoSuchObjectLDAPException(Object object) {
        LDAPException lDAPException;
        boolean bl = object instanceof LDAPException ? (lDAPException = (LDAPException)((Object)object)).getLDAPResultCode() == 32 : false;
        return bl;
    }

    public static int getNumSubOrdinates(LDAPEntry lDAPEntry) {
        int n;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("numsubordinates");
        if (lDAPAttribute == null) {
            n = 0;
        } else {
            try {
                n = Integer.parseInt(lDAPAttribute.getStringValueArray()[0]);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        return n;
    }

    public static String[] getReferral(LDAPEntry lDAPEntry) {
        Enumeration enumeration;
        String[] stringArray = null;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
        if (lDAPAttribute != null && (enumeration = lDAPAttribute.getStringValues()) != null) {
            boolean bl = false;
            while (enumeration.hasMoreElements() && !bl) {
                String string = (String)enumeration.nextElement();
                bl = string.equalsIgnoreCase("referral");
            }
            if (bl && (lDAPAttribute = lDAPEntry.getAttribute("ref")) != null && lDAPAttribute.size() >= 1) {
                stringArray = lDAPAttribute.getStringValueArray();
            }
        }
        return stringArray;
    }

    public boolean nodeIsExpanded(BasicNode basicNode) {
        TreePath treePath = new TreePath(this._treeModel.getPathToRoot(basicNode));
        return this._tree.isExpanded(treePath);
    }

    static int[] intArrayFromVector(Vector vector) {
        int[] nArray = new int[vector.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (Integer)vector.elementAt(n);
            ++n;
        }
        return nArray;
    }

    static LDAPEntry[] entryArrayFromVector(Vector vector) {
        LDAPEntry[] lDAPEntryArray = new LDAPEntry[vector.size()];
        vector.toArray(lDAPEntryArray);
        return lDAPEntryArray;
    }

    static BasicNode[] nodeArrayFromVector(Vector vector) {
        BasicNode[] basicNodeArray = new BasicNode[vector.size()];
        vector.toArray(basicNodeArray);
        return basicNodeArray;
    }

    static void swingInvoke(Runnable runnable) throws InterruptedException {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    class BrowserNodeInfo
    implements IBrowserNodeInfo {
        BasicNode _node;
        LDAPUrl _url;
        boolean _isRemote;
        boolean _isSuffix;
        boolean _isRootNode;
        String[] _referral;
        int _numSubOrdinates;
        int _errorType;
        Exception _errorException;
        Object _errorArg;

        public BrowserNodeInfo(BasicNode basicNode) {
            this._node = basicNode;
            this._url = BrowserController.this.findUrlForDisplayedEntry(basicNode);
            this._isRootNode = basicNode instanceof RootNode;
            this._isRemote = BrowserController.this.isDisplayedEntryRemote(basicNode);
            this._isSuffix = basicNode instanceof SuffixNode;
            this._referral = basicNode.getReferral();
            this._numSubOrdinates = basicNode.getNumSubOrdinates();
            if (basicNode.getError() != null) {
                BasicNode.Error error = basicNode.getError();
                switch (error.getType()) {
                    case 1: {
                        this._errorType = 1;
                        break;
                    }
                    case 2: {
                        this._errorType = 2;
                        break;
                    }
                    case 4: 
                    case 5: {
                        this._errorType = 3;
                    }
                }
                this._errorException = error.getException();
                this._errorArg = error.getArg();
            }
        }

        public BasicNode getNode() {
            return this._node;
        }

        public LDAPUrl getURL() {
            return this._url;
        }

        public boolean isRootNode() {
            return this._isRootNode;
        }

        public boolean isSuffix() {
            return this._isSuffix;
        }

        public boolean isRemote() {
            return this._isRemote;
        }

        public String[] getReferral() {
            return this._referral;
        }

        public int getNumSubOrdinates() {
            return this._numSubOrdinates;
        }

        public int getErrorType() {
            return this._errorType;
        }

        public Exception getErrorException() {
            return this._errorException;
        }

        public Object getErrorArg() {
            return this._errorArg;
        }

        public TreePath getTreePath() {
            return new TreePath(BrowserController.this._treeModel.getPathToRoot(this._node));
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getURL());
            if (this.getReferral() != null) {
                stringBuffer.append(" -> ");
                stringBuffer.append(this.getReferral());
            }
            return stringBuffer.toString();
        }
    }
}

