/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.attredit;

import com.netscape.admin.dirserv.attredit.IAttributeEditor;
import com.netscape.management.client.util.Debug;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;

public class AttributeEditorFactory {
    private static Hashtable _nameTable = null;
    private static Hashtable _typeTable = null;
    private static Hashtable _editorTable = null;
    private static Hashtable _allTable = null;
    private static final String _package = "com.netscape.admin.dirserv.attredit";
    private static final String _defaultEditorName = "com.netscape.admin.dirserv.attredit.StringAttributeEditor";
    private static Class _defaultEditor = null;
    private static final boolean _initialized = AttributeEditorFactory.init();

    private static boolean init() {
        _nameTable = new Hashtable();
        _typeTable = new Hashtable();
        _editorTable = new Hashtable();
        _allTable = new Hashtable();
        AttributeEditorFactory.addName("objectclass", "com.netscape.admin.dirserv.attredit.ObjectClassAttributeEditor");
        AttributeEditorFactory.addName("jpegphoto", "com.netscape.admin.dirserv.attredit.ImageAttributeEditor");
        AttributeEditorFactory.addName("userpassword", "com.netscape.admin.dirserv.attredit.PasswordAttributeEditor");
        AttributeEditorFactory.addSyntax(6, _defaultEditorName);
        AttributeEditorFactory.addSyntax(1, _defaultEditorName);
        AttributeEditorFactory.addSyntax(4, _defaultEditorName);
        AttributeEditorFactory.addSyntax(5, _defaultEditorName);
        AttributeEditorFactory.addSyntax(3, _defaultEditorName);
        AttributeEditorFactory.addSyntax(2, "com.netscape.admin.dirserv.attredit.BinaryAttributeEditor");
        AttributeEditorFactory.addSyntax(3, _defaultEditorName);
        AttributeEditorFactory.addSyntax(0, _defaultEditorName);
        AttributeEditorFactory.setDefaultEditor(_defaultEditorName);
        return true;
    }

    public static void addName(String string, String string2) {
        _nameTable.put(string, string2);
        _allTable.put(string2, string.trim().toLowerCase());
    }

    public static void addSyntax(int n, String string) {
        _typeTable.put(new Integer(n), string);
        _allTable.put(string, new Integer(n));
    }

    public static void addClass(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            IAttributeEditor iAttributeEditor = (IAttributeEditor)clazz.newInstance();
            iAttributeEditor.registerEditors();
        }
        catch (Exception exception) {
            Debug.println((String)("AttributeEditorFactory.addClass: no class for " + string + ", " + exception));
        }
    }

    private static void removeClassFromTable(String string, Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Class clazz = (Class)hashtable.get(string2);
            if (!clazz.getName().equals(string)) continue;
            hashtable.remove(string2);
        }
    }

    public static void removeClass(String string) {
        _editorTable.remove(string);
        AttributeEditorFactory.removeClassFromTable(string, _nameTable);
        AttributeEditorFactory.removeClassFromTable(string, _typeTable);
    }

    public static void setDefaultEditor(String string) {
        try {
            _defaultEditor = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.println((String)("AttributeEditorFactory.setDefaultEditor: no class for " + string));
        }
    }

    public static String getDefaultEditor() {
        if (_defaultEditor != null) {
            return _defaultEditor.getClass().getName();
        }
        return null;
    }

    public static Class getClassForEditor(String string) {
        if (_editorTable == null) {
            _editorTable = new Hashtable();
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
            _editorTable.put(string, clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.println((String)("AttributeEditorFactory.getClassForEditor: no class for " + string));
        }
        return clazz;
    }

    public static Class getEditorForAttribute(String string) {
        if (_nameTable == null) {
            return null;
        }
        Class clazz = null;
        String string2 = (String)_nameTable.get(string = string.trim().toLowerCase());
        if (string2 != null) {
            clazz = AttributeEditorFactory.getClassForEditor(string2);
        }
        return clazz;
    }

    public static Class getEditorForSyntax(int n) {
        if (_typeTable == null) {
            return null;
        }
        Class clazz = null;
        String string = (String)_typeTable.get(new Integer(n));
        if (string != null) {
            clazz = AttributeEditorFactory.getClassForEditor(string);
        }
        return clazz;
    }

    public static Enumeration getAttributeEditors() {
        if (_allTable == null) {
            return null;
        }
        return _allTable.keys();
    }

    public static boolean isEditor(String string) {
        if (_allTable == null) {
            Debug.println((String)"AttributeEditorFactory.isEditor: null _allTable");
            return false;
        }
        return _allTable.get(string) != null;
    }

    public static IAttributeEditor makeEditor(String string, String string2, Rectangle rectangle, boolean bl, int n) {
        Class clazz = AttributeEditorFactory.getEditorForAttribute(string);
        if (clazz == null) {
            clazz = AttributeEditorFactory.getEditorForSyntax(n);
        }
        if (clazz == null) {
            clazz = _defaultEditor;
        }
        if (clazz != null) {
            try {
                IAttributeEditor iAttributeEditor = (IAttributeEditor)clazz.newInstance();
                iAttributeEditor.init(string, string2, rectangle, bl);
                return iAttributeEditor;
            }
            catch (Exception exception) {
                Debug.println((String)("AttributeEditorFactory.makeEditor: cannot instantiate " + clazz.getName()));
            }
        }
        return null;
    }
}

